
UNIT XSTRING;

Interface

CONST
	 HEXChars: array [0..15] of char = '0123456789ABCDEF';

FUNCTION CVV(TmpCvt: Word):Real;   {two bytes to 0.00 version}
Function Replace(tStr, SearchStr, Tzx:String):String;
FUNCTION RTrim(inString:String; TrimChar:Char):String;
FUNCTION BSDel(HowFar:Byte; WithIt:String):String;
FUNCTION SwapWord(sWord : Word) : Word;
Function Intel(ULONG:LongInt):LongInt;           {  Intel()    from WATTCP  }
Function Intel16(UINT:Integer):Integer;          {  Intel16()  from WATTCP  }
FUNCTION ByteToHEXASCII(tByte : Byte) : String;
FUNCTION WordToHEXASCII(tWord : Word) : String;
FUNCTION LongToHexASCII(tLong : LongInt) : String;
Function NewValWord(InTxt : String):Word;
Function NewValInteger(InTxt : String):Integer;
FUNCTION  Instr  (Objct, Target: STRING; StartPos: BYTE): BYTE;

{ Unsigned LongInt Value string to LongInt - By Jeff Patterson}
Function ULVal(tStr:String):LongInt;
{ LongInt (Unsigned) to String - from someone on comp.lang.pascal.borland }
Function ULStr(tLong:LongInt):String;

Implementation

var
  Result:Integer;

{ Unsigned LongInt Value string to LongInt - By Jeff Patterson}
Function ULVal(tStr:String):LongInt;
var TmpLong    : LongInt;
    DigitValue : LongInt;
    I,X : Integer;
Begin
 ULVal:=0;
 If (Length(tStr)<1) or (not (tStr[1] in ['0'..'9'])) then exit;
 TmpLong:=0;
 For I:=Length(tStr) downto 1 do
  Begin
    If not (tStr[I] in ['0'..'9']) then break;
    DigitValue :=Ord(tStr[I])-48;
    X:= (Length(tStr)-I)+1;
    Case X of
       1 : Inc(TmpLong, (DigitValue * 1        ) );
       2 : Inc(TmpLong, (DigitValue * 10       ) );
       3 : Inc(TmpLong, (DigitValue * 100      ) );
       4 : Inc(TmpLong, (DigitValue * 1000     ) );
       5 : Inc(TmpLong, (DigitValue * 10000    ) );
       6 : Inc(TmpLong, (DigitValue * 100000   ) );
       7 : Inc(TmpLong, (DigitValue * 1000000  ) );
       8 : Inc(TmpLong, (DigitValue * 10000000 ) );
       9 : Inc(TmpLong, (DigitValue * 100000000) );
      10 : Inc(TmpLong, (DigitValue * 1000000000));
      Else
        break;
     End;
  End;
 ULVal:=TmpLong;
End;

Function ULStr(tLong:LongInt):String;
var TmpStr:String;
Begin
  If tLong<0 then Str(4294967296.0 + tLong:1:0, TmpStr)
             else Str(tLong, TmpStr);
  ULStr:=TmpStr;
End;

Function Replace(tStr, SearchStr, Tzx:String):String;
var  TmpText, Txz:String;
     Wit : Integer;
Begin
 TmpText:=tStr;
 Txz:='';
 Repeat
  Wit := Pos(SearchStr, tStr);
  If Wit >0 then
    Begin
      Txz:=Txz+Copy(TmpText, 1, Wit-1) + Tzx;
      TmpText:=Copy(TmpText, Wit+Length(SearchStr), Length(TmpText));
    End;
 Until Pos(SearchStr, tStr)=0;
 Txz:=Txz+TmpText;
 Replace:=Txz;
End;

FUNCTION RTrim(inString:String; TrimChar:Char):String;
var TmpStr:String;    {Is this really needed?}
Begin
 TmpStr:=inString;
 While TmpStr[Length(TmpStr)]=TrimChar do   Dec(TmpStr[0]);
 RTrim:=TmpStr;
End;

FUNCTION CVV(TmpCvt: Word):Real;   {two bytes to 0.00 version}
Begin
 CVV:=(HI(TmpCvt)/100)+LO(TmpCvt);
End;

FUNCTION BSDel(HowFar:Byte; WithIt:String):String;
var  a1, a2: String;
     a0: Byte;
Begin
  a1:='';  a2:='';
  for a0:=1 to HowFar do
    begin
      a1:=a1+CHR(8);
      a2:=a2+WithIt;
    end;
  BSDel:=a1+a2+a1;
End;

FUNCTION SwapWord(sWord : Word) : Word;
VAR tWord : Word;
BEGIN
  tWord := (Lo(sWord) SHL 8) + Hi(sWord);
  SwapWord := tWord;
END;

{  Intel()  from WATTCP  }
Function Intel(ULONG:LongInt):LongInt; Assembler;
asm
  mov   AX, word ptr [ULONG+2]
  mov   DX, word ptr [ULONG+0]
  xchg  AL, AH
  xchg  DL, DH
end;
{  Intel16()  from WATTCP  }
Function Intel16(UINT:Integer):Integer; Assembler;
asm
  mov   AX, UINT
  xchg  AL, AH
end;

Function NewValWord(InTxt : String):Word;
var
  TmpRes:Word;
  TmpStr:String;
begin
 NewValWord:=0;  TmpRes:=0;
 TmpStr:='';
 while (Pos(InTxt[1],'1234567890')>0) and (Length(TmpStr)>0) do
   begin
      TmpStr:=TmpStr+InTxt[1];
      Delete(InTxt,1,1);
   end;
 Val(InTxt,TmpRes,Result);
 If Result<>0 then TmpRes:=0;
 NewValWord:=TmpRes;
end;

Function NewValInteger(InTxt : String):Integer;
var
  TmpRes:Word;
  TmpStr:String;
begin
 NewValInteger:=0;  TmpRes:=0;
 TmpStr:=InTxt;
 while (Pos(InTxt[1],'1234567890-')>0) and (Length(TmpStr)>0) do
   begin
      TmpStr:=TmpStr+InTxt[1];
      Delete(InTxt,1,1);
   end;
 Val(InTxt,TmpRes,Result);
 If Result<>0 then TmpRes:=0;
 NewValInteger:=TmpRes;
end;

FUNCTION ByteToHEXASCII(tByte : Byte) : String;
VAR Nibble1 : Byte;
		Nibble2 : Byte;
		tStr		: String;
BEGIN
	Nibble1 := (tByte AND $0F); 			 { AND 00001111b }
	Nibble2 := (tByte AND $F0) SHR 4;  { AND 11110000b }
	tStr := HEXChars[Nibble2]+HEXChars[Nibble1];
	ByteToHEXASCII := tStr;
END;

FUNCTION WordToHEXASCII(tWord : Word) : String;
VAR tStr : String;
BEGIN
	tStr := ByteToHexASCII(Hi(tWord));
	tStr := tStr+ByteToHexASCII(Lo(tWord));
	WordToHexASCII := tStr;
END;

FUNCTION LongToHexASCII(tLong : LongInt) : String;
VAR tStr : String;
    TmpBA: Array[0..3] of Byte;
    I : Integer;
BEGIN
  Move(tLong, TmpBA, 4);
  tStr :='';
  For I:=3 downto 0 do tStr:=tStr+ByteToHexASCII(TmpBA[I]);
  LongToHexASCII := tStr;
END;

{ Instr is similar to Pos, but allows to specify a start position at which the
  search in the Target string for the Objct string is to start.

  Copyright (c) 1989-1994 Norbert Juffa
}
FUNCTION  Instr  (Objct, Target: STRING; StartPos: BYTE): BYTE; ASSEMBLER;
ASM
{$IFOPT G+}
           PUSH    BP            { save frame pointer }
{$ENDIF}
           CLD                   { auto increment for string instructions }
           PUSH    DS            { save Turbo Pascal's data segment }
           LES     DI, [Target]  { pointer to target string }
           LDS     SI, [Objct]   { pointer to object string }
           XOR     BX, BX        { initialize }
           OR      BL, [StartPos]{  start position }
           JZ      @NoChange     { don't change when zero }
           DEC     BX            { dekrement start position }
@NoChange: LODSW                 { AL = length Object, AH = 1. char in Object }
           SUB     AL, 1         { length Object - 1 }
           JB      @NotFound1    { exit, if length-1 < 0 }
           MOV     CL, ES: [DI]  { length target String }
           MOV     CH, CL        { length traget String }
           SUB     CL, AL        { length target - length Object + 1 }
           JBE     @NotFound1    { if <= 0, exit }
           SUB     CL, BL        { remaining length Target }
           JBE     @NotFound1    { if <= 0, exit }
           INC     DI            { 1. char in Target }
           ADD     DI, BX        { start position in Target }
           XCHG    CH, BH        { BH = length target string, CH = 0 }
           XCHG    AL, AH        { AL = 1. char Object, AH = length Object }
           MOV     BP, SI        { save pointer }
@Search1:  REPNZ   SCASB         { scan target for 1st char of Object }
           JNZ     @NotFound2    { if not found, exit }
           MOV     BL, CL        { save remaining length target }
           MOV     CL, AH        { char still to compare in Object }
           MOV     DX, DI        { get offset into Target }
           REPZ    CMPSB         { compare CX chars of Target and Object }
           MOV     SI, BP        { offset into Object }
           MOV     DI, DX        { offset into Target }
           MOV     CL, BL        { remaining length Target }
           JNZ     @Search1      { continue search if no complete match }
           SUB     BH, BL        { pos = length Target - remaining len target}
           SUB     BH, AH        { pos = l. Target - rem. l. target - l. Object}
@NotFound1:MOV     CH, BH        { pos }
@NotFound2:MOV     AL, CH        { pos }
           XOR     AH, AH        { clear MSB }
           POP     DS            { restore TURBO Pascal's data segment }
{$IFOPT G+}
           POP     BP            { restore frame pointer }
{$ENDIF}
END; { Instr }


END.


