/*-----------------------------------------------------------------------------
	Do_playback_sound -
			Instructs the sound toolkit to play the sounds that
			are stored in buffers in memory that were allocated
			by set_up_buffers() and filled by do_record_sound().
			2-Jul-94
	
			This function is used by demo1 and demo3.  Please
			refer to DEMO1.C and DEMO3.C for more information.

	DPLAY is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include "sound.h"
#include "dgetbuf.h"
#include "dplay.h"
#include "dtime.h"

#ifdef __STDC__
void do_playback_sound(void)
#else
void do_playback_sound()
#endif
{
	int	i;
	SNDHDR far * shp;

/*	prompt operator and wait for response */

	printf("Press ENTER to start playback.\n");
	while (getch() != '\r')		/*Wait for carriage return */
		;			/*Until then, do nothing*/

	printf("0.0   Seconds of sound played\r");
	for (i = 0; i < numbuffers; i++) {	/*For each buffer */
		shp = sndheaders[i];		/*Get SNDHDR struct address */
		if (shp->sndp->sndlen > 0) {	/*If there is sound in the
						  buffer */
			shp->rate = shp->sndp->rate;	/*Set playback rate to
						the original record rate. Start
						and end in SNDHDR are set to
						zero so entire sound to be
						played*/
			snd_play(shp);	/*Play the sound*/
		}
		show_time();
	}

	snd_flush();			/*Tell the toolkit to finish*/
	while(show_time()) ;		/*Wait for playing to finish*/
	printf("\r\n");
	return;
}

