.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH INTRO PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
INTRO troff documentation \- Version 1(8) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.

WARNING - THIS FILE INCLUDES DIAGRAMS AND REQUIRES A TROFF PACKAGE
CAPABLE OF SUPPORTING A COURIER (FIXED SPACING) FONT.  SEARCH
FOR \fC IF YOU NEED TO MAKE CHANGES.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.de IR
.if t  .in +1.5i
.if n  .in +2.2i
..
.de OR
.if t  .in -1.5i
.if n  .in -2.2i
..
.de TR
.if t  .ti -1.5i
.if n  .ti -2.2i
..
.SH Introduction
.br
The PSSJ Digital Sound Toolkit is a library of functions and
utilities that provide digital audio support on many personal computers
manufactured by Tandy
that were sold under the Tandy, Panasonic and Digital brand-names.

The PSSJ hardware provides the ability to digitally record audible
sounds and store them in digital 
form.  These recorded sounds can then be stored on disk, transmitted 
by modem, or manipulated and combined with other recorded sounds.  These 
sounds can then be reproduced by converting the digital information 
back into audible sounds.  

The toolkit includes library functions that are designed to hide the
complexities and requirements of the PSSJ sound hardware from the
software developer.  The functions provide the ability to record, play
and manipulate sounds, as well as synchronize sounds to video and other
activities.

This distribution contains the following items:
.IN
.TI
o       The PSSJ Sound Toolkit library functions, in binary and source form.
The complete library contains less than 18K of code, small
enough to be used in almost any program.
.br
.TI
o       Include and header files for applications to use.
.br
.TI
o       Sample programs, in source and binary form, that show how to
use the functions in the PSSJ Digital Sound Toolkit functions.
.br
.TI
o       Scripts you can use to create the sample programs and the toolkit library file.
.br
.TI
o       Sample audio files, which can be played using one of the 
demonstration programs.
.br
.TI
o       Documentation in troff/nroff format, along with formatted pages.
.OU

.SH Credit
In 1988, the Tandy Digital Sound Library was developed by Gordon Burditt
(compression functions) and John Elliott IV (misc buffer management
functions) and Frank Durda IV (memory play/record functions and drivers).
The TDSL binary-only distribution provided functions to play and record sound
to and from memory.

In 1992 the author of the PSSJ Digital Sound Toolkit
requested that Tandy release 1988 TDSL to the public domain.  Eventually Tandy
released the TDSL code to the public domain, since Tandy had no future plans
for using the PSSJ chip, the code was of no future interest to them.

The PSSJ Digital Sound Toolkit (PDST) contains a few tiny fragments of the
TDSL code, but the bulk of the modules have been rewritten.  This was done
to provide major new features, such as the ability to record
directly to disk and play data directly from disk, plus elapsed time
functions. 
.if n .bp
.if t .sp
The PSSJ Digital Sound Toolkit is not compatible with
TDSL, so any existing programs will require changes to take advantage
of the new software.

A conditional assembly version of the PDST code that drives Sound Blaster
boards using the same functions has been developed but is
not included in this release.
.if n .sp
.if t .sp
.SH Copyright and Licensing
The PSSJ Digital Sound Toolkit source code, binaries, sample programs and
documentation are Copyright 1994, by Frank Durda IV.
It may be used in whole or in part for any non-commercial use provided
the various credit and copyright texts and messages are left in place.
Persons interested in using the code for commercial projects should contact
the author for a license agreement.  Shareware is considered a commercial
product.
.if t .bp
.if n .sp
The entire toolkit is provided on an "AS IS" basis.  Although I will be
interested to hear about problems or suggested patches or enhancements,
there is no commitment that any problem will be fixed or enhancement
implemented.  It is the responsibility of the user to judge the fitness
of this software.

.SH The Hardware
In 1988, Tandy began using a chip called the PSSJ (Parallel, Serial,
Sound and Joystick) in the Tandy 1000 SL and TL computers.  The PSSJ
chip was used in numerous machine models until 1993, so a large number
of systems exist that contain this basic sound hardware.
PSSJ-based systems sold under the Tandy label include:

.if t  .ta 1.0i 2.0i 3.0i 4.0i 5.0i 6.0i
.if n  .ta 1.2i 2.4i 3.6i 4.8i 6.0i
1000SL  1000TL  1000SL/2        1000TL/2        1000TL/3
.br
1000RL  1000RLX 1000RSX 2500    2500SX
.br
Sensation I (non-motorized CD-ROM drawer), playback only
.br
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i

The digital sound capability of the PSSJ chip is a by-product of the
joystick circuitry.
The key component is an eight-bit digital-to-analog 
converter, also known as a DAC.  (The DAC is inside the PSSJ chip).  The
DAC converts an eight-bit number 
into a corresponding voltage.  Each bit that is turned on produces a 
specific amount of voltage.  For example, when Bit 1 is on the DAC produces
twice as much voltage as it would if Bit 0 was on.  Bit 2 being on produces
twice as much voltage as Bit 1, and so on.  The sum of the voltages
produced by all 8 bits (on or off) becomes the voltage that is 
amplified and sent on to the speaker.  By outputting different voltages 
at regular intervals, a sound can be generated.
.if t .sp
.if n .bp
The way an analog sound is quantized (digitized) is more complicated. 
The method used by the PSSJ chip to make recordings is called
Successive Approximation.
When an input signal is to be digitized, several events occur.
First, the voltage on the input is latched internally.
This is done to prevent any variation in the signal from affecting
the approximation of this sample.  Then the same DAC in the PSSJ that is used
to create sounds during playback begins generating eight different 
voltage levels by turning on and off bits in the DAC circuitry.  The 
PSSJ chip determines if the voltage being input is equal or greater than 
the voltage the DAC outputs when a given bit is on.  The most significant 
bit (7) is checked first to see if its level is greater than or equal 
to the level that was latched.  If so, Bit 7 remains on and will be on 
in the finished byte.  Now Bit 7 is left as it is and the same type of 
comparison is done on Bit 6 and then on the remaining bits.  The procedure 
resembles a binary search, so when all eight bits have been computed, 
the CPU can read the eight bit value present in the DAC and store it 
as one sample of a digital recording.
.if n .sp
.if t .sp
Since the same DAC is used for both playing and recording, only one 
function can be done at a time.  In addition, the joysticks are disabled 
while sound operations are being performed since the joysticks also share 
the same DAC.

To actually record or play back an audible sound, the PSSJ chip
must obtain multiple samples by repeating these operations thousands 
of times a second.  At the same time,  software must manage the digitized 
data and get it to and from the PSSJ chip.  Because it takes a minimum 
of two samples to reproduce a single cycle of an analog waveform, the 
highest frequency that can be recorded and reproduced is about one-half 
the sampling rate.  This table can be used as a guide:

.IN
Sampling        Highest Recordable
.br
Rate            Frequency

5,500 Hz        2,500 Hz
.br
11,000 Hz       5,000 Hz
.br
22,000 Hz       10,000 Hz
.br
.OU
.if t .bp
.if n .bp
The higher the sampling rate, the higher the frequencies that can be 
recorded, while the lower frequencies will be recorded more accurately. 
For example, the following charts show a 5,500 Hz waveform that is 
recorded at these three sampling rates and what the signal will look 
like in digitized form.  Each sampling point is circled.

.nf
.if n \&        Original Signal                       Sampled at 5,500Hz
.if n \&    o               o
.if n \&   o o             o o                               
.if n \&  o   o           o   o    
.if n \& o     o         o     o   
.if n \&o       o       o       o       o      o_______o_______o_______o_______o
.if n \&         o     o         o     o 
.if n \&          o   o           o   o
.if n \&           o o             o o  
.if n \&            o               o
.if n .sp
.ig
123456789012345678901234567890123  123456789012345678901234567890123
..
.if n \&     Sampled at 11,025Hz                     Sampled at 22,050Hz
.if n \&    o___            o___                   o_              o_  
.if n \&    |   |           |   |                  | |             | |
.if n \&    |   |           |   |                o_  o_          o_  o_
.if n \&    |   |           |   |                |     |         |     |
.if n \&o___    o___    o___    o___    o      o_      o_      o_      o_      o
.if n \&            |   |           |   |                |     |         |     |
.if n \&            |   |           |   |                o_  o_          o_  o_
.if n \&            |   |           |   |                  | |             | |
.if n \&            o___            o___                   o_              o_
.if n .sp
.if t .sp
.if t \&               Original Signal                                  Sampled at 5,500Hz
.if t \0\0\0\0o\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o
.if t \0\0\0o\0o\0\0\0\0\0\0\0\0\0\0\0\0\0o\0o                               
.if t \0\0o\0\0\0o\0\0\0\0\0\0\0\0\0\0\0o\0\0\0o    
.if t \0o\0\0\0\0\0o\0\0\0\0\0\0\0\0\0o\0\0\0\0\0o   
.if t \&o\0\0\0\0\0\0\0o\0\0\0\0\0\0\0o\0\0\0\0\0\0\0o\0\0\0\0\0\0\0o\0\0\0\0\0\0o______o______o______o______o
.if t \0\0\0\0\0\0\0\0\0o\0\0\0\0\0o\0\0\0\0\0\0\0\0\0o\0\0\0\0\0o 
.if t \0\0\0\0\0\0\0\0\0\0o\0\0\0o\0\0\0\0\0\0\0\0\0\0\0o\0\0\0o
.if t \0\0\0\0\0\0\0\0\0\0\0o\0o\0\0\0\0\0\0\0\0\0\0\0\0\0o\0o  
.if t \0\0\0\0\0\0\0\0\0\0\0\0o\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o
.if t .sp
.ig
123456789012345678901234567890123  123456789012345678901234567890123
..
.if t \&         Sampled at 11,025Hz                              Sampled at 22,050Hz
.if t \0  \0\0o___\0\0\0\0\0\0\0 \0\0\0\0o___\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o_\0\0\0\0\0\0\0\0\0\0\0\0o_  
.if t \0\0 \0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0|\0\0\0\0\0\0\0\0\0\0\0\0|\0 |
.if t \0 \0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o_\0 o_\0\0\0\0\0\0\0\0\0o_\0 o_
.if t \0 \0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0|\0\0\0\0\0\0\0\0 |\0\0\0\0\0|
.if t o____\0\0\0o____\0\0\0o____\0 \0o____\0\0 o\0\0\0\0\0\0\0o_\0\0\0\0\0o_\0\0\0\0\0o_\0\0\0\0\0o_\0\0\0\0\0\0o
.if t \0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0 |
.if t \0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0o_\0 o_\0\0\0\0\0\0\0\0\0o_\0\0o_
.if t \0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0|\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0|\0\0\0\0\0\0\0\0\0\0\0\0\0|\0|
.if t \0\0 \0\0\0\0\0\0\0\0\0\0o___\0\0\0\0\0\0\0\0\0\0\0o___\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 o_\0\0\0\0\0\0\0\0\0\0\0\0\0o_
.if t .sp

.fi
If the sampling rate is too low, there is not enough information to 
reproduce something that sounds like the original sound.  As the sampling 
rate increases the resulting waveform resembles the original more closely. 
A roll-off filter is present in the PSSJ hardware design that eliminates
frequencies that could not be recorded even with the 22,000 Hz sampling rate.
Without this filter, additional distortion could be introduced into the
recordings.
.if n .sp
.if t .sp
One specific form of distortion that arises in digital sound reproduction 
is called "aliasing". Most people have seen a form of aliasing when watching 
a movie where the spoked wheels on a vehicle that is in motion appear to
turn backwards or
stand still.  The wheel appears to stand still because the wheel was turning 
at the same speed as the camera shutter was exposing frames of film.
This causes 
the camera to expose each frame of the film when the wheel is in the
same position, making it appear to stand still.
.if n .bp
.if t .sp
Aliasing in digital sound occurs when a frequency being recorded is
equal or greater than half the sampling rate.  When this occurs, the
resulting recording will not reflect the true frequency of the input signal.
For example, the chart above showing the result of a 5.5 KHz signal
being sampled at 5.5 KHz, shows no change in the recorded signal.
Because each sample was taken when the input signal was at the same
amplitude, the recorded signal will play back as silence.  The PSSJ
hardware circuitry includes an input roll-off filter that eliminates
some of the aliasing problems, but it is
important to select a sampling rate that best matches the type of audio
you are recording.  Most forms of music need a higher sampling rate than
a baritone voice.

The PSSJ output section also has a roll-off filter to reduce switching noise 
caused by the processor.  The combination of roll-off filters on input
and output causes frequencies above 5 KHz to be attenuated.  The higher
the frequency, the more attenuation.  You may want to use an equalizer
to boost higher frequencies when making recordings so that they will
sound more natural when they are played-back.

The PSSJ chip is able to sample at rates higher than 22,000 Hz, but
the analog hardware is optimized for signals below about 10,000 Hz.

To improve the resulting reproduction of a digitized sound recorded 
at a sampling rate lower than 22KHz, the toolkit routines compute
intermediate samples so that 22,000 samples per second are always sent to
the PSSJ chip during playback.  This process is called oversampling.
When playing 11,000Hz
audio, one sample is computed for every "real" one.  At 5,500Hz, three
intermediate samples are computed.  The intermediate samples are computed
by taking averages between "real" samples.  For rates that are not
an evenly divisible by 22,000, oversampling is not performed.
.if n .sp
.if t .sp
.SH The Software
The functions (calls) provided in the PSSJ Digital Sound Toolkit allow the 
caller to record and play sounds without having to deal with most of 
the hardware-related activities.  Some of the key functions included 
in the sound toolkit are discussed briefly below. Each function has its
own manual page describing its operation in detail.

All functions included in the toolkit are written to expect C-style 
calling rules and all functions must be called FAR.  The toolkit functions 
further assume that SS is equal to DS.  Only the registers SI and DI 
are preserved across calls to the toolkit functions.  All functions return
result codes in AX (short), unless otherwise specified.  Functions returning
a long do so with the most significant word in DX and the least significant 
word in AX.  A few functions return far pointers with the segment in 
DX and the offset in AX.  All of these return formats are compatible 
with Microsoft C.
.if n .bp
.if t .sp
Since the developer may choose to use a different language than C, the 
developer is responsible for opening and closing files and allocating all
memory required by the functions in the toolkit.  The developer informs
the toolkit functions of the address of these memory areas by
calling \fIsnd_addbuf\fR.  If the development language you are using requires
the memory to be released before
terminating, the developer's code is also responsible for this task
after calling \fIsnd_exit\fR.

The drivers within the toolkit make extensive use of interrupts 
and one DMA channel to operate the sound hardware.  (The interrupt and 
DMA channel that are to be used are specified in the \fIsnd_init\fR call.) 
Because the interrupts must be serviced frequently, the developer must 
ensure that interrupts do not remain off for more than 3 milliseconds
at a time while playing or recording sounds.  The DMA channel that the 
sound hardware uses must not be used for any reason during the entire 
use of the sound toolkit, which starts with a call to \fIsnd_init\fR and 
ends with a call to \fIsnd_exit\fR.
.if n .sp
.if t .sp
The \fIsnd_play\fR call is used to output sounds located in designated
buffers. Repeated calls to \fIsnd_play\fR will cause the sounds to be
played back to back in a seamless fashion, assuming that the subsequent
calls are made frequently enough. 
The sound data provided by the caller may be expanded (depending on 
the sampling rate) by the toolkit and this data is placed in a series of
fixed-size buffers.  

These buffers are placed on a queue which is handed to an internal function 
that programs the DMA to run continuously in the same fixed-size area. 
If the DMA were allowed to stop, the brief time it takes to program it to
point to the next section of the sound and resume the transfer would be 
audible to the listener as a "wow" or "flutter" in the sound.  To avoid this,
the DMA runs continuously through the same buffer and the sound driver inserts 
subsequent portions of the sound into the buffer when interrupts and 
other status indicate that the DMA is transferring data in other parts 
of the buffer.  When the DMA returns to a given point, new sound information 
will be present.  (This "circular" DMA mode is also known as 
Auto-Initialize Mode and is also used in recording.)
.if n .sp
.if t .bp
To help synchronize sound output with other activity such as animation, 
\fIsnd_buf_wait\fR allows the caller to determine when a specific sound,
previously supplied to \fIsnd_play\fR, is about to start outputting.
The \fIsnd_flush\fR call forces the player to queue any residual sound
data and makes sure that the player has started.  The amount of data
accumulated before the player starts automatically is determined by the
number of buffers provided to \fIsnd_addbuf\fR and a parameter to
\fIsnd_init\fR.  The \fIsnd_wait\fR function allows the developer to
determine when the player has output all of the sounds that have been
queued.  The \fIsnd_stop\fR function can either terminate the sound
output immediately or at a certain point. 
The output level can be set with \fIsnd_volume\fR, but cannot be adjusted 
while sound is being produced.
.if n .bp
.if t .sp
The \fIsnd_record\fR call causes the hardware to start digitizing sounds 
and stores the resulting data in an area the developer specifies in the 
call.  The \fIsnd_wait\fR call will inform the developer when recording has 
finished, and the \fIsnd_stop\fR call can terminate recording at any point. 
A "bucket-brigade" buffering system can be implemented by multiple calls 
to \fIsnd_record\fR.  This allows the sound toolkit to record into one buffer 
and switch to a second, while the caller is processing the first and 
preparing a third. This allows continuous or extended recording to be
performed.

The \fIsnd_amplify\fR function is the first of a series of functions that 
can be used to manipulate sound data.  With it, the amplitude of a section 
of sound can be increased or reduced.  The \fIsnd_amplify\fR call merely 
prepares the information needed for the manipulation.  The developer 
calls \fIsnd_apply_func\fR to indicate what sound is to be worked on.  In 
this way several sounds or only portions of a given sound can be modified.

The \fIsnd_compress_part\fR allows digitized sounds to be compressed 
so that they require less memory for storage.  Some compression methods 
can be adjusted to be more aggressive at the cost of time and sound quality, 
but the compressed sound will take even less space.  The compressed sounds 
are passed to \fIsnd_decompress_part\fR, which restores them to a
playable form. 

Finally, the \fIsnd_play_file\fR and \fIsnd_record_file\fR functions play
the contents of files on a hard disk drive, or make recordings directly to
a file on a hard disk.  These functions take care of all buffering and
timing issues.

Example uses of these functions can be found in the sample programs in the
DEMOSRC directory.

.SH Structures and Defines
.IN
typedef unsigned long u_long;
.br
typedef unsigned int u_int;
.br
typedef unsigned short u_short;
.br
typedef unsigned char u_char;
.br
typedef char far * saddr;
.br
.OU

The above types are used throughout the sound libraries.  
.if t .bp
.if n .sp
.nf
typedef struct sound {
.if t   saddr   buffer;                 /* The sound buffer itself */
.if n   saddr   buffer;                 /* The sound buffer itself */
.if n   u_long  sndlen;         /* Length of the sound in the buffer */
.if n   u_long  buflen;         /* Length of the buffer itself */
.if t   u_long  sndlen;                 /* Length of the sound in the buffer */
.if t   u_long  buflen;                 /* Length of the buffer itself */
.if t   u_char  rate;                   /* Rate the sound was recorded at */
.if n   u_char  rate;                   /* Rate the sound was recorded at */
.if n   u_char  system;         /* Sound source (see defines below) */
.if n   u_long  reserved[4];    /* Reserved for internal use */
.if t   u_char  system;                 /* Sound source (see defines below) */
.if t   u_long  reserved[4];            /* Reserved for internal use */
} SOUND;
.if n .bp
.if t .sp
/* Machine sound came from */
.if n #define B_SYNTH 0                         /* Sound was synthetically produced */
.if t #define B_SYNTH 0                 /* Sound was synthetically produced */
#define B_MAC      0                    /* Sound came from a Macintosh(R) */
#define B_SB       0                    /* Sound came from a SB or PC sound card*/
#define B_AT8      1                    /* Recorded on a 8mhz AT compatible */
#define B_SL       2                    /* Recorded on a 1000-SL */
#define B_TL       3                    /* Recorded on a 1000-TL */
#define B_PSSJ2    4                    /* System with 2nd generation PSSJ chip */
.if n                                           /* Recording rate matches playback */
.if t                                   /* Recording rate matches playback */

/* Sampling rate defines */
#define R5500      1                    /* 5.5KHz sample rate */
#define R11000     2                    /* 11KHz sample rate */
#define R22000     3                    /* 22KHz sample rate */

.fi
The \fISOUND\fR structure is used to describe a sound or a place to put a 
sound when recording.  A \fISOUND\fR structure is handed to \fIsnd_record\fR,
and it fills in the elements of the structure which describe the sound.  
The caller sets the elements buffer and buflen, and \fIsnd_record\fR fills 
in the rest.

\fIBuffer\fR is a pointer to the memory where the sound itself is stored.
\fIsndlen\fR is the length of the sound (in bytes).  It should never be longer 
than \fIbuflen\fR.
\fIBuflen\fR is the length of the buffer in which the sound is stored.
\fIsnd_record\fR uses \fIbuflen\fR.
\fIRate\fR is set by \fIsnd_record\fR.  It is the sampling rate at which
the sound was recorded.
\fISystem\fR is set by \fIsnd_record\fR.  It is the type of machine on
which the sound was recorded.
\fIReserved\fR is a field which is reserved for internal use.  Do not
refer to or alter this field.

.nf
typedef struct sndhdr {
    /* The following items, except "ticket", "reserved1", and
       reserved2" are to be filled in by the caller */
.if n   SOUND  far      *sndp;          /* The sound structure */
.if t   SOUND  far      *sndp;          /* The sound structure */
.if n   u_long  start;          /* Where to start playing */
.if t   u_long  start;                  /* Where to start playing */
.if n   u_long  end;                    /* Where to stop playing */
.if t   u_long  end;                    /* Where to stop playing */
.if n   u_short ticket;         /* When buffer was/is-to-be played */
.if t   u_short ticket;                 /* When buffer was/is-to-be played */
.if n   u_char  rate;                   /* Rate sound is to be played at */
.if t   u_char  rate;                   /* Rate sound is to be played at */
.if n   u_char  reserved1;              /* Reserved for internal use */
.if t   u_char  reserved1;              /* Reserved for internal use */
.if n   u_long  reserved2[4];   /* Also reserved for internal use */
.if t   u_long  reserved2[4];           /* Also reserved for internal use */
} SNDHDR;
.fi
.if t .bp
.if n .sp
A \fISNDHDR\fR structure is used to describe to \fIsnd_play\fR what part
of a sound to play, at what rate to play it, and where the sound is.
A \fISNDHDR\fR points to a \fISOUND\fR structure.  \fISNDHDR\fR structures
are used with the following calls:

		snd_play(PSSJ),                 snd_wait(PSSJ),
.br
		snd_stop(PSSJ)
.if n .bp
.if t .sp
The following calls all use \fISOUND\fR structures:

.if n           snd_record(PSSJ),                       snd_compress_part(PSSJ),
.if t           snd_record(PSSJ),               snd_compress_part(PSSJ),
.br
		snd_apply_func(PSSJ),           snd_decompress_part(PSSJ)

Be careful not to confuse the two structures.

\fISndp\fR is the pointer to the \fISOUND\fR structure, which describes
the sound to be played.
\fIStart\fR is the index into the sound from which to start playing
(the playing starts at \fISNDHDR.sndp\fR->\fIbuffer\fR[\fIstart\fR]) 
\fIEnd\fR is the index into the sound before which the playing is to stop 
(the playing ends the byte before
\fISNDHDR.sndp\fR->\fIbuffer\fR[\fIend\fR]).  A value of \fB0\fR means play
to the end of the sound.
\fIRate\fR is the rate at which the sound is to be played back.
\fISnd_play\fR ignores the \fIrate\fR field in the \fISOUND\fR structure.
\fITicket\fR is used internally by the sound toolkit to identify which
play buffer contains the sound.
\fIReserved1\fR and \fIreserved2\fR are elements which are reserved for
internal use.  Do not refer to or alter these fields.


.nf
/* Error codes for sound calls */
#define BADFMT          -3      /* Decompress called with corrupted data
					   or sound compressed with unsupported
					   algorithm */
#define BADPARM         -2      /* Compress called with bad type or
					   compress_mode */
#define INVALID         -1      /* Call made when driver uninitialized
					   or call not legal at this point */
#define NOERROR         0       /* Call succeeded */
#define INITBUF         1       /* Insufficient buffers were allocated
					   before snd_init(PSSJ) was called */
.if n #define INIT64K           2       /* All buffers spanned 64k addresses */
.if t #define INIT64K                   2       /* All buffers spanned 64k addresses */
#define BADDMA          3       /* The DMA Channel requested is invalid */
.if n #define BADIRQ            4       /* The IRQ number requested is invalid */
.if t #define BADIRQ                    4       /* The IRQ number requested is invalid */
.if n #define NOIRON            5       /* Can't find the sound hardware */
.if t #define NOIRON                    5       /* Can't find the sound hardware */
#define BADSIZE         6       /* Record buffer is too small or
					   too small for the requested time */
.if n #define WOULDBLOCK        7       /* snd_record(PSSJ) failed because two buffers
.if t #define WOULDBLOCK                7       /* snd_record(PSSJ) failed because two buffers
					   are already queued and block was FALSE */
.fi
.if t .bp
.if n .sp
These "defines" list all the error codes that are produced by calls 
in the sound toolkit.  Of the calls that do return error codes, most 
return at least \fBINVALID\fR and \fBNOERROR\fR.  See the individual
description of each call for specifics.
.if n .bp
.if t .sp
.nf
/* Scratch area for internal use of compress/decompress routines */
typedef struct {
	u_long          scratch[20];  /* Scratch area */
} COMPINFO;
.fi

This structure is used by \fIsnd_compress_part\fR and
\fIsnd_decompress_part\fR. These routines store internal information about
the compression or decompression in progress.  Do not alter or refer to
anything in this structure.

.SH Function Call Summary
These functions form the initial installment of the PSSJ Digital Sound
Toolkit:
.if n .ta 2.0i
.if t .ta 1.4i
.IR
.TR
snd_addbuf      - Adds memory for the player to use
.br
.TR
snd_init        - Initializes the sound chip and disables the joysticks
.br
.TR
snd_exit        - Turns the sound chip off and re-enables the joysticks
.br

.TR
snd_play        - Plays sound(s) in memory
.br
.TR
snd_file_play   - Plays sound(s) from files
.br
.TR
snd_volume      - Sets the output level for play
.br
.TR
snd_flush       - Starts playing queued sounds
.br
.TR
snd_record      - Records a sound into memory
.br
.TR
snd_file_record - Records sound(s) into files
.br
.TR
snd_compensate  - Creates a recording translation table
.br
.TR
snd_cue - Places the hardware in standby for playing or recording
.br
.TR
snd_wait        - Waits or reports how long recording or playback has been active.
.br
.TR
snd_buf_wait    - Waits for the sound in a specified or for all sounds to finish playing.
.br
.TR
snd_stop        - Stops the sound output or stops recording at a given time.
.br
.TR
snd_buf_stop    - Stops the sound output at a particular memory buffer.
.br

.TR
snd_apply_func  - Applies a function table (generated by one of the routines listed below) to a sound
.br
.TR
snd_amplify     - Generates a function table used to amplify a sound
.br
.TR
snd_compress_part       - Performs data compression on a sound
.br
.TR
snd_decompress_part     - Performs data decompression on a sound
.br

.TR
snd_version     - Returns the version number of the PSSJ Digital Sound Toolkit Library
.br
.fi
.in 0i

.br
\-\-\-\-\-\-
.br
410188

