	page	60,132
;-----------------------------------------------------------------------------
;	Rampup.asm    - Ramp up/down volume levels for playback
;	RAMPUP.ASM is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.

;	This routine covers a problem in the PSSJ sound output circuit that
;	produces an annoying "click" when playback mode is entered or
;	when a gain level is changed.   It cannot cover it all.
;	The hardware problem is that the base output level and the
;	on/off transition has no slew, and causes the speaker cone
;	to change its idling position.
;	If this is ever fixed in hardware, this code will become a waste.
;<13>	No hardware fix for 1989 systems either (TL2/SL2), so guess we need
;<13>	it forever.
;<29>	The NEW PSSJ chip (in TL3 and later systems) does not solve the click,
;	but it makes it possible to hide the click.  The "off" voltage has
;	been moved up so that it is now in the range of voltages we can
;	slew from.  Great, but the existing code isn't any good for that,
;	so we have to re-write almost everything and generate new tables for
;	the old chip.
;	14-Nov-89 Frank Durda IV

;	The procedure is reversed for shutdown of playback mode.
;	To go from one level to another, suggest ramping down at
;	the old level, pick up the new level and ramp up to it.
;	The transition could occur at level 1, eliminating the 10%
;	glitch, but it should not make the code that complicated.
;-----------------------------------------------------------------------------
	extrn	snd_mode:word		;<22>
	extrn	snd_mode2:word
	extrn	cur_db_level:byte
	extrn	db_level:byte
	extrn	DacBase:word
	extrn	machine:byte

	include	sound.inc
	page
snddata	segment	public 'DATA'
oldtbl	dw	ogain0			;Placeholder
	dw	ogain1
	dw	ogain2
	dw	ogain3
	dw	ogain4
	dw	ogain5
	dw	ogain6
	dw	ogain7

newtbl	dw	ogain0			;Placeholder
	dw	ngain1
	dw	ngain2
	dw	ngain3
	dw	ngain4
	dw	ngain5
	dw	ngain6
	dw	ngain7

;	Table entries are:
;	gain, start, end
;	next gain, next start, next end
;	0,0

	db	0			;NULL for backwards searches
ogain0	db	0,80h,80h
	db	0,0

ogain1	db	020h,0,080h
	db	0,0

ogain2	db	020h,0,02ch
	db	040h,0,080h
	db	0,0

ogain3	db	020h,0,067h
	db	060h,0,080h
	db	0,0

ogain4	db	020h,0,0bch
	db	080h,0,080h
	db	0,0
	page
ogain5	db	020h,0,0bch
	db	080h,0,02bh
	db	0a0h,0,080h
	db	0,0

ogain6	db	020h,0,0bch
	db	080h,0,067h
	db	0c0h,0,080h
	db	0,0

ogain7	db	020h,0,0bch
	db	080h,0,0bdh
	db	0e0h,0,080h
	db	0,0

ngain1	db	080h,0dch,0		;.592 -> .459
	db	020h,0bdh,80h		;.459 -> .446
	db	0,0

ngain2	db	080h,0dch,0dh		;.592 -> .467
	db	040h,80h,080h		;.467
	db	0,0

ngain3	db	080h,0dch,3dh		;.592 -> .496
	db	060h,80h,080h		;.496
	db	0,0

ngain4	db	080h,0dch,080h
	db	0,0

ngain5	db	0a0h,7dh,80h
	db	0,0

ngain6	db	0c0h,3ah,080h
	db	0,0

ngain7	db	0e0h,0ah,080h		;<32>was 0bh
	db	0,0
snddata	ends

	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata

;------------------------------------------------------------------------------
;	Snd_Play_On	Sets hardware up for playback as quietly as possible
;
;	Accepts:	
;		No parms passed,
;		Reads mode and db_level control bytes

;	Returns:
;		No result parameter
;		Writes mode and cur_db_level control bytes
;------------------------------------------------------------------------------

		public snd_play_on
snd_play_on	proc near
	or	byte ptr snd_mode,RAMPUP;<22>Set rampup flag

	push	si			;Save regs, a,b,c and d are
	push	di			;volatile, right?

	cld				;Force direction
	mov	al,db_level		;Get volume to use
	mov	cur_db_level,al		;Save for rampdown

	mov	dx,DacBase		;Get base port number
	shl	al,1			;Convert into offset

	mov	bx,snd_mode2		;<9>
	test	bx,FASTRAMP		;<9>
	jz	$slowramp		;<9>

;	Just turn it on, let the click be heard

	shl	al,1			;<9>
	shl	al,1			;<9>
	shl	al,1			;<9>
	shl	al,1			;<9>
	mov	ah,al			;<9>
			
	mov	al,DMAIEI		;<9>
	out	dx,al			;<9>
	xor	al,al
	inc	dx
	inc	dx
	inc	dx
	out	dx,al			;Set gain to zero
	page
	mov	dx,DacBase		;Get base port number
	mov	al,PLAYMODE OR DMAIEI	;<9>Set playback mode
	out	dx,al			;<9>Now in play, no DMA, no Ints
	inc	dx			;<9>
	mov	al,80h			;<9>
	out	dx,al			;<9>Set DAC to 80h
	inc	dx
	inc	dx			;Set final gain
	mov	al,ah			;<9>Set final Gain
	out	dx,al			;<9>
	jmp	$rampdone		;<9>
	
$slowramp:
	mov	si,offset oldtbl 	;Assume table for old hardware
	mov	bl,machine
	cmp	bl,M1KSLTL2		;Does this machine need a
					;different table?
	jnz	$oldtab
	mov	si,offset newtbl	;Select table for new hardware

$oldtab:sub	ah,ah
	add	si,ax			;Point at entry
	mov	si,[si]			;Point at start of table

	mov	al,DMAIEI		;Only interrupts
	out	dx,al			;Confirm hardware is
					;in joystick mode

	inc	dx			;305
	mov	di,dx			;Save DAC out port #
	inc	dx			;306
	inc	dx			;307
	mov	cx,dx
	xor	al,al
	out	dx,al			;Set gain to zero - after we enter
					;direct write mode, this will result
					;in same voltage as "not in dir mode"
	mov	dx,di			;305
	dec	dx			;Point at command port
	mov	al,PLAYMODE OR DMAIEI
	out	dx,al			;Now in play, no DMA, no Ints
	page
;	Hardware is in direct write mode, now that DAC port is visible,
;	entering starting settings.

	lodsb				;Get first gain seting
	mov	ah,al			;<32>Save first gain setting

	lodsb				;Get starting DAC setting
	mov	dx,di			;Get DAC port #
	out	dx,al			;Set DAC

	mov	dx,cx			;Get gain port #
	xchg	ah,al			;<32>Save starting DAC val in AH
					;<32>Load gain setting into AL
	out	dx,al			;Set starting gain position


;	We are now in play mode - on new hardware, no voltage swing
;	should occur.

;	Okay, here are the players:
;	si points at next command byte, in this case, end of range
;	di contains port # of DAC  305
;	ah = DAC setting we we started at 


$nxt1:	mov	bh,[si]			;Get end of range
	inc	si
	mov	dx,di			;Save DX to DAC port
	cmp	bh,ah			;Which way are we going
	mov	al,ah
	jc	$lower1			;Counting down
	
;	Here we are counting up

$up1:	cmp	al,bh
	jnc	$enx			;<32>
	add	al,1h			;<32>
	out	dx,al
	call	$delay
	jmp	$up1

;	Here we are counting down

$lower1:cmp	al,bh
	jz	$enx
	dec	al
	call	$delay
	out	dx,al
	jmp	$lower1
	page
;	Here the slew through one Gain setting is complete.

$enx:	lodsw				;Read next gain and starting pos
					;gain is in al, pos in ah
	or	ax,ax			;Or is this the end?
	jz	$rampdone
	mov	dx,cx			;307
	pushf				;Save interrupt setting
	cli	;--------------------------------------------------------------
	out	dx,al			;Set new GAIN value
	mov	dx,di			;305
	mov	al,ah
	out	dx,al			;Set new DAC value
	popf	;--------------------------------------------------------------
	jmp	$nxt1			;Loop through this GAIN setting

$rampdone:
	pop	di
	pop	si			;Restore reg variables
	ret				;Near or FAR
snd_play_on	endp

	page
	public snd_play_off
snd_play_off	proc near

;------------------------------------------------------------------------------
;	Snd_Play_Off	Turns off playback mode in hardware (quietly)
;
;	Accepts:	No parms passed,
;			Reads mode and cur_db_level control bytes

;	Returns:	No result
;			Writes mode control byte
;------------------------------------------------------------------------------

	and	byte ptr snd_mode,NOT RAMPUP	;<22>Clear play-state flag

	push	si			;Save regs, a,b,c and d are
	push	di			;volatile, right?

	mov	ax,snd_mode2		;<9>
	test	ax,FASTRAMP		;<9>
	jz	$quiet
	jmp	$fastdown		;<9>
$quiet:	mov	al,cur_db_level		;Get volume to use

	shl	al,1			;Convert into offset
	mov	si,offset oldtbl 	;Assume table for old hardware
	mov	bl,machine
	cmp	bl,M1KSLTL2		;Does this machine need a
					;different table?
	jnz	$oldtab1
	mov	si,offset newtbl	;Select table for new hardware

$oldtab1:
	sub	ah,ah
	add	si,ax			;Point at entry
	mov	si,[si]			;Point at start of table
	page
;	Since we do this backwards, scan ahead for terminator

$srch:	mov	al,[si]
	or	al,al
	jz	$end
	inc	si
	inc	si
	inc	si
	jmp	short $srch

$end:	dec	si			;Point at gain of 
	dec	si			;last ramp
	dec	si

	mov	dx,DacBase		;Get Base port number
	inc	dx

;	Move output level to 80h first

	in	al,dx
	cmp	al,80h			;Are we there already?
	jz	$ego
	ja	$gdown

;	Here we need to move towards the centerline

$gup:	inc	al
	out	dx,al
	call	$delay
	cmp	al,80h
	jnz	$gup
	jmp	$ego

$gdown:	dec	al
	out	dx,al
	call	$delay
	cmp	al,80h
	jnz	$gdown
	page
;	Get ready to perform the standard ramp

;	We are now in leaving play mode - on new hardware, no voltage swing
;	should occur.

;	Okay, here are the players:
;	si points at next command byte, in this case, end of range
;	di contains port # of DAC  305
;	ah = DAC setting we we started at 


$ego:	mov	di,dx			;Save DAC port
	inc	dx
	inc	dx
	mov	cx,dx			;Save Gain Port
	mov	ah,80h
$nxt2:	mov	bh,[si+1]		;Get start of range
	mov	dx,di			;Save DX to DAC port
	cmp	bh,ah			;Which way are we going
	mov	al,ah
	jc	$lower2			;Counting down
	
;	Here we are counting up

$up2:	cmp	al,bh
	jz	$enx2
	inc	al
	call	$delay
	out	dx,al
	jmp	$up2

;	Here we are counting down

$lower2:cmp	al,bh
	jz	$enx2
	dec	al
	call	$delay
	out	dx,al
	jmp	$lower2
	page
;	Here the slew through one Gain setting is complete.

$enx2:	dec	si			;Read next gain and starting pos
	dec	si			;gain is in al, pos in ah
	mov	ax,[si]
	or	ax,ax			;Or is this the end?
	jz	$rampdone2

	dec	si
	mov	al,[si]			;Get new gain value
	mov	ah,[si+2]		;Get ending (our start) value
	mov	dx,cx			;307
	pushf				;Save interrupt setting
	cli	;--------------------------------------------------------------
	out	dx,al			;Set new GAIN value
	mov	dx,di			;305
	mov	al,ah
	out	dx,al			;Set new DAC value
	popf	;--------------------------------------------------------------
	jmp	$nxt2			;Loop through this GAIN setting

$rampdone2:
	mov	dx,cx			;Point at gain
	xor	al,al
	out	dx,al			;Set gain to zero
$fastdown:
	mov	dx,DacBase
	mov	al,DMAIEI		;Interrupt mode only
	out	dx,al			;Turn off hardware
	inc	dx
	mov	al,0ffh
	out	dx,al			;Reset TI sound chip
					;(Was DAC Write field)
	pop	di
	pop	si			;Restore reg variables
	ret				;Near or FAR


$delay:	push	cx
	mov	cx,100			;Was 100 then was 1000
					;100 sounds ok on LX and TL,
					;so 200 should be wonderful
$dl1:	loop	$dl1
	pop	cx
	ret

snd_play_off	endp

sndseg	ends
	end

