/*
 * $Workfile: $
 * $Revision: $
 * $Date: $
 *
 * Copyright (c) 1999-2000 National Semiconductor Corporation.
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of National 
 * Semiconductor Corporation. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into
 * with National Semiconductor Corporation.
 * This code is supplied as is.
 *
 * This header file contains the mode tables.  It is used by the "gfx_disp.c" 
 * file to set a display mode.
 */

/*
 *$History: $
*/

/* MODE FLAGS (BITWISE-OR) */

#define GFX_MODE_8BPP		0x00000001
#define GFX_MODE_16BPP		0x00000002
#define GFX_MODE_60HZ		0x00000004
#define GFX_MODE_70HZ		0x00000008
#define GFX_MODE_72HZ		0x00000010
#define GFX_MODE_75HZ		0x00000020
#define GFX_MODE_85HZ		0x00000040
#define GFX_MODE_NEG_HSYNC	0x00000080
#define GFX_MODE_NEG_VSYNC	0x00000100

/* STRUCTURE DEFINITION */

typedef struct tagDISPLAYMODE
{
	/* DISPLAY MODE FLAGS */
	/* Specify valid color depths and the refresh rate. */

	unsigned long flags;

	/* TIMINGS */

	unsigned short hactive; 
	unsigned short hblankstart; 
	unsigned short hsyncstart; 
	unsigned short hsyncend; 
	unsigned short hblankend; 
	unsigned short htotal; 

	unsigned short vactive;
	unsigned short vblankstart;
	unsigned short vsyncstart;
	unsigned short vsyncend;
	unsigned short vblankend;
	unsigned short vtotal;

	/* CLOCK FREQUENCY */
	
	unsigned long frequency;

} DISPLAYMODE;

DISPLAYMODE DisplayParams[] = {

/* 640x480 */

{ GFX_MODE_60HZ |									/* refresh rate = 60  */
  GFX_MODE_8BPP | GFX_MODE_16BPP |					/* 8 and 16 BPP valid */
  GFX_MODE_NEG_HSYNC | GFX_MODE_NEG_VSYNC,			/* negative syncs     */
  0x0280, 0x0288, 0x0290, 0x02E8, 0x0318, 0x0320,	/* horizontal timings */
  0x01E0, 0x01E8, 0x01EA, 0x01EC, 0x0205, 0x020D,   /* vertical timings   */
  0x00192CCC, 										/* freq = 25.175 MHz  */
},

{ GFX_MODE_72HZ |									/* refresh rate = 72  */
  GFX_MODE_8BPP | GFX_MODE_16BPP |					/* 8 and 16 BPP valid */
  GFX_MODE_NEG_HSYNC | GFX_MODE_NEG_VSYNC,			/* negative syncs     */
  0x0280, 0x0288, 0x0298, 0x02c0, 0x0338, 0x0340,	/* horizontal timings */
  0x01e0, 0x01e8, 0x01e9, 0x01ec, 0x0200, 0x0208,   /* vertical timings   */
  0x001F8000, 										/* freq = 31.5 MHz    */
},

{ GFX_MODE_75HZ |									/* refresh rate = 75  */
  GFX_MODE_8BPP | GFX_MODE_16BPP |					/* 8 and 16 BPP valid */
  GFX_MODE_NEG_HSYNC | GFX_MODE_NEG_VSYNC,			/* negative syncs     */
  0x0280, 0x0280, 0x0290, 0x02D0, 0x0348, 0x0348,	/* horizontal timings */
  0x01E0, 0x01E0, 0x01E1, 0x01E4, 0x01F4, 0x01F4,	/* vertical timings   */
  0x001F8000, 										/* freq = 31.5 MHz    */
},

{ GFX_MODE_85HZ |									/* refresh rate = 85  */
  GFX_MODE_8BPP | GFX_MODE_16BPP |					/* 8 and 16 BPP valid */
  GFX_MODE_NEG_HSYNC | GFX_MODE_NEG_VSYNC,			/* negative syncs     */
  0x0280, 0x0280, 0x02B8, 0x02F0, 0x0340, 0x0340,   /* horizontal timings */
  0x01E0, 0x01E0, 0x01E1, 0x01E4, 0x01FD, 0x01FD,   /* vertical timings   */
  0x00240000,  									    /* freq = 36.0 MHz    */
},

/* 800x600 */

{ GFX_MODE_60HZ |									/* refresh rate = 60  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0320, 0x0328, 0x0348, 0x03D0, 0x0418, 0x0420,	/* horizontal timings */
  0x0258, 0x0258, 0x0259, 0x025D, 0x0274, 0x0274,   /* vertical timings   */
  0x00280000, 										/* freq = 40.00 MHz   */
},

{ GFX_MODE_72HZ |									/* refresh rate = 72  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0320, 0x0320, 0x0358, 0x03D0, 0x0410, 0x0410,   /* horizontal timings */
  0x0258, 0x0258, 0x027D, 0x0283, 0x029A, 0x029A,	/* vertical timings   */
  0x00320000, 										/* freq = 49.5 MHz    */
},

{ GFX_MODE_75HZ |									/* refresh rate = 75  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0320, 0x0320, 0x0330, 0x0380, 0x0420, 0x0420,   /* horizontal timings */
  0x0258, 0x0258, 0x0259, 0x025C, 0x0271, 0x0271,	/* vertical timings   */
  0x00318000, 										/* freq = 49.5 MHz    */
},

{ GFX_MODE_85HZ |									/* refresh rate = 85  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0320, 0x0320, 0x0340, 0x0380, 0x0418, 0x0418,   /* horizontal timings */
  0x0258, 0x0258, 0x0259, 0x025C, 0x0277, 0x0277,   /* vertical timings   */
  0x00384000, 									    /* freq = 56.25 MHz   */
},

/* 1024x768 */

{ GFX_MODE_60HZ |									/* refresh rate = 60  */
  GFX_MODE_8BPP | GFX_MODE_16BPP |					/* 8 and 16 BPP valid */
  GFX_MODE_NEG_HSYNC | GFX_MODE_NEG_VSYNC,			/* negative syncs     */
  0x0400, 0x0400, 0x0418, 0x04A0, 0x0540, 0x0540,	/* horizontal timings */
  0x0300, 0x0300, 0x0303, 0x0309, 0x0326, 0x0326,   /* vertical timings   */
  0x00410000, 									    /* freq = 65.00 MHz   */
},

{ GFX_MODE_70HZ |									/* refresh rate = 70  */
  GFX_MODE_8BPP | GFX_MODE_16BPP |					/* 8 and 16 BPP valid */
  GFX_MODE_NEG_HSYNC | GFX_MODE_NEG_VSYNC,			/* negative syncs     */
  0x0400, 0x0400, 0x0418, 0x04A0, 0x0530, 0x0530,   /* horizontal timings */
  0x0300, 0x0300, 0x0303, 0x0309, 0x0326, 0x0326,   /* vertical timings   */
  0x004B0000,									    /* freq = 78.75 MHz   */
},

{ GFX_MODE_75HZ |									/* refresh rate = 75  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0400, 0x0400, 0x0410, 0x0470, 0x0520, 0x0520,   /* horizontal timings */
  0x0300, 0x0300, 0x0301, 0x0304, 0x0320, 0x0320,   /* vertical timings   */
  0x004EC000,									    /* freq = 78.75 MHz   */
},

{ GFX_MODE_85HZ |									/* refresh rate = 85  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0400, 0x0400, 0x0430, 0x0490, 0x0560, 0x0560,   /* horizontal timings */
  0x0300, 0x0300, 0x0301, 0x0304, 0x0328, 0x0328,   /* vertical timings   */
  0x005E8000,									    /* freq = 94.50 MHz   */
},

/* 1280x1024 */

{ GFX_MODE_60HZ |									/* refresh rate = 60  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0500, 0x0508, 0x0540, 0x05C0, 0x0698, 0x06A0,   /* horizontal timings */
  0x0400, 0x0400, 0x0401, 0x0404, 0x042A, 0x042A,   /* vertical timings   */
  0x006C0000, 										/* freq = 108.0 MHz   */
},

{ GFX_MODE_75HZ |									/* refresh rate = 75  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0500, 0x0500, 0x0510, 0x05A0, 0x0698, 0x0698,   /* horizontal timings */
  0x0400, 0x0400, 0x0401, 0x0404, 0x042A, 0x042A,   /* vertical timings   */
  0x00870000, 										/* freq = 135.0 MHz   */
},

{ GFX_MODE_85HZ |									/* refresh rate = 85  */
  GFX_MODE_8BPP | GFX_MODE_16BPP,					/* 8 and 16 BPP valid */
  0x0500, 0x0500, 0x0540, 0x05E0, 0x06C0, 0x06C0,   /* horizontal timings */
  0x0400, 0x0400, 0x0401, 0x0404, 0x0430, 0x0430,   /* vertical timings   */
  0x009D8000, 									    /* freq = 157.5 MHz   */
},

};

#define NUM_DISPLAY_MODES sizeof(DisplayParams) / sizeof(DISPLAYMODE)

/* For Fixed timings */
typedef struct tagFIXEDTIMINGS
{
	/* DISPLAY MODE FLAGS */
	/* Specify valid color depths and the refresh rate. */

	int panelresx;
	int panelresy;
	unsigned short xres;
	unsigned short yres;
	
	/* TIMINGS */

	unsigned short hactive; 
	unsigned short hblankstart; 
	unsigned short hsyncstart; 
	unsigned short hsyncend; 
	unsigned short hblankend; 
	unsigned short htotal; 

	unsigned short vactive;
	unsigned short vblankstart;
	unsigned short vsyncstart;
	unsigned short vsyncend;
	unsigned short vblankend;
	unsigned short vtotal;

	/* CLOCK FREQUENCY */
	
	unsigned long frequency;

} FIXEDTIMINGS;

FIXEDTIMINGS FixedParams[] = {
/* 640x480 Panel */
{ 640 , 480, 640, 480,									
  0x0280, 0x280, 0x2a8, 0x328, 0x380, 0x380,	
  0x1e0, 0x1e0, 0x1e1, 0x1e5, 0x1fc, 0x1fc,   
  0x00325999, 										
},

{ 640 , 480, 800, 600,									
  0x0280, 0x280, 0x2a8, 0x328, 0x380, 0x380,	
  0x1e0, 0x1e0, 0x1e1, 0x1e5, 0x1fc, 0x1fc,   
  0x00325999, 										
},

{ 640 , 480, 1024 , 768,									
  0x0280, 0x280, 0x2a8, 0x328, 0x380, 0x380,	
  0x1e0, 0x1e0, 0x1e1, 0x1e5, 0x1fc, 0x1fc,   
  0x00325999, 										
},

{ 640 , 480, 1280, 1024,									
  0x0280, 0x280, 0x2a8, 0x328, 0x380, 0x380,	
  0x1e0, 0x1e0, 0x1e1, 0x1e5, 0x1fc, 0x1fc,   
  0x00325999, 										
},


/* 800x600 Panel */
{ 800 , 600, 640, 480,									
  0x0280, 0x2d0, 0x2f8, 0x378, 0x3d0, 0x420,	
  0x1e0, 0x21c, 0x21d, 0x221, 0x238, 0x274,   
  0x00280000, 										
},

{ 800 , 600, 800, 600,									
  0x320, 0x320, 0x348, 0x3c8, 0x420, 0x420,	
  0x258, 0x258, 0x259, 0x25d, 0x274, 0x274,   
  0x00280000, 										
},

{ 800 , 600, 1024, 768,									
  0x320, 0x320, 0x348, 0x3c8, 0x420, 0x420,	
  0x258, 0x258, 0x259, 0x25d, 0x274, 0x274,   
  0x00280000, 										
},

{ 800 , 600, 1280, 1024,									
  0x320, 0x320, 0x348, 0x3c8, 0x420, 0x420,	
  0x258, 0x258, 0x259, 0x25d, 0x274, 0x274,   
  0x00280000, 										
},


/* 1024x768 panel */
{ 1024 , 768, 640, 480,									
  0x0280, 0x340, 0x368, 0x3e8, 0x440, 0x500,	
  0x1e0, 0x270, 0x271, 0x275, 0x28c, 0x31c,   
  0x00410000, 										
},

{ 1024 , 768, 800, 600,									
  0x0320, 0x390, 0x3b8, 0x438, 0x490, 0x500,	
  0x258, 0x2ac, 0x2ad, 0x2b1, 0x2c8, 0x31c,   
  0x00410000, 										
},

{ 1024 , 768, 1024, 768,									
  0x0400, 0x400, 0x428, 0x4a8, 0x500, 0x500,	
  0x300, 0x300, 0x301, 0x305, 0x31c, 0x31c,   
  0x00410000, 										
},

{ 1024 , 768, 1280, 1024,									
  0x0400, 0x400, 0x428, 0x4a8, 0x500, 0x500,	
  0x300, 0x300, 0x301, 0x305, 0x31c, 0x31c,   
  0x00410000, 										
},

};
/* END OF FILE */

