//------------------------------------------------------------------
//
// CEPC device drivers should get their IRQ number from the registry and use
// MapIrq2SysIntr to get the appropriate SYSINTR_* number to use.
//
//------------------------------------------------------------------
//#define	DEBUGGING	1

// SYSINTR_FIRMWARE is the base for any interrupts defined in the OAL
#define SYSINTR_DEVICES     8
#define SYSINTR_FIRMWARE    (SYSINTR_DEVICES+8)

//-----------------------------------------------------------------------------------
//
//               These macros must be defined by the OS:
//
//-----------------------------------------------------------------------------------
#define     MAP_IRQ_TO_SYS_INT(x)  x

#define     SLEEP(x)          

//
//   Memory management
//
#define     ALLOC_SYS_ADDRESS(x)    (unsigned long) kmalloc(x, GFP_KERNEL | GFP_DMA)
//                                   virtual address =  ioremap          ( physical address,                             size)
#define  MAP_IO_ADDRESS(x,y,w,z)  x=(unsigned long)ioremap((unsigned long)w,(unsigned long)z)
#define  MAP_DMA_PAGES(x,y,z)  	

//  Allocate 2^ORDER pages for the DMA Buffers 
//  The second argument (ORDER) is the potency of 2 that represents the number of pages requested.
//  This function returns a Virtual address
//

#define ORDER	3
#define ALLOC_DMA_BUFFER 	(unsigned char *) __get_free_pages(GFP_KERNEL, ORDER)
#define DMA_BUFFER_SIZE  	((1<<ORDER)*4096)/4

#define     FREE_DMA_BUFFER(x) 	  free_pages((unsigned long)x,3)

#define	 PHYSICAL_ADDRESS(x)     virt_to_phys(x)

#define     FILL_MEMORY(x,y,z)      memset(x,y,z)

// 
//     I/O Space
//
#define     INP_ULONG(x)            inl((int) x)
#define     OUTP_ULONG(x,y)         outl(y,(int)x)                         
#define     INP_USHORT(x)           inw(x)
#define     OUTP_USHORT(x,y)        outw(y,x)

//
//    Debugging
//
#ifdef DEBUGGING
#define     DBG_MSG(args...)           printk(args);
#define     DURAUDIO_MSG(args...)      printk(args);        
#else
#define     DBG_MSG(args...)           
#define     DURAUDIO_MSG(args...)           
#endif

//
//   Physical address of the PRD array
//   
#define AUDIO_DMA_BUFFER_BASE_PA    0x1FC00000

//-----------------------------------------------------------------------------------


#include <linux/slab.h>
#include <asm/io.h>


#define   KERN_EMERG   "<0>"   /* system is unusable         */
#define   KERN_ALERT   "<1>"   /* action must be taken immediately   */
#define   KERN_CRIT   "<2>"   /* critical conditions         */
#define   KERN_ERR   "<3>"   /* error conditions         */
#define   KERN_WARNING   "<4>"   /* warning conditions         */
#define   KERN_NOTICE   "<5>"   /* normal but significant condition   */
#define   KERN_INFO   "<6>"   /* informational         */
#define   KERN_DEBUG   "<7>"   /* debug-level messages         */

//
//  Return value for AudioGetInterruptType()
//
//  AudioGetInterruptType will return to the caller 
//  one of the following states:
//

#define AUDIO_STATE_IGNORE          0
#define AUDIO_STATE_IN_RECORDING    0x01
#define AUDIO_STATE_IN_OVERFLOW     0x02
#define AUDIO_STATE_IN_STOPPED      0x03
#define AUDIO_STATE_IN_MASK         0x0F
#define AUDIO_STATE_OUT_PLAYING     0x10
#define AUDIO_STATE_OUT_UNDERFLOW   0x20
#define AUDIO_STATE_OUT_STOPPED     0x30
#define AUDIO_STATE_OUT_MASK        0xF0

typedef unsigned char AUDIO_STATE;

#define WPDM_CLOSE          1
#define WPDM_CONTINUE       2
#define WPDM_ENDOFDATA      3
#define WPDM_GETDEVCAPS     4
#define WPDM_GETVOLUME      5
#define WPDM_OPEN           6
#define WPDM_PAUSE          7
#define WPDM_RESTART        8
#define WPDM_SETVOLUME      9
#define WPDM_STANDBY        10
#define WPDM_START          11
#define WPDM_STOP           12

//
//   Physical address of the device
//
#define AUDIO_REGS_BUFFER           0x40011000  

//  
//    Typedefs
//
typedef enum 
{
	WAPI_IN = 0, 
	WAPI_OUT
} WAPI_INOUT, *PWAPI_INOUT;


//
//   Extended waveform format structure used for all non-PCM formats. this
//   structure is common to all non-PCM formats.
//
typedef struct tWAVEFORMATEX
{
	unsigned short  wFormatTag;         // format type 
	unsigned short  nChannels;          // number of channels (i.e. mono, stereo...) 
	unsigned long   nSamplesPerSec;     // sample rate 
	unsigned long   nAvgBytesPerSec;    // for buffer estimation 
	unsigned short  nBlockAlign;        // block size of data 
	unsigned short  wBitsPerSample;     // number of bits per sample of mono data 
	unsigned short  cbSize;             // the count in bytes of the size of 
                                        // extra information (after cbSize) 
} WAVEFORMATEX, *PWAVEFORMATEX,  *NPWAVEFORMATEX,  *LPWAVEFORMATEX;
typedef const WAVEFORMATEX  *LPCWAVEFORMATEX;

WAPI_INOUT  GlobalApidir;

//
//  Wave data block header 
//
typedef struct wavehdr_tag 
{
	char *              lpData;                 // pointer to locked data buffer 
	unsigned long       dwBufferLength;         // length of data buffer 
	unsigned long       dwBytesRecorded;        // used for input only 
	unsigned long		 dwBytesRead;        // Number of bytes Read in this buffer
	unsigned long       dwUser;                 // for client's use 
	unsigned long       dwFlags;                // assorted flags (see defines) 
	unsigned long       dwLoops;                // loop control counter 
	struct wavehdr_tag *lpNext;                 // reserved for driver 
	unsigned long       reserved;               // reserved for driver 
} WAVEHDR, *PWAVEHDR, *NPWAVEHDR, *LPWAVEHDR;

//
//   Common stuff
//
#define     TRUE    1
#define     FALSE   0
#define     NULL    ((void *)0)

//
//  waveform audio error return values 
//
#define WAVERR_BADFORMAT      (32)  // unsupported wave format
#define WAVERR_STILLPLAYING   (33)  // still something playing
#define WAVERR_UNPREPARED     (34)  // header not prepared
#define WAVERR_SYNC           (35)  // device is synchronous
#define WAVERR_LASTERROR      (35)  // last error in range

//
//  General error return values 
//
#define MMSYSERR_NOERROR      0     // no error 
#define MMSYSERR_ALLOCATED    (4)   // device already allocated 
#define MMSYSERR_INVALHANDLE  (5)   // device handle is invalid 

typedef unsigned short    MMRESULT;                                   

//
//    PCM Format value
//
//    The caller has to specify the format of the wave data.
//    At this point, the driver does only handles PCM data.
// 
#define WAVE_FORMAT_PCM         1   

