#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include <fcntl.h>
#include <scanner.h>
#include <stdio.h>
#include <unistd.h>
#include <vga.h>

char point(int x,int y,char buf[3][1024]) {
  return (buf[y][x >> 3] & (0x80 >> (x&7)))!=0;
}

void main() {
  struct modeinfo_struct info;

  int fd,bpl,cc,y,a,ya,xa;

  char buf[3][1024];
  int pal[768];


  vga_init();

  vga_setmode(G640x480x256);

  for (a=0; a<255;a++) {
    pal[a*3]=pal[a*3+1]=pal[a*3+2]=a >> 2;
  }

  vga_setpalvec(0,256,pal);

  if ((fd=open("/dev/gs4500",O_RDONLY))<0) 
    perror("open");

  if (ioctl(fd,HSIOCGMOD,&info)<0) 
    perror("ioctl");

  bpl = info.bpl;

  y=0;

  while (1) {

    for (ya=0; ya<3; ya++) 
      read(fd,buf[ya],bpl);

    for (cc=0; cc<640; cc++) {
      
      a=0;
      for (ya=0; ya<3; ya++) {
	for (xa=cc*3; xa<cc*3+3; xa++) {
	  a += point(xa,ya,buf);
	}
      }

      vga_setcolor(a*28);
      vga_drawpixel(cc,y);
    }
        
    y++;
    if (y==480) y=0;

  }


  close(fd);

}







