        page 250,150
;Begin--------------------------------------------------------------------
;
; DFS, Dump file-system info
;
; by: P.R. Faasse
;     Hakfort 337
;     1102LA Amsterdam
;
; Program to dump the file-system information of a PoFoIDE driver.
;
; update history:
; ---------------
;
; 11-08-1998: Started
;
;End----------------------------------------------------------------------

; ------------------------------------------------------------------------
; standard beginning of a .COM file. Seems to satisfy MASM...
; ------------------------------------------------------------------------

code    segment para 'code'     ; define the  code segment
        org   0100h             ; begin at offset 0100H

        assume cs:code, ds:code, es:code, ss:code
                                ; all segment registers
                                ; point to the code segment

Start:  jmp     Main            ; goto the main processing loop

;Pars---------------------------------------------------------------------
;
cr      equ     0DH             ; carriage return
lf      equ     0AH             ; line-feed
eos     equ     '$'             ;
;
;End----------------------------------------------------------------------

;Data---------------------------------------------------------------------
; the local parameters for the program, text strings too
;-------------------------------------------------------------------------
;
DriveNo db      0       ; drive number PoFoIDE drive

; text strings, a lot of them.....
; the strings for the data found:
;
; Example of the expected output:
;
;                Drive: D:       Partition: 01
;                Name : 2Mb Fs   Cluster  : 01
;                Resvd: 0001     # Fats   : 01
;                Rootd: 0080     MediaType: F8
;                DSize: 1000     FatSize  : 0C
;
DriveStr db     "Drive: ",eos
;                       D:
PartStr  db              "       Partition: ",eos

NameStr  db     "Name : ",eos
;                       12345678
ClusStr  db                    " Cluster  : ",eos
;
ResvdStr db     "Resvd: ",eos
;                       0001
nFatStr  db                "     # Fats   : ",eos
;
RootdStr db     "Rootd: ",eos
;                       0080
MediaStr db                "     MediaType: ",eos
;
DSizeStr db     "DSize: ",eos
;                       1000
FatStr  db                 "     FatSize  : ",eos
;
;
NewLn   db      cr,lf,eos
;
NoPars          db      "usage: dfs <drive>",lf,cr,eos
NoDriver        db      "PoFoIDE driver not found",lf,cr,eos
;
;End----------------------------------------------------------------------

;Prog---------------------------------------------------------------------
;
; The main program itself. It will first look for a PoFo driver.
; Next it will blindly pump a file-system on the drive.
;
Main:
        ; Parse parameters
        mov     si,081H                 ; si -> begin of parameters
        cld                             ;

ParLp:  lodsb                           ;
        cmp     al,CR                   ;
        jz      ParErr                  ;
        cmp     al,' '                  ;
        jz      ParLp                   ;

        ; convert to upper
        and     al,0DFH                 ; -> upper

        ; test if valid drive letter
        cmp     al,'D'                  ; test A .. Z
        jc      parerr                  ;
        cmp     al,'Z'+1                ;
        jnc     parerr                  ;
        sub     al,'A' - 1              ; A -> 1; D -> 4
        mov     driveno,al              ;

        jmp     TstIdeDrv               ;

        ; wrong parameters given
ParErr: mov     dx,offset NoPars        ; give message
        jmp     MesEx                   ; exit

        ; test if an IDE driver there for that drive
TstIdeDrv:
        mov     bl,driveno              ; save drive number
        mov     ax,04404H               ; IoCtlRead
        mov     cx,0258H                ; # bytes
        mov     dx,offset IoBuf         ;
        int     21H                     ;
        jc      NoIdeDrv                ;

        ; test if driver there
        cmp     word ptr IoBuf,'KP'     ; test if signal there
        jz      GoDump                  ;

NoIdeDrv:

        mov     dx,offset NoDriver      ; error message
mesex:  mov     ah,9                    ;
        int     21H                     ;

        mov     ax,04C01H               ; exit
        int     21H                     ;

        ; driver found
GoDump: nop                             ;

        ; give message
        mov     dx,offset DriveStr      ; file-system string
        call    Mess                    ;
        mov     al,DriveNo              ;
        add     al,'A'-1                ;
        call    DisChar                 ;
        mov     al,':'                  ;
        call    DisChar                 ;

        ; print the current partition number
        mov     dx,offset PartStr       ;
        call    Mess1                   ;
        mov     al,byte ptr IoBuf+2     ;
        call    DisHexByte              ;

        ; make ds:si a pointer to the BootInfo block
        mov     ax,word ptr IoBuf+7     ; driver's segment
        mov     si,word ptr IoBuf+9     ; bootinfo offset
        mov     ds,ax                   ;

        lodsw                           ; skip 3 bytes
        lodsb                           ;

        ; dump the information found in a readable format

        ; the OEM name string
        mov     dx,offset NameStr       ;
        call    Mess                    ;

        mov     cx,8                    ; 8 chars name
bootnam:lodsb                           ;
        call    DisChar                 ;
        loop    bootnam                 ;

        ; skip sector size
        lodsw                           ; 1 word

        ; the cluster size
        mov     dx,offset ClusStr       ;
        call    Mess1                   ;
        lodsb                           ;
        call    DisHexByte              ;

        ; the # reserved sectors
        mov     dx,offset ResvdStr      ;
        call    Mess                    ;
        lodsw                           ;
        call    DisHexWord              ;

        ; the number of FAT's
        mov     dx,offset nFatStr       ;
        call    Mess1                   ;
        lodsb                           ;
        call    DisHexByte              ;

        ; root dir entries
        mov     dx,offset RootdStr      ;
        call    Mess                    ;
        lodsw                           ;
        call    DisHexWord              ;

        ; media type
        mov     dx,offset MediaStr      ;
        call    Mess1                   ;
        mov     al,[si+2]               ;
        call    DisHexByte              ;

        ; disk size
        mov     dx,offset DSizeStr      ;
        call    Mess                    ;
        lodsw                           ;
        call    DisHexWord              ;
        lodsb                           ; skip media byte

        ; Fat size
        mov     dx,offset FatStr        ;
        call    Mess1                   ;
        lodsw                           ;
        call    DisHexWord              ;

        ; get ds back to cs
        mov     ax,cs                   ;
        mov     ds,ax                   ;

        ; one clean line between the disk entries
        call    NewLine                 ;

        ; exit
        mov     ax,04C00H               ;
        int     21h                     ;

;End----------------------------------------------------------------------

;Routines-----------------------------------------------------------------
;
; The data display routines I use
;
;---------------------------------------------------------------------
; Routine Mess/Mess1
; purp: display a message on the console, on a new line (Mess)
;       or without new line (Mess1)
; in  : dx -> message in cs
; out : nothing
; uses: nothing

Mess1:
        push    ax              ;
        push    dx              ;
        push    ds              ;

        mov     ax,cs           ;
        mov     ds,ax           ;

        jmp     messin          ;

Mess:   push    ax              ; save registers
        push    dx              ;
        push    ds              ;

        mov     ax,cs           ;
        mov     ds,ax           ;

        mov     dx,offset NewLn ; print new line
        mov     ah,9            ;
        int     21h             ;

        pop     ds              ;
        pop     dx              ;
        push    dx              ;
        push    ds              ;

        mov     ax,cs           ;
        mov     ds,ax           ;

messin: mov     ah,9            ; print string
        int     21h             ;

        pop     ds              ;
        pop     dx              ;
        pop     ax              ;

        ret                     ; done

;---------------------------------------------------------------------
; Routine NewLine
; purp: make the console goto a new line
; in  : nothing
; out : nothing
; uses: nothing

Newline:push    ax              ; save registers

        mov     al,LF           ;
        call    DisChar         ;
        mov     al,CR           ;
        call    DisChar         ;

        pop     ax              ;

        ret                     ; done

;--------------------------------------
; Routine DisHexByte and DisHexWord
; purp  : Writes AL or AX as hex ascii
; in    : byte in AL (DisHexByte)
;         word in AX (DisHexWord)
; out   : nothing
; uses  : nothing

DisHexWord:

        ; save registers
        push    ax              ;

        ; higher byte
        mov     al,ah           ;
        call    DisHexByte      ;

        ; lower byte
        pop     ax              ;
        call    DisHexByte      ;

        ; done
        ret                     ;

DisHexByte:

        ; save registers
        pushf                   ;
        push    ax              ;

        ; higher nibble
        shr     al,1            ;
        shr     al,1            ;
        shr     al,1            ;
        shr     al,1            ;
        call    ToHex           ;
        call    DisChar         ;

        ; lower nibble
        pop     ax              ;
        push    ax              ;
        and     al,0FH          ;
        call    ToHex           ;
        call    DisChar         ;

        ; restore registers
        pop     ax              ;
        popf                    ;

        ; done
        ret                     ;

; --------------------------------------
; Routine ToHex
; purp  : converts nibble to hex ASCII character
; in    : nibble in al
; out   : ASCII char in al
; uses  : nothing

ToHex:  pushf                   ;

        and     al,0FH          ; make sure of 0 .. F

        cmp     al,0AH          ;
        jge     tohex1          ;

        ; 0 .. 9
        add     al,'0'          ; 0 .. 9 convert
        jmp     tohexe          ;

        ; A .. F
tohex1: add     al,('A' - 0AH)  ;

tohexe: popf                    ;

        ret                     ;

; --------------------------------------
; Routine DisChar
; purp  : Writes AL to display
; in    : character in al
; out   : nothing
; uses  : nothing

DisChar:pushf                   ;
        push    ax              ;
        push    dx              ;

        mov     dl,al           ;
        mov     ah,02H          ;
        int     21H             ;

disnsio:pop     dx              ;
        pop     ax              ;
        popf                    ;

        ret                     ;

;End----------------------------------------------------------------------

;Buffer-------------------------------------------------------------------
;
; The I/O buffer. This buffer is used to write sector data to the
; disk. I do not store the buffer data on the disk image of the
; program because I will always put something in the buffer
; before writing it to disk.
;
IoBuf           equ     this byte       ; the I/O buffer
IoBufSize       equ     512             ;
;
;End----------------------------------------------------------------------

;Tail---------------------------------------------------------------------
;
; Note that I do not do any stack inits at all. The stackpointer
; is just left at the end of the allocated memory segment. It
; should do no harm there.
;
code    ends
        end     Start           ; end of the program
;
;End----------------------------------------------------------------------
