        page 250,150
;Comment--------------------------------------------------------
;
; Project name: PoFoIDE
; ---------------------
;
; Device driver for IDE-Harddisks on an Atari Portfolio.
; version: v0.86
; date   : 13-11-1998
;
; Description:
; ------------
;
; This is the source code a device/interface driver. It is part
; of a hardware/software contraption that can be used to connect
; an IDE harddisk to a PortFolio parallel interface. The
; hardware/software combination allows a PortFolio to access the
; IDE harddisk as a number of extra disk drives.
;
; Copyright notice:
; -----------------
;
; (C) 16.05.1998 by Klaus Peichl, stliche Ringstr. 7, 85113 Bhmfeld
; (C) 11-09-1998 by P.R. Faasse, Hakfort 337, 1102 LA Amsterdam
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; Warranty:
; ---------
; As nearly all computer programs this code comes  without any
; warranty. When using this code I am not responsible if anything
; goes wrong with your hardware/software, data, married life or
; otherwise.
;
; I've tried my very best to make this program work; I've seen it
; work on at least two PortFolio's with different version numbers
; of the PoFo's ROM and with two different harddisks. The current
; version 0.83 is however an 'alfa-test' version. I have run it on
; my own computers, and not yet on anyone else's.
;
; Bugs/error reporting:
; ---------------------
; Any reports of errors are welcome. I can again guarantee
; nothing, but as long as I'm interested in PortFolio's there is
; a very good chance that I'll do my best to kill any remaining
; bugs. I prefer error reports in e-mail form to:
;
;       faasse@nlr.nl
;
; If e-mail is not available to you you could also send a written
; report to:
;
;       P.R. Faasse
;       Hakfort 337
;       1102 LA Amsterdam
;       Netherlands
;
; Known problems:
; ---------------
; This being alfa-test software I do not expect it to work fully
; without errors. At this moment most of the driver seems to
; work. The following bugs are known:
;
; I did encounter problems when using unreliable disks. This
; driver has no 'bad-block' management, it blindly assumes that
; all disk blocks are read/writable. At this point I do not
; intend to implement any 'bad-block' management. The time to
; scan a disk for bad blocks with this slow interface is
; prohibitive. Newer disks 'hide' bad blocks themselves.
;
; The chkdsk program of the PoFo works unreliably with the
; PoFoIDE driver. It sometimes works -more-or-less-, somtimes
; simply hangs the system. The chkdsk response changes with the
; disk's history: with a 'clean' disk (no files there) it seems
; to work, after a few copy-s, deletes it seems to hang. It
; always reports wrong info for the used space (no-files works
; ok..). It seems not go get the hang of the more-than-one-
; sector-per-cluster idea. I do not know what to do about it.
;
; I got one disk for testing from Stefan Kaechele. This disk does
; not work with the PoFoIDE system at all. It gives a 'Command
; Aborted' error on all reads and writes. I'm in doubt if this is
; a software or hardware error, I'm working on it.. (NB: The disk
; is a Caviar (tm) Lite 170)
;
; History:
; --------
;
; 20.05.98 0.01 First version, missing I/O routines
;
; 25-05-1998:
;             converted Klaus's code to masm format. Masm cannot
;             eat some of the TASM directives and insists upon
;             some pretty cryptic descriptions at the beginning
;             and end of the file.
;             Assembly and linking/sys file making now works with:
;
;       MASM driver,,,,,
;       LINK driver,,,,
;       EXE2BIN driver.exe driver.sys
;
; 26-06-1998 to 05-06-1998:
;
;       Integrated the driver code with my IDE interface code.
;       The thing works now. No error handling is there yet.
;       Bumped the version number to 0.02.
;
; 06-06-1998:
;
;       Bus passify at the end of I/O operation(s) added.
;       This is needed because the PoFo sometimes re-inits the
;       parallel port on (soft-) power-up/power-down.
;
; 07-06-1998:
;
;       Routine SetAdr changed. I no longer support the /CS1
;       addressing. I never did use the high registers, now
;       SetAdr does the same. Some debug code removed.
;
;       Error handling put in place. Tested with both the 512
;       KBytes PoFo and the 128KBytes one. All seems to work ok.
;       DIP versions: 1.072 (512 KB PoFo) and 1.052 (128 KB PoFo)
;
; 17-06-1998:
;
;       Started on a special version. use a standard file-system.
;       I solved some puzzle of the 12-bit FAT file-system. It is
;       less well-documented than it seems. I had to dump some
;       floppy boot-blocks to find most of the boot-block
;       parameters.
;
; 18-06-1998:
;
;       Started reading the BPB from the disk itself. That makes
;       the driver independent of the actual file-system used on
;       the disk. Results in an immediate crash of the PoFo. Even
;       the normal reset will not solve that. Still, this has to
;       work. I want to make a more flexible disk partitioning
;       system. Otherwise I'll be stuck with this 3x30 MB
;       partitioning mechanism. It's not so bad in itself, but
;       not all disks are 100 MB in size. I wonder if this is
;       coming from some error in my code, or perhaps I'm
;       provoking some stack overflow. This driver does not (yet)
;       have it's own stack.....
;
;  14-07-1998:
;
;       Some debug info put back, I had occasional crashes with
;       my old 40MB disk. Looks like the disk itself has finally
;       given up itself. It had been screeking along for some time
;       already, this was no big surprise. I also made a final
;       check upon block read/write ready. DRQ should be '0',
;       error flag should be '0' too. I'm thinking of a
;       soft-reset at the end of any timeout. Now the disk simply
;       stays 'locked' with no hope of recovery. The disk SHOULD
;       NEVER get into this state, but if it does, I'd better
;       reset it and hope for the best....
;
; 14-07-1998:
;
;       Continued making the multi-fs version. I've got the
;       reason for the crash now. At the moment I did the
;       ReadBPB the disk's geometry was not (yet) known. That
;       gave a divide-by-zero (SPT and SPC where both 0, I divide
;       by them...). ReadBPB has been moved to AFTER the geometry
;       read. Now I have to verify that the data I get is
;       usable...
;
; 19-07-1998:
;
;       I finally got the ReadBPB/SetPart span to work as I want.
;       The driver now supports multiple partitions, with all the
;       information about them stored in the one-and-only place
;       that I think is sensible: the disk itself. The entire
;       driver works nicely on my 512KB PoFo, with the QUANTUM
;       ELSA127 disk. There is only one thing really missing
;       here, a utility to switch the active partition from the
;       command line. I tried with both 30MB and 2MB file-systems
;       even with a mix of them. The MDEXTERN and ATMD
;       combination also seems to work. If no unexpected things
;       happen this could be the alfa-test version. I have run
;       out of bugs, let's see how the rest of the world thinks
;       about that. I've bumped the version number to 0.8 to give
;       a measure of the confidence I have in the thing. NB:
;       there should be no traces left of the previous
;       two-versions sitiuation I had: One version that works
;       with 2 MB file-systems, one version that works with 30MB
;       file-systems. Remains some comment-translations. Klaus's
;       skeletton driver was very nicely commented, but a mix of
;       German and English comment would, I think, be too much to
;       ask of the rest of the world.
;
; 07-08-1998:
;
;       Changing the ds:si assignment in writesectors. This has
;       been poisoning my code for too long. the assignment of
;       ds:si up in the front of the writesectors has made me
;       write cs: overrides all over the code. The idea on itself
;       (stosw for data storage) is not bad, it just has to be
;       done a lot later on in the code. This may even have led
;       to some of the remaining bugs. I now change from es:di to
;       ds:si in the writeblock part (at the tail of the code).
;       NB: I do net (yet) test if the partition selection goes
;       beyond the disk size.
;
; 10-08-1998:
;
;       Changed SetAdr and the address bytes to include the
;       appropriate CS bit. This re-enables access to the
;       soft-reset and simplifies the SetAdr routine some more.
;       Also added a soft-reset at the end of a timeout. This
;       should prevent the disk from a 'lockup' when some error
;       happens. Also moved quite a lot of code/data around. I
;       want a 'clean' separation between data, code and between
;       device/interface driver and transient/resident code. I've
;       joinded some subroutines and moved the transient routines
;       to the back of the code to achieve that. I've also been
;       hunting for German comment again. I have nothing against
;       German comment perse, but a mixture of German and English
;       will make this program unreadable for most of the world's
;       population. If that was my intention I would have
;       commented my own code in Dutch.
;
;       Added most of the relevant information of the driver's
;       static storage to the return information of the IoCtlRead
;       call. This should allow easy on-line disgnostics of the
;       driver and/or drive.
;
;       Got a few minor bugs. The multi-sector read/write was not
;       ok. It was never used that way, so I do not expect anyone
;       has stumbled over this, but anyway...
;
; 11-08-1998:
;
;       /C option made for the command line. This will make the
;       driver read the disk's geometry from the command line in
;       the form of
;
;               /C <cyl> <head> <sec> .
;
;       The separation between the numbers can be a ' ' or a '/'.
;       The cyl must range from 1 to 1024, the head from 1 to 16,
;       the sec from 1 to 256. This means that I'v added a
;       decimal number parser routine to the driver. The same
;       routine is now used to read the partition number from the
;       command line. NB: If a disk geometry is specified the
;       Disk Ident command is skipped. NBII: If debug modus is
;       selected the disk's geomery is balked to the console at
;       start.
;
;       The complete command-line option set is:
;
;               /D              sets debug modus
;
;               /C <c> <h> <s>  sets disk geometry
;                               <c> = [1 .. 1024]
;                               <h> = [1 .. 16]
;                               <s> = [1 .. 256]
;
;               /O <time>       auto-idle the disk after
;                               <time> 5-seccond units.
;                               <time> = 0 -> keep disk on
;                                      = 1 ..240 -> off after
;                                                   5 .. 1200 sec
;                                      >240, <255-> off after
;                                        long time, see ATA-3 doc
;
;               /N              Skip FileSystem test
;
; 11-08-1998:
;
;       Not visible in this file, but it's there: A number of
;       utilities for the PoFoIDE interface:
;
;       sp   : set a partition in a driver
;       ddiag: driver diagnostics info dump
;       dfs  : dump file-system info of PoFoIDE drivers
;
; 12-08-1998:
;
;       Debugging the new facilities. The real PoFo crashed like
;       a bomb on the first attempt. I'd really messed up the
;       parameter parsing. Debugging on a PC gave a view of the
;       error. I now have some statements starting with ;d in the
;       code. These are for debugging the command parsing. The
;       statements are comment as it is now, removing the ;d will
;       make the driver dump all its command line to the console.
;
; 12-08-1998:
;
;       Substituted ReadSectors and WriteSectors into the code of
;       Read and Write. Only IoCtlWrite *sometimes* links into
;       the write code. No other use was made of this
;       intermediate subroutines.
;
; 13-08-1998:
;
;       I had a strange effect when testing my 8051A disk. I set
;       a CHS override, and was rewarded with a 'sector size too
;       large' error. It turned out that the 8051A disk was the
;       only disk that did NOT have a PoFo-file-system on it yet.
;       The routine ReadBPB read that info from disk and was
;       attempting to sell it to the PoFo. The PoFo did not
;       agree. I have made a simple mechanism to prevent that
;       from happening. If the driver finds an invalid
;       file-system as the last one of a SetPart, it will correct
;       the file-system's BPB in the driver, but lockout all
;       normal read/writes to that partition. The IoCtlWrite is
;       still fully operational. That means that you can make a
;       file-system, but not read or write to a partition wiout a
;       valid file system. Otherwise I get a bootstrap problem
;       when someone wants to start using a virgin disk. - There
;       IS a way to make the PoFo NOT load the driver. That is
;       exactly what happened when my file-system was not
;       usable.... I think I'm going to do some disassembly of
;       the config.sys loader in the PoFo's ROM. That should give
;       some clues of how to convince the PoFo not to load a
;       driver. The code for the config.sys loader is in the
;       E-segment, just like the rest of the DIP. Some more work
;       on disassmbly there might prove valuable.
;
; 16-08-1998:
;
;       Most of the work is again not done on the pofoide driver
;       itself. I've got my driver-debugger working. Called the
;       thing DDT, it's deadly for bugs. Now the plug-and-pray
;       approach to driver design is over. I can single-step
;       driver command prcessing. Found one bug already: I had
;       forgotten to copy the number of sectors for a tranfer to
;       my local buffer in SetBuffer. That caused a 255-sector
;       read all the time. No wonder the PoFo crashed. Nearly all
;       it's memory was overwritten by this driver. My 127 MB
;       disk is humming like a bee, it works just nice. The old
;       Miniscribe seems to have problems with the sector lenght?
;       It needs MORE than 256 words transfer on a read???? Guess
;       the error is somewhere else. A 'new' old disk (ST-157A)
;       gives read errors (it says 'sector not found'?) perhaps I
;       look at the status too early in the process. The new
;       sp/ddiag/dfs system seems to work nicely. The driver has
;       no really great bugs (it doe not crash the PoFo
;       anymore..). The read/write lock looks good too. Time for
;       a version increase? I'll wait till at least one more disk
;       works ok. I'll have to notify Klaus and Stefan, this
;       thing is definitely a lot better than what I sent them.
;       The bug with the non-initialised first partition would
;       kill all their efforts.
;
; 17-08-1998:
;
;       I've been reading manuals again. My DOS4.0 programmers
;       reference tells me that there is one thing I've been
;       doing wrong all the time. The BPBpointer in the Init call
;       must point to an array of word offsets to real BPB's.
;       I've always put a pointer to my BPB there. That is wrong.
;       Perhaps that is why the PoFo has been refusing to load
;       multiple devices in one driver. Let's see what happens if
;       I do it right. 3 drive's and no divide by zero as Klaus
;       reports. Someone at DIP must hate programmers. Every time
;       this PoFo finds an error and runs out of ideas it starts
;       dividing things by zero.... I'll continue implementing
;       the multiple-drives one-driver somewhat further. I'll
;       need more than one LBB at least. A lot of work in the
;       Init part too. I'll have to find out how to partition the
;       disk all over again. The SP (set-partition) program
;       becomes a lot less important all of a sudden..
;
; 18-08-1998:
;
;       Removed the MACRO part. Klaus's macroes where very nice in
;       the beginning, but DDT can do the same work and more. I
;       never use the macro's anymore. No need to keep them in
;       the code.
;
; 22-08-1998:
;
;       Made the proper implementation of the multi-drive
;       version. This required some re-design of some parts of
;       the driver. The SetPart routine is all gone now. It has
;       no more use. I'll depend completely on the fact that the
;       PoFo will load all available 'partitions' (I've called
;       them Units now..) at boot time. I'll deduce the number of
;       partitions from the disk's size. I'll use only one
;       file-system now. Some 65520 sectors per file-system, the
;       last part of the disk will get a file-system with a
;       different size. I now have a nice 351 MBytes portable
;       harddisk. Let's see how it responds to this new driver.
;
; 24-08-1998:
;
;       This new drive responds very well to the driver. I'll
;       continue with the new configuration of the driver. I'm
;       producing an automatic disk size -> partitioning
;       machanism for this driver too. Plug-and-play is not half
;       as difficult as you are made to believe. LockRdWr will be
;       activated if one or more of the partitions do not have a
;       valid file system on-board. If you bump into that, you'll
;       have to make/correct the file-system (mkfs is the
;       utility's name..) and reboot after doing that.
;
; 26-08-1998:
;
;       I found the bug in the Init. When something went wrong I
;       returned a number of units 0. The PoFo responded with a
;       re-attempt to load the driver and a crash. I have most of
;       the multi-fs interface in place too. All seems to work.
;       Just the chkdsk program keeps giving strange results. It
;       looks like the PoFo just looks at the FAT to determine
;       the disk's size. The parameter dsize in the BPB is more
;       or less ignored. A partition with a smalle dsize
;       parameter still reports a full disk size, instead of the
;       reduced one. I'll have to decrease the FAT size I think.
;
; 28-08-1998:
;
;       Changed two things mainly:
;
;       The general LockRdWr mechanism when one or more
;       partitions where not ok was too rude. Now I hope to have
;       a partition-based lock bit. I warn about the partitions
;       that do not have valid file-systems, lock ONLY them and
;       continue...
;
;       I've made a nice 'best-fit' algorithm for the tail of the
;       disk. The left-over blocks when all full-size partitions
;       are found is now nicely divided into the last partition.
;       Hope it works ok.. I start dividing/multiplying like wild
;       to get the cluster size/FAT size and disk size ok..
;       Besides this some cleanup from previous actions and
;       TestFs, SetLock/GetLock, FixBPB are changed or made.
;
;       Made a minor change to the Init function too. It now
;       checks if it has executed an init before. If so, it just
;       gives strings etc.. but not the other works. That should:
;       - Make my life easier when using ddt.
;       - Prevent multiple-init-loading of the driver.
;       - respond a little nicer when the PoFo is about to crash
;         (again....)
;
; 30-08-1998:
;
;       All works again for the 'newer' disks. The new (for me..)
;       40-MB disks refuse to work. I now have a Seagate ST157A
;       and my old Miniscribe to test. The big disks work ok.
;       What would be wrong this time? Using ddt again to find
;       out... I now suspect that sometimes, I'm just too bloody
;       fast for these old beasties... They never get the time to
;       respond at all. The newer disks do not have that problem.
;       they are fast enough. I'll have to set the timeout longer
;       for old disks.... An option would not be a bad idea....
;       Option /T added. If you use it you have to specify the
;       timeout. That has to be > 4096. Let's see what that does.
;       Could I venture to make this the alfa-test software..?
;       Klaus and Stefan are waiting for it, I'd love to get
;       these small disks working first.
;
; 11-09-1998:
;
;       After some time I've restarted working on the driver. Dtt
;       has become real nice, I'll distribute it together with
;       the driver. The timeout was NOT the problem with the old
;       disks. These oldies generate DRQ later than the new ones.
;       I now use WaitDRQ again to give them time. I've also
;       re-read the ATA-spec for the Reset function. The disk
;       reports in it's busy flag while the Reset is still busy.
;       I now wait for that to finish. I've removed ALL error
;       reporting from the Init function. The PoFo does not
;       tolerate ANY errors here. I've removed read locking when
;       no valid filesystem found. That could result in some
;       funny data read, or save the day when something minor
;       went wrong. Added reporting of the drives the driver has
;       made. That works ok on a PoFo, it assumes the driver gets
;       d: as the first drive. All non-defect disks work ok with
;       this. Let's call it alfa-test version v0.83. Wish me
;       luck...
;
; 27-09-1998:
;
;       The alfa-testing has started for real. I'm getting error
;       reports for all parts of the code. Problems reported:
;
;       - Stefan reports problems with: one 130 MB disk. It does
;         not get recognised. He'll send it over here. I'm
;         waiting for that one to arrive. This would mean that
;         either this disk is rotten, or my IDE interface code is
;         not watertight.
;
;       - Stefan also reports problems with the command line. If
;         pofoide.sys is the last line in config.sys you get:
;         'command line error'. I've found that too. The -end of
;         line- detection has been changed. That should do the
;         trick.
;
;       - Problems when loading .exe files. That one may prove
;         tricky to find. Best guess is that the driver messes up
;         the memory somehow. I'm working on it, but that comes
;         down to looking over all of the code.
;
;       - Jochen reports that some of his disks do not get
;         recognised at all. That does look like I/O level
;         problems. Perhaps timing problems, perhaps something
;         like termination/ resistors. I try to give advice in
;         that matter, but I'm not sure I can help very much.
;
;       Changes so far: (v0.83 -> v0.84)
;
;       - The parameter end of input detection is changed. The
;         driver now tests for any command line char < 01FH, and
;         concludes end of input if it finds that. Looks like it
;         works, let's see how the others see this.
;
;       - I've found a bug in the SetBuffer routine. The LBA was
;         not computed correctly. That would in the end mess up
;         all the disk data.
;
;       - I've changed something in the IoCtlWrite code. Made
;         that just a write, bypassing all write locks. This is
;         not strictly part of the alfa-test results, I wanted to
;         change it anyway. That should make the code slightly
;         smaller.
;
;       - The Dummy routine for all unsupported calls now reports
;         errorc=3 (unsupported request). That's art-for-art-sake
;         mostly. These calls should never be made anyway, better
;         the driver handles them correctly.
;
;       - In routine SetLBB the dx register too is saved/restored
;         on stack.
;
; 06-10-1998:
;
;       The problem with Stefan's 127MB disk turned out to be in
;       the IoCtlRead function. The FixBPB and SetLBB routines
;       need the unit number in al, I'd forgotten to put it
;       there. This caused the problems I had had with the last
;       partition of Stefan's disk. It is now fixed.
;
; 11-09-1998:
;
;       I had massive problems with my dinosaur ST-157A disk.
;       That turned out to be caused by two things:
;
;       1) I did something wrong in the IDE interfacing. I waited
;          ONLY for the status's BUSY bit to be cleared before
;          using the disk. It turns out that I'll have to wait
;          for BOTH the busy AND the DRDY bit to be ok (busy=0,
;          DRDY=1).
;
;       2) This disk too gives wrong answers when an ident is
;          done. It reports as CHS=615/6/26, but wants to be
;          addressed as 977/5/17. I thought the idsk was gone,
;          that proved wrong. It's now working fine. I now think
;          that a different approach to 'auto-detection' of the
;          disk's parameters is a good idea: scan for the disk
;          size, by reading from the disk. First the cyl=0,
;          head=0, increase sector till you get an error, then:
;          keep the sector=1, increase the head till error, last:
;          keep sector=1, head=0, increase the cyl till error.
;          Perhaps just in a separate program, the auto-ident
;          function is unreliable with old disks, some better way
;          has to be there....
;
; 28-10-1998:
;
;       Re-started working on the thing after some out-house
;       schooling and a period of illness.
;
;       The problems with Stefan's 170 MB disk remain. Jochen
;       too reports similar errors with his disk(s). He reports
;       that the last partition of his disk DOES work..
;       (confusing....)
;
; 13-11-1998:
;
;       Found two things:
;
;       1) the trouble with the .exe files WAS in the hardware.
;          As soon as I put the 74HC04 in the interface to work,
;          and short-circuited the socket of the external 74HC14
;          the thing started working nicely, even over a 50 cm
;          IDE cable. NB: Extensions over the 25-pins (rs232)
;          cable do NOT work ok.
;
;       2) There was a bug in the SetPars part of the driver.
;          When I removed that one the WD170 gave up the
;          resistance. It too works ok now.
;
;       Over here, I've run out of bugs again.... Jochen still
;       has problems with two of his disks, he reports that he
;       cannot access the first part of his disks. What can I do
;       to help him? I have 8 disks here that all work. Ranging
;       from a ST157A 40MB dinosaur, to the IBM portable 351MB.
;       I'd be inclined to declare beta-test stadium, if not
;       Jochen had these problems. Could it be that he still has
;       hardware bugs on-board? What would be the difference
;       between his setup and mine? I'll bump up to v0.86 anyway.
;       Who says fridays the 13-th are bad luck? I just got the
;       whole IDE system running ok.... All the bus on my list
;       are dead. There could be others remaining, but I for one
;       cannot find them. Even chkdsk does not crash anymore. It
;       does give strange answers some time, It seems to be
;       unable to grasp the idea of more than one sector per
;       cluster and I suspect it has 128-bytes sectors burnt
;       inside somewhere..
;
;End-------------------------------------------------------------

;Assembler------------------------------------------------------
;
; I have only masm, not tasm, the directives below do not
; work for masm. I have put the masm equivalent instead.
; In TASM the directives below may just result in working code. I
; do however have no means to check that (I have no TASM, just
; some old-style MASM)
;
;            .MODEL tiny
;            .Code
;
; This is what MASM thinks is needed to start a simple device
; driver. I hardly understand most of it, seems it has something
; to do with segment-assignment.
;
code    segment para 'code'     ; define code segment
        assume cs:code, ds:code, es:code, ss:code
;
; nice and cryptic as you see, MASM is famous for that ;-)
;
;End------------------------------------------------------------

;Defs-----------------------------------------------------------
;
; The defines for the request packet interface
; They are really the offsets in the request packet of the
; parameter.
;
; request packet:
; ---------------
;
RqLen   equ     0       ; byte: length of the packet in bytes
RqUnit  equ     1       ; byte: unit number: 0 .. no of units
RqCmd   equ     2       ; byte: Command opcode byte
RqSts   equ     3       ; word: returned status
;
; 8 bytes reserved
;
RqHdr   equ     13      ; header hength in bytes
;
; start of the parameters:
; ------------------------
;
; Init call:
;
RqInitNUnits    equ     RqHdr+0 ; byte: Number of units
RqInitEndAdr    equ     RqHdr+1 ; ptr : End addres of driver
RqInitBPBarr    equ     RqHdr+5 ; ptr : BPB words array
RqInitCmdLine   equ     RqHdr+5 ; ptr : command line of driver
;
; Media check:
;
RqMChkDesc      equ     RqHdr+0 ; byte: Media descriptor
RqMChkRet       equ     RqHdr+1 ; byte return value
;
; BuildbPB:
;
RqBBPBDesc      equ     RqHdr+0 ; byte: Media descriptor
RqBBPBScr       equ     RqHdr+1 ; ptr : scratch area (512 bytes)
RqBBPBPtr       equ     RqHdr+5 ; ptr : BPB of the unit
;
; Read / Write (with/without verify and IoCtl....)
;
RqRdWrDesc      equ     RqHdr+0 ; byte: Media descriptor
RqRdWrIoAdr     equ     RqHdr+1 ; ptr : I/O address
RqRdWrCnt       equ     RqHdr+5 ; word: sector count
RqRdWrSec       equ     RqHdr+7 ; word: starting sector
;
; The error codes as returned to the DIP
;
EWriteProt      equ     0       ; write-protect error
EUNIT           equ     1       ; Unknown unit error
ENRDY           equ     2       ; drive not ready error
ECMD            equ     3       ;
ECRC            equ     4       ;
ELEN            equ     5       ;
ESEEK           equ     6       ;
EMEDIA          equ     7       ;
ESECNF          equ     8       ;
ENoPaper        equ     9       ; ok, the IDE driver has no paper
                                ;     problems...
EWRITE          equ     10      ;
EREAD           equ     11      ;
EGENERAL        equ     12      ;
ERes1           equ     13      ;
Eres2           equ     14      ;
EDISKCH         equ     15      ;
;
;End------------------------------------------------------------

;ORG------------------------------------------------------------
        ORG 0           ; device drivers have no PSP
;End------------------------------------------------------------

;Dev Header-----------------------------------------------------
;
; This header is interpreted by DOS/DIP to find out about the
; device driver.
;
;---------------------------------------------------------------
;
            dd 0FFFFFFFFh               ; Pointer to next driver
            dw 6000h                    ; Attribute word
            dw Offset StratRoutine      ; ptr to strategy routine
IntVektor   dw Offset IntRoutine        ; ptr to interrupt routine
Units       db 23                       ; number of units (max)
;
            db 'PoFoIde'        ; OEM (that's us here..) string
;
;
;End------------------------------------------------------------

;---------------------------------------------------------------
; Strategy-Routine:
;
; Does nearly nothing, it just saves the pointer to the request
; block in a local parameter
;
StratRoutine:
            mov cs:word ptr DosPointer,bx       ; save pointer to
            mov cs:word ptr DosPointer+2,es     ; request block
            retf                                ; exit
;
;---------------------------------------------------------------
; Dummy routine:
;---------------------------------------------------------------
;
; The dummy routine does nothing. It is needed because the PoFo
; would crash if it was not there. It simply returns and error,
; Unfortunately it is not possible to skip the complete
; installation of the driver on a PoFo.
;
; NB: I'm not so sure about that anymore.. making BuildBPB return a wrong
; sector size could just do that?...

DummyRoutine:
        push    di                      ;
        push    es                      ;
        les     di,cs:[DosPointer]      ; es:di -> request block
        mov     es:[di+RqSts],8102h     ; drive not ready, done bit
        pop     es                      ;
        pop     di                      ;
        retf                            ;
;
;End------------------------------------------------------------

;Static---------------------------------------------------------
;
; the static storage of the device driver.
;
;---------------------------------------------------------------
;
Debug           db      0       ; debug flag <>0 -> debug messages
NoFsChk         db      0       ; skip fs check (1=skip)
DoIdent         db      1       ; Flag for Do Disk Ident 1=do it
DoInit          db      1       ; Flag for Init 1=do init
errorc          db      0       ; error flag/byte (<>0 -> error)
DosPointer      dd      0       ; request block pointer
DataPointer     dd      0       ; data I/O addres pointer
;
; the array of BPB pointers as specified in the:
;
;       DOS4.0 programmers manual
;
BPBarray:
        dw      offset BPB ; D: ; For the moment I point them all
        dw      offset BPB ; E: ; at my one-and-only BPB.
        dw      offset BPB ; F: ; I have made room for all
        dw      offset BPB ; G: ; the remaining alfabet.
        dw      offset BPB ; H: ; I'll manipulate the dsize
        dw      offset BPB ; I: ; parameter of my BPB to fit
        dw      offset BPB ; J: ; the real BPB parameter(s) of
        dw      offset BPB ; K: ; the current unit.
        dw      offset BPB ; L: ;
        dw      offset BPB ; M: ;
        dw      offset BPB ; N: ; <- this is where my 351 MBytes
        dw      offset BPB ; O: ;    disk ends
        dw      offset BPB ; P: ;
        dw      offset BPB ; Q: ;
        dw      offset BPB ; R: ;
        dw      offset BPB ; S: ;
        dw      offset BPB ; T: ;
        dw      offset BPB ; U: ;
        dw      offset BPB ; V: ;
        dw      offset BPB ; W: ;
        dw      offset BPB ; X: ;
        dw      offset BPB ; Y: ;
        dw      offset BPB ; Z: ; room for 23 units
;
; I decided to make a LockRdWr bit per unit after all. It's a
; little more work, but the rigid solution I had before would
; make even me wild...
;
LockBits:       dd      0       ; 32 lock bits.
;
;---------------------------------------------------------------
; The BPB (Bios Parameter Block). This block of data is passed
; (pointed to) when the DIP wants to know the disk's geometry.
;---------------------------------------------------------------
;
; The parameters of the file-system, I support 12-bits FATs for
; the moment. So does DIP, another DOS may be better at this
; trick. NB: the parameter dsize in the real BPB buffer is
; updated each time a SetBuffer is requested.
;
rootdir equ     128             ; # entries in the root directory
fats    equ     1               ; # fat's
cluster equ     16              ; sectors/cluster
dtype   equ     0F8H            ; media type byte (F8H = harddisk)
dsize   equ     65280           ; number of sectors in the disk
;
; the fixed parameters of the DOS file-system
;
secsize equ     0200H           ; always 512 bytes/sector
dirsize equ     020H            ; bytes per directory entry
dskresv equ     1               ; always one reserved sector (why?)
;
; the pars I compute from the others
;
; The size of the FAT in sectors
;
; fatsize equ ((3 * dsize)+1)/(2 * secsize * cluster) ; sectors/fat
;
fatsize         equ     12      ; MASM is no good calculator
;
; The size of the root directory in sectors
;
rootsize        equ     (rootdir * dirsize) / secsize
;
; admin size of a file-system:
; FAT, rootdir reserved and bootblock (the '1')
;
admsize         equ     (fatsize + rootsize + dskresv + 1)
;
; When the disk tail size is below a certain lower limit I do not
; bother to start a new partition. A partition with ONLY a
; bootblock and a FAT seems like nonsense to me.
;
minsize equ     2048            ; minimum partition size (1Mbyte)
;
; I fill in the BPB for the disk that is being accessed. That
; happens when a read/write or a BuildBPB is requested.
;
; The Normal and Last disk size
;
DSizeN          dw      dsize           ; Normal disk size
DSizeL          dw      0               ; last-unit disk size
ClustN          db      cluster         ; Normal cluster size
ClustL          db      0               ; last-unit cluster size
FatSizeN        dw      fatsize         ; Normal FAT size
FatSizeL        dw      0               ; last-unit FAT size
;
; I check this with data from disk. For simplicity I compare
; the entire head of the boot-block to here. That saves some
; counting.
;
BootBlock:
        jmp     short noboot    ; short jmp ends up here
        db      0               ; filler byte
;
; The BPB itself is where the parameters end up. NB: The ones
; marked (fixed: <value>) are checked when a TstFs is executed.
; This is done when the driver Init-s. If one of these parameters
; is found different from the <value> the entire disk is read/write
; locked. This can be made ok by executing a mkfs on the
; offending partition(s). A subsequent reboot will re-check the
; parameters and remove the read/write lock when all partitions
; are found to have a valid file-system. This is perhaps a bit
; too rigid, but it does assure that there are no reads/writes to
; partitions that do not contain a valid file-system.
;
BPBNam: db      "PoFoIDE " ;    ; volume name (8 chars)
;                           offs in BPB:
BPB     dw      secsize    ;+00 ; sector size     (fixed: 0200H)
BPBclus db      cluster    ;+02 ; cluster size    (fixed: 16)
BPBResv dw      dskresv    ;+03 ; reserved sectors (mostly 1)
BPBfatn db      fats       ;+05 ; no of FAT's     (fixed: 1)
BPBroot dw      rootdir    ;+06 ; root dir entries
BPBdsiz dw      dsize      ;+08 ; total number of sectors
BPBdtyp db      dtype      ;+0A ; media code      (fixed: F8H = hard-disk)
BPBfats dw      fatsize    ;+0B ; sectors per FAT (fixed: 12)
        dw      8          ;+0D ; sectors per track (nonsense
        dw      2          ;+0F ; number of heads     really)
        dd      0          ;+11 ; hidden sectors

        ; some reserved space, 11 bytes in all. This should
        ; satisfy even DOS4.0 and on
        db      0,0,0,0,0       ; reserved
        db      0,0,0,0,0,0     ; reserved too
;
noboot:
;
bootsize        equ     (offset noboot - offset bootblock)
;
;---------------------------------------------------------------
;
; For debugging, I've added a name table mechanism to the diver.
; This part will not be in the real code when a production
; version goes into the world. It saves a hell off a lot of
; trouble when debugging. My nice little debugger (ddt) will find
; this and use it to make me find out where I'm looking.
;

        ; name table entry definition macro
NM      macro   NtName
        dw      NtName
        db      '&NtName',0
        endm

; un-comment the next line to get a name table. With this
; line commented you'll not get a name table:
;With_NT equ    1        ; names tabel ON

; check if the names table is requested.
IFDEF With_NT

        ; signal string for ddt. It will recognize the
        ; existence of the table when it finds this string.
        db      'ddt nt'        ; for ddt: name table follows

        ; The macro can make life a load easier here
        ; simply: NM <name of label to put in the name table>
        ; Note: comment is allowed here...
        NM      ReadSec         ; read one sector
        nm      WriteSec        ; write a sector
        nm      IntRoutine      ; interrupt routin
        nm      Read            ; read entry point
        nm      SetBuffer       ; setup buffers
        nm      RdWrError       ; error processing
        nm      ReadMore        ; more to read
        nm      RdWrDone        ; read done
        nm      WaitNBsy        ; Wait till disk is not busy
        nm      WaitDRDY        ; same thing
        nm      FixBPB          ; make BPB ok
        nm      SetLBB          ; unit -> LBB conversion
        nm      ReadSecErr      ; handles read-sector errors
        nm      SetLBA          ; set LBA in the disk
        nm      DoCmd           ; write command to disk
        nm      RecalDisk       ; recalibrate the disk
        nm      ReadSts         ; read disk's status register
        nm      ReadSecStsErr   ; handles status errors
        nm      WaitDRQ         ; Wait till disk requests data
        nm      ReadSecDrqErr   ; error processing thereof
        nm      ReadBlock       ; read a data block from the disk
        nm      WriteBlock      ; write a block to disk
        nm      SetIn           ; set I/O to input
        nm      SetAdr          ; set IDE bus address
        nm      ReadByte        ; read byte from IDE bus
        nm      WriteByte       ; write a byte to IDE bus
        nm      ReadReg         ; read a register
        nm      ReadWord        ; read a word from IDE data
        nm      RdSkip          ; read/skip data
        nm      SoftReset       ; execute soft-reset
        nm      WaitTimOut      ; wait time-out
        nm      FinWait         ; wait finished
        nm      SetOut          ; bus to output
        nm      SetIn           ; bus to input

        ; Init routines too
        nm      ParsePars       ; Parse run-string pars
        nm      InitIde         ; init IDE system
        nm      DisChar         ; display a character
        nm      ToHex           ; convert to hex
        nm      DisHexByte      ; display hex byte
        nm      DisHexWord      ; display a hex word
        nm      NewLine         ; goto new line
        nm      TestFs          ; test file-system
        nm      InitIdeErr      ; Ide init error
        nm      CheckFailedStr  ; check failed
        nm      DoDiskIdent     ; execute disk ident
        nm      Check_PF_Drive  ; test if PoFo & drive
        nm      Number          ; read a number
        nm      Parameter       ; parse parameters
        nm      ParamError      ; error in parameter

        ; Init parameters
        nm      TestBlock       ; I/O testblock
        nm      Tst             ; I/O test block too

        ; Test: the parameters too, the new ddt should print them
        ; too
        nm      BPB             ; BPB
        nm      Debug           ; debug flag <>0 -> debug messages
        nm      NoFsChk         ; skip fs check (1=skip)
        nm      DoIdent         ; Flag for Do Disk Ident 1=do it
        nm      DoInit          ; Flag for Init 1=do init
        nm      errorc          ; error flag/byte (<>0 -> error)
        nm      DosPointer      ; request block pointer
        nm      DataPointer     ; data I/O addres pointer

        ; IDE interface parameters too
        nm      LBB             ; LBA base (Partition start)
        nm      LBA             ; Lineair Block Address (LBA)
        nm      SCnt            ; sector count.
        nm      Cyl             ; number of cylinders of the disk
        nm      Head            ; number of heads of the disk
        nm      Sec             ; number of sectors per track of the disk
        nm      IdNoName        ; default = name is there
        nm      SPD             ; Sectors Per Disk     (=Sec x Head x Cyl)
        nm      SPC             ; Sectors Per Cylinder (=Sec x Head)
        nm      SPT             ; Sectors Per Track    (=Sec)
        nm      CUnit           ; Current Unit number
        nm      CCyl            ; current cylinder
        nm      CHead           ; current head
        nm      CSec            ; current sector
        nm      TOff            ; default = no timer

        ; end of the name table
        db      0,0,0           ; end of the names table

ENDIF
;
; When the initialisation of the driver goes ok the code after
; the label EndResident will be released from memory. If an error
; in the initial phase of the driver happens the part after
; ErrEndResident will be released. This saves some of the very
; valuable memory space of the Pofo. In this error case ONLY the
; the device header, strategy routine, the DummyRoutine and the
; BPB array and BPB itself  will remain in the memory.
;
ErrEndResident:
;
;End-------------------------------------------------------------

;Despatcher------------------------------------------------------
;
; This is the 'interrupt' part of the driver. It parses the
; command and executes the appropriate service routine. It is NOT
; an interrupt-driven routine in the sense that hardware-
; interrupts activate this code. Dos/Dip have all the provisions
; for multi-tasking device drivers, just the real multi-tasking
; kernel is not there....
;
IntRoutine:

        push    ax              ; save all registers
        push    bx              ;
        push    cx              ;
        push    dx              ;
        push    si              ;
        push    di              ;
        push    bp              ;
        push    ds              ;
        push    es              ;
        pushf                   ;

        mov     ax,cs           ;
        mov     ds,ax           ; ds:=cs

        ; prepare pointer to request packet
        les     di,[DosPointer] ; make es:di -> request packet

        ; clear error code
        mov     errorc,0        ; preset error to 0

        ; parse the command of the request packet
        mov     bl,es:[di+RqCmd]; get command byte
        xor     bh,bh           ; BX = Command code

        cmp     bl,12           ; test if acceptable command
        jbe     Cmd_ok          ; if so, continue

        ; this driver supports commands 0 .. 12
        mov     errorc,ECMD     ; unknown Command
        jmp     CmdRet          ; exit with error code set
;
; The main command interpreter of the driver. It uses the
; JumpTable to find which routine to call. One rouine for each
; supported function call. Upon being called the subroutine
; pointed to by bx the following registers have the following
; contents:
;
;  ds    = local code/data segment
;  es:di -> request packet
;
; The handler can signal errors by setting a non-zero error code
; in the parameter errorc. The value here is the error code that
; will be passed back to DOS/DIP. See the DOS/DIP manual for a
; description of error codes.
;
Cmd_ok: shl     bx,1                    ; it is a word table
        call    word ptr [JumpTable+bx] ; call function handler

        ; entry when the command has done it's work
CmdRet:

        ; make sure you NEVER return an error for an INIT
        ; call. The PoFo crashes like a bomb when that happens
        cmp     byte ptr es:[di+RqCmd],0        ;
        jnz     CmDoErr                         ;

        ; an INIT call NEVER returns an error
        mov     errorc,0        ; whatever happens...

        ; process the value of errorc
CmDoErr:mov     al,errorc       ; test if no errors
        mov     ah,0            ;
        or      al,al           ;
        jz      CmNoErr         ;

        mov     ah,80h          ; set error flag
CmNoErr:or      ah,01           ; set done flag
        mov     es:[di+RqSts],ax; set the return status

        popf                    ; restore all registers
        pop     es              ;
        pop     ds              ;
        pop     bp              ;
        pop     di              ;
        pop     si              ;
        pop     dx              ;
        pop     cx              ;
        pop     bx              ;
        pop     ax              ;

        retf                    ; far return
;
; The JumpTable of the main command interpreter.
;
JumpTable:

        DW      Offset Init             ; Command  0
        DW      Offset MediaChk         ;          1
        DW      Offset BuildBPB         ;          2
        DW      Offset IoctlRead        ;          3
        DW      Offset Read             ;          4
        DW      Offset Dummy            ; unsup    5
        DW      Offset Dummy            ; unsup    6
        DW      Offset Dummy            ; unsup    7
        DW      Offset Write            ;          8
        DW      Offset WriteVfy         ;          9
        DW      Offset Dummy            ; unsup   10
        DW      Offset Dummy            ; unsup   11
        DW      Offset IoctlWrite       ;         12

;End----------------------------------------------------------

;Handlers-----------------------------------------------------
;
; The function handlers of the interrupt routine
;
;-------------------------------------------------------------

;-------------------------------------------------------------
; Handler Dummy
; purp: dead end for all non-supported function calls
; in  : nothing
; out : error code set to indicate that the command is not
;       supported
; uses: nothing

Dummy:  mov     errorc,ECMD     ; unknown command error
        ret                     ;

;-------------------------------------------------------------
; Handler Init
; purp: Initialise the driver.
; in  : nothing
; out : driver initialised and request block parameters filled
;       in. NB: when something goes wrong in this initial phase
;       the number of devices is set to 0 and the Dummy routine
;       is hooked up as the interrupt routine. This is
;       self-modifying code, the entry for IntRoutine in the
;       driver's header is modified.
; uses: registers, request header etc...
;
; NB: This handler could be placed in the transient part of the
;     driver. It would not take resident code space then. It has
;     been kept here because all the other handlers are here too.
;     All it's routines are in the transient part of the driver
;     (at the tail of this code..).

Init:
        ; issue start message
        mov     dx,Offset InitStr       ;
        mov     ah,9                    ;
        int     21h                     ;

        ; test if init is to be done (skip most of the work
        ; if it is called a seccond time...)
        cmp     DoInit,1                ;
        jnz     InitOk                  ;

        ; parse run-string parameters
        call    ParsePars               ; (see tail of the code)
        jc      InitErr                 ;

        ; init the IDE bus, check if there is any drive
        ; connected.
        call    Check_PF_Drive          ; (see tail of the code)
        jc      InitErr                 ;

        ; test if any units found
        cmp     Units,0                 ;
        jz      InitErr                 ;

        ; all IDE start things done, setup return parameters
        jmp     InitOk                  ;

        ; In case of error, ALL function calls end up at the dummy
        ; routine; This will result in the PoFo reporting an error
        ; without a total system crash. Unfortunately the PoFo WILL
        ; install the driver,
        ; This is NOT in accordance with the normal DOS
        ; behaviour, but we'll have to live with that (or burn a
        ; modified PoFo ROM....).

InitErr:mov     units,1                         ;
        mov     IntVektor,offset DummyRoutine   ;

        ; in case of errors the driver's resident part will
        ; become noticably smaller. All code AFTER the dummy
        ; routine will be removed from the memory.
        mov     ax,offset ErrEndResident        ;
        jmp     InitTail                        ;

InitOk: mov     ax,offset EndResident           ;
;       jmp     InitTail                        ;

        ; finish up things in the driver's return packet from the
        ; INIT call; ax = end of resident portion

InitTail:

        mov     word ptr es:[di+RqInitEndAdr],ax        ; setup mem pointer
        mov     word ptr es:[di+RqInitEndAdr+2],cs      ; to driver's end

        ; setup BPB pointer
        mov     word ptr es:[di+RqInitBPBarr],offset BPBarray
        mov     word ptr es:[di+RqInitBPBarr+2],cs

        ; return number of units
        mov     al,Units                        ;
        mov     byte ptr es:[di+RqInitNUnits],al;

        ; make sure you do the real Init work only once,
        ; a seccond time the code would no longer be there...
        mov     DoInit,0                        ;

        ret                                     ;

;-------------------------------------------------------------
; Handler MediaChk
; purp: test if device medium changed.
; in  : nothing
; out : do not know if medium changed, for all units.
; uses: nothing

MediaChk:
        mov     byte ptr es:[di+RqMChkdesc],dtype       ;
        mov     byte ptr es:[di+RqMChkRet],0H           ;
        ret                                             ;

;-------------------------------------------------------------
; Handler BuildBPB
; purp: get drive parameters (DOS/DIP-level)
; in  : nothing
; out : pointer to BPB set in return parameters
; uses: nothing
; NB  : this routine also does some strange manipulations
;       with the BPB's sector size. Seems to have something to
;       do with DIP's problems with >512 bytes clusters.

BuildBPB:

        ; prepare returned buffer
        mov     byte ptr es:[di+RqBBPBDesc],dtype           ;
        mov     word ptr es:[di+RqBBPBPtr],Offset BPB       ; pointer to BPB
        mov     word ptr es:[di+RqBBPBPtr+2],cs             ;

        ; set the correct parameters for this unit in the BPB
        mov     al,byte ptr es:[di+RqUnit]      ; get unit number
        call    FixBPB                          ; make BPB ok

        ret                             ;

;-------------------------------------------------------------
; Handler IoCtlRead
; purp: read parameters from the driver, driver present signal
; in  : nothing
; out : driver's parameters in the return block.
; uses: some registers
;

IoctlRead:

        ; setup data
        mov     al,byte ptr es:[di+RqUnit]      ; get unit number
        mov     CUnit,al                ;
        call    SetLBB                  ; make LBB ok
        call    FixBPB                  ; make BPB ok

        ; get pointer to the return packet data block
        cld                             ;
        push    es                      ;
        push    di                      ;
        les     di,es:[di+RqRdWrIoAdr]  ;

        ; fill in the return packet data
        mov     ax,'KP'                 ; signal bytes
        stosw                           ;
        mov     al,CUnit                ; unit number
        stosb                           ;

        ; I pass a load of internal information back too. This is
        ; quite nice for on-line disgnostics of the driver.

        ; the partition's base
        mov     ax,word ptr LBB         ;
        stosw                           ;
        mov     ax,word ptr LBB+2       ;
        stosw                           ;

        ;  the offset of the partition's bootblock info section
        mov     ax,cs                   ; the driver's code-segment
        stosw                           ;
        mov     ax,offset BootBlock     ;
        stosw                           ;

        ; the disk size
        mov     ax,word ptr SPD         ; disk's SPD
        stosw                           ;
        mov     ax,word ptr SPD+2       ;
        stosw                           ;

        ; the disk's configuration in CHS form
        mov     ax,Cyl                  ;
        stosw                           ;
        mov     ax,Head                 ;
        stosw                           ;
        mov     ax,Sec                  ;
        stosw                           ;

        ; information about the latest access to the disk
        mov     ax,word ptr LBA         ; in LBA form
        stosw                           ;
        mov     ax,word ptr LBA+2       ;
        stosw                           ;
        mov     ax,CCyl                 ; CHS form
        stosw                           ;
        mov     al,CHead                ;
        stosb                           ;
        mov     al,CSec                 ;
        stosb                           ;

        ; scan the IDE I/O ports
        push    dx                      ; Data and control
        mov     dx,IODatH               ;
        in      al,dx                   ;
        mov     ah,al                   ;
        mov     dx,IoDatL               ;
        in      al,dx                   ;
        stosw                           ;
        mov     dx,IoCtl                ;
        in      al,dx                   ;
        stosb                           ;
        pop     dx                      ;

        ; read all relevant IDE registers. Note that this will
        ; destroy the previously read I/O registers values
        mov     al,IDECylL              ;
        call    readReg                 ;
        stosb                           ;
        mov     al,IDECylH              ;
        call    ReadReg                 ;
        stosb                           ;
        mov     al,IDeHd                ;
        call    ReadReg                 ;
        stosb                           ;
        mov     al,IDESec               ;
        call    ReadReg                 ;
        stosb                           ;
        mov     al,IDENum               ;
        call    ReadReg                 ;
        stosb                           ;
        mov     al,IDESts               ; status register
        call    ReadReg                 ;
        stosb                           ;
        mov     al,IDEErr               ;
        call    ReadReg                 ;
        stosb                           ;

        ; done, get registers ok again
        pop     di                      ;
        pop     es                      ;
        ret                             ;

;-------------------------------------------------------------
; Handler Read
; purp: read sectors from the disk
; in  : es:di -> request packet
; out : data written into the indicated buffer, error flag
; uses: registers

Read:

DoRead: call    SetBuffer               ; get parameters from
                                        ; request block
ReadMore:

        call    ReadSec                 ; read one sector
        jc      RdWrError               ; handle errors

        add     word ptr LBA,1          ; next sector
        adc     word ptr LBA+2,0        ;
        dec     SCnt                    ; test if any more to
        cmp     SCnt,0                  ; read
        jnz     ReadMore                ;
        jmp     RdWrDone                ;

;-------------------------------------------------------------
; Handler IoCtlWrite
; purp: write a single sector to the disk
; in  : parameters in the request block
; out : error code
; uses: registers

IoctlWrite:

        ; sector write, always one sector, no lock check

        ; make ds:bx -> data buffer
        lds     bx,es:[di+RqRdWrIoAdr]  ;

        mov     ax,[bx+513]     ; get sector number
        xchg    ah,al           ; swap to get the
                                ; byte-order ok

        mov     word ptr es:[di+RqRdWrSec],ax   ; put in the request header
        mov     word ptr es:[di+RqRdWrCnt],1    ;

        mov     ax,cs                   ; to fake a normal write
        mov     ds,ax                   ; ds = cs again
        jmp     DoWrite                 ; go write the sector,
                                        ; ignore lockout mech.

;-------------------------------------------------------------
; Handler Write/WriteVfy
; purp: write sectors to the disk
; in  : es:di -> request packet
; out : data written to the disk, error flag
; uses: registers

WriteVfy:   ; This write-command is used by DIP/DOS when verify has
            ; been set to ON. I just write. Verify could be
            ; implemented later on.

Write:

        ; test lockout mechanism
        mov     al,es:[di+RqUnit]       ; unit code
        call    GetLock                 ; get lock bit
        jc      RdWrLocked              ;

        ; go do writes
DoWrite:call    SetBuffer               ; get parameters

WriteMore:

        call    WriteSec                ; write one sector
        jc      RdWrError               ; handle errors

        add     word ptr LBA,1          ; next sector
        adc     word ptr LBA+2,0        ;
        dec     SCnt                    ; test if any more to
        cmp     SCnt,0                  ; write
        jnz     writemore               ;
        jmp     RdWrDone                ;

RdWrLocked:

        ; read/write lockout, give error & exit
        mov     errorc,ENRDY            ; drive not ready
        mov     ax,es:[di+RqRdWrCnt]    ; nothing done
        mov     SCnt,ax                 ;

RdWrError:

        ; error handler for read/write. Error code
        ; is already set. I just fill in what has been
        ; read or written.
        mov     ax,es:[di+RqRdWrCnt]    ; get requested count
        sub     ax,SCnt                 ; what has been Rd/Wr
        mov     es:[di+RqRdWrCnt],ax    ;

RdWrDone:

        ; make the I/O ports passive
        call        SetIn               ; data bus to input
        ret                             ; done

;
;End------------------------------------------------------------

;Routines-------------------------------------------------------
;
; The subroutines of the handlers:
;
;---------------------------------------------------------------

;----------------------------------------------------------------
; Routine SetBuffer
; purp: copies incoming parameters from request block to local
;       parameters.
; in  : data in request block from DIP:
;       ds = cs
;       ds:DosPointer -> request packet.
; out : data in local parameters:
;       LBB = base-sector number of the unit.
;       LBA = sector number of first sector to transfer
;       SCnt = number of sectors to transfer
;       BPB made ok for this unit
;       DataPointer -> I/O data address
;
; uses: ax
;

SetBuffer:

        ; get the number of sectors
        mov     ax,es:[di+RqRdWrCnt]    ; get number of sectors
        mov     SCnt,ax                 ;

        ; convert unit code to LBB
        mov     al,es:[di+RqUnit]       ; unit code
        mov     CUnit,al                ; store
        call    SetLBB                  ; convert to LBB

        ; load the BPB with the dsize for the current unit
        mov     al,es:[di+RqUnit]       ; RqUnit [0 .. units-1]
        call    FixBPB                  ; make BPB ok

        ; now, make the LBA
        mov     ax,es:[di+RqRdWrSec]    ; get starting sector number
        add     ax,word ptr LBB         ; + LBB -> LBA
        mov     word ptr LBA,ax         ;
        mov     ax,word ptr LBB+2       ;
        adc     ax,0                    ;
        mov     word ptr LBA+2,ax       ;

        ; put the data pointer in local buffer
        mov     ax,word ptr es:[di+RqRdWrIoAdr]         ;
        mov     word ptr DataPointer,ax                 ;
        mov     ax,word ptr es:[di+RqRdWrIoAdr+2]       ;
        mov     word ptr DataPointer+2,ax               ;

        ret                             ;

;----------------------------------------------------------------
; Routine FixBpb
; purp: fix up the BPB for a specified drive
; in  : al = unit number
; out : BPB made ok for that unit. Delivers the standard
;       parameters when non-last unit requested, special ones for
;       the last unit of the disk.
; uses: ax

FixBPB:

        ; save input pars
        push    ax                      ;

        ; al = unit no 0 .. units-1
        inc     al                      ; make it [1 .. units]
        cmp     al,units                ;
        jz      fixlastunit             ;

        ; not the last unit, make BPB for normal unit
        mov     ax,DSizeN               ; standard disk size
        mov     BPBdsiz,ax              ;
        mov     al,ClustN               ; standard cluster size
        mov     BPBclus,al              ;
        mov     ax,FatSizeN             ; standard FAT size
        mov     BPBfats,ax              ; 
        jmp     FixBPBEnd               ;

        ; prepare the last unit's BPB
fixlastunit:
        mov     ax,DSizeL               ; disk-size for Last
        mov     BPBdsiz,ax              ;
        mov     al,ClustL               ; cluster size for Last
        mov     BPBclus,al              ;
        mov     ax,FatSizeL             ; fat size for last
        mov     BPBfats,ax              ;
;       jmp     FixBPBEnd               ;

FixBPBEnd:

        ; restore registers
        pop     ax                      ;
        ret                             ;

;----------------------------------------------------------------
; Routine SetLBB
; purp: convert unit number to LBB value
; in  : al = unit number
; out : LBB set for that unit
; uses: nothing

SetLBB: push    ax                      ; save input
        push    cx                      ;
        push    dx                      ;

        mov     ah,0                    ;
        mov     cx,dsize                ;
        mul     cx                      ; x disk size
        mov     word ptr LBB,ax         ; put in buffer
        mov     word ptr LBB+2,dx       ; for LBB

        pop     dx                      ;
        pop     cx                      ;
        pop     ax                      ;
        ret                             ;

;----------------------------------------------------------------
; Routine SetLock
; purp: Set a read/write lock bit for a unit
; in  : al = unit number
; out : read/write lock bit set for that unit
; uses: flags

SetLock:push    ax                      ; save input
        push    cx                      ;

        ; test high/low word
        cmp     al,16                   ;
        jnc     setuplk                 ; upper byte lock bit

        ; lock bits 0 .. 15 in lower word
        mov     cl,al                   ;
        mov     ax,1                    ;
        shl     ax,cl                   ;
        or      word ptr LockBits,ax    ;
        jmp     setlken                 ;

setuplk:sub     al,16                   ;
        mov     cl,al                   ;
        mov     ax,1                    ;
        shl     ax,cl                   ;
        or      word ptr LockBits+2,ax  ;

setlken:pop     cx                      ;
        pop     ax                      ;
        ret                             ;

;----------------------------------------------------------------
; Routine GetLock
; purp: Get a read/write lock bit for a unit
; in  : al = unit number
; out : carry = read/write lock bit for that unit
; uses: flags

GetLock:push    ax                      ; save input
        push    cx                      ;

        ; test high/low word
        cmp     al,16                   ;
        jnc     getuplk                 ; upper byte lock bit

        ; lock bits 0 .. 15 in lower word
        mov     cl,al                   ; make cl = bit # in ax
        mov     ax,word ptr LockBits    ; get lockbits word
        jmp     getlkbit                ;

        ; lock bits 16 .. 31 in upper word
getuplk:sub     al,16                   ; make cl = bit # in ax
        mov     cl,al                   ;
        mov     ax,word ptr LockBits+2  ; get lockbits word
;       jmp     getlkbit                ;

        ; get the correct bit to the carry
getlkbit:
        shr     ax,cl                   ; get the bit
        and     ax,1                    ; mask all other bits
        add     ax,0FFFFH               ; put in the carry

        pop     cx                      ;
        pop     ax                      ;
        ret                             ;

;End------------------------------------------------------------

;Defs-----------------------------------------------------------
;
; IDE interface defines
;
; All defines of parameters that are not bytes etc..
; These take no memory, thay are only symbolic names for things I
; intend to use later. Mainly the defines etc. of the IDE bus and
; register parameters.
;
; The I/O ports of the IDE controller. This are the I/O
; ports of the PortFolio parallel interface. When using this
; thing on something else this is where you have to put the I/O
; address. I use a simple 82C55 for the interface. The hardware
; has an extra inverter and some pull-down resistors. That makes
; up the entire hardware of the IDE interface.
;
IoBase          equ     8078H   ; I/O base address for the interface
;
IoDatL          equ     IoBase+0        ; Low  byte data IDE (port A)
IoDatH          equ     IoBase+1        ; High byte data IDE (port B)
IoCtl           equ     IoBase+2        ; Control byte for IDE (port C)
IoMod           equ     IoBase+3        ; I/O modus IDE and bit set/clr
;
; The I/O modi I use, set as control words in the 8255
;
DMout           equ     10000000B       ; all ports are output
DMin            equ     10010010B       ; ctl = output, data input
;
; The bits of the control port of the IDE bus. I use the bit
; SET/RESET facility of the 8255 too.
;
DCNOP           equ     00000000B       ; Nothing on IDE ctl bus
;
DCIow           equ     10000000B       ; IOWR  bit
DCSetIow        equ     00001111B       ; Assert IOWR
DCClrIow        equ     00001110B       ; Negate IOWR
;
DCIor           equ     01000000B       ; IORD  bit
DCSetIor        equ     00001101B       ; Assert IORD
DCClrIor        equ     00001100B       ; Negate IORD
;
DCCs1           equ     00100000B       ; CS1   bit
DCCs0           equ     00010000B       ; CS0   bit
DCCsMask        equ     11001111B       ; CS mask
DCRes           equ     00001000B       ; reset bit
;
; IDE register adresses. The IDE 'bus' looks like these I/O ports
; to an outside observer. I've translated these addresses to
; include the appropriate CS bit.
;
IDECmd          equ     07H+DCCs0       ; addres for command
IDESts          equ     07H+DCCs0       ; addres status register
IDEHd           equ     06H+DCCs0       ; addres head number
IDECylH         equ     05H+DCCs0       ; addres cylinder number high
IDECylL         equ     04H+DCCs0       ; addres cylinder number low
IDEsec          equ     03H+DCCs0       ; addres sector number
IDEnum          equ     02H+DCCs0       ; addres number of sectors
IDEErr          equ     01H+DCCs0       ; addres Error register
IDEData         equ     00H+DCCs0       ; addres for data bus (16-bits)
IDERIRQ         equ     07H+DCCs1       ; addres Reset/IRQ register
;
; The head number (0..F) also has the mask for master/slave
; I fix this at Master, I do not think I will use two drives
; on my IDE interface.
;
IDEHdA          equ     00001111B       ; head number and mask
IDEHdO          equ     10100000B       ; head number or mask
;
; The Reset/IRQ register has two interesting bits. Later I'll
; have to implement a soft-reset of the disk in case of errors.
; At this moment I do not use these register bits.
;
IDESRes         equ     00000100B       ; Soft Reset bit
IDENIRQ         equ     00000010B       ; 0 = IRQ active
;
; My usage of the soft-reset bits, I keep the interrupts off
;
IDESetSRes      equ     00000110B       ; set soft-reset
IDEClrSRes      equ     00000010B       ; clear soft-reset
;
; The bits from IDE Status register
;
StsBsy          equ     10000000B       ; Busy flag
StsRdy          equ     01000000B       ; Ready flag
StsWft          equ     00100000B       ; Write error
StsSKC          equ     00010000B       ; Seek complete
StsDRQ          equ     00001000B       ; Data Request
StsCorr         equ     00000100B       ; ECC executed
StsIdx          equ     00000010B       ; Index found
StsErr          equ     00000001B       ; Error flag
;
; Command opcodes I use
;
CmdRecal        equ     010H    ; recalibrate disk
CmdRead         equ     020H    ; write a block
CmdWrite        equ     030H    ; read block
CmdSetPar       equ     091H    ; set device pars
CmdStandby      equ     0E3H    ; set standby timer
CmdIdent        equ     0ECH    ; Identify disk
;
; I use CHS internally on all disks. I present an LBA interface
; to the outside world, the low-level routines (notably SetLBA)
; convert LBA to CHS notation. If anyone wants to connect a
; really big disk to this contraption, he'll have to implemet
; real LBA. That is far easier than it may look.
;
; All ATA3 compliant disks support automatic geometry detection
; by means of the Ident Disk command. This means that I can read
; the disk's geometry from the disk itself. The routine IdentDisk
; does that.
;
; I have -till now- found one (8051A from Miniscribe) disk that
; does not give proper answers in an IdentDisk request. I will
; have to provide for a 'manual override' on this automatic disk
; size detection mechanism. For now, I'll simply not support
; those disks that have no Ident support. If you really want to
; use such a dinosaur on this IDE interface you'll have to modify
; the code. The way to go is: simply put your disk's parameters
; in the SPT and SPC parameters and forget about calling
; IdentDisk.
;
;End-------------------------------------------------------------------

;Static---------------------------------------------------------
;
; The static storage of the IDE interface driver.
;
LBB     dd      0       ; LBA base (Partition start)
LBA     dd      0       ; Lineair Block Address (LBA)
SCnt    dw      0       ; sector count.
;
; the parameters of the disk (as read from the disk using the
; ident command)
;
Cyl     dw      0       ; number of cylinders of the disk
Head    dw      0       ; number of heads of the disk
Sec     dw      0       ; number of sectors per track of the disk
;
; flag, used to remember if a name was specified of the disk.
;
IdNoName db     0       ; default = name is there
;
; I use some converted parameters, notably:
; Used to convert LBA -> CHS
;
SPD     dd      0       ; Sectors Per Disk     (=Sec x Head x Cyl)
SPC     dw      0       ; Sectors Per Cylinder (=Sec x Head)
SPT     dw      0       ; Sectors Per Track    (=Sec)
;
; buffer for CHS of currently accessed block
;
CUnit   db      0       ; Current Unit number
CCyl    dw      0       ; current cylinder
CHead   db      0       ; current head
CSec    db      0       ; current sector
;
; The off timer value
;
TOff    db      0       ; default = no timer
;
;End------------------------------------------------------------

;Routines-------------------------------------------------------
;
; The IDE disk drive I/O routines.
;
;---------------------------------------------------------------
; Routine SetIn
; purp: set all ports of the 8255 for input from the IDE bus
; in  : nothing
; out : nothing
; uses: nothing
; NB  : This also resets ALL control lines and adr section

SetIn:  push    ax              ; save accu
        push    dx              ;
        mov     dx,IoMod        ; write to modus port
        mov     al,DMIn         ;
        out     dx,al           ;
        pop     dx              ; restore registers
        pop     ax              ;
        ret                     ;

;---------------------------------------------------------------
; Routine SetOut
; purp: set all ports of the 8255 for output to the IDE bus
; in  : nothing
; out : nothing
; uses: nothing
; NB  : This also resets ALL control lines and adr section

SetOut: push    ax              ; save accu
        push    dx              ;
        mov     dx,IoMod        ;
        mov     al,DMout        ;
        out     dx,al           ;
        pop     dx              ;
        pop     ax              ;
        ret                     ;

;---------------------------------------------------------------
; Routine RecalDisk
; purp: ReCalibrate the disk, re-position the disk's heads
; in  : nothing
; out : nothing
; uses: al

RecalDisk:
        mov     al,CMDRecal     ; give the command
;       jmp     DoCmd           ; see code below

;---------------------------------------------------------------
; Routine DoCmd
; purp: issues command opcode to the IDE device
; in  : nothing
; out : nothing
; uses: al

DoCmd:
        push    ax              ; save a
        call    SetOut          ; set bus to output
        mov     al,IDECmd       ; set address
        call    SetAdr          ;
        pop     ax              ; get command byte back
;       jmp     WriteByte       ; see code below
        
;---------------------------------------------------------------
; Routine WriteByte
; purp: Write one byte to the IDE bus
; in  : byte in AL
; out : nothing
; uses: nothing

WriteByte:
        push    dx              ; save dx
        push    ax              ; save ax too

        mov     dx,IoDatL       ; put data byte on port
        out     dx,al           ;

        mov     dx,IoMod        ; go make write pulse
        mov     al,DCSetIow     ;
        out     dx,al           ;
        mov     al,DCClrIow     ;
        out     dx,al           ;

        pop     ax              ;
        pop     dx              ;
        ret                     ;

;---------------------------------------------------------------
; Routine SetAdr
; purp: Set an address on the IDE bus
; in  : address byte (incl CS bit) in al
; out : nothing
; uses: nothing
; NB  : clears all other control bits in the process

SetAdr: push    dx              ; save registers
        push    ax              ;

        ; output address
        mov     dx,IoCtl        ; on control byte
        and     al,DCCsMask     ; first only the address
        out     dx,al           ;
        pop     ax              ; then the CS bits too
        out     dx,al           ;

        ; get registers back
        pop     dx              ;
        ret                     ;

;---------------------------------------------------------------
; Routine ReadSts
; purp: get status if the IDE device
; in  : nothing
; out : status byte in al
; uses: nothing

ReadSts:
        mov     al,IDESts       ; set address
;       jmp     ReadReg         ; see code below here

;---------------------------------------------------------------
; Routine ReadReg
; purp: get byte from the IDE device
; in  : address in al
; out : data byte in al
; uses: nothing

ReadReg:call    SetIn           ;
        call    SetAdr          ;
;       jmp     ReadByte        ; see code below

;---------------------------------------------------------------
; Routine ReadByte
; purp: Read one byte from the IDE bus
; in  : nothing
; out : byte in al
; uses: ax
; nb  : assumes address and bus have been set

ReadByte:
        push    dx              ; save dx

        mov     dx,IoMod        ; get current
        mov     al,DCSetIor     ;
        out     dx,al           ;

        mov     dx,IoDatL       ; get data
        in      al,dx           ;
        mov     ah,al           ; save in ah

        mov     dx,IoMod        ; reset read strobe
        mov     al,DCClrIor     ;
        out     dx,al           ;

        mov     al,ah           ; get data from ah

        pop     dx              ; restore dx
        ret                     ;

;---------------------------------------------------------------
; Routine WaitNBSY
; purp: wait till the drive indicates non-busy status
; in  : nothing
; out : errorc and carry set if timed out
; uses: nothing

WaitNBSY:

        push    ax              ; save registers
        push    cx              ;
        mov     cx,0            ; timeout

        ; test if device ready
wtrdy1: call    ReadSts         ; get status byte
        and     al,StsBsy       ; get status bits
        jz      to_FinWait      ;
        loop    wtrdy1          ; wait for it

        jmp     WaitTimOut      ;

to_FinWait:jmp  FinWait         ;

;---------------------------------------------------------------
; Routine WaitDRDY
; purp: wait till the drive indicates Data ready status
; in  : nothing
; out : errorc and carry set if timed out
; uses: nothing

WaitDRDY:

        push    ax              ; save registers
        push    cx              ;
        mov     cx,0            ; timeout

        ; test if device ready
wtdrdy1:call    ReadSts         ; get status byte
        and     al,StsRdy       ; get status bits
        jnz     FinWait         ;
        loop    wtdrdy1         ; wait for it

        jmp     WaitTimOut      ;

;---------------------------------------------------------------
; Routine WaitDrq
; purp: wait till the drive indicates data request status
; in  : nothing
; out : errorc and carry set if timed out
; uses: nothing

WaitDrq:

        push    ax              ; save registers
        push    cx              ;
        mov     cx,0            ; timeout

        ; test if device ready for data
wtdrq1: call    ReadSts         ; get status byte
        test    al,StsDrq       ; get status bits
        jnz     FinWait         ;
        loop    wtdrq1          ;

        jmp     WaitTimOut      ;

;---------------------------------------------------------------
; Fragment FinWait
; purp: finishes up things when waiting for something is done
; in  : ax still on stack
; out : nothing
; uses: nothing
; NB  : this code fragment is a result of code compression
;       it is used by the routines WaitDRQ, WaitNBSY and
;       WaitDRDY

FinWait:pop     cx              ; get cx back from the stack
        pop     ax              ; get ax back from stack
        clc                     ; no errors
        ret                     ; routine done

;---------------------------------------------------------------
; Fragment WaitTimOut
; purp: signals timeout errors
; in  : cx,ax still on stack
; out : nothing
; uses: nothing
; NB  : this code fragment is a result of code compression
;       it is used by the routines WaitDRQ, WaitNBSY and
;       WaitDRDY.
; NB1 : A soft-reset added to make the disk non-lockup if some
;       timeout happens
;

WaitTimOut:

        mov     errorc,ENRDY    ; set error code

        ; get registers from stack
        pop     cx              ;
        pop     ax              ; get ax back from stack
        stc                     ; signal error
        ret                     ; routine done

;---------------------------------------------------------------
; Routine SoftReset
; purp: issue a soft-reset to the disk
; in  : nothing
; out : nothing
; uses: nothing

SoftReset:
        push    ax              ; save registers
        push    dx              ;
        push    cx              ;

        ; Issue a soft-reset to the disk, perhaps it can recover
        ; from errors this way...
        call    SetOut          ; bus to output
        mov     al,IDERIRQ      ; set the address
        call    SetAdr          ;

        mov     al,IDESetSRes   ; set soft-reset
        call    WriteByte       ; set the reset pulse

        mov     cx,100H         ;
wtout1: loop    wtout1          ;

        mov     al,IDEClrSRes   ; remove soft-reset
        call    WriteByte       ;

        mov     cx,100H         ;
wtout2: loop    wtout2          ;

        ; wait till busy bit cleared
        mov     cx,0080H        ; wait long tim
wtout3: call    ReadSts         ; get status byte
        test    al,StsBsy       ; get status bits
        jz      wtout4          ;
        loop    wtout3          ; wait for it
wtout4:

        ; restore registers
        pop     cx              ;
        pop     dx              ;
        pop     ax              ;

        ret                     ;

;---------------------------------------------------------------
; Routine SetLBA
; purp: sets the LBA for the next transfer
; in  : LBA holds sector number
; out : registers of the IDE controller loaded
; uses: CCyl, CHead and CSec set
; NB  : I select ONE sector to be processed

SetLBA:

        ; save register ax
        push    ax                      ;
        push    dx                      ;

        ; prepare for IDE interface for output
        call    SetOut                  ;

        ; first part = dd(LBA)/dw(SPC) -> dw(CCyl), dw(rest)
        mov     ax,word ptr LBA         ; get low word
        mov     dx,word ptr LBA+2       ; get high word
        div     word ptr SPC            ;
        mov     word ptr CCyl,ax        ; save cylinder number

        ; remaining (word) contains head & sector number
        mov     ax,dx                   ; get remainder
        div     byte ptr SPT            ;

        ; al = result, ah = remainder
        mov     CHead,al                ;
        inc     ah                      ; NB: Sector count starts at 1!!!
        mov     CSec,ah                 ;     Sounds crazy, is Crazy, but true

        ; now load the buffered data to the IDE drive
        mov     al,IDECyll              ; cylinder low byte
        call    SetAdr                  ;
        mov     al,byte ptr CCyl        ;
        call    WriteByte               ;

        mov     al,IDECylh              ; cylinder high byte
        call    SetAdr                  ;
        mov     al,byte ptr CCyl+1      ;
        call    WriteByte               ;

        mov     al,IdeHd                ; head byte
        call    SetAdr                  ;
        mov     al,CHead                ;
        and     al,IDEHdA               ; some bits set/reset
        or      al,IDEHdO               ;
        call    WriteByte               ;

        mov     al,IDESec               ; sector byte
        call    SetAdr                  ;
        mov     al,CSec                 ;
        call    WriteByte               ;

        mov     al,IdeNum               ; number of sectors
        call    SetAdr                  ;
        mov     al,1                    ; always 1 sector
        call    WriteByte               ;

        pop     dx                      ; get dx back
        pop     ax                      ; get ax back

        ret                             ; done

;---------------------------------------------------------------
; Fragments errors1
; purp: provide jump part to the ReadSecErr etc..
;       They are out of reach here
; in  : nothing
; out : nothing
; uses: nothing

ReadSecErr1:                    ;
        jmp     ReadSecErr      ;
ReadSecStsErr1:                 ;
        jmp     ReadSecStsErr   ;
ReadSecDrqErr1:                 ;
        jmp     ReadSecDrqErr   ;

;---------------------------------------------------------------
; Routine RdSkip
; purp: skip data reads from the disk
; in  : cx = number of words to skip
; out : nothing
; uses: ax

RdSkip: call    ReadWord        ; read a word
        loop    RdSkip          ; ignore it
        ret                     ;

;---------------------------------------------------------------
; Routine ReadWord
; purp: reads data from the disk
; in  : all setup has to be done already
; out : ax = word read
; uses: dx

ReadWord:

        mov     dx,IoMod        ; assert read strobe
        mov     al,DCSetIor     ;
        out     dx,al           ;

        mov     dx,IoDatL       ; get data word
        in      ax,dx           ;

        push    ax              ; save on stack

        mov     dx,IoMod        ; deassert read strobe
        mov     al,DCClrIor     ;
        out     dx,al           ;

        pop     ax              ; get word back

        ret                     ;

;---------------------------------------------------------------
; Routine ReadSec
; purp: reads one sector from the disk
; in  : LBA   = block address to write
;       es:di = address to store the data
; out : data read into the destination address, carry set if error
; uses: nothing

        ; wait for bsy bit cleared
ReadSec:
        call    WaitNBSY        ; wait till disk is ready
        jc      ReadSecErr      ;
        call    WaitDRDY        ;
        jc      ReadSecErr      ;

        ; load parameters
        call    SetLBA          ; set address
        mov     al,CmdRead      ; give read command
        call    DoCmd           ;

        ; wait for busy gone
        call    WaitNBSY        ;
        jc      ReadSecErr      ;

        ; test on errors
        call    ReadSts         ; get status byte
        test    al,StsErr       ; check error bit
        jnz     ReadSecStsErr   ;

        ; test if ready for data transport
        call    WaitDRQ         ;
        jc      ReadSecDrqErr   ;

        ; transport the data block to destination
        call    ReadBlock       ; get the data block

        ; final status check
        call    ReadSts         ; get status byte
        test    al,StsErr       ; check error bit
        jnz     ReadSecStsErr   ;

        ; return with no errors
        clc                     ; no errors
        ret                     ;

        ; DRQ error, no DRQ after command passed
ReadSecDrqErr:                          ;
        mov     errorc,EREAD            ; read error

        ; errorc is already set elsehere
ReadSecErr:
        call    SoftReset               ; soft-reset to the disk
        stc                             ;
        ret                             ;

ReadSecStsErr:
        mov     errorc,EREAD            ; preset to read error
;       jmp     RWStsErr                ; see below...

;---------------------------------------------------------------
; Fragment RWStsErr
; purp: attempts to get a proper error code after read/write
;       sector failed.
; in  : byte errorc preset to an error code
; out : sometimes a better error code in errorc
; uses: nothing
; NB  : this code is used by readsec and writesec

        ; status gives error code
        ; see if I can make out any error remark
RWStsErr:
        mov     al,IDEErr               ; get error register
        call    ReadReg                 ;

        ; see if I can make something of this
        test    al,00010001B            ; sector not found
        jz      stserr1                 ; addres mark not found
        mov     errorc,ESECNF           ; gives sector not found
        jmp     StsErrDone              ;

stserr1:

        test    al,01000000B            ; uncorrectable
        jz      stserr2                 ; data error
        mov     errorc,ECRC             ; gives CRC error
        jmp     StsErrDone              ;

stserr2:

        test    al,00000010B            ; track 0 not found
        jz      stserr3                 ;
        mov     errorc,ESEEK            ; gives seek error
        jmp     StsErrDone              ;

stserr3:

        test    al,00000100B            ; aborted
        jz      stserr4                 ;
        mov     errorc,EGENERAL         ; gives general failure
        jmp     StsErrDone              ;

stserr4:

        ; not anything I know how to handle, use default and exit

StsErrDone:

        call    SoftReset       ; soft-reset the disk
        stc                     ; set error flag
        ret                     ; exit

;---------------------------------------------------------------
; Routine ReadBlock
; purp: read one block from the IDE device
; in  : es:di -> request packet
; out : es:di 256 words further on
; uses: nothing

ReadBlock:
        ; save registers
        push    ax              ;
        push    cx              ;
        push    dx              ;

        ; setup for data read
        call    SetIn           ; set to input
        mov     al,IDEData      ; set address
        call    SetAdr          ;

        ; init loop counter
        mov     cx,256          ; 256 word reads
        cld                     ; clear direction flag (UP)

        ; setup source pointer
        les     di,[DataPointer]        ;

rdblk1: mov     dx,IoMod        ; assert read strobe
        mov     al,DCSetior     ;
        out     dx,al           ;

        mov     dx,IoDatL       ; use word read
        in      ax,dx           ;
        stosw                   ; put in memory

        mov     dx,IoMod        ; negate read strobe
        mov     al,DCClrIor     ;
        out     dx,al           ;

        ; do for all words of a block
        loop    rdblk1          ;

        ; make pointers ok again
        mov     word ptr DataPointer,di     ; store new
        mov     word ptr DataPointer+2,es   ; pointer

        les     di,[DosPointer] ; get old es:di back

        ; done, get things back
        pop     dx              ;
        pop     cx              ;
        pop     ax              ;
        ret                     ;

;---------------------------------------------------------------
; Routine WriteSec
; purp: Write one sector to the disk
; in  : LBA   = sector to write to
;       es:di -> request packet
; out : data written to the disk, carry set if error happened
; uses: nothing

WriteSec:
        call    WaitNBSY        ; wait till bus is ready
        jc      WriteSecErr     ;
        call    WaitDRDY        ; wait till disk is ready
        jc      writeSecErr     ;

        call    SetLBA          ; set address
        mov     al,CmdWrite     ; give write command
        call    DoCmd           ;

        ; wait till command ready
        call    WaitNBSY        ;
        jc      WriteSecErr     ;

        ; test on errors
        call    ReadSts         ; get status byte
        test    al,StsErr       ; check error bit
        jnz     WriteSecStsErr  ; error -> report

        ; wait for DRQ
        call    WaitDRQ         ;
        jc      WriteSecDrqErr  ;

        ; transport the data block to destination
wrsec1: call    WriteBlock      ; write data to disk

        ; test final status
        call    ReadSts         ;
        test    al,StsErr       ; check error bit
        jnz     WriteSecStsErr  ; error -> report

        ; return indicating no errors
        clc                     ;
        ret                     ; done

        ; No Drq after command given
WriteSecDrqErr:                         ;
        mov     errorc,EWRITE   ; write fault

        ; errorc is set elsewhere
WriteSecErr:                    ;
        call    SoftReset       ; give disk a soft reset
        stc                     ; error indicator on
        ret                     ;

        ; error status detected
WriteSecStsErr:                         ; write fault too
        mov     errorc,EWRITE           ; default = write fault
        jmp     RWStsErr                ; perhaps there is a
                                        ; better one

;---------------------------------------------------------------
; Routine WriteBlock
; purp: write one block of data to the IDE device
; in  : es:di -> data address (512 bytes)
; out : nothing
; uses: nothing

WriteBlock:

        ; save registers
        push    ax              ; accu
        push    cx              ; 256 words counter
        push    dx              ; I/O port address
        push    ds              ; save ds:si
        push    si              ; on stack this time..

        ; setup for data write
        call    SetOut          ; bus to output
        mov     al,IDEData      ; set address
        call    SetAdr          ;

        ; here I now do the es:di -> ds:si transit
        lds     si,[DataPointer]        ;

        ; init loop counter
        mov     cx,256          ; 256 word write
        cld                     ; direction = up

wrblk1: lodsw                   ; get data w
        mov     dx,IoDatL       ; dx -> dataword
        out     dx,ax           ;

        mov     dx,IoMod        ; assert the write strobe
        mov     al,DCSetIow     ;
        out     dx,al           ;
        mov     al,DCClrIow     ;
        out     dx,al           ;

        ; do that for all 256 words
        loop    wrblk1          ;

        ; put new data destination pointer back
        mov     word ptr cs:DataPointer,si      ;
        mov     word ptr cs:DataPointer+2,ds    ;

        ; done, get things back
        pop     si              ; ds:si from stack
        pop     ds              ;
        pop     dx              ; registers too
        pop     cx              ;
        pop     ax              ;
        ret                     ;

;End------------------------------------------------------------

;End------------------------------------------------------------

; **********************************************
; * End of the resident part of the driver     *
; * all code PAST this label will not be there *
; * after the Init routine has been called.    *
; **********************************************

EndResident:

;---------------------------------------------------------------
; Routine ParsePars
; purp  : reads and interpretes the driver's command line
; in    : request block data = command line
; out   : driver's parameters set, carry set if something wrong
;         carry clear if parsing went ok.
; uses  : nothing

ParsePars:

        ; I'll use ds:si to scan the command line. that means
        ; that ds no longer points to the local code segment
        push    ds                      ; save ds for later

        ; make ds:si -> command line
        mov     si,word ptr es:[di+RqInitCmdLine]  ; offset command line
        mov     ax,word ptr es:[di+RqInitCmdLine+2]; segment command line
        mov     ds,ax                   ;

        ; I'll use string operations -> direction = up.
        cld                             ;

Parameter:

        ; scan the command-line
        lodsb                   ; get a command-line byte
        cmp     al,01FH         ; test for end-of-line
        ja      ParamH          ; look for parameter head
        jmp     ParamEnd        ; <CR> ends all parameter scans

        ; see if a parameter starts here
ParamH: cmp     al,'/'          ; parameters start with '/'
        jz      Param           ;
        cmp     al,'-'          ; or with '-' (UNIX-style)
        jz      Param           ;
        jmp     Parameter       ;

        ; parse parameters
Param:  lodsb                   ; get next byte
        and     al,0DFh         ; convert to UPPER case

        ; Parameter 'D': use debug modus
        cmp     al,'D'          ; test debug modus
        jne     nota_D          ;

        inc     cs:[debug]      ;
        jmp     Parameter       ;

nota_D:

        ; Parameter 'N': no file-system check
        cmp     al,'N'          ; file-system check skip
        jne     nota_N          ;

        inc     cs:[NoFsChk]    ;
        jmp     Parameter       ;

nota_N:

        ; Parameter 'C': C/H/S setting
        cmp     al,'C'          ;
        jne     nota_C          ;

        ; set fixed number of Cylinders/Heads/Sectors
        ; This will allow me to use my old Minscribe 8051A again..
        call    Number                  ; C-number
        jc      ParamError              ;
        cmp     ax,1025                 ; [1 .. 1024]
        jnc     ParamError              ;
        cmp     ax,1                    ;
        jc      ParamError              ;
        mov     word ptr cs:Cyl,ax      ;

        call    Number                  ; H-number
        jc      ParamError              ;
        cmp     ax,17                   ; [1 .. 16]
        jnc     ParamError              ;
        cmp     ax,1                    ;
        jc      ParamError              ;
        mov     word ptr cs:Head,ax     ;

        call    Number                  ; S-number
        jc      ParamError              ;
        cmp     ax,257                  ; [1 .. 256]
        jnc     ParamError              ;
        cmp     ax,1                    ;
        jc      ParamError              ;
        mov     word ptr cs:Sec,ax      ;

        mov     cs:DoIdent,0            ; skip Disk Ident
        jmp     Parameter               ;

nota_C:

        ; Parameter 'O': disk-off timer
        cmp     al,'O'          ;
        jne     nota_O          ;

        ; get disk's off time
        call    Number          ; get the off time
        jc      paramerror      ;
        cmp     ax,256          ; max = 255
        jnc     paramerror      ;
        mov     cs:TOff,al      ; store it for later
        jmp     Parameter       ;

nota_O:

        ; none of the parameters I know, give parameter
        ; error

ParamError:

        pop     ds                      ; get ds back

        mov     dx,Offset CmdErrorStr   ; Command-line error
        mov     ah,9                    ;
        int     21h                     ;

        stc                             ; carry set
        ret                             ;

        ; parameter parsing worked out ok.

ParamEnd:

        pop     ds                      ; restore data segment
        clc                             ;

        ret

;---------------------------------------------------------------
; Routine Number
; purp: reads a number from a <CR> terminated string
; in  : ds:si -> string
; out : ax = number's value, carry clear when number read or
;       ax = 0000, carry set when error happened.
;       both cases: si -> last byte that was not understood or
;                   not part of the number.
; uses: si

Number: push    cx              ; save cx, is result register
        push    dx              ; save dx, needed for mul
        mov     cx,0            ;

        ; start the scan
numb0:  lodsb                   ; get the first byte
        cmp     al,13           ; see if line ends
        ja      numb1           ;

        ; end of line, si -> cr
numerr: dec     si              ; si -> the cr
        mov     ax,0            ; result = 0000
        pop     dx              ;
        pop     cx              ; cx from stack
        stc                     ; error signal set
        ret                     ; done

        ; next test
numb1:  cmp     al,' '          ; separation is ' ' or '/'
        jz      numb0           ; many ' '
        cmp     al,'/'          ;
        jz      numb3           ; or a single '/'

        ; now the real work begins.
        sub     al,'0'          ;
        jc      numerr          ; below '0' is no good
        cmp     al,10           ;
        jnc     numerr          ; above '9' is no good too

        ; found a digit in al
numb2:  push    ax              ; I want: mul cx,10
        mov     ax,cx           ; have to move about somewhat
        mov     cx,10           ;
        mul     cx              ;
        mov     cx,ax           ;
        pop     ax              ;

        add     cl,al           ; put result in place
        adc     ch,0            ;

numb3:  lodsb                   ; get next byte
        sub     al,'0'          ; test it
        jc      numfin          ;
        cmp     al,10           ;
        jnc     numfin          ;

        jmp     numb2           ; process it

        ; finished reading the number
numfin: mov     ax,cx           ; get result
        dec     si              ; si -> non-number
        pop     dx              ;
        pop     cx              ;
        clc                     ;
        ret                     ;

;---------------------------------------------------------------
; Routine Check_PF_drive
; purp: checks if the actual computer is a PortFolio, and if the
;       drive/interface is ok.
; in  : nothing
; out : # of drives set to 0 if anything goes wrong.
; uses: a lot, registers; 82C55 etc....
;---------------------------------------------------------------

Check_PF_Drive:

        ;--------------------------------------------------------
        ; test if this is a PoFo (in fact: if it's NOT a normal PC)
        ;--------------------------------------------------------
        in      al,61h                  ; read keyboard port of PC
        cmp     al,61h                  ; gives 61H in a PoFo
        jz      isa_PF                  ;

        ; prepare for error message
        mov     dx,Offset NoPoFoStr     ;
        jmp     CheckFailedStr          ;

        ; PoFo detected, continue installation
isa_PF:

        ;--------------------------------------------------------
        ; test if in debug modus, give message if so
        ;--------------------------------------------------------
        cmp     debug,0                 ;
        jz      DebInDone               ;

        ; debug modus active string
        mov     dx,offset DebugStr      ;
        mov     ah,09H                  ;
        int     21H                     ;

        ; display code segment
        mov     ax,cs                   ;
        call    DisHexWord              ;

        mov     dx,offset NewLn         ;
        mov     ah,09H                  ;
        int     21H                     ;

DebInDone:

;gocheck:

        ;--------------------------------------------------------
        ; see if the IDE hardware (8255 Pio) is there.
        ;--------------------------------------------------------
        call    SetOut                  ; set Pio output modus
        mov     dx,IoDatL               ; test if AAAA and 5555
        mov     ax,0AAAAH               ; are read back correctly
        out     dx,ax                   ;
        nop                             ;
        nop                             ;
        nop                             ;
        in      ax,dx                   ;
        cmp     ax,0AAAAH               ;
        jnz     PioError                ;

        ; test with 05555H too
        mov     ax,05555H               ;
        out     dx,ax                   ;
        nop                             ;
        nop                             ;
        nop                             ;
        in      ax,dx                   ;
        cmp     ax,05555H               ;
        jz      PioOk                   ;

PioError:

        ; point to error string
        mov     dx,offset NoPioStr      ;
        jmp     CheckFailedStr          ; Pio not there

PioOk:
        ;--------------------------------------------------------
        ; I/O level ok, init as an IDE I/O system
        ;--------------------------------------------------------
        call    InitIde                 ; init bus and reset drive
        jnc     IIdeDone                ; if no device found

        ; InitIde returned an error
        jmp     CheckFailedStr          ;

IIdeDone:

        ;--------------------------------------------------------
        ; Get the disk's geometry
        ;--------------------------------------------------------

        ; do the Ident part only if no disk geometry was specified
        ; the /C option in the drives pars can do that
        cmp     DoIdent,1               ; test if ident required
        jz      DoDiskIdent             ;

        jmp     SkipDiskIdent           ; no -> skip it

        ; go execute the disk ident

DoDiskIdent:

        call    WaitNBSY        ; wait till disk ready
        jc      IdentFailed     ; may time out...
        call    WaitDRDY        ;
        jc      IdentFailed     ;

        ; give command
        mov     al,CmdIdent     ; send Ident command
        call    DoCmd           ;

        ; wait for busy gone
        call    WaitNBSY        ;
        jc      IdentFailed     ; timeout?
        call    WaitDRDY        ; and data-ready there
        jc      IdentFailed     ; timeout?

        ; test on errors reported by the drive itself
        call    ReadSts         ; get status byte
        test    al,StsErr       ; check error bit
        jnz     IdentFailed     ; no error -> cont

        ; device ready for data transfer
        call    WaitDRQ         ; drive must make DRQ active
        jc      Identfailed     ; or else I do not know what...

        ; setup for data read
        call    SetIn           ; set Pio to input
        mov     al,IDEData      ; set address
        call    SetAdr          ;
        jmp     idcont          ;

        ; I need a jmp to get to Check_Failed
IdentFailed:                            ; otherwise: jmp out of
        mov     dx,offset NoIdentStr    ;
        jmp     CheckFailedStr          ; range

        ; I use cx as word counter
idcont: mov     cx,0            ; no words read yet

        ; read a word from the disk
idloop: call    ReadWord        ;

        ; see what to do with the word
        cmp     cx,1            ; word # 1 = cylinders
        jnz     idloop1         ;

        ; is the number of cylinders
        mov     word ptr Cyl,ax ;

idloop1:cmp     cx,3            ; word # 3 = heads
        jnz     idloop2         ;

        ; is the number of heads, save lower byte
        mov     word ptr Head,ax;
        jmp     idloope         ;

idloop2:cmp     cx,6            ; word # 6 = sectors
        jnz     idloop3         ;

        mov     word ptr Sec,ax ; save lower byte
        jmp     idloope         ;

idloop3:cmp     cx,26           ; just before the name
        jnz     idloop4         ;

        mov     dx,offset IdeNameStr
        mov     ah,9            ;
        int     21h             ;
        jmp     idloope         ;

idloop4:cmp     cx,27           ; word # 27 = first word of
        jnz     idloop5         ;             device name

        ; test if name there
        cmp     ax,0            ;
        jnz     idloop5         ; name is there
        mov     idnoname,1      ;
        mov     dx,offset IdeNoName     ;
        mov     ah,9                    ;
        int     21h                     ;

        ; test if in the name
idloop5:cmp     cx,27           ; words # 27 .. 46 = disk type
        jl      idloope         ; ASCII string
        cmp     cx,40           ; I stop at word # 40
        jg      idloope         ;

        ; test if name there
        cmp     idnoname,1      ;
        jz      idloope         ;

        ; inside the name
        xchg    ah,al           ; print the bytes
        call    DisChar         ; high-low, in that order
        xchg    ah,al           ;
        call    DisChar         ;

        ; end of checks
idloope:nop                     ;

        ; do for all words of a block
        inc     cx              ;
        cmp     cx,256          ;
        jnz     idloop          ;

        ; end of disk ident result handling
        call    NewLine         ; for disk type string output

SkipDiskIdent:

        ;--------------------------------------------------------
        ; convert Disk's CHS to SPD, SPC and SPT
        ;--------------------------------------------------------
        mov     ax,sec                  ; SPT
        mov     SPT,ax                  ;

        mov     ax,word ptr head        ; SPC
        mul     word ptr sec            ;
        mov     SPC,ax                  ;

        mov     ax,SPC                  ; SPD
        mul     word ptr cyl            ;
        mov     word ptr SPD,ax         ;
        mov     word ptr SPD+2,dx       ;

        ;--------------------------------------------------------
        ; compute the number of units that this disk can contain
        ;--------------------------------------------------------
        mov     Units,0                 ; start with 0 units

        ; compute the number of full partitions that will fit
        ; nb: dx:ax = SPD

        ; get the number of full
        mov     cx,dsize                ;
        div     cx                      ;
        mov     Units,al                ;

        ; see how many you got
        cmp     ax,23                   ; less than 23 gives some
        jc      unit1                   ; work
        jz      NoTail                  ; 23, means a full house

        ; more than a full disk, set to 23 units and exit
        mov     Units,23                ;
        jmp     NoTail                  ;

        ;--------------------------------------------------------
        ; a number of tail blocks is there, see what to do
        ; with them. This is a kind of up-and-down calculation.
        ; First I compute the best cluster size, then the number
        ; of FAT sectors, then I re-generate the disk size I
        ; would get from that. I fill in the parameters as I go
        ; along.
        ;--------------------------------------------------------
unit1:  mov     ax,dx                   ; get remainder

        ; see if it any use to bother about this tail
        cmp     ax,(minsize+admsize)    ; if too small
        jc      notail                  ; I skip it

        ; prepare tail's parameters. This is some kind of
        ; 'best-fit' of a file-system into the remaining
        ; file system parameters.

        ; first: substract the number of sectors used by the
        ; bootblock, the root directory etc...
        sub     ax,admsize              ; rootdir, FAT, dskresv

        ; determine the best sectors/cluster size
        push    ax                      ; save ax
        mov     cx,4080                 ; max no of data clusters
        mov     dx,0                    ;
        div     cx                      ;
        cmp     dx,0                    ; if it fits...
        jz      unit2                   ; no rounding, else
        inc     al                      ; round up
unit2:  mov     ClustL,al               ;
        pop     ax                      ; get ax back

        ; got the cluster size, see how big the FAT should be
fitone: mov     cl,ClustL               ; see how many clusters
        cmp     cl,0                    ; I NEVER div/0
        jz      NoTail                  ;
        mov     ch,0                    ;
        mov     dx,0                    ;
        div     cx                      ; ax = # of clusters

        mov     dx,0                    ; fit into integer no
        mov     cx,3                    ; of FAT sectors
        mul     cx                      ;
        mov     cx,1024                 ;
        div     cx                      ;
        cmp     ax,0                    ;
        jz      NoTail                  ;
        mov     FatSizeL,ax             ; ax = # of sectors FAT
        mov     dx,0                    ;
        mov     cx,1024                 ;
        mul     cx                      ;
        mov     cx,3                    ;
        div     cx                      ; ax = # of clusters in FAT

        mov     cl,ClustL               ; compute # of sectors in the
        mov     ch,0                    ; partition
        mov     dx,0                    ;
        mul     cx                      ;

        ; add the admin info again
        add     ax,rootsize+dskresv+1   ; normal admin
        add     ax,FatSizeL             ; + computed FAT
        mov     DSizeL,ax               ; put that in place too

        ; fitted the tail into the FAT12 file-system one more
        ; unit done
        inc     Units                   ;
        jmp     UntDone                 ;

        ; no tail partition, last partition has size of
        ;  a normal partition
NoTail:
        mov     word ptr DSizeL,dsize           ;
        mov     byte ptr ClustL,cluster         ;
        mov     word ptr FatSizeL,fatsize       ;

UntDone:

        ;--------------------------------------------------------
        ; in debug modus, give the disk's geometry
        ;--------------------------------------------------------
        cmp     debug,0                 ;
        jz      SkipGeoDisplay          ;

        ; print header string
        mov     dx,offset Identstr      ;
        mov     ah,9                    ;
        int     21h                     ;

        ; print cccc hh ss in hex....
        mov     ax,cyl                  ;
        call    DisHexWord              ;
        mov     al,' '                  ;
        call    DisChar                 ;
        mov     ax,head                 ;
        call    DisHexbyte              ;
        mov     al,' '                  ;
        call    DisChar                 ;
        mov     ax,Sec                  ;
        call    DisHexByte              ;
        call    NewLine                 ;

SkipGeoDisplay:

        ;--------------------------------------------------------
        ; set the drive's parameters
        ;--------------------------------------------------------

        call    WaitNBSY        ; wait till disk ready
        jc      SetParsFailed   ; may time out...
        call    WaitDRDY        ;
        jc      SetParsFailed   ;

        ; set the parameters
        call    SetOut          ;
        mov     al,IdeHd        ;
        call    SetAdr          ;
        mov     ax,Head         ;
        dec     al              ;
        and     al,IdeHda       ;
        or      al,IdeHdo       ;
        call    WriteByte       ;

        mov     al,IdeNum       ;
        call    SetAdr          ;
        mov     ax,Sec          ;
        call    WriteByte       ;

        ; give command
        mov     al,CmdSetPar    ; send Ident command
        call    DoCmd           ;

        ; wait for busy gone
        call    WaitNBSY        ;
        jc      SetParsFailed   ; timeout?

        ; test on errors reported by the drive itself
        call    ReadSts         ; get status byte
        test    al,StsErr       ; check error bit
        jnz     SetParsFailed   ; no error -> cont

        ; set parameters done
        jmp     SetParsDone     ;

SetParsFailed:
        mov     dx,offset SetParErr
        jmp     CheckFailedStr  ;

        ; set-parameters done
SetParsDone:

        ;--------------------------------------------------------
        ; test the file system info of disk
        ;--------------------------------------------------------
        cmp     NoFsChk,0               ; test if fs check is
        jnz     SkipFsCheck             ; bypassed

        ; execute fs check
        mov     CUnit,0                 ; for all units

        ; test file-system there
testfslp:

        mov     al,CUnit                ; setup unit number
        call    TestFs                  ; test fs
        jnc     tstfsok                 ; test for errors

        ; error processing
        mov     dx,offset FsErrStr      ; display error message
        mov     ah,9                    ;
        int     21h                     ;
        mov     al,CUnit                ;
        add     al,'d'                  ; with drive letter
        call    DisChar                 ;
        mov     al,':'                  ; and ':'
        call    DisChar                 ;
        call    NewLine                 ;

        mov     al,CUnit                ; lock this unit
        call    SetLock                 ;

tstfsok:inc     CUnit                   ; next fs
        mov     al,CUnit                ;
        cmp     al,Units                ;
        jnz     testfslp                ;

        mov     dx,offset FsDnStr       ;
        jmp     FsChkDone               ;

SkipFsCheck:
        mov     dx,offset NoFsStr       ;

FsChkDone:
        ; in debug modus: bark
        cmp     debug,0         ;
        jz      FsNoBark        ;

        ; give message
        mov     ah,9            ;
        int     21h             ;

FsNoBark:

        ;--------------------------------------------------------
        ; set, if requested the standby timer
        ;--------------------------------------------------------
        cmp     TOff,0          ;
        jz      StandbyOk       ;

        ; set the timer
        call    WaitNBSY        ; wait till disk not busy
        jc      StandbyErr      ;

        ; set count in the register
        call    SetOut          ;
        mov     al,IDENum       ; number of sectors
        call    SetAdr          ;
        mov     al,TOff         ;
        call    WriteByte       ;
        mov     al,CMDStandby   ;
        call    DoCmd           ;
        jmp     StandByOk       ;

StandbyErr:

        ; error processing
        mov     dx,offset NoTimerStr    ;
        jmp     CheckFailedStr          ;

StandbyOk:

        ;--------------------------------------------------------
        ; all checks passed
        ;--------------------------------------------------------
Check_ok:

        ; tell the user what drives to expect
        mov     dx,offset DrvStr; d: is always there
        mov     ah,9            ;
        int     21h             ;

        ; test if E: etc there
        cmp     Units,1         ;
        jz      InitDrvDone     ;
        mov     dx,offset DrvStr1       ;
        mov     ah,9            ;
        int     21h             ;

        mov     dl,Units        ;
        add     dl,'d'-1        ;
        mov     ah,2            ;
        int     21h             ;

        mov     dx,offset DrvStr2       ;
        mov     ah,9            ;
        int     21h             ;

InitDrvDone:

        mov     dx,offset NewLn ;
        mov     ah,9            ;
        int     21h             ;

        call    SetIn           ;
        clc                             ;
        ret                             ;

        ;--------------------------------------------------------
        ; process errors
        ; dx already points to an error message
        ;--------------------------------------------------------

CheckFailedStr:                         ;

        mov     units,1                 ; set number of units to
                                        ; 1 to prevent hangs
        mov     ah,9                    ; issue error message
        int     21h                     ;

        ;--------------------------------------------------------
        ; process errors
        ; Error message already given
        ;--------------------------------------------------------


CheckFailedNoStr:

        call    SetIn                   ;
        stc                             ;
        ret                             ;

;---------------------------------------------------------------
; Routine InitIDE
; purp: Init the IDE bus
; in  : nothing
; out : carry set if error happened
; uses: nothing

        ; set I/O port modus to activate the control signals
InitIDE:call    SetIn           ; preset modus of controller

        ; make reset pulse on IDE bus
        ; NB: this is the IDE hardware reset, it will reset ALL
        ; devices connected to the the IDE bus at once. Take heed
        ; of this if you ever want to connect more than one device!
        mov     dx,IoCtl        ; set reset pulse
        mov     al,DCRes        ;
        out     dx,al           ;
        
        ; ATA-3 specifies 25 us minimum for the reset pulse
        ; duration. I use some 1000H loop counts. That should do
        ; the trick easily. I may be a bit on the long side,
        ; I'll do this only once, so I do not care that much..
        mov     cx,1000H        ;
initlp: loop    initlp          ;

        ; remove reset pulse again
        mov     al,DCNOP        ; 
        out     dx,al           ;

        mov     cx,1000H        ; wait some time
initlp1:loop    initlp1         ; ATA-3 says 400 ns

        call    WaitNBSY        ;

        ; Select the master device, ATA-3 says to use the head
        ; register for that, It holds the master/slave select.
        ; For now, this driver supports ONLY the master device.
        ; It should not be impossible to attach two drives to the
        ; IDE bus, that would however require a command-line
        ; option to specify that the driver is to access the
        ; slave device. Perhaps you'd also get some problems
        ; coordinating the master/slave activities. I have not
        ; gone into that here. One disk is difficult enough for
        ; me at this time..

        call    SetOut          ; bus on output
        mov     al,IDEHd        ; set address
        call    SetAdr          ;
        mov     al,0            ; select head no 0
        and     al,IDEHdA       ; and byte
        or      al,IDEHdO       ; or byte
        call    WriteByte       ; write to the bus
        call    SetOut          ; clear all the bus to '0'
        call    SetIn           ; bus to input again

        ; Go see if the device is there at all. ATA-3 specifies
        ; two bits in the head register as 'reserved and 1'. I
        ; use that to see if there is a real disk attached.
        mov     al,IDEHd        ; read head register
        call    ReadReg         ;
        and     al,10100000B    ; leave only these bits
        cmp     al,10100000B    ; require they are there
        jz      initlpa         ;

        ; disk not there
        mov     dx,offset DskErr; these two bits are defined '1'
        jmp     InitIdeErr      ; and reserved at that value. If they
                                ; are not there, the device is not there

        ; Wait till the disk reports non-busy
        ; ATA-3 specifies that this may take 30 secconds
initlpa:mov     cx,0080H        ; wait long time
initlp2:push    cx              ;
        call    WaitNBSY        ; get status byte
        pop     cx              ;
        jnc     InitRec         ;
        loop    initlp2         ; wait for it

        ; disk never ready
        mov     dx,offset ResTimErr     ;
        jmp     InitIdeErr              ;

        ; give the disk a recalibrate command
InitRec:mov     al,CMDRecal     ;
        call    DoCmd           ;

        ; wait for end of recalibrate cimmand
initlp3:mov     cx,080H         ;
initlp4:push    cx              ;
        call    WaitNBSY        ; wait for command completion
        pop     cx              ;
        jnc     InitIdeOk       ;
        loop    initlp4         ;

        ; recalibrate never ready
        mov     dx,offset RecTimErr     ;
        jmp     InitIdeErr              ;

        ; ok return of InitIde, carry is clear here
InitIdeOk:
        mov     errorc,0        ;
        clc                     ;
        ret                     ;

        ; error processing of the InitIde routine
InitIdeErr:
        mov     errorc,0        ; INIT does NOT accept errors
        stc                     ; carry set
        ret                     ; and return

;---------------------------------------------------------------
; Routine TestFs
; purp: check the BPB from the disk
; in  : al = unit no to test the file-system for
; out : carry clear if file-system there, else carry set
; uses: registers

TestFs:

        ; prepare buffers
        call    FixBPB                  ; make reference BPB for unit
        call    SetLBB                  ; make LBB for unit

        ; prepare parameters for a modified read sector
        mov     ax,word ptr LBB         ; read sector 0 of current
        mov     word ptr LBA,ax         ; unit
        mov     ax,word ptr LBB+2       ;
        mov     word ptr LBA+2,ax       ;

        ; wait for bsy bit cleared
        call    WaitNBSY        ;
        jc      TstFs5          ;
        call    WaitDRDY        ;
        jc      TstFs5          ;

        ; load parameters
        ; set this LBA in the disk
        call    SetLBA          ; set address

        ; issue read command
        mov     al,CmdRead      ;
        call    DoCmd           ;

        ; wait for busy gone
        call    WaitNBSY        ;
        jc      TstFs5          ;

        ; test on errors
        call    ReadSts         ; get status byte
        test    al,StsErr       ; check error bit
        jnz     TstFs5          ;

        ; wait till drive is ready for data
        call    WaitDRQ         ; wait for drq
        jc      TstFs5          ;

        ; get the bootblock into the test buffer
        push    ax              ;
        push    cx              ;
        push    dx              ;
        push    di              ;
        push    es              ;

        ; setup for data read
        call    SetIn           ; set to input
        mov     al,IDEData      ; set address
        call    SetAdr          ;

        ; get BPB data words
        mov     cx,20           ; read 20 words (40 bytes)

        cld                     ; read into buffer
        mov     ax,cs           ; testblock
        mov     es,ax           ;
        mov     di,offset TestBlock

tstfs1: call    ReadWord        ;
        stosw                   ;
        loop    TstFs1          ;

        ; skip the rest
        mov     cx,246          ; skip the tail of the block
        call    RdSkip          ;

        ; see if the Fs from the disk matches the one in BootBlock
        ; issue warning if not so
        ; I'll test all the disk-config parameters
        mov     si,offset BootBlock     ; BPB as reference
        mov     di,offset Testblock     ; TST to be tested
        mov     cx,bootsize             ; # of bytes

        ; go test if the same
tstfs2: mov     al,[si]                 ;
        cmp     al,[di]                 ;
        jnz     tstfs3                  ;
        inc     si                      ;
        inc     di                      ;
        loop    tstfs2                  ;

        ; all testable parameters are ok, hope for the best
        ; about the rest of the parameters
        clc                     ; error flag off
        jmp     tstfs4          ;

        ; registers back, error exit
tstfs3: stc                     ; error flag on
tstfs4: pop     es              ;
        pop     di              ;
        pop     dx              ;
        pop     cx              ;
        pop     ax              ;
        call    SetIn           ;
        ret                     ;
;
tstfs5: stc                     ;
        call    SetIn           ;
        ret                     ;

;
;---------------------------------------------------------------
; I use a seccond buffer to load the header of the file-system
; when testing it. This costs only a few words of memory space,
; saves a load of counting however. The thing is a copy
; of the real bootblock.
;---------------------------------------------------------------
;
TestBlock:
        jmp     short notest    ; short jmp ends up here
        db      0               ; filler byte
TstNam  db      "        "      ; volume name (8 chars)
TST     dw      0          ;+00 ; sector size     (fixed: 0200H)
TSTclus db      0          ;+02 ; cluster size    (fixed: 16)
TSTResv dw      0          ;+03 ; reserved sectors (mostly 1)
TSTfatn db      0          ;+05 ; no of FAT's     (fixed: 1)
TSTroot dw      0          ;+06 ; root dir entries
TSTdsiz dw      0          ;+08 ; total number of sectors
TSTdtyp db      0          ;+0A ; media code      (fixed: F8H = hard-disk)
TSTfats dw      0          ;+0B ; sectors per FAT (fixed: 12)
        dw      0          ;+0D ; sectors per track (nonsense
        dw      0          ;+0F ; number of heads     really)
        dd      0          ;+11 ; hidden sectors
        db      0,0,0,0,0       ; reserved
        db      0,0,0,0,0,0     ; reserved too
;
notest:
;
; For comparison, I need to know the size of the testblock.
; crazy MASM: gives phase-errors on this... use rootsize
; instead. Gives the same number, but no phase errors....
;
testsize        equ (offset notest - offset testblock)
;
;---------------------------------------------------------------------
; Routine NewLine
; purp: make the console goto a new line
; in  : nothing
; out : nothing
; uses: nothing

Newline:push    ax              ; save registers
        push    dx              ;
        push    ds              ;

        mov     ax,cs           ; ds <- cs
        mov     ds,ax           ;

        mov     ah,9            ; print predefined string
        mov     dx,Offset NewLn ;
        int     21h             ;

        pop     ds              ; get registers back
        pop     dx              ;
        pop     ax              ;

        ret                     ; done

;--------------------------------------
; Routine DisHexByte and DisHexWord
; purp  : Writes AL or AX as hex ascii
; in    : byte in AL (DisHexByte)
;         word in AX (DisHexWord)
; out   : nothing
; uses  : nothing

DisHexWord:

        ; save registers
        push    ax              ;

        ; higher byte
        mov     al,ah           ;
        call    DisHexByte      ;

        ; lower byte
        pop     ax              ;
        call    DisHexByte      ;

        ; done
        ret                     ;

DisHexByte:

        ; save registers
        pushf                   ;
        push    ax              ;

        ; higher nibble
        shr     al,1            ;
        shr     al,1            ;
        shr     al,1            ;
        shr     al,1            ;
        call    ToHex           ;
        call    DisChar         ;

        ; lower nibble
        pop     ax              ;
        push    ax              ;
        and     al,0FH          ;
        call    ToHex           ;
        call    DisChar         ;

        ; restore registers
        pop     ax              ;
        popf                    ;

        ; done
        ret                     ;

; --------------------------------------
; Routine ToHex
; purp  : converts nibble to hex ASCII character
; in    : nibble in al
; out   : ASCII char in al
; uses  : nothing

ToHex:  pushf                   ;

        and     al,0FH          ; make sure of 0 .. F

        cmp     al,0AH          ;
        jge     tohex1          ;

        ; 0 .. 9
        add     al,'0'          ; 0 .. 9 convert
        jmp     tohexe          ;

        ; A .. F
tohex1: add     al,('A' - 0AH)  ;

tohexe: popf                    ;

        ret                     ;

; --------------------------------------
; Routine DisChar
; purp  : Writes AL to display
; in    : character in al
; out   : nothing
; uses  : nothing

DisChar:pushf                   ;
        push    ax              ;
        push    dx              ;

        mov     dl,al           ;
        mov     ah,02H          ;
        int     21H             ;

disnsio:pop     dx              ;
        pop     ax              ;
        popf                    ;

        ret                     ;

;Text-----------------------------------------------------------
; Installation messages:
; These messages (some of them anyway) are displayed when the
; driver is started. They do not stay resident when the init
; phase of the driver is done.
;---------------------------------------------------------------
;
; This is the normal messages you should always get:
;
InitStr     db 'PoFoIDE disk driver v0.86 (alfa-test)',10,13
            db '(c) 1998 Klaus Peichl & Peter Faasse',10,13,'$'
;
; If /D is specified in config.sys you also get:
;
DebugStr    db 'Debug modus active',10,13
            db 'Driver code segment: ','$'
;
; I like to tell what disk I found at the other end of the bus.
; Real ATA-3 disks will give a nice string of what disk is
; attached
;
IdeNameStr  db 'Disk  : ','$'
IdeNoName   db 'Not specified','$'
DrvStr      db 'Drives: d:','$'
DrvStr1     db ' .. ','$'
DrvStr2     db ':','$'
NewLn       db 10,13,'$'
;
; In debug modus I also give some info about what I read from
; the disk's geometry
;
IdentStr    db 'Disk geometry: ','$'
;
; some other barking
;
NoFsStr     db 'File-system check skipped',10,13,'$'
FsDnStr     db 'File-system check done',10,13,'$'
;
; Some error messages:
;
; Do I have to explain what went wrong?
;
CmdErrorStr db 'Illegal command line option!',10,13,'$'
NoPoFoStr   db 'Not a Portfolio!',10,13,'$'
NoPioStr    db 'IDE interface not detected!',10,13,'$'
DskErr      db 'No disk detected!',10,13,'$'
ResTimErr   db 'Disk Reset timed out',10,13,'$'
RecTimErr   db 'Disk Recalibrate timed out',10,13,'$'
SetParErr   db 'Disk Parameter set error',10,13,'$'
NoIdentStr  db 'Disk Ident Failed',10,13,'$'
;
; non-fatal error messages:
;
NoTimerStr  db 'Error setting standby timer',10,13,'$'
FsErrStr    db 'No valid filesystem: ','$'
;
;End-------------------------------------------------
;
; some MASM-satisfiers
;
code    ends            ; end of code segment
                        ;
            END
