#include "r74s475.h"
#include <QByteArray>
#include "../devicedriver.h"
#include <QDebug>
#include <QString>
#include <qglobal.h>
#include "toolkit.h"

//Here you display power requirements. Nothing special, this one just types text and waits for key.
void power74s475()
{
    QTextStream cin(stdin);
    qDebug()<<"Please connect your ground to pin 12 (switch 4 on)\n and Vcc to pin 24.";
    qDebug()<<"Press Return to start, Ctrl-C aborts";
    cin.readLine();
}

QByteArray read74s475(DeviceDriver * tester, int debug)
{
    QByteArray rom;
    char readWord;

    tester->setIO("000000001111111110000001"); //initialize IO
    tester->powerON();
    qDebug()<<"Reading 512 words from 74S475 chip...";
    for (int i=0;i<512;i++)
    {
        QString addr=QString::number(i,2).rightJustified(9,'0'); //generate binary address
        addr=rev(addr);

        QString state=addr.mid(7,1)+addr.mid(6,1)+addr.mid(5,1)+addr.mid(4,1)+addr.mid(3,1)+addr.mid(2,1)+addr.mid(1,1)+addr.mid(0,1)+"0000"
                     +"00000"+"0101"+"1"+addr.mid(8,1)+"1";

        tester->setData(state); //address and CS low goes in
        qSleep(2);

        //read word
        QString res=tester->getData();

        res=res.mid(16,1)+res.mid(15,1)+res.mid(14,1)+res.mid(13,1)+res.mid(12,1)+res.mid(10,1)+res.mid(9,1)+res.mid(8,1);
        readWord=res.toInt(NULL,2);
        if ((i+1)%16==0) qDebug()<<i+1;

        if(debug)
          qDebug()<<i<<"("<<addr<<"): "<<res<<" ascii: "<<readWord<<" to "<<QString::number(readWord,2).right(8).rightJustified(8,'0')<<":"<<state;
        rom.append(readWord);

    }
    tester->reset();
    return rom;
}
