#include <iostream>
#include <iomanip>
#include <string>
#include <cstdlib>
#include <unistd.h>
#include <fstream>
#include <sstream>
#include "../Romcheck/romio.h"
using namespace std;

void printUsage()
{
 cout<<" ________ "<<endl;
 cout<<" |_      \\     ROM interlacing split tool "<<endl;
 cout<<" _/  /\\   \\   2013 MCbx                  v. 0.02"<<endl;
 cout<<" ___/__\\___\\  "<<endl;
 cout<<"   /    \\      Usage :"<<endl;
 cout<<"        interlace X input.bin output.bin\n";
 cout<<"All parameters are needed.\n";
 cout<<"Parameters: \n";
 cout<<" X - split to n parts (usually you need 2 for even/odd roms)\n";
 cout<<" \n";
 cout<<" New files will be called output.bin.000, output.bin.001, 002 etc.\n";
 return;
}


int main(int argc, char* argv[])
{
    char* buffer;
    long lSize = 0;

    if (argc!=4)
    {
        printUsage();
        return 0;
    }

    int partCount = atoi(argv[1]);
    if (partCount<=0)
    {
        cout<<"Error with part count!\n";
        return 0;
    }

    lSize=loadRom(argv[2],buffer,false);
    if (lSize<=0)
    {
        cout<<"Error when loading file!\n";
        return 65;
    }
    cout<<"File loaded\n";

    if (lSize%partCount!=0)
    {
      cout<<"File cannot be divided, its size is not multiply of part count!\n";
      return 0;
    }

    ofstream resultFile;

    for (int i=0;i<partCount;i++)
    {
        stringstream ss;
        ss<<argv[3]<<"."<<setw(3)<<setfill('0')<<i;
        resultFile.open(ss.str().c_str(), ios::out|ios::binary);
        if (!resultFile.is_open())
        {
            cout<<"Error opening file for writing: "<<ss.str()<<" /n";
            return 0;
        }
        for (int j=0;j<lSize;j=j+partCount)
        {
            resultFile<<buffer[j+i];
        }
        resultFile.close();
    }
    cout<<"Finished interlacing\n";

    return 0;
}
