/*
 *  basicmbed.ld      linker script specifically for the mbed version of KLBasic
 */
 
 
/* Adapted for CortexM3 LPC1768, originally based on LPC21xx and LPC22xx User 
 * Manual UM10144, pg. 15. */

OUTPUT_FORMAT("elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_startup)

MEMORY
{
	flash (rx)  : ORIGIN = 0x00000000, LENGTH = 512K
	sram (rwx) : ORIGIN = 0x10000000, LENGTH =  32K
	ahbsram0 (rwx) : ORIGIN = 0x2007c000, LENGTH = 16K
	ahbsram1 (rwx) : ORIGIN = 0x2007c000, LENGTH = 16K
}

/* Define the top our stack at the end of SRAM */
TOTAL_RESERVED_STACK = 8196;		/* note that printf() and other stdio routines use 4K+ from stack! */
_top_stack = 0x10008000-256;		/* leave the top 256 bytes of RAM open for possible use by IAP! */

EXTERN(__interrupt_vector_table);

SECTIONS
{
	.text :
	{
		CREATE_OBJECT_SYMBOLS
		/* Insert the interrupt vector table first */
		__interrupt_vector_table = .;
		*(.interrupt_vector_table)
		/* Startup assembly */
		*(.startup)

		/* Rest of the code (C) */
		*(.text)
		*(.text.*)
		*(.glue_7)
		*(.glue_7t)

/*  Added following section for holding initializers for variables
 *  that will be accessed from RAM; see also the AT(_end_data_flash)
 *  usage below.
 *
 *  The _data_size value will be used in the startup code to step through
 *  the image of data in flash and copy it to RAM.
 */
		. = ALIGN(4);
		*(.rodata)
		*(.rodata*)
		*(.init)					/* added */
		*(.fini)					/* added */
		. = ALIGN(4);
		_end_data_flash = .;
	} >flash

/*
 *  ------------------- Start of SRAM sections ---------------
 */
 
/*
 *  If moving vectors from flash to RAM, declare a reserved area for
 *  the RAM vector table.  This section should appear first, so it gets
 *  assigned to the first available SRAM address.  Due to requirements
 *  of the NVIC subsystem, this address MUST be on a 1024-byte
 *  boundary.
 */
	.RAMVectorTable :
	{
		*(.RAMVectorTable)
	}
	. = ALIGN(4);
	
			
  /*  From generic.ld, supplied by CodeSourcery  */
  /* .ARM.exidx is sorted, so has to go in its own output section.  */
	PROVIDE_HIDDEN (__exidx_start = .);
	.ARM.exidx :
	{
		*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	} >sram  
	PROVIDE_HIDDEN (__exidx_end = .);

	
/*	.data : AT (_end_data_flash)   */
	.data :
	{
		_start_data_flash = LOADADDR(.data);
		_start_data = .;
		*(.data)
		*(.data.*)
		*(.shdata)
		_end_data = .;
	} >sram  AT>flash
	. = ALIGN(4);
	_data_size = _end_data - _start_data;

	.noinit :
	{
		*(.noinit)
		*(.noinit.*)
	} >sram
	
	_start_bss = .;
	.bss :
	{
		*(.bss)
		*(.bss.*)
		*(COMMON)
	} >sram
	. = ALIGN(4);
	_end_bss = .;

	bss_size = _end_bss - _start_bss;


	/* Stack can grow down to here, right after data and bss sections in 
	 * SRAM */
	_start_stack = _top_stack - TOTAL_RESERVED_STACK;
	_top_stack = _top_stack;			/* just to make the map file easier to read */

	/* Linker wants .eh_frame section defined because of gcc 4.4.X bug,
	 * just discard it here. */
	/DISCARD/ :
	{
		*(.eh_*)
	}
	
/*  --------- Declare RAM sections in AHB0 SRAM block ----------- */
	.ahbsram0 :
	{
		*(.ahrbsram0)
	} >ahbsram0
	. = ALIGN(4);
	
/*  --------- Declare RAM sections in AHB1 SRAM block ----------- */
	.ahbsram1 :
	{
		*(.ahrbsram1)
	} >ahbsram1
	. = ALIGN(4);
		
}

_end = .;
PROVIDE(end = .);

