//#define DEBUGPOT 
//#define DEBUGPOT2
#include <stdlib.h>
#include <math.h>  
float DTetaMin=0.02;
int InitPot(struct MyPot *pot,int left,int top,int size,UINT min,UINT max,UINT cur,HDC hdc,HANDLE hInst);
void RedrawPot(RECT *rect,struct MyPot *Pot,PAINTSTRUCT *ps,HDC hDC);
int InPot(struct MyPot *pot,POINT *pt);
int MovePot(struct MyPot *pot,POINT *pt,HWND hwnd);

int InitPot2(struct MyPot *pot,int left,int top,int CenterX,int CenterY,int Radius,UINT min,UINT max,UINT cur,float minTeta,float maxTeta,HDC hdc,HANDLE hInst,RECT *fra);
int InPot2(struct MyPot *pot,POINT *pt);
int MovePot2(struct MyPot *pot,POINT *pt,HWND hwnd);
float CenterAngle(float newAngle);
float Val2Angle(int val,UINT minVal,UINT maxVal,float minAngle,float maxAngle);
float Pos2Angle(int x, int y);
void Angle2Border(float angle,struct MyPot *pot);
void SkatePot(float Angle,struct MyPot *pot);
UINT Angle2Val(float Angle,float minAngle,float maxAngle,UINT minVal,UINT maxVal);
int Rad2Deg(float Angle);
float Deg2Angle(int Angle);
void RedrawPotCur(RECT *rect,struct MyPot *Pot,PAINTSTRUCT *ps,HDC *hDC);
float BetweenStop(float NewTeta,int dTeta,struct MyPot *pot);
int SetPotVal(struct MyPot *pot,UINT value,HWND hWnd);
int ReleasePot(struct MyPot *pot,HWND hwnd);
int MovePot3(struct MyPot *pot,POINT *pt,HWND hwnd);
float Val2Angle2(int val,UINT minVal,UINT maxVal,float minAngle,float maxAngle);
float ContinuAngle(float oldangle, float newangle);
int MovePot4(struct MyPot *pot,POINT *pt,HWND hwnd);
void IncCross(float newangle,struct MyPot *pot);
//*****************************************************
//InitPot(&Sly[2],50,50,100,0,100, 50,hDC,hInst);
int InitPot(struct MyPot *pot,int left,int top,int size,UINT min,UINT max,UINT cur,HDC hdc,HANDLE hInst)
{
int potheight,potwidth;
HBITMAP hBmp;
UINT run;
float pos;
float step;
float PotOffset;
float curAngle;
BITMAP Bm;
pot->GlobRect.left=left;
pot->GlobRect.top=top;
pot->bSel=FALSE;
pot->min=min;
pot->max=max;
if (cur < min )
	cur=min;
if (cur > max)
	cur=max;
pot->curt=cur;
run=max-min;
if (run==0)
	return 0;
	
	pot->hDC = CreateCompatibleDC(hdc);
	hBmp=LoadBitmap(hInst,(LPCSTR)IDB_POT);
	SelectObject(pot->hDC,hBmp);
    GetObject(hBmp,sizeof(BITMAP),&Bm);
	DeleteObject(hBmp);
	potwidth=Bm.bmWidth;
	potheight=Bm.bmHeight;
	pot->GlobRect.bottom=pot->GlobRect.top+potheight;
	pot->GlobRect.right=pot->GlobRect.left+potwidth;
	pot->Center.x=(pot->GlobRect.right+pot->GlobRect.left)/2;
	pot->Center.y=(pot->GlobRect.bottom+pot->GlobRect.top)/2;
	pot->Radius=(pot->GlobRect.right-pot->GlobRect.left)/2;
	PotOffset=360-(maxAngle-minAngle);
	step=(float)(maxAngle-minAngle)/(float)run;
    curAngle=step*(float)(cur)-PotOffset;
	curAngle=(float)(6.283185)*curAngle/360;
	step=(float)(pot->Radius)*curAngle;
	pos=(float)(pot->Center.x) + (float)(pot->Radius)*cos(step) + (float)0.5;
	pot->Border.x=(int)pos;
	pos=(float)(pot->Center.y) + (float)(pot->Radius)*sin(step) + (float)0.5;
	pot->Border.y=(int)pos;
	return(1);
}
//*************************************************************
void RedrawPot(RECT *rect,struct MyPot *Pot,PAINTSTRUCT *ps,HDC hDC)
{
int i;
HDC hdc;
HBITMAP hBmp;

if((IntersectRect(rect, &(Pot->GlobRect), &(ps->rcPaint)))&&(Pot->visible))
	{
	hBmp=LoadBitmap(hInst,(MAKEINTRESOURCE(Pot->bmp)));
	hdc = CreateCompatibleDC(hDC);
	SelectObject(hdc,hBmp);
	i=BitBlt(hDC,Pot->GlobRect.left,Pot->GlobRect.top,Pot->GlobRect.right-Pot->GlobRect.left,Pot->GlobRect.bottom-Pot->GlobRect.top,hdc,0,0,SRCCOPY);  
	i=DeleteDC(hdc);	
	i=DeleteObject(hBmp);
	MoveToEx(hDC,Pot->Center.x,Pot->Center.y,NULL);
	LineTo(hDC,Pot->Border.x,Pot->Border.y);
		
	}
}
void RedrawPotCur(RECT *rect,struct MyPot *Pot,PAINTSTRUCT *ps,HDC *hDC,struct MyFrame *fra)
{
if( Pot->bSel)
	{
	
	//	BitBlt(*hDC,Pot->GlobRect.left,Pot->GlobRect.top,Pot->GlobRect.right-Pot->GlobRect.left,Pot->GlobRect.bottom-Pot->GlobRect.top,Pot->hDC,0,0,SRCCOPY);  
		MoveToEx(*hDC,Pot->Center.x,Pot->Center.y,NULL);
		LineTo(*hDC,Pot->Border.x,Pot->Border.y);
		
	}
}

//*****************************************************
int InPot(struct MyPot *pot,POINT *pt)
{
/*
float pos;
float step;
float PotOffset;
float curAngle,newAngle;
int relX,relY,relRadius;
char ftxt[10];
	
if (pt->x < pot->GlobRect.left)
	return 0;
if (pt->x > pot->GlobRect.right)
	return 0;
if (pt->y < pot->GlobRect.top)
	return 0;
if (pt->y > pot->GlobRect.bottom)
	return 0;
#ifdef DEBUGPOT
		wsprintf((LPSTR)txt,"click point ( x = %d ,y = %d )\n\r",pt->x,pt->y);
		OutputDebugString((LPSTR)txt);
#endif
relX=(pt->x)-(pot->Center.x);
relY=(pot->Center.y)-(pt->y);//remember that y axis is up side down on computers!!!!
#ifdef DEBUGPOT
		wsprintf((LPSTR)txt,"click point ( X = %d ,Y = %d )\n\r",relX,relY);
		OutputDebugString((LPSTR)txt);
#endif
if ((relX==0)&&(relY==0)) //clicked point is center of Pot !!! exit 
	return 0;
if(relX==0)
	{
	if(relY>0)
		newAngle=90;
	else
		newAngle=270;
	newAngle=(float)(6.283185)*newAngle/360;
	}
else
	{
	newAngle=(float)atan2((double)relY,(double)relX);	
	}

#ifdef DEBUGPOT
		gcvt((double)newAngle,6,ftxt);
		wsprintf((LPSTR)txt,"ClPt OffsetAngle %s\n\r",(LPSTR)ftxt);
		OutputDebugString((LPSTR)txt);
#endif


pot->OffsetAngle=newAngle;

pot->bSel=TRUE; -*/
return 1; 
}
//*****************************************************
int MovePot(struct MyPot *pot,POINT *pt,HWND hwnd)
{
UINT run;
float pos;
float step;
float PotOffset;
float curAngle,newAngle,deltaAngle;
float maxRad,minRad;
int relX,relY;
float nwval;
float TwoPi;
#ifdef DEBUGPOT
	char ftxt[10];
#endif	

TwoPi=2*PI;
#ifdef DEBUGPOT
		wsprintf((LPSTR)txt,"Move point ( x = %d ,y = %d )\n\r",pt->x,pt->y);
		OutputDebugString((LPSTR)txt);
#endif
maxRad=(float)(maxAngle-60)*TwoPi/360;
minRad=(float)(minAngle+300)*TwoPi/360;

run=(pot->max)-(pot->min);
PotOffset=360-(maxAngle-minAngle);
step=(float)(maxAngle-minAngle)/(float)run;
curAngle=step*(float)(pot->curt)-PotOffset;
curAngle=TwoPi*curAngle/360;

relX=(pt->x)-(pot->Center.x);
relY=(pot->Center.y)-(pt->y);
#ifdef DEBUGPOT
		wsprintf((LPSTR)txt,"Move point ( X = %d ,Y = %d )\n\r",relX,relY);
		OutputDebugString((LPSTR)txt);
#endif
if ((relX==0)&&(relY==0)) //clicked point is center of Pot !!! exit 
	return 0;
if(relX==0)
	{
	if(relY>0)
		newAngle=90;
	else
		newAngle=270;
	newAngle=(float)(6.283185)*newAngle/360;
	}
else
	{
	newAngle=(float)atan2((double)relY,(double)relX);	
	}

deltaAngle=newAngle-pot->OffsetAngle;
newAngle=curAngle + deltaAngle;
newAngle=CenterAngle(newAngle);


//Stop values handling
if((newAngle>(3*PI/2))&&(newAngle<minRad))
	newAngle=minRad;
if((newAngle<(3*PI/2))&&(newAngle>maxRad))
	newAngle=maxRad;

pos=(float)(pot->Center.x) + (float)(pot->Radius)*cos(newAngle) + (float)0.5;
	pot->Border.x=(int)pos;
	pos=(float)(pot->Center.y) - (float)(pot->Radius)*sin(newAngle) + (float)0.5;
	pot->Border.y=(int)pos;
pot->OffsetAngle=newAngle;
#ifdef DEBUGPOT
		gcvt((double)newAngle,6,ftxt);
		wsprintf((LPSTR)txt,"MvPt OffsetAngle %s\n\r",(LPSTR)ftxt);
		OutputDebugString((LPSTR)txt);
#endif
// convert rad to degree
newAngle=360*newAngle/TwoPi;//TwoPi or not TwoPi that is the kestion !!
newAngle=(newAngle+PotOffset)/(float)step;

nwval=newAngle;

pot->curt=(UINT)nwval; //no no don't update pot->curt here !!!
InvalidateRect(hwnd,&pot->GlobRect,TRUE);

	#ifdef DEBUGPOT
		wsprintf((LPSTR)txt,"nwval= %d \n",(UINT)nwval);
		OutputDebugString((LPSTR)txt);
	#endif	

return((unsigned int)nwval);
}

/****************************************************************/
float CenterAngle(float newAngle)
{

float TwoPi;
TwoPi=(float)2*(float)PI;

if ((newAngle>=0) && (newAngle<=TwoPi))
	return(newAngle);

while(newAngle<0) 
	newAngle+= TwoPi;

while(newAngle>TwoPi)
	newAngle-= TwoPi;

return(newAngle);
}
//*****************************************************
float Val2Angle(UINT val,UINT minVal,UINT maxVal,float minAngle,float maxAngle)
{
UINT valRange;
float angleRange;
float Angle;
valRange=maxVal-minVal;
angleRange=maxAngle-minAngle;
if (valRange ==0)
	return((float)0);
Angle=((float)val * angleRange)/(float)valRange;
return(Angle);
}
//*****************************************************
float Pos2Angle(int x, int y)
{
float Angle;

if ((x==0)&&(y==0)) 
	return ((float)0);
if(x==0)
	{
	if(y>0)
		Angle=(float)PI/2;
	else
		Angle=3*(float)PI/2;	
	}
else
	{
	Angle=(float)atan2((double)y,(double)x);	
	}
if((Angle<0.1)&&(Angle>(-0.1)))
	Angle=0;
return(Angle);	
}
//*****************************************************
void Angle2Border(float Angle,struct MyPot *pot)
{
	float Temp;
	Temp = (float)cos(Angle);
	Temp*=(float)(pot->Radius);
	Temp+=(float)(pot->Center.x) + (float)0.5;
	pot->Border.x=(int)Temp;
	Temp=(float)(pot->Center.y) - (float)(pot->Radius)*(float)sin(Angle) + (float)0.5;
	pot->Border.y=(int)Temp;
}
//*****************************************************
void SkatePot(float Angle,struct MyPot *pot)
{
	float Temp;
	float InputAngle,DeadAngle;
	#ifdef DEBUGPOT
		char ftxt[10],txt[50];
	#endif	
	DeadAngle=(2*(float)PI)-pot->maxAngle+pot->minAngle;
	InputAngle=Angle+DeadAngle/2;
	Temp= (float)(pot->Radius)*(float)cos(InputAngle) + (float)0.5;
	pot->Click.x=(int)Temp;
	Temp=(float)(pot->Radius)*(float)sin(InputAngle) + (float)0.5;

	pot->Click.y=(int)Temp;
	#ifdef DEBUGPOT
		gcvt((double)InputAngle,6,ftxt);		
		wsprintf((LPSTR)txt, "NewClickTeta= %s \n",(LPSTR)ftxt );
		OutputDebugString((LPSTR)txt);
	    wsprintf((LPSTR)txt, "NewClick= M( %d , %d )\n",pot->Click.x,pot->Click.y);
		OutputDebugString((LPSTR)txt);
	
	#endif	
}
//*****************************************************
UINT Angle2Val(float Angle,float minAngle,float maxAngle,UINT minVal,UINT maxVal)
{
	UINT valRange;
	float angleRange;
	float Temp;
	valRange=maxVal-minVal;
	angleRange=maxAngle-minAngle;

	if (angleRange ==0)
		return(0);
	Temp=(((float)valRange * Angle) / angleRange) + (float)0.5;
	return((UINT)Temp);
}
//*****************************************************
int Rad2Deg(float Angle)
{
	float Temp;
	Temp=(((float)180*Angle)/(float)PI)+(float)0.5;
	return((int)Temp);
}
//*****************************************************
float Deg2Angle(int Angle)
{
	float Temp;
	Temp=(((float)Angle)*(float)PI)/(float)180;
	return(Temp);
}
//*****************************************************
int InPot2(struct MyPot *pot,POINT *pt)
{
float newAngle;
int relX,relY;
#ifdef DEBUGPOT
	char ftxt[10];
#endif	
if (!pot->visible)
	return 0;
	
if (pt->x < pot->GlobRect.left)
	return 0;
if (pt->x > pot->GlobRect.right)
	return 0;
if (pt->y < pot->GlobRect.top)
	return 0;
if (pt->y > pot->GlobRect.bottom)
	return 0;

relX=(pt->x)-(pot->Center.x);
relY=(pot->Center.y)-(pt->y);//remember that y axis is up side down on computers!!!!
#ifdef DEBUGPOT
	wsprintf((LPSTR)txt,"ClkPt2 m(%d ,%d ) M(%d ,%d )\n\r",pt->x,pt->y,relX,relY);
	OutputDebugString((LPSTR)txt);
#endif

newAngle=Pos2Angle(relX,relY);

#ifdef DEBUGPOT
		gcvt((double)newAngle,6,ftxt);
		wsprintf((LPSTR)txt,"ClkPt2 OffsetAngle %s\n\r",(LPSTR)ftxt);
		OutputDebugString((LPSTR)txt);
#endif

//memorize some useful data
pot->Click.x=relX;
pot->Click.y=relY;
pot->ClickVal=(pot->max - pot->min)-pot->curt;
newAngle=CenterAngle(newAngle);
pot->curAngle=newAngle;
pot->bSel=TRUE;
return 1;
}

//*****************************************************
int MovePot2(struct MyPot *pot,POINT *pt,HWND hwnd)
{
/*
float StartTeta,NewTeta,dTeta,MoveTeta,ClickTeta;
UINT nwVal;
int relX,relY;
int dVal;

relX=(pt->x)-(pot->Center.x);
relY=(pot->Center.y)-(pt->y);//remember that y axis is up side down on computers!!!!
if((relX==pot->Click.x)&&(relY==pot->Click.y))
	return(pot->curt);
#ifdef DEBUGPOT
	wsprintf((LPSTR)txt,"MovPt2 m(%d ,%d) M(%d,%d)\n\r",pt->x,pt->y,relX,relY);
	OutputDebugString((LPSTR)txt);
#endif

ClickTeta = Pos2Angle(pot->Click.x, pot->Click.y);
MoveTeta = Pos2Angle(relX, relY);
dTeta = MoveTeta-ClickTeta;
StartTeta = Val2Angle(pot->ClickVal, pot->min, pot->max, pot->minAngle, pot->maxAngle);
NewTeta = StartTeta + dTeta;
dTeta=NewTeta-pot->curAngle;
NewTeta=CenterAngle(NewTeta);
nwVal = Angle2Val(NewTeta, pot->minAngle, pot->maxAngle, pot->min, pot->max);
dVal=nwVal;
NewTeta=BetweenStop(NewTeta,dVal,pot);//Check if NewTeta is between Min and Max

nwVal = Angle2Val(NewTeta, pot->minAngle, pot->maxAngle, pot->min, pot->max);
nwVal=( pot->max - pot->min ) - nwVal;
pot->curt=nwVal;
pot->curAngle=NewTeta;
NewTeta-=pot->OffsetAngle;
Angle2Border(NewTeta, pot);

InvalidateRect(hwnd, &pot->GlobRect, TRUE);

	#ifdef DEBUGPOT
		wsprintf((LPSTR)txt, "nwval= %d \n", nwVal);
		OutputDebugString((LPSTR)txt);
	#endif	

return(nwVal); */
}
//*****************************************************
int InitPot2(struct MyPot *pot,int left,int top,int CenterX,int CenterY,int Radius,UINT min,UINT max,UINT cur,float minTeta,float maxTeta,HDC hdc,HANDLE hInst,struct MyFrame *fra)
{
UINT potheight,potwidth;
HBITMAP hBmp;

//UINT UsefulSize;
UINT run;
//float pos;
//float step;
float PotOffset;
float curAngle;
BITMAP Bm;
if(fra==NULL)
{
	pot->GlobRect.left=left;
	pot->GlobRect.top=top;
	pot->visible=TRUE;
}
else
{
	pot->GlobRect.left=left+fra->left+1;
	pot->GlobRect.top=top+fra->top+1;
	pot->visible=fra->visible;
} 
pot->bSel=FALSE;
pot->min=min;
pot->max=max;
pot->minAngle=minTeta;
pot->maxAngle=maxTeta;

if (cur < min )
	cur=min;
if (cur > max)
	cur=max;

run=max-min;
cur=run-cur;
pot->curt=cur;
pot->bmp=(LPCSTR)IDB_POT;

if (run==0)
	return 0;
	
	//pot->hDC = CreateCompatibleDC(hdc);
	hBmp=LoadBitmap(hInst,(LPCSTR)IDB_POT);
	//SelectObject(pot->hDC,hBmp);
    GetObject(hBmp,sizeof(BITMAP),&Bm);
	DeleteObject(hBmp);
	potwidth=Bm.bmWidth;
	potheight=Bm.bmHeight;
	pot->GlobRect.bottom=pot->GlobRect.top+potheight;
	pot->GlobRect.right=pot->GlobRect.left+potwidth;
	pot->Center.x=pot->GlobRect.left+CenterX;
	pot->Center.y=pot->GlobRect.top+CenterY;
	pot->Radius=Radius;

	PotOffset=2*(float)PI-(pot->maxAngle-pot->minAngle);
	pot->OffsetAngle=PotOffset;
	curAngle=Val2Angle(cur, pot->min, pot->max, pot->minAngle, pot->maxAngle);
	curAngle-=pot->OffsetAngle;
	Angle2Border(curAngle,pot);
	return(1);
}
//*********************************************
int SetPotVal(struct MyPot *pot,UINT value,HWND hWnd)
{
	float PotOffset;
	float curAngle;
	 
	value=pot->max - pot->min - value;
	pot->curt=value;
	//PotOffset=2*(float)PI-(pot->maxAngle-pot->minAngle);
	//pot->OffsetAngle=PotOffset;
	curAngle=Val2Angle(value, pot->min, pot->max, pot->minAngle, pot->maxAngle);
	curAngle-=pot->OffsetAngle;
	Angle2Border(curAngle,pot);
	InvalidateRect(hWnd,&pot->GlobRect,TRUE);
return(value);
}

//*********************************************
float BetweenStop(float NewTeta,int dVal,struct MyPot *pot)
{
	float fstop;
	int stop;
	int middle;
	int totest;
	totest=(pot->max - pot->min)-pot->curt;

	middle=(pot->max + pot->min)/2;
	fstop=2*PI*((float)pot->max - (float)pot->min)/(pot->maxAngle - pot->minAngle) + (float)0.5;
	stop=((int)fstop + pot->max)/2;

	if((totest<middle)&&(dVal<=(int)fstop)&&(dVal>pot->max))
		return(pot->minAngle);	
	else if((totest>middle)&&(dVal<=(int)fstop)&&(dVal>pot->max))
		return(pot->maxAngle);	
	else
		return(NewTeta);
}
//************************************************
//***********************************************************
int ReleasePot(struct MyPot *pot,HWND hwnd)
{
//	DeleteDC(pot->hDC);
	return(1);
}

//*****************************************************
int MovePot3(struct MyPot *pot,POINT *pt,HWND hwnd)
{
/*
float StartTeta,NewTeta,dTeta,MoveTeta,ClickTeta,TetaInc;
UINT nwVal,calcval;
int relX,relY,dX,dY;
int dVal;
float valinc,deltaVal;
long tmpVal;
#ifdef DEBUGPOT
char ftxt[10];	
#endif


relX=(pt->x)-(pot->Center.x);
relY=(pot->Center.y)-(pt->y);//remember that y axis is up side down on computers!!!!
if((relX==pot->Click.x)&&(relY==pot->Click.y))
	return(pot->curt);
	
ClickTeta = Pos2Angle(pot->Click.x, pot->Click.y);
ClickTeta = CenterAngle(ClickTeta);
 
			#ifdef DEBUGPOT
				gcvt((double)ClickTeta,6,ftxt);		
				wsprintf((LPSTR)txt, "ClickTeta= %s \n",(LPSTR)ftxt );
				OutputDebugString((LPSTR)txt);
			#endif
	                                           	
MoveTeta = Pos2Angle(relX, relY);
MoveTeta = CenterAngle(MoveTeta);

			#ifdef DEBUGPOT
				gcvt((double)MoveTeta,6,ftxt); 
				wsprintf((LPSTR)txt, "MoveTeta= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
			#endif
MoveTeta=ContinuAngle(pot->curAngle,MoveTeta,pot->dec);			   

			#ifdef DEBUGPOT
				gcvt((double)MoveTeta,6,ftxt); 
				wsprintf((LPSTR)txt, "MoveTeta= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
				gcvt((double)pot->curAngle,6,ftxt); 
				wsprintf((LPSTR)txt, "OldAngle= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
			#endif                        
if((pot->curAngle*MoveTeta)<0)
	TetaInc=MoveTeta-pot->curAngle;
else
	TetaInc=pot->curAngle-MoveTeta;
if (TetaInc>0)
	pot->dec=0;
else if (TetaInc<0)
	pot->dec=1;

pot->curAngle=MoveTeta;

if((pot->skatemin==1)&&(pot->dec==1))
	{
	
	#ifdef DEBUGPOT
		OutputDebugString((LPSTR)"skatemin\n\r");
	#endif
	pot->ClickVal=pot->min;
	pot->Click.x=relX;
	pot->Click.y=relY; 
	return(pot->min);
	}
if((pot->skatemax==1)&&(pot->dec==1))
	{
	
	#ifdef DEBUGPOT
		OutputDebugString((LPSTR)"skatemax\n\r");
	#endif
	pot->ClickVal=pot->max;
	pot->Click.x=relX;
	pot->Click.y=relY;  
	return(pot->max);
	}


dTeta=ClickTeta-MoveTeta;



			#ifdef DEBUGPOT2
					wsprintf((LPSTR)txt, "dec= %d \n", pot->dec);
					OutputDebugString((LPSTR)txt);
			#endif
			
			#ifdef DEBUGPOT
					gcvt((double)dTeta,6,ftxt); 
					wsprintf((LPSTR)txt, "dTeta= %s \n",(LPSTR)ftxt);
					OutputDebugString((LPSTR)txt);
			#endif   
valinc=((float)(pot->max-pot->min))/((float)(pot->maxAngle-pot->minAngle));
deltaVal=valinc*dTeta;
tmpVal=(long)pot->ClickVal+(long)deltaVal;
			#ifdef DEBUGPOT
					wsprintf((LPSTR)txt, "tmpVal= %d \n", tmpVal);
					OutputDebugString((LPSTR)txt);
			#endif

if(tmpVal>(long)pot->max)
	{
	#ifdef DEBUGPOT
		OutputDebugString((LPSTR)"max\n\r");
	#endif
	pot->skatemax=1;
	pot->ClickVal=pot->max;
	return(pot->max);
	}
if(tmpVal<(long)pot->min)
	{
	
	#ifdef DEBUGPOT
		OutputDebugString((LPSTR)"min\n\r");
	#endif
	pot->ClickVal=pot->min;
	pot->skatemin=1; 
	return(pot->min);
	}
pot->skatemin=0;
pot->skatemax=0;
tmpVal=max(tmpVal,(long)pot->min);
tmpVal=min(tmpVal,(long)pot->max);
nwVal=(UINT)tmpVal;
calcval=(pot->max-pot->min)-nwVal;
#ifdef DEBUGPOT
		wsprintf((LPSTR)txt, "nwVal= %d \n", nwVal);
		OutputDebugString((LPSTR)txt);
#endif
NewTeta=Val2Angle(calcval,pot->min,pot->max,pot->minAngle,pot->maxAngle);
NewTeta-=pot->OffsetAngle;
Angle2Border(NewTeta, pot);

#ifdef DEBUGPOT
	wsprintf((LPSTR)txt,"MovPt3 	B(%d ,%d)\n\r",pot->Border.x,pot->Border.y);
	OutputDebugString((LPSTR)txt);
#endif
InvalidateRect(hwnd, &pot->GlobRect, TRUE);

	

return(nwVal);*/
}

//*****************************************************
float Val2Angle2(UINT val,UINT minVal,UINT maxVal,float minAngle,float maxAngle)
{
UINT valRange;
float angleRange;
float Angle;
valRange=maxVal-minVal;
angleRange=maxAngle-minAngle;
if (valRange ==0)
	return((float)0);
Angle=minAngle+((float)val * angleRange)/(float)valRange;
return(Angle);
}
/*********************************************************/
float ContinuAngle(float oldangle, float newangle,int dec)
{			   

if(dec==0)
	{
	while(oldangle<newangle)
		newangle-=2*(float)PI;	
	}
else 
	{
	while(oldangle>newangle)
		newangle+=2*(float)PI;	
	
	}
/*
if((oldangle>=0)&&(newangle>1.5*(float)PI)&&(dec==0))
	{
	newangle-=2*(float)PI;	
	}
else if((oldangle>1.5*(float)PI)&&(newangle>=0)&&(dec==1))
	{
	newangle+=2*(float)PI;
	}
else
	return(newangle); */
return(newangle);
}
/*********************************************************/
void IncCross(float newangle,struct MyPot *pot)
{			   
float OldTeta ;
OldTeta = CenterAngle(pot->curAngle);
if((OldTeta<(0.5*(float)PI))&&(newangle>1.5*(float)PI)&&(pot->zerocross==0))//&&(pot->dec==0))
	{
	pot->zerocross=-1;
	#ifdef DEBUGPOT				
				wsprintf((LPSTR)txt, "   ZeroX= %d \n",pot->zerocross);
				OutputDebugString((LPSTR)txt);
	#endif	
	}
else if((OldTeta>1.5*(float)PI)&&(newangle<(0.5*(float)PI))&&(pot->zerocross==0))//&&(pot->dec==1))
	{
	pot->zerocross=+1;
	#ifdef DEBUGPOT				
				wsprintf((LPSTR)txt, "   ZeroX= %d \n",pot->zerocross);
				OutputDebugString((LPSTR)txt);
	#endif
	}
else
	{
	pot->zerocross=0;
	#ifdef DEBUGPOT				
				wsprintf((LPSTR)txt, "   ZeroX= %d \n",pot->zerocross);
				OutputDebugString((LPSTR)txt);
	#endif
	}
}
//*****************************************************
int MovePot4(struct MyPot *pot,POINT *pt,HWND hwnd)
{
float NewTeta,MoveTeta,ClickTeta,TetaInc;
UINT nwVal,calcval;
int relX,relY;
//int dVal,dX,dY;
//float dTeta,StartTeta;
unsigned int curVal;
float valinc,deltaVal;
long tmpVal;
#ifdef DEBUGPOT
char ftxt[10];	
#endif
#ifdef DEBUGPOT
	OutputDebugString((LPSTR)"*******MovePot");
#endif
curVal=(pot->max - pot->min)-pot->curt;
valinc=((float)(pot->max - pot->min)/(float)128)+(float)0.5;
valinc=(unsigned int)valinc;
relX=(pt->x)-(pot->Center.x);
relY=(pot->Center.y)-(pt->y);//remember that y axis is up side down on computers!!!!
if((relX==pot->Click.x)&&(relY==pot->Click.y))
	return(curVal);
	
ClickTeta = Pos2Angle(pot->Click.x, pot->Click.y);
ClickTeta = CenterAngle(ClickTeta);
 
			#ifdef DEBUGPOT
				gcvt((double)ClickTeta,6,ftxt);		
				wsprintf((LPSTR)txt, "ClickTeta= %s \n",(LPSTR)ftxt );
				OutputDebugString((LPSTR)txt);
			#endif
	                                           	
MoveTeta = Pos2Angle(relX, relY);
MoveTeta = CenterAngle(MoveTeta);

			#ifdef DEBUGPOT
				gcvt((double)MoveTeta,6,ftxt); 
				wsprintf((LPSTR)txt, "MoveTeta= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
			#endif
			#ifdef DEBUGPOT
				gcvt((double)pot->curAngle,6,ftxt); 
				wsprintf((LPSTR)txt, "OldAngle= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
			#endif

IncCross( MoveTeta,pot);			   
            /*
			#ifdef DEBUGPOT
				gcvt((double)MoveTeta,6,ftxt); 
				wsprintf((LPSTR)txt, "NewTeta= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
				gcvt((double)pot->curAngle,6,ftxt); 
				wsprintf((LPSTR)txt, "OldAngle= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
			#endif*/                        
if(pot->curAngle==MoveTeta)
	{
	#ifdef DEBUGPOT				
				OutputDebugString((LPSTR)"equal");
			#endif
	goto skip;
	}
switch(pot->zerocross)
{
	case -1:
		TetaInc=pot->curAngle-MoveTeta+2*(float)PI;	
		break;
	case 1:
		TetaInc=pot->curAngle-MoveTeta-2*(float)PI;	
		break;
	case 0:
		TetaInc=pot->curAngle-MoveTeta;	
		break;
}
	
if (TetaInc>DTetaMin)
	{
	pot->dec=1;
	valinc=((float)(pot->max-pot->min))/((float)(pot->maxAngle-pot->minAngle));
	deltaVal=valinc*TetaInc;
	valinc=(unsigned int)deltaVal;
	}
else if (TetaInc<(-DTetaMin))
	{
	pot->dec=-1;
	valinc=((float)(pot->max-pot->min))/((float)(pot->maxAngle-pot->minAngle));
	deltaVal=-valinc*TetaInc;
	valinc=(unsigned int)deltaVal;
    }
			#ifdef DEBUGPOT2
					wsprintf((LPSTR)txt, "dec= %d \n", pot->dec);
					OutputDebugString((LPSTR)txt);
			#endif
pot->curAngle=MoveTeta;
/*
MoveTeta=ContinuAngle(pot->curAngle,MoveTeta,pot->dec);
			#ifdef DEBUGPOT
				gcvt((double)MoveTeta,6,ftxt); 
				wsprintf((LPSTR)txt, "MoveTeta= %s \n",(LPSTR)ftxt);
				OutputDebugString((LPSTR)txt);
			#endif
//*******************
pot->curAngle=MoveTeta;
dTeta=ClickTeta-MoveTeta;			
			#ifdef DEBUGPOT
					gcvt((double)dTeta,6,ftxt); 
					wsprintf((LPSTR)txt, "dTeta= %s \n",(LPSTR)ftxt);
					OutputDebugString((LPSTR)txt);
			#endif   
valinc=((float)(pot->max-pot->min))/((float)(pot->maxAngle-pot->minAngle));
deltaVal=valinc*dTeta; */
deltaVal=(float)pot->dec * valinc;
tmpVal=(long)curVal+(long)deltaVal;
			#ifdef DEBUGPOT
					wsprintf((LPSTR)txt, "tmpVal= %d \n", tmpVal);
					OutputDebugString((LPSTR)txt);
			#endif

if(tmpVal>(long)pot->max)
	{
	#ifdef DEBUGPOT
		OutputDebugString((LPSTR)"max\n\r");
	#endif
	//pot->curt=pot->max;
	nwVal=pot->max;
	goto displayPot;
	}
if(tmpVal<(long)pot->min)
	{
	
	#ifdef DEBUGPOT
		OutputDebugString((LPSTR)"min\n\r");
	#endif
	//pot->ClickVal=pot->min;
	nwVal=pot->min;
	goto displayPot;
	}
/*	
tmpVal=max(tmpVal,(long)pot->min);
tmpVal=min(tmpVal,(long)pot->max); */
nwVal=(UINT)tmpVal;

displayPot:
calcval=(pot->max-pot->min)-nwVal;
pot->curt=calcval;
#ifdef DEBUGPOT
		wsprintf((LPSTR)txt, "nwVal= %d \n", nwVal);
		OutputDebugString((LPSTR)txt);
#endif
NewTeta=Val2Angle(calcval,pot->min,pot->max,pot->minAngle,pot->maxAngle);
NewTeta-=pot->OffsetAngle;
Angle2Border(NewTeta, pot);
/*
#ifdef DEBUGPOT
	wsprintf((LPSTR)txt,"MovPt3 	B(%d ,%d)\n\r",pot->Border.x,pot->Border.y);
	OutputDebugString((LPSTR)txt);
#endif  */
InvalidateRect(hwnd, &pot->GlobRect, TRUE);

	
	
	
//	pot->curAngle=MoveTeta;
skip:

return(nwVal);
}

//*****************************************************
