int InitSlider(struct MySlider *sly,int left,int top,int size,int orient,unsigned int min,unsigned int max,unsigned int cur,HDC hdc,HANDLE hInst);
int InitSlider2(struct MySlider *sly,int left,int top,int slot,int size,int orient,UINT min,UINT max,UINT cur,LPCSTR fly,LPCSTR back,HDC hdc,HANDLE hInst,RECT *fra);

void RedrawSlider(RECT *rect,struct MySlider *Sly,PAINTSTRUCT *ps,HDC hDC);
int SetSliderVal(struct MySlider *sly,UINT value,HWND hWnd);
int InSlider(struct MySlider *sly,POINT *pt);
int MoveSlider(struct MySlider *sly,POINT *pt,HWND hwnd);
int ReleaseSlider(struct MySlider *sly,HWND hwnd);

//*****************************************************
int InitSlider(struct MySlider *sly,int left,int top,int size,int orient,int min,int max,int cur,HDC hdc,HANDLE hInst,RECT *fra)
{
/*int slysize;
HBITMAP hBmp;

int UsefulSize;
int run;
float pos;
float step;
BITMAP Bm;

sly->GlobRect.left=left;
sly->GlobRect.top=top;
sly->orient=orient;
sly->bSel=FALSE;
sly->min=min;
sly->max=max;

if (cur < min )
	cur=min;
if (cur > max)
	cur=max;

sly->curt=cur;
run=max-min;
if (run==0)
	return 0;


if (orient == SB_VERT)
	{
	
	sly->hDC = CreateCompatibleDC(hdc);
	hBmp=LoadBitmap(hInst,(LPCSTR)IDB_VFLY);
	SelectObject(sly->hDC,hBmp);
    GetObject(hBmp,sizeof(BITMAP),&Bm);
	slysize=Bm.bmWidth;
	sly->GlobRect.bottom=sly->GlobRect.top+size;
	sly->GlobRect.right=sly->GlobRect.left+slysize;
	UsefulSize=size-Bm.bmHeight;
	sly->FlyRect.left=left;   
	sly->FlyRect.right=sly->FlyRect.left+Bm.bmWidth;

	step=(float)UsefulSize/(float)run;    
	pos=step*(float)(run-cur);
	sly->FlyRect.top=sly->GlobRect.top+(int)pos;
	sly->FlyRect.bottom=sly->FlyRect.top+Bm.bmHeight;
	
	
	return(1);
	}
else
	{
	
	sly->hDC = CreateCompatibleDC(hdc);
	hBmp=LoadBitmap(hInst,(LPCSTR)IDB_HFLY);
	SelectObject(sly->hDC,hBmp);
    GetObject(hBmp,sizeof(BITMAP),&Bm);
	slysize=Bm.bmHeight;
	sly->GlobRect.right=sly->GlobRect.left+size;
	sly->GlobRect.bottom=sly->GlobRect.top+slysize;
	UsefulSize=size-Bm.bmWidth;
	sly->FlyRect.top=top;   
	sly->FlyRect.bottom=sly->FlyRect.top+Bm.bmHeight;
	
	step=(float)UsefulSize/(float)run;    
	pos=step*(float)cur;
	sly->FlyRect.left=sly->GlobRect.left+(int)pos;
	sly->FlyRect.right=sly->FlyRect.left+Bm.bmWidth;
	return(1);
	}
*/
}
//*****************************************************
int InitSlider2(struct MySlider *sly,int left,int top,int slot,int size,int orient,UINT min,UINT max,UINT cur,LPCSTR fly,LPCSTR back,HDC hdc,HANDLE hInst,struct MyFrame *fra)
{
int slysize;
HBITMAP hBmp;

int UsefulSize;
unsigned int run;
float pos;
float step;
BITMAP Bm;
if(fra==NULL)
{
	sly->GlobRect.left=left;
	sly->GlobRect.top=top;
	sly->visible=TRUE;
}
else
{
	sly->GlobRect.left=left+fra->left+1;
	sly->GlobRect.top=top+fra->top+1;
	sly->visible=fra->visible;
}
sly->orient=orient;
sly->bSel=FALSE;
sly->min=min;
sly->max=max;

if (cur < min )
	cur=min;
if (cur > max)
	cur=max;

sly->curt=cur;
run=max-min;
if (run==0)
	return 0;
sly->bmpfly=fly;
sly->bmpback=back;
//sly->hDCfly = CreateCompatibleDC(hdc);
//sly->hDCback = CreateCompatibleDC(hdc);
hBmp=LoadBitmap(hInst,(LPCSTR)(back));
//SelectObject(sly->hDCback,hBmp);
DeleteObject(hBmp);
hBmp=LoadBitmap(hInst,(LPCSTR)(fly));
//SelectObject(sly->hDCfly,hBmp);
GetObject(hBmp,sizeof(BITMAP),&Bm);
DeleteObject(hBmp);
if (orient == SB_VERT)
	{
	
	//sly->hDC = CreateCompatibleDC(hdc);
	//hBmp=LoadBitmap(hInst,(LPCSTR)IDB_VFLY);
	//SelectObject(sly->hDC,hBmp);
    //GetObject(hBmp,sizeof(BITMAP),&Bm);
	slysize=Bm.bmWidth;
	sly->GlobRect.bottom=sly->GlobRect.top+size;
	sly->GlobRect.right=sly->GlobRect.left+slot;
	UsefulSize=size-Bm.bmHeight;
	sly->FlyRect.left=sly->GlobRect.left+(slot-Bm.bmWidth)/2;   
	sly->FlyRect.right=sly->FlyRect.left+Bm.bmWidth;

	step=(float)UsefulSize/(float)run;    
	pos=step*(float)(run-cur);
	sly->FlyRect.top=sly->GlobRect.top+(int)pos;
	sly->FlyRect.bottom=sly->FlyRect.top+Bm.bmHeight;
	
	
	return(1);
	}
else
	{
	
	//sly->hDC = CreateCompatibleDC(hdc);
	//hBmp=LoadBitmap(hInst,(LPCSTR)IDB_HFLY);
	//SelectObject(sly->hDC,hBmp);
    //GetObject(hBmp,sizeof(BITMAP),&Bm);
	slysize=Bm.bmHeight;
	sly->GlobRect.right=sly->GlobRect.left+slot;
	sly->GlobRect.bottom=sly->GlobRect.top+slysize;
	UsefulSize=size-Bm.bmWidth;
	sly->FlyRect.top=sly->GlobRect.top+(slot-Bm.bmHeight)/2;   
	sly->FlyRect.bottom=sly->FlyRect.top+Bm.bmHeight;
	
	step=(float)UsefulSize/(float)run;    
	pos=step*(float)cur;
	sly->FlyRect.left=sly->GlobRect.left+(int)pos;
	sly->FlyRect.right=sly->FlyRect.left+Bm.bmWidth;
	return(1);
	}

}
//*************************************************************
void RedrawSlider(RECT *rect,struct MySlider *Sly,PAINTSTRUCT *ps,HDC hDC)
{
int i;
HDC hdcb,hdcf;
HBITMAP hBmpb,hBmpf;
if((IntersectRect(rect, &(Sly->GlobRect), &(ps->rcPaint)))&&(Sly->visible))
	{
	hdcb = CreateCompatibleDC(hDC);
	hBmpb=LoadBitmap(hInst,(MAKEINTRESOURCE(Sly->bmpback)));
	SelectObject(hdcb,hBmpb);
	
	hdcf = CreateCompatibleDC(hDC);
	hBmpf=LoadBitmap(hInst,(MAKEINTRESOURCE(Sly->bmpfly)));
	SelectObject(hdcf,hBmpf);
	
	i=BitBlt(hDC,Sly->GlobRect.left,Sly->GlobRect.top,Sly->GlobRect.right-Sly->GlobRect.left,Sly->GlobRect.bottom-Sly->GlobRect.top,hdcb,0,0,SRCCOPY);  
	
	
	
	i=BitBlt(hDC,Sly->FlyRect.left,Sly->FlyRect.top,Sly->FlyRect.right-Sly->FlyRect.left,Sly->FlyRect.bottom-Sly->FlyRect.top,hdcf,0,0,SRCCOPY);    
	i=DeleteDC(hdcb);	
	i=DeleteObject(hBmpb);
	i=DeleteDC(hdcf);	
	i=DeleteObject(hBmpf);
	
	}
else if ((IntersectRect(rect, &(Sly->FlyRect), &(ps->rcPaint)))&&(Sly->visible))
	{
	hdcf = CreateCompatibleDC(hDC);
	hBmpf=LoadBitmap(hInst,(MAKEINTRESOURCE(Sly->bmpfly)));
	SelectObject(hdcf,hBmpf);
	i=BitBlt(hDC,Sly->FlyRect.left,Sly->FlyRect.top,Sly->FlyRect.right-Sly->FlyRect.left,Sly->FlyRect.bottom-Sly->FlyRect.top,hdcf,0,0,SRCCOPY);    
	i=DeleteDC(hdcf);	
	i=DeleteObject(hBmpf);
		//BitBlt(*hDC,Sly->FlyRect.left,Sly->FlyRect.top,Sly->FlyRect.right-Sly->FlyRect.left,Sly->FlyRect.bottom-Sly->FlyRect.top,Sly->hDCfly,0,0,SRCCOPY);  
		}
	
}
//*****************************************************
int SetSliderVal(struct MySlider *sly,UINT value,HWND hWnd)
{
int slysize;
int UsefulSize;
unsigned int run;
float pos;
float step;

UINT min,max; 
int FlyDim;
InvalidateRect(hWnd,&sly->FlyRect,TRUE);
min=sly->min;
max=sly->max;
if (value <min)
	value=min;
if (value >max)
	value=max;
		
sly->curt=value;

run=max-min;


if (sly->orient == SB_VERT)
	{

	slysize=sly->GlobRect.right-sly->GlobRect.left;
	FlyDim=sly->FlyRect.bottom-sly->FlyRect.top;
	UsefulSize=sly->GlobRect.bottom-sly->GlobRect.top-FlyDim;
	step=(float)UsefulSize/(float)run;    
	pos=step*(float)(run-value);
	
	sly->FlyRect.top=sly->GlobRect.top+(int)pos;
	sly->FlyRect.bottom=sly->FlyRect.top+FlyDim; 
	//InvalidateRect(hWnd,&sly->GlobRect,TRUE);
	InvalidateRect(hWnd,&sly->FlyRect,TRUE);
	return(1);
	}
else
	{
	
	slysize=sly->GlobRect.bottom-sly->GlobRect.top;
	FlyDim=sly->FlyRect.right-sly->FlyRect.left;
	UsefulSize=sly->GlobRect.right-sly->GlobRect.left-FlyDim;
	step=(float)UsefulSize/(float)run;    
	pos=step*(float)value;
	
	sly->FlyRect.left=sly->GlobRect.left+(int)pos;
	sly->FlyRect.right=sly->FlyRect.left+FlyDim; 
	//InvalidateRect(hWnd,&sly->GlobRect,TRUE);
	InvalidateRect(hWnd,&sly->FlyRect,TRUE);
	return(1);
	
	}

}
//*****************************************************
int InSlider(struct MySlider *sly,POINT *pt)
{
if (!sly->visible)
	return 0;
if (pt->x < sly->FlyRect.left)
	return 0;
if (pt->x > sly->FlyRect.right)
	return 0;
if (pt->y < sly->FlyRect.top)
	return 0;
if (pt->y > sly->FlyRect.bottom)
	return 0;

sly->yOffset=pt->y-sly->FlyRect.top;
sly->xOffset=pt->x-sly->FlyRect.left;
sly->bSel=TRUE;
return 1;
}
//*****************************************************
int MoveSlider(struct MySlider *sly,POINT *pt,HWND hwnd)
{
int UsefulSize;
unsigned int run;
float pos;
float step;
float nwval;

int FlyHeight,FlyWidth;
int cux,cuy;
int xMov,yMov;
InvalidateRect(hwnd,&sly->FlyRect,TRUE);
run=sly->max-sly->min;
FlyHeight=sly->FlyRect.bottom-sly->FlyRect.top;	 
FlyWidth=sly->FlyRect.right-sly->FlyRect.left;
yMov=sly->FlyRect.top+sly->yOffset-pt->y;
cuy=sly->FlyRect.top-yMov;
xMov=sly->FlyRect.left+sly->xOffset-pt->x;
cux=sly->FlyRect.left-xMov;
if (sly->orient == SB_VERT)
	{
	if (cuy < sly->GlobRect.top)
		cuy = sly->GlobRect.top;
	else if (cuy > sly->GlobRect.bottom-FlyHeight)
		cuy = sly->GlobRect.bottom-FlyHeight;
		
	sly->FlyRect.top=cuy;
	sly->FlyRect.bottom=sly->FlyRect.top+FlyHeight;
	UsefulSize=sly->GlobRect.bottom-sly->GlobRect.top-FlyHeight;

	step=(float)UsefulSize/(float)run;
	pos=(float)(cuy-sly->GlobRect.top);		
	nwval=(run*pos)/UsefulSize;
	nwval=run-nwval;	
	
	}
else
	{
	if (cux < sly->GlobRect.left)
		cux = sly->GlobRect.left;
	else if (cux > sly->GlobRect.right-FlyWidth)
		cux = sly->GlobRect.right-FlyWidth;
				
	sly->FlyRect.left=cux;
	sly->FlyRect.right=sly->FlyRect.left+FlyWidth;
	UsefulSize=sly->GlobRect.right-sly->GlobRect.left-FlyWidth;
	
	step=(float)UsefulSize/(float)run;
	pos=(float)(cux-sly->GlobRect.left);		
	nwval=(run*pos)/UsefulSize;	
	}	 


//InvalidateRect(hwnd,&sly->GlobRect,TRUE);
InvalidateRect(hwnd,&sly->FlyRect,TRUE);
	#ifdef _DEBUG
		wsprintf((LPSTR)txt,"nwval= %d \n",(int)nwval);
		OutputDebugString((LPSTR)txt);
	#endif	

return((unsigned int)nwval);
}
//***********************************************************
int ReleaseSlider(struct MySlider *sly,HWND hwnd)
{
	DeleteDC(sly->hDCfly);
	DeleteDC(sly->hDCback);
	return(1);
}