#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include "dream94.h"
#include "dream.h"
#include <sys\types.h> 
#include <sys\stat.h> 
#include <string.h> 


LPVOID pVxDEntry=NULL;
extern MemBlDefTyp MemoryBlock[NbMemBlocks]; 
char LocalCopy[256];
struct _stat ParamInfo; 


DWORD MemMapAdd;

//	BOOL VAR for LoadFirmwareEx
BOOL MidiCaps=TRUE, WaveInCaps=TRUE, WaveOutCaps=TRUE, sbSaved=FALSE, WaveOut4=FALSE;


/***************************************************************
*
*	DWORD FAR PASCAL memAlloc(DWORD dwSize, WORD wType)
*                                      
*	dwSize : The size (in 16 bits Words) of the block to allocate
*			must be <64 kW
*			unless for	wType & 0xff =0x11 
*									(Sound Pcm, dwSize must be < 256 kWords)
*						wType & 0xff =0x30 (Static buffer, no limit)
*	dwType :	cf "SAM9407 Developers' Reference" 2 Firmware Structures -
*										  Memory Mapping Table
*
*	Return : Address of memory space allocated if succeed, 0 if failed
*
****************************************************************/

DWORD FAR PASCAL _loadds memAlloc(DWORD dwSize, WORD wType)
{
	DWORD Pointer;
	WORD  w1, w2;
	D1("memAlloc");
	if (((wType & 0xff)!=0x11) && ((wType & 0xff)!=0x30) && (dwSize>0x10000))
		return NULL;			// dwSize should be < 64kWords
	if (((wType & 0xff)==0x11) &&  (dwSize>0x40000))
		return NULL;			// dwSize should be < 256kWords
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	w1=(WORD) dwSize;
	w2=(WORD) (dwSize>>16);
	_asm
   {
	  mov	bx, w1			
	  mov	ax, w2
	  mov	cx, wType
      mov   dx, 0x100
      call  dword ptr pVxDEntry

	  jc    SHORT Failure
				// dx:ax=address returned
      mov   w1, dx
	  mov	w2, ax
	  jmp	Exitasm
   Failure:
      mov  w1, 0
	  mov  w2, 0
  Exitasm:
	  nop
   }
	Pointer=w2+(((DWORD) w1)<<16);
   return Pointer ;
}




/***************************************************************
*
*	WORD FAR PASCAL memFree(DWORD Address)
*                                      
*	dwAddress : Address of the block to delete
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds memFree(DWORD Address)
{
	WORD  w1, w2;
	D1("memFree");
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	w1=(WORD) Address;
	w2=(WORD) (Address>>16);
	_asm
   {
	  mov	bx, w1			
	  mov	ax, w2
      mov   dx, 0x101
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
   return w1 ;
}




/***************************************************************
*
*	WORD FAR PASCAL bankLoad(LPCHAR BankName)
*                                      
*	BankName : Name of th sound bank file (.94b)
*
*	Return : Sound bank number if succeed, 0x10+error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankLoad(char far *BankName)
{
	WORD  w1;
	D1("bankLoad");
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  les	di, BankName;
      mov   dx, 0x102
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
   return w1 ;
}


/***************************************************************
*
*	WORD FAR PASCAL memLoadFirmware(char far *FirmName)
*                                      
*	FirmName : name of the firmware file (.bin)
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds memLoadFirmware(char far *FirmName)
{
	WORD  w1;
	D1("memLoadFirmware");
	MidiCaps=TRUE;
	WaveInCaps=TRUE;		// to keep backward compatibility
	WaveOutCaps=TRUE;		// to keep backward compatibility
	WaveOut4=FALSE;

	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  les	di, FirmName;
      mov   dx, 0x103
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
   return w1 ;
}


/***************************************************************
*
*	WORD FAR PASCAL bankGetCaps(LPBANKCAPS lpBankCaps)
*                                      
*	Fill the stucture BANKCAPS with information on 9407 board memory
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankGetCaps(LPBANKCAPS lpBankCaps)
{
	WORD  w1;
	D1("bankGetCaps");
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  les	di, lpBankCaps;
      mov   dx, 0x106
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
	D1("return");
   return w1 ;
}


/***************************************************************
*
*	WORD FAR PASCAL _loadds bankSetPriority(WORD wBankNb, wBankPriority)
*                                      
*	Change the priority of the sound bank
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankSetPriority(WORD wBankNb, WORD wBankPriority)
{
	WORD  w1;
	D1("bankSetPriority");
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  mov	ax, wBankNb
	  mov	bx, wBankPriority
      mov   dx, 0x105
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
   return w1 ;
}

/***************************************************************
*
*	WORD FAR PASCAL _loadds bankUnload(WORD wBankNb)
*                                   
*	Remove the sound bank from 9407 boar memory
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankUnload(WORD wBankNb)
{
	WORD  w1;
	D1("bankUnLoad");
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  mov	ax, wBankNb
      mov   dx, 0x104
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
   return w1 ;
}


/***************************************************************
*
*	WORD FAR PASCAL _loadds DirectSoundVolumeCheck(WORD Volume,  WORD BaseAddress))
*                                   
*	Check if DirectSound is running.
*	
*	Parameter : Volume : (0-0xff) Volume to apply to primary buffer if DS is running
*				If Volume>0xff, no volume to apply.
*
*	Return : 0 if DirectSound is running
*			 1 if not
****************************************************************/

WORD FAR PASCAL _loadds DirectSoundVolumeCheck(WORD Volume, WORD BaseAddress)
{
	WORD  w1;
	D1("DirectSoundVolumeCheck");
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  mov	ax, Volume
	  mov	al, ah
	  mov	ah, 0
	  mov	bx, BaseAddress
      mov   dx, 0x107
      call  dword ptr pVxDEntry
      mov   w1, ax
   }
   return w1 ;
}


/***************************************************************
*	MAY 98
*
*	WORD FAR PASCAL memLoadFirmwareEx(char far *FirmName, DWORD Flags)
*
*                                      
*	FirmName : name of the firmware file (.bin)  (<256 char)
*
*	Flags	 :	FIRMWCAPS_UART		(Capability : The new Firmware answer 0xfe when receiving 0x3f)
*				FIRMWCAPS_MIDI		(Capability : The new Firmware is able to play midi)
*				FIRMWCAPS_WAVEIN		(Capability : The new Firmware is able to play wave in)
*				FIRMWCAPS_WAVEOUT		(Capability : The new Firmware is able to play wave out)
*				
*				FIRMWARE_SAVEBANKS	(Option		: Save the sound banks to be restored after
*									reloading a GM Firmware. 
*									DREAMERR_CANNOTSAVEBANK is returned if the Firmware deleted isn't a
*									Midi Firmware or if the new Firmware loaded is going to
*									erase some part of sound banks.
*				FIRMWARE_RESTOREBANKS (Option	: Restore previously saved Sound Banks).
*									DREAMERR_CANNOTRESTOREBANK if no banks are saved
*
*	Return : 0 if succeed, error code if failed 
*			(	DREAMERR_CANNOTSAVEBANK if the option 
*			FIRMWARE_SAVEBANKS is specified and it would be impossible to
*			restore the memory state (sound banks) later) 
*
*
*	**	 -If you ask to load a Firmware with FIRMWARE_SAVEBANKS or FIRMWARE_RESTOREBANKS options and
*	**	that the option asked cannot be successfully achieved, the Firmware isn't loaded on board.
*	**	Application programmers should handle this case by loading (or not) the Firmware without 
*	**	option.
*
*
*
****************************************************************/
WORD FAR PASCAL _loadds memLoadFirmwareEx(char far *FirmName, DWORD Flags)
{
	WORD  w1;   
	int n;

	D1("memLoadFirmwareEx");


	if (Flags & FIRMWCAPS_MIDI)
		MidiCaps=TRUE;
	else
		MidiCaps=FALSE;

	if (Flags & FIRMWCAPS_WAVEIN)
		WaveInCaps=TRUE;
	else
		WaveInCaps=FALSE;

	if (Flags & FIRMWCAPS_WAVEOUT)
		WaveOutCaps=TRUE;
	else
		WaveOutCaps=FALSE;

	if (Flags & FIRMWCAPS_4WAVES)
		WaveOut4=TRUE;
	else
		WaveOut4=FALSE;

	if (Flags & FIRMWARE_SAVEBANKS)
	{
		sbSaved=TRUE;
		// GetMMT Add (and save it)
		if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
			{
			D1("MMADD error .................");
			sbSaved=FALSE;
			return DREAMERR_CANNOTSAVEBANK;
			}
		// Upload MMT
		if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
			{
			D1("Upload MMT Error");
			sbSaved=FALSE;
			return DREAMERR_CANNOTSAVEBANK;
			}
		if (_fstrlen(FirmName)>255)
			return DREAMERR_PATHTOOLONG;
		_fstrcpy(LocalCopy, FirmName);

		_stat(LocalCopy,&ParamInfo);

		//Check that no part of Sound Banks will be erased

		// !!!!! FOR SAM 9777 the Firmware is loaded at Address 0x400!!!!!
		if (MemMapAdd<(DWORD) (ParamInfo.st_size/2 +0x200))	//0x9000)
		{
			D1("MMT will be erased...");
			sbSaved=FALSE;
			return DREAMERR_CANNOTSAVEBANK;

		}
		n=1;
		while ((MemoryBlock[n].Address<(DWORD) (ParamInfo.st_size/2 +0x200)) && (n<NbMemBlocks))
		{
			if (((MemoryBlock[n].Type & 0x7f)==0x4) || ((MemoryBlock[n].Type & 0x7f)==0x5) ||
				((MemoryBlock[n].Type & 0x7f)==0x10) || ((MemoryBlock[n].Type & 0x7f)==0x11) ||
				((MemoryBlock[n].Type & 0x7f)==0x20) || ((MemoryBlock[n].Type & 0x7f)==0x30))
			{
				D1("SB Block will be erased...");
				sbSaved=FALSE;
				return DREAMERR_CANNOTSAVEBANK;

			}
			n++;
		}

		if (n==NbMemBlocks)
		{
			D1("ERROR in MMT");
			sbSaved=FALSE;
			return DREAMERR_CANNOTSAVEBANK;

		}
	}


	if (Flags & FIRMWARE_RESTOREBANKS)
	{
		if (sbSaved==FALSE)
			return DREAMERR_CANNOTRESTOREBANK;  // No SB Saved

	}


	// LOAD FIRWARE
	if (!pVxDEntry)
		pVxDEntry=GetVxDEntry(DreamVxdId);

	_asm
   {
	  les	di, FirmName;
      mov   dx, 0x103
      call  dword ptr pVxDEntry
      mov   w1, ax
   }

	if (Flags & FIRMWARE_RESTOREBANKS)
	{
		SetMemMapAddress(MemMapAdd);
	}

   return w1 ;
}

