/****************************************************************************

    playwave.c   Play a mono wave file

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#include <conio.h>
#include <dos.h>
#include <malloc.h>

#include <memory.h>
#include <string.h> 
#include "test.h"


#define IVT_BASE        0x08


// PROTOTYPES  // // // // // // // // // // // // // // // // // // // // //

static VOID  initPCMPlay(VOID);
static VOID  loadData(CHAR*  pszFilename);
static VOID  pumpData(WORD  bytesToPump);

// // // // // // // // // // // // // // // // // // // // // // // // // //

static BOOL bEndlessLoop;


VOID _interrupt _far  PCM_BufferAvail_ISR_Play
    (
    unsigned            _es,
    unsigned            _ds,
    unsigned            _di,
    unsigned            _si,
    unsigned            _bp,
    unsigned            _sp,
    unsigned            _bx,
    unsigned            _dx,
    unsigned            _cx,
    unsigned            _ax,
    unsigned            _ip,
    unsigned            _cs,
    unsigned            _flags )
    {
    static UINT  I;
    
    if ( (remainingChunk = dataSize - readPos) > DATASIZE )
        {
        for ( I = 0; I < DATASIZE ; I++ ) 
            if (bWaveDone)
                _outp(MMA_DATA, SILENCE);
            else
                _outp( MMA_DATA, data[readPos++] );
        }
    else
        {
        // Wrap around...
        for ( I = 0; I < remainingChunk; I++ ) 
            if (bWaveDone)
                _outp( MMA_DATA, SILENCE);
            else
                _outp( MMA_DATA, data[readPos++] );   
                
        if (bEndlessLoop) 
            readPos = 0L;
        else
            bWaveDone = TRUE;
  
        }
    ISR_hit++;

    _inp(MMA_STATUS); // reading status reg required to reset Irq

    if (Irq >= 8)           // slave
        {
        _outp(0xa0, 0x60 | (Irq & 7));
        _outp(0x20, 0x62);
        }
    else                    // master
        {
        _outp(0x20, 0x60 | Irq);
        }
    }


static VOID initPCMPlay(VOID)
/*
    Set up MMA registers for simple PCM test.
*/
    {
    ResetMMA();

    // Data format register 
    MMA_OUT( MMA_SELT, 0 );    // offset binary

    // Volume control
    MMA_OUT( MMA_VOLUME, 0xC8 );

    // DMA/FIFO control
    MMA_OUT( MMA_PCM_FORMAT, D2 | D3 );     // 64-byte trigger

    // Wave audio config reg (freq sel)
    MMA_OUT( MMA_PCM_CONTROL, D0 | D1 | D2 | ((BYTE)(dataRate<<3)) | D5|D6 );


    // Select the PCM data register
    _outp( MMA_REG, MMA_PCM_DATA );
    }


// --------------------------------------------------------------------------

VOID  loadData (CHAR* pszFilename)
/*
    Read PCM data into a big buffer.
*/
    {
    DWORD               bytesInSample;
    DWORD               totalRead;
    INT                 numRead;
    int                 fh;
    PH_BYTE             writeBuffer;

    if ( (fh = _open(pszFilename, O_RDONLY | O_BINARY)) == -1 )
        {
        printf("Could not access [%s]\n", pszFilename);
        exit(0);
        }

    dataSize = bytesInSample = _filelength(fh);
    _lseek(fh, 0L, SEEK_SET);

    if ( (data = (PH_BYTE) _halloc(bytesInSample, 1)) == ((PH_BYTE) NULL) )
        {
        printf("Not enough memory to load [%s]\n", pszFilename);
        exit(0);
        }

    writeBuffer = data;

    for ( totalRead = 0L; totalRead < bytesInSample; totalRead += numRead )
        {
        if (0 == (numRead = _read(fh, diskread, (UINT)DISKREADSIZE)) )
            {
            printf("File read error [%x]\n", totalRead);
            abort();
            }

        _fmemcpy(writeBuffer, diskread, numRead);
        writeBuffer += numRead;
        }

    _close(fh);
    }

// --------------------------------------------------------------------------

VOID  pumpData (WORD bytesToPump)
/*
    Pump the specified number of bytes out to the MMA.  If we hit the
    end of our buffer, just wrap around.
*/
    {
    UINT    I;
    for ( I = 0; I < bytesToPump ; I++ )
        {
        _outp( MMA_DATA, SILENCE );
        }
    }


// --------------------------------------------------------------------------
VOID EndWave(VOID)
    { 
    _disable();
    _outp(PicImr, (_inp(PicImr) | PicMask)); // Re-mask Irq in 8259 IMR
    _dos_setvect( IntVect, old_ISR );  // Restore existing Irq handler  
    old_ISR = 0;
    _hfree(data); 
    data = NULL;
    _enable();
    }


// --------------------------------------------------------------------------

VOID  PlayWave(CHAR *pFileName, int Rate, BOOL bEndlessPar)
    {
    UINT I;
    bWaveDone = FALSE;
    bEndlessLoop = bEndlessPar;
    
    if (!bEndlessLoop)
        printf("Playing .wav file, press any key to interrupt...");    

    MixPlayMMAMax();                        // Setup to play at max volume
    
    dataRate = Rate;
    loadData( pFileName );

    _disable();
    readPos = 0L;
    
    if (Irq >= 8)           // Slave
        {
        IntVect = Irq - 8 + 0x70;  
        PicImr  = 0xa1;
        PicEoi  = 0xA0;
        } 
    else                   // Master
        {
        IntVect = Irq + 8;
        PicImr = 0x21;
        PicEoi = 0x20;
        }
    PicMask = 1 << (Irq & 7);

    // Hook ISR
    old_ISR = (LPISR)(_dos_getvect( IntVect ));
    _dos_setvect( IntVect, (LPISR) PCM_BufferAvail_ISR_Play );

    // Unmask Irq in 8259 IMR
    _outp(PicImr, (_inp(PicImr) & ~PicMask));

    initPCMPlay();

    // Prime the data pump
    for ( I = 0; I < 70 ; I++ )
        _outp( MMA_DATA, SILENCE );

    _enable(); // just make sure interrupts are enabled

    if (bEndlessLoop)
        return;

    while (!CheckBreak() &&  ! _kbhit() && !bWaveDone)
        {
        // just wait... data pump occurs in ISR
        DELAY
        }
    
    if (!CheckBreak() && _kbhit()) 
        {
        _getch();    // Eat the character
        printf(" interrupted!\n"); 
        }
    else
        printf(" done!\n");
    EndWave();
    }

// end listing
