/****************************************************************************
 recwave.c   Record into a pseudo-.wav file
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#include <conio.h>
#include <dos.h>
#include <malloc.h>

#include <memory.h>
#include <string.h>
#include "test.h"


// PROTOTYPES  // // // // // // // // // // // // // // // // // // // // //

static VOID  initPCMRec(VOID);
static VOID  makeBuffer(VOID);
static VOID  writeBuffer(CHAR*  pszFilename);

// // // // // // // // // // // // // // // // // // // // // // // // // //     

static BYTE byHadFirstIRQ = 0;

VOID _interrupt _far  PCM_BufferAvail_ISR_Rec
    (
    unsigned            _es,
    unsigned            _ds,
    unsigned            _di,
    unsigned            _si,
    unsigned            _bp,
    unsigned            _sp,
    unsigned            _bx,
    unsigned            _dx,
    unsigned            _cx,
    unsigned            _ax,
    unsigned            _ip,
    unsigned            _cs,
    unsigned            _flags )
    {
    static UINT  I;

    if (byHadFirstIRQ)
        {

        if ( writePos < SAMPLE_SIZE )
            {
            for ( I = 0; I < 2048; I++ )
                if (I & 1)
                    data[writePos++] = _inp(FIFO_REG);
                else
                    _inp(FIFO_REG);     // Throw-away sample!
            }
        else
            bufferFull = 1; 
        }
    else
        byHadFirstIRQ = 1;

    if (Irq >= 8)           // slave
        {
        _outp(0xa0, 0x60 | (Irq & 7));
        _outp(0x20, 0x62);
        }
    else                    // master
        {
        _outp(0x20, 0x60 | Irq); 
        }
        
    _inp(MMA_STATUS); // reading status reg required to reset IRQ 
    
    ISR_hit++;


    }
   
// --------------------------------------------------------------------------

static VOID  initPCMRec(void)
/*
    Set up MMA registers for simple PCM test.
*/
    {
    ResetMMA();

    // Data format register 
    MMA_OUT( MMA_SELT, 0 );            // offset binary

    // Volume control
    MMA_OUT(MMA_VOLUME, 0xC8); 
    MMA_OUT2(MMA_VOLUME, 0xC8);

    // Program base counter
    MMA_OUT(MMA_BASE_H, 0);
    MMA_OUT(MMA_BASE_L, 12);
    
    
    // Program timer 2
    MMA_OUT(MMA_TIMER2_L, 0);
    MMA_OUT(MMA_TIMER2_H, 0x08);           // 0x800 = 2048


    // DMA/FIFO control
    MMA_OUT( MMA_PCM_FORMAT, D7 | D1 | D0);     // 1-channel DMA, Mask FIFO interrupt, DMA enabled
    MMA_OUT2( MMA_PCM_FORMAT, D7 | D1 | D0);     // 1-channel DMA, Mask FIFO interrupt, DMA enabled 
    
    MMA_OUT( MMA_MIDI_CONTROL, D5 );    // Mask overrun error

    // Wave audio config reg (freq sel)
    MMA_OUT( MMA_PCM_CONTROL, MMA_PCM_CONTROL_PCM | 
             ((BYTE)(dataRate<<3)) | MMA_PCM_CONTROL_SELECT_L ); 
             
    // Wave audio config reg (freq sel)
    MMA_OUT2( MMA_PCM_CONTROL, MMA_PCM_CONTROL_PCM | 
             ((BYTE)(dataRate<<3)) | MMA_PCM_CONTROL_SELECT_R );
                                                                     
    // Start I/O

    MMA_OUT(MMA_TIMER_CONTROL, D4 | D5 | D3 | D2); // Mask T0, T1, Start BC, T2                                                                      
    MMA_OUT( MMA_PCM_CONTROL, MMA_PCM_CONTROL_ADPST | MMA_PCM_CONTROL_PCM | 
             ((BYTE)(dataRate<<3)) | MMA_PCM_CONTROL_SELECT_L);
             
    MMA_OUT2( MMA_PCM_CONTROL, MMA_PCM_CONTROL_ADPST | MMA_PCM_CONTROL_PCM | 
             ((BYTE)(dataRate<<3)) | MMA_PCM_CONTROL_SELECT_R);                                                                               
    
    }

// --------------------------------------------------------------------------

static VOID makeBuffer(VOID)
/*
    Alloc big buffer to load PCM data into.
*/
    {
    if ( (data = (PH_BYTE) _halloc(SAMPLE_SIZE,1)) == NULL )
        {
        printf("Not enough memory for PCM data buffer\n");
        exit(0);
        }

    for ( writePos = 0; writePos < SAMPLE_SIZE; writePos++ )
        data[writePos] = SILENCE;

    writePos = 0L;
    }

// --------------------------------------------------------------------------

static VOID writeBuffer(CHAR* pszFilename)
/*
    Write PCM data to a file.
*/
    {
    int                 fh;
    DWORD               totalWritten = 0L;
    DWORD               numWritten = 0L;

    if ( data == NULL )
        return;

    fh = _open(pszFilename,  O_WRONLY | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);

    if ( fh == -1 )
        {
        printf("Could not access [%s]\n", pszFilename);
        exit(0);
        }

    for ( totalWritten = 0L; totalWritten < SAMPLE_SIZE;)
        {
        numWritten = min((SAMPLE_SIZE - totalWritten), DISKREADSIZE);

        _fmemcpy(diskBuffer, data + totalWritten, (WORD) numWritten);

        if (0 == (numWritten = _write(fh, diskBuffer, (WORD) numWritten)) )
            {
            printf("File write error [%d]\n", numWritten);
            abort();
            }

        totalWritten += numWritten;
        }

    _close(fh);
    }

// --------------------------------------------------------------------------

VOID  RecWave(CHAR *pFileName, int Rate)
/*
    Record a PCM file when a key is pressed.
*/
    { 
    long i;
    
    SetTmpxRecord(); 
    ResetFifo();
    for (i=0; i<32768; i++)
        { 
        _outp(FIFO_REG, SILENCE);
        } 
    ResetFifo();
            
    OutIndirect(MIX_REG, MIX_SELECT, MIX_SELECT_MONO | MIX_SELECT_RECORD_L | MIX_SELECT_RECORD_R);
    
    makeBuffer();
    writePos = 0L;

    if (Irq >= 8)           // Slave
        {
        IntVect = Irq - 8 + 0x70;  
        PicImr  = 0xa1;
        PicEoi  = 0xA0;
        } 
    else                   // Master
        {
        IntVect = Irq + 8;
        PicImr = 0x21;
        PicEoi = 0x20;
        }
    PicMask = 1 << (Irq & 7);

    // Hook ISR
    old_ISR = (LPISR)(_dos_getvect( IntVect ));
    _dos_setvect( IntVect, (LPISR) PCM_BufferAvail_ISR_Rec );

    // Unmask Irq in 8259 IMR
    _outp(PicImr, (_inp(PicImr) & ~PicMask));

    printf("Press a key to begin recording...");

    dataRate = Rate;                   
    bufferFull = 0;

    while (!_kbhit() && !CheckBreak()); 
    _getch();
    
    printf("recording...");

    _disable();
    initPCMRec();
    _inp(MMA_STATUS); // reading status reg required to reset IRQ 
    byHadFirstIRQ = 0;     
    _enable();

    while ( 0 == bufferFull && !CheckBreak())
        {
        DELAY
        }

    _disable(); 
    MMA_OUT(MMA_TIMER_CONTROL, D4 | D5 | D6); // Mask T0, T1    
    MMA_OUT( MMA_PCM_CONTROL, 0 );
    MMA_OUT2( MMA_PCM_CONTROL, 0);
    
    _outp(PicImr, (_inp(PicImr) | PicMask)); // Re-mask Irq in 8259 IMR
    _dos_setvect( IntVect, old_ISR );  // Restore existing Irq handler
    old_ISR = NULL;
    writeBuffer(pFileName); 
    _hfree(data); 
    data = NULL;
    _enable();
    
    printf("Done!\n");

    }

// end listing
