#ifndef EDITORWINDOW_H
#define EDITORWINDOW_H

#include <QDialog>
#include <QList>
#include "chordinterpreter.h"
#include "chord.h"

namespace Ui {
class EditorWindow;
}

class EditorWindow : public QDialog
{
    Q_OBJECT

public:
    explicit EditorWindow(chordInterpreter *interp, QWidget *parent = 0);
    ~EditorWindow();


private slots:
    void on_twCommandsList_currentRowChanged(int currentRow);

    void on_btnRemove_clicked();

    void on_btnAdd_clicked();

    void on_btnApply_clicked();

    void on_leName_textChanged();

    void on_leChord_textChanged();

    void on_leCommand_textChanged();

    void on_EditorWindow_accepted();

    void on_btnRec_clicked();

private:
    Ui::EditorWindow *ui;
    void visualizeTable();

    QList<chord> workingBase;
    chordInterpreter * interpreter;
};

#endif // EDITORWINDOW_H
