#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSignalMapper>
#include <QSystemTrayIcon>
#include <QComboBox>
#include "chordinterpreter.h"
#include "qxtglobalshortcut.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void runButton(QString);

    void on_actionKeyActivation_triggered(bool checked);

    void on_actionTrainingMode_triggered(bool checked);

    void on_debug_changed(int index);
    void on_actionFlip_triggered();

    void on_actionClearLog_triggered();

    void on_actionExit_triggered();

    void on_actionEditor_triggered();

    void on_actionShow_Window_triggered();
    void on_tray_activated(QSystemTrayIcon::ActivationReason re);

private:
    Ui::MainWindow *ui;
    chordInterpreter * interpreter;
    QxtGlobalShortcut *shortcut1d;
    QxtGlobalShortcut *shortcut1u;
    QxtGlobalShortcut *shortcut2d;
    QxtGlobalShortcut *shortcut2u;
    QxtGlobalShortcut *shortcut3d;
    QxtGlobalShortcut *shortcut3u;
    QxtGlobalShortcut *shortcut4d;
    QxtGlobalShortcut *shortcut4u;
    QxtGlobalShortcut *shortcut5d;
    QxtGlobalShortcut *shortcut5u;
    QSignalMapper* signalMapper;
    QString buttonsFile;
    void saveSettings();
    QComboBox* dbgCombo;

    QString settingsFile;
    QMenu * menu;
    QSystemTrayIcon * trayIcon;
    QString key1up;
    QString key1down;
    QString key2up;
    QString key2down;
    QString key3up;
    QString key3down;
    QString key4up;
    QString key4down;
    QString key5up;
    QString key5down;
    void changeEvent(QEvent *event);
};

#endif // MAINWINDOW_H
