#!/bin/bash
#Ask for connecting cameras
echo "JOIN v. 1.0    2015 MCbx"
echo "Welcome to image joining guide"
if [ ! -d "cam1" ];
then
 echo "Directory cam1 does not exist - script will not operate"
 exit 0
fi
if [ ! -d "cam2" ];
then
 echo "Directory cam2 does not exist - script will not operate"
 exit 0
fi
echo "Please open directories and remove images showing no pages."
d=""
echo "Please type number of directory with cover: 1 for cam1, 2 for cam2"
read d
testeri=""
if [ "$d" == "1" ];
then
	testeri="1"
	ODD="cam1"
	EVEN="cam2"
fi
if [ "$d" == "2" ];
then
	testeri="1"
	ODD="cam2"
	EVEN="cam1"
fi
if [ "$testeri" == "" ]
then
	echo "Bad option"
	exit 0
fi
ODDROTATE="90"
echo "Enter degree to rotate cover directory pages clockwise."
echo "[default 90]"
read ODDROTATE
if [ "$ODDROTATE" == "" ]
then
	ODDROTATE=90
fi
EVENROTATE="90"
echo "Enter degree to rotate even pages clockwise."
echo "[default 270]"
read EVENROTATE
if [ "$EVENROTATE" == "" ]
then
	EVENROTATE=270
fi
cd $ODD
ODDCNT=$(find . -maxdepth 1 -type f|wc -l)
cd ..
cd $EVEN
EVENCNT=$(find . -maxdepth 1 -type f|wc -l)
cd ..
echo "SUMMARY:"
echo "  ODD Pages in directory:  "$ODD
echo "      Rotate by: "$ODDROTATE
echo "  EVEN Pages in directory: "$EVEN
echo "      Rotate by: "$EVENROTATE
echo "Odd files:  "$ODDCNT
echo "Even files: "$EVENCNT
if [ "$ODDCNT" != "$EVENCNT" ]
then
 echo "WARNING! Number of files is different. It looks strange."
fi
maxRun=$[$ODDCNT+$EVENCNT]
while [ -d "ready" ]
do
 echo "Delete or rename directory ready, please"
 read
done
mkdir ready
i="1"
while [ $i -lt $maxRun ]
do
	target=$(printf "%05d" $i).jpg
	echo $target
	cd $ODD
	FILE=$(find . -name "*.JPG" -type f -exec ls "{}" + | head -1)
	jpegtran -rotate $ODDROTATE $FILE >../ready/$target
	rm $FILE
	cd ..

	i=$[$i+1]
	target=$(printf "%05d" $i).jpg
	echo $target
	cd $EVEN
	FILE=$(find . -name "*.JPG" -type f -exec ls "{}" + | head -1)
	jpegtran -rotate $EVENROTATE $FILE >../ready/$target
	rm $FILE
	cd ..
	i=$[$i+1]
done
rmdir cam1
rmdir cam2
echo "Operation finished. Check images and run ScanTailor"
