#!/bin/bash

#WARNING: This script MUST be sourced.
#If buffer is missing, we need to bootstrap, because script is not 
# sourced.
if [ "${BUFFER}" = "" ]; then
	echo ERROR! No buffer, bootstrapping!
	source ./bootstrap.sh
fi

#Verify do we have all materials for action
if [ ! -d "${BUFFER}/cam1" ]; then
	DIALOG --title "Error" --msgbox "No cam1 folder in buffer!" 6 40
	return
fi
if [ ! -d "${BUFFER}/cam2" ]; then
	DIALOG --title "Error" --msgbox "No cam2 folder in buffer!" 6 40
	return
fi
CNT=$(find $BUFFER/cam1 -follow -maxdepth 2 | wc -l)
CNT=$(($CNT-1))
if [ "${CNT}" = "0" ]; then
	DIALOG --title "Error" --msgbox "cam1 folder is empty!" 6 40
	return
fi
CNT=$(find $BUFFER/cam2 -follow -maxdepth 2 | wc -l)
CNT=$(($CNT-1))
if [ "${CNT}" = "0" ]; then
	DIALOG --title "Error" --msgbox "cam2 folder is empty!" 6 40
	return
fi

#SHIT - Show Image In Terminal. If you use fim, use it here.
SHIT() {
#Uncomment to terminal version
#	fbi --noverbose -a $1
#	killall fbi
#Uncomment to X-win version
	feh -g 320x600+25+25 $1 &
}

#We have everything needed
#First, show images to delete: Cam1 first, if not Cam1 last
#Cam2 first, if not Cam2 last.
DIALOG --title "Deleting unneeded stuff" \
--msgbox "Images will be presented on screen. Exit them with Q key and \
answer questions.\nFirst, we will remove unneeded images." 7 65
IMG=$(ls $BUFFER/cam1 | head -1)
LOOP=0
DELE=0
while [ "${LOOP}" = "0" ]; do
	SHIT $BUFFER/cam1/$IMG
	K=$(DIALOG --nocancel --title "Photo operation 1" \
		--menu "What do you want to do with this photo?" 12 25 4 \
		p "Preserve" d "Delete" a "Show Again" x "Abort" 2>&1 >/dev/tty)
	if [ "${K}" = "x" ]; then
		#abort
		return
	fi
	if [ "${K}" = "p" ]; then
		#preserve
		LOOP=1
	fi
	if [ "${K}" = "d" ]; then
		#delete
		rm $BUFFER/cam1/$IMG
		LOOP=1
		DELE=1
	fi
done
killall feh
if [ "${DELE}" = "0" ]; then
IMG=$(ls $BUFFER/cam1 | tail -1)
LOOP=0
while [ "${LOOP}" = "0" ]; do
	SHIT $BUFFER/cam1/$IMG
	K=$(DIALOG --nocancel --title "Photo operation 2" \
		--menu "What do you want to do with this photo?" 12 25 4 \
		p "Preserve" d "Delete" a "Show Again" x "Abort" 2>&1 >/dev/tty)
	if [ "${K}" = "x" ]; then
		#abort
		return
	fi
	if [ "${K}" = "p" ]; then
		#preserve
		LOOP=1
	fi
	if [ "${K}" = "d" ]; then
		#delete
		rm $BUFFER/cam1/$IMG
		LOOP=1
	fi
done
killall feh
fi
IMG=$(ls $BUFFER/cam2 | head -1)
LOOP=0
DELE=0
while [ "${LOOP}" = "0" ]; do
	SHIT $BUFFER/cam2/$IMG
	K=$(DIALOG --nocancel --title "Photo operation 3" \
		--menu "What do you want to do with this photo?" 12 25 4 \
		p "Preserve" d "Delete" a "Show Again" x "Abort" 2>&1 >/dev/tty)
	if [ "${K}" = "x" ]; then
		#abort
		return
	fi
	if [ "${K}" = "p" ]; then
		#preserve
		LOOP=1
	fi
	if [ "${K}" = "d" ]; then
		#delete
		rm $BUFFER/cam2/$IMG
		LOOP=1
		DELE=1
	fi
done
killall feh
if [ "${DELE}" = "0" ]; then
IMG=$(ls $BUFFER/cam2 | tail -1)
LOOP=0
while [ "${LOOP}" = "0" ]; do
	SHIT $BUFFER/cam2/$IMG
	K=$(DIALOG --nocancel --title "Photo operation 4" \
		--menu "What do you want to do with this photo?" 12 25 4 \
		p "Preserve" d "Delete" a "Show Again" x "Abort" 2>&1 >/dev/tty)
	if [ "${K}" = "x" ]; then
		#abort
		return
	fi
	if [ "${K}" = "p" ]; then
		#preserve
		LOOP=1
	fi
	if [ "${K}" = "d" ]; then
		#delete
		rm $BUFFER/cam2/$IMG
		LOOP=1
	fi
done
killall feh
fi

#Show cam1 first picture, ask is it cover (ODD), or rotation
DIALOG --title "Image navigation" \
--msgbox "Images will be presented on screen. Exit them with Q key and \
answer questions.\nNow it's needed to know where is the cover and \
how to rotate pictures." 8 65

IMG=$(ls $BUFFER/cam1 | head -1)
LOOP=0
while [ "${LOOP}" = "0" ]; do
	SHIT $BUFFER/cam1/$IMG
	K=$(DIALOG --nocancel --title "Photo operation" \
		--menu "Is this photo of cover?" 18 40 11 \
		c "Cover, rotate right" \
		d "Cover, rotate 180" \
		e "Cover, rotate left (usually)" \
		f "Cover, do not rotate" \
		g "Not Cover, rotate right (usually)" \
		h "Not Cover, rotate 180" \
		i "Not Cover, rotate left" \
		j "Not Cover, do not rotate" \
		a "Show Again" x "Abort" 2>&1 >/dev/tty)

	if [ "${K}" = "c" ]; then
		ODD=cam1
		EVEN=cam2
		ODDROTATE=90
		EVENROTATE=270
		LOOP=1
	fi
	if [ "${K}" = "d" ]; then
		ODD=cam1
		EVEN=cam2
		ODDROTATE=180
		EVENROTATE=0
		LOOP=1
	fi
	if [ "${K}" = "e" ]; then
		ODD=cam1
		EVEN=cam2
		ODDROTATE=270
		EVENROTATE=90
		LOOP=1
	fi
	if [ "${K}" = "f" ]; then
		ODD=cam1
		EVEN=cam2
		ODDROTATE=0
		EVENROTATE=180
		LOOP=1
	fi

	if [ "${K}" = "g" ]; then
		ODD=cam2
		EVEN=cam1
		ODDROTATE=90
		EVENROTATE=270
		LOOP=1
	fi
	if [ "${K}" = "h" ]; then
		ODD=cam2
		EVEN=cam1
		ODDROTATE=180
		EVENROTATE=0
		LOOP=1
	fi
	if [ "${K}" = "i" ]; then
		ODD=cam2
		EVEN=cam1
		ODDROTATE=270
		EVENROTATE=90
		LOOP=1
	fi
	if [ "${K}" = "j" ]; then
		ODD=cam2
		EVEN=cam1
		ODDROTATE=0
		EVENROTATE=180
		LOOP=1
	fi

	if [ "${K}" = "x" ]; then
		#abort
		return
	fi
done
killall feh
ODDCNT=$(find $BUFFER/$ODD -maxdepth 1 -type f|wc -l)
EVENCNT=$(find $BUFFER/$EVEN -maxdepth 1 -type f|wc -l)

#File unmber is different!
if [ ! "${ODDCNT}" = "${EVENCNT}" ]; then
	DIALOG --title "File number differs" \
	--yesno "WARNING Different number of files in even ($EVENCNT) and \
	odd ($ODDCNT) folders. It is not normal. Do you want to continue?"\
	 8 60
	resp=$?
	if [ ! $resp -eq 0 ]; then
		return
	fi
fi

#summary
DIALOG --title "Ready to work!" \
--yesno "So here is what we know: \
\n Odd pages in folder:  $ODD \
\n   Rotate by: $ODDROTATE \
\n Even pages in folder: $EVEN \
\n   Rotate by: $EVENROTATE \
\n Odd pages:  $ODDCNT \
\n Even pages: $EVENCNT \
\n\nDo you want to continue?" 13 60
resp=$?
if [ ! $resp -eq 0 ]; then
	return
fi

#We know everythng. We can process images!
maxRun=$[$ODDCNT+$EVENCNT]
i="1"
while [ $i -lt $maxRun ]
do
	target=$(printf "%05d" $i).jpg
	FILE=$(ls $BUFFER/$ODD/* | head -1)
	jpegtran -rotate $ODDROTATE $FILE >$BUFFER/$target
	rm $FILE
	echo -n Page $i OK; 
	i=$[$i+1]

	target=$(printf "%05d" $i).jpg
	FILE=$(ls $BUFFER/$EVEN/* | head -1)
	jpegtran -rotate $EVENROTATE $FILE >$BUFFER/$target
	rm $FILE
	echo  Page $i OK;
	i=$[$i+1]
done
rmdir $BUFFER/cam1
rmdir $BUFFER/cam2
echo "Operation finished!"

if [ -d "${BUFFER}/cam1" ]; then
	echo WARNING: Could not delete cam1 directory from buffer
fi
if [ -d "${BUFFER}/cam2" ]; then
	echo WARNING: Could not delete cam2 directory from buffer
fi
beep
read
return
