#ifndef __PNP_H__
#define __PNP_H__

#include "ntddk.h"

#ifndef BOOL
#define BOOL ULONG
#endif

//
// pnp structure, all the operation upon these data are
// locked by pnp_lock
//

#define PNP_MAX_DRIVES 				2
#define DRIVE_STATE_NO_MEDIA		1
#define DRIVE_STATE_INITIALIZING  	2
#define DRIVE_STATE_WAIT_VERIFY		3
#define DRIVE_STATE_READY			4

#define CHECK_REQ_OPT_VERIFY		0x01	// if media changed, need to return STATUS_VERIFY_NEEDED
#define CHECK_REQ_OPT_NO_COMPLETE	0x02

#define ListFirst( heAD, firST) \
{\
    if( IsListEmpty( ( heAD ) ) )\
        firST = NULL;\
    else\
	    firST = ( heAD )->Flink;\
}

#define ListNext( heAD, curreNT, neXT) \
{\
	if( IsListEmpty( ( heAD ) ) == FALSE )\
	{\
		neXT = (curreNT)->Flink;\
		if( neXT == heAD )\
			neXT = NULL;\
	}\
	else\
		neXT = NULL;\
}

#define ListPrev( heAD, curreNT, prEV) \
{\
	if( IsListEmpty( ( heAD ) ) == FALSE )\
	{\
		prEV = (curreNT)->Blink;\
		if( prEV == heAD )\
			prEV = NULL;\
	else\
		prEV = NULL;\
}

#define ListFirstPrev( heAD, firST) \
{\
    if( IsListEmpty( ( heAD ) ) )\
        firST = NULL;\
    else\
	    firST = ( heAD )->Blink;\
}

#define UMSS_PNPMSG_STOP			0x01
#define UMSS_PNPMSG_DISCONNECT 		0x02

#define IOCTL_REGISTER_DISK_DRIVER 	CTL_CODE( 45008, 4203, METHOD_BUFFERED, FILE_ANY_ACCESS )
// input_buffer is a CLASS_DRV_REG_INFO, and input_buffer_length is equal to or greater than 
// sizeof( CLASS_DRV_REG_INFO ); the output_buffer is null and no output_buffer_length,
// only the following fields in urb can be accessed, others must be zeroed.


typedef NTSTATUS ( *PCLASS_DRVR_PNP_DISP )( PDEVICE_OBJECT pdo, ULONG ctrl_code, PVOID context );
	// pdo is the device object umss created

typedef PDEVICE_OBJECT ( *PCLASS_DRIVER_ADD_DEV )( PDRIVER_OBJECT fdo_drvr, PDEVICE_OBJECT pdo );
	// if the return value is not zero, it is a pointer to the
	// fdo sitting over the pdo of this driver. if it is null,
	// the add_device failed, and initialization process should
	// stall.

typedef struct _CLASS_DRV_REGISTRY_INFO
{
	// class driver will pass this structure to umss port
	// driver after loaded
	PDRIVER_OBJECT			fdo_driver;
	PCLASS_DRIVER_ADD_DEV   add_device;
	PCLASS_DRVR_PNP_DISP	pnp_dispatch;

} CLASS_DRV_REG_INFO, *PCLASS_DRV_REG_INFO;

typedef struct _NEW_DEV_ENTRY
{
	LIST_ENTRY 		dev_link;
	PDEVICE_OBJECT 	pdo;
	PDEVICE_OBJECT  fdo;

} NEW_DEV_ENTRY, *PNEW_DEV_ENTRY;

typedef struct _PNP_DATA
{
	PDRIVER_OBJECT  		pdriver;
	KSPIN_LOCK 				pnp_lock;			// spin-lock for access to the following fields
	LIST_ENTRY 				new_dev_list;
	ULONG					drive_count;		// this is a count of valid entries in phys_drive

	PDEVICE_OBJECT			phys_drive[ PNP_MAX_DRIVES ]; 	// this is an array holding all the device_object of part0
															// element in this array won't be removed since it is created,
															// and the array can only grow forward

    NPAGED_LOOKASIDE_LIST 	dev_entry_pool;		// this field is a pool to provide new dev entry from new_dev_list
	CHAR					thread_active;		// this is used to serialize the pnp event process launched from the work-item
	
	ULONG					thread_count;		// this is a count of valid entries in thread_ids
	HANDLE					thread_ids[ 20 ];	// this is an array recording the thread id for tracking irp's origin
	
} PNP_DATA, *PPNP_DATA;

BOOL
init_pnp(
PPNP_DATA pnp_data,
PDRIVER_OBJECT pdrvr
);

BOOL
destroy_pnp(
PPNP_DATA pnp_data
);

PDEVICE_OBJECT
pnp_add_device(
PDRIVER_OBJECT fdo_drvr,
PDEVICE_OBJECT pdo
);

NTSTATUS
pnp_disk_msg(
PDEVICE_OBJECT pdo,
ULONG ctrl_code,
PVOID context
);

BOOL
pnp_clear_port_dev(
PDEVICE_OBJECT fdo
);

BOOL
pnp_set_port_dev(
PDEVICE_OBJECT fdo,
PDEVICE_OBJECT pdo,
BOOL new_device
);

NTSTATUS
pnp_query_and_lock_pdo(
PDEVICE_OBJECT fdo,
PDEVICE_OBJECT *ppdo
);

VOID
pnp_unlock_pdo(
PDEVICE_OBJECT pdo
);

NTSTATUS
pnp_check_req(
PDEVICE_OBJECT fdo,
PIRP irp,
PDEVICE_OBJECT *pport_dev_obj,
ULONG options
);

PDEVICE_OBJECT
pnp_get_port_dev(
PDEVICE_OBJECT fdo
);

NTSTATUS
pnp_register_driver(
PDRIVER_OBJECT pdriver,
PDEVICE_OBJECT port_dev_obj,
PFILE_OBJECT file_obj
);

BOOL
pnp_register_drive_device(
PDEVICE_OBJECT fdo,
BOOL locked
);

BOOL
pnp_revoke_drive_device(
PDEVICE_OBJECT fdo
);

VOID
pnp_assign_drive_letter(
PDEVICE_OBJECT part_dev,
ULONG part_idx
);

BOOL
pnp_mark_request_origin();

VOID
pnp_clear_requst_origin();

BOOL
pnp_is_request_from_pnp();

#endif
