#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#define DISKIO 0x13
#define READCMD 2
#define WRITECMD 3

unsigned char *buffer;
int fflag=0;
int debug=0;

extern short cpu( void );

int main(argc,argv)
int argc;
char *argv[];
{  FILE *fp;
   int i,drv,ch;
   int anzsec,anzcyl,sides;
   int secbuf,kmdo;
   int tmax,smax,tempt;
   int cputype;

   if (argc<4) {
     fputs("usage: disktool <cmd> <type> filename [x:]\n",stderr);
     fputs("       (c)1993 Peter Dassow, royalty free software.\n",stderr);
     fputs("       <cmd> can be 'read' or 'write'(or 'read-debug'for debugging),\n",stderr);
     fputs("       <type> can be '160','180','360','720','800','1200' or '1440',\n",stderr);
     fputs("       if drive letter x: is omitted, A: is standard\n",stderr);
     exit(1);
   }
   if (argc==4) {
     drv= 0;
   }
   else {
     drv= toupper(*(argv[4])) - 'A';
   }

   if (drv>1) {
     fputs("Don't try to use a harddisk ! Only A or B is allowed !\n",stderr);
     exit(1);
   }

   if (stricmp(argv[2],"1440")==0) {
     anzsec=18;
     anzcyl=80;
     sides=2;
   }
   else if (stricmp(argv[2],"1200")==0) {
     anzsec=15;
     anzcyl=80;
     sides=2;
   }
   else if (stricmp(argv[2],"720")==0) {
     anzsec=9;
     anzcyl=80;
     sides=2;
   }
   else if (stricmp(argv[2],"800")==0) {
     anzsec=10;
     anzcyl=40;
     sides=2;
   }
   else if (stricmp(argv[2],"360")==0) {
     anzsec=9;
     anzcyl=40;
     sides=2;
   }
   else if (stricmp(argv[2],"160")==0) {
     anzsec=8;
     anzcyl=40;
     sides=1;
   }
   else if (stricmp(argv[2],"180")==0) {
     anzsec=9;
     anzcyl=40;
     sides=1;
   }
   else {
     fputs("disktool: wrong type of disk type (floppy size)\n",stderr);
     exit(2);
   }

   if (stricmp(argv[1],"read")==0) {
     kmdo=READCMD;
   }
   else if (stricmp(argv[1],"write")==0) {
     kmdo=WRITECMD;
   }
   else if (stricmp(argv[1],"read-debug")==0) {
     kmdo=READCMD;
     debug= -1; /* true */
   }
   else {
     fputs("disktool: wrong command\n",stderr);
     exit(2);
   }

   cputype=cpu();
   printf("This program runs on a machine with 80%d CPU.\n",cputype);

   if (debug) {
    if (cputype>=186) {  /* it may only work on AT class and above */
     disktyp(drv,&tmax,&smax);
    }
   }

   secbuf=anzsec*512;
   buffer=malloc(secbuf);
   if (buffer==NULL) {
     fprintf(stderr,"disktool: can't allocate %d bytes\n",secbuf);
     exit(3);
   }
   fflag= -1;
   readsec(0,0,1,drv); /* only for a seek to the first track */
   fflag=0;

   if (kmdo==READCMD) {
     printf("Reading from drive %c:, %d tracks %d sectors (total %d sectors)\nPress any key...",
            drv+'A',anzcyl,anzsec,anzcyl*anzsec*2);
   }
   else {
     printf("Writing to drive %c:, %d tracks %d sectors (total %d sectors)\nPress any key...",
            drv+'A',anzcyl,anzsec,anzcyl*anzsec*2);
   }
   fflush(stdout);
   ch=getch();
   if (ch==0x03 || ch==0x1b) exit(0);
   putchar('\n');
   if (kmdo==READCMD) {
     fp=fopen(argv[3],"wb");
   }
   else {
     fp=fopen(argv[3],"rb");
   }
   if (fp==NULL) {
     fputs("File open error\n",stderr);
     exit(1);
   }
   if (kmdo==READCMD && *(buffer+0x18)!=0) {
     tempt= *( (int *)(buffer+0x13) ) / *(buffer+0x18) /2;
     if (tempt==40||tempt==80) {
       printf("Possible disk parameter: %d tracks/%d sectors\n",
	      tempt,*(buffer+0x18) );
     }
   }

   for (i=0;i<anzcyl;i++) {
     if (kmdo==READCMD) {  /* Start of "read" branch */
       printf("Reading track %d head 1",i);
       fflush(stdout);
       readsec(i,0,anzsec,drv);
       if (fwrite(buffer,1,secbuf,fp)!=secbuf) {
         fputs("\nwrite to file failed\n",stderr);
         exit(4);
       }
       putchar('\r');
       if (sides==2) {
	 printf("Reading track %d head 2",i);
	 fflush(stdout);
	 readsec(i,1,anzsec,drv);
	 if (fwrite(buffer,1,secbuf,fp)!=secbuf) {
	   fputs("\nwrite to file failed\n",stderr);
	   exit(4);
	 }
	 putchar('\r');
       }
     } /* End of "read" branch */
     else { /* Start of "write" branch */
       printf("Writing track %d head 1",i);
       fflush(stdout);
       if (fread(buffer,1,secbuf,fp)!=secbuf) {
         fputs("\nread from file failed\n",stderr);
         exit(4);
       }
       writesec(i,0,anzsec,drv);
       putchar('\r');
       if (sides==2) {
	 printf("Writing track %d head 2",i);
	 fflush(stdout);
	 if (fread(buffer,1,secbuf,fp)!=secbuf) {
	   fputs("\nread from file failed\n",stderr);
	   exit(4);
	 }
	 writesec(i,1,anzsec,drv);
	 putchar('\r');
       }
     } /* End of "write" branch */
   }
   fclose(fp);
   puts("\nDone.");
   return(0);
}

int writesec(cyl,head,secs,drive)
int cyl,head,secs,drive;
/* buffer is global */
{  union REGS inregs, outregs;
   struct SREGS segregs;
   int ok=1,ch;

   while (ok!=0) {
     inregs.h.ah=WRITECMD;
     inregs.h.al=secs;
     inregs.h.ch=cyl;
     inregs.h.cl=1;
     inregs.h.dh=head;
     inregs.h.dl=drive;
     inregs.x.bx=FP_OFF(buffer);
     segregs.es=FP_SEG(buffer);
     int86x(DISKIO,&inregs,&outregs,&segregs);
     if (debug) {
       puts("\nint 13h function 3 returns:");
       printf("Register ah,al=%02x %02x\n",outregs.h.ah,outregs.h.al);
       printf("Register bh,bl=%02x %02x\n",outregs.h.bh,outregs.h.bl);
       printf("Register ch,cl=%02x %02x\n",outregs.h.ch,outregs.h.cl);
       printf("Register dh,dl=%02x %02x\n",outregs.h.dh,outregs.h.dl);
       printf("Register es:di=%04x:%04x\n",segregs.es,outregs.x.di);
     }
     ok=outregs.h.ah;
     if (ok!=0) {
       fprintf(stderr,"\nERROR track %d head %d, R)etry, A)bort or I)gnore ? ",cyl,head);
       fflush(stderr);
       ch=getch();
       ch=toupper(ch);
       fprintf(stderr,"%c\n",ch);
       if (ch=='I') ok=0;
       if (ch=='A')
	 exit(2); /* quit program immediately */
     }
   }
   return(outregs.h.al); /* number of sectors */
}

int readsec(cyl,head,secs,drive)
int cyl,head,secs,drive;
/* buffer is global */
{  union REGS inregs, outregs;
   struct SREGS segregs;
   int ok=1,ch;

   while (ok!=0) {
     inregs.h.ah=READCMD;
     inregs.h.al=secs;
     inregs.h.ch=cyl;
     inregs.h.cl=1;
     inregs.h.dh=head;
     inregs.h.dl=drive;
     inregs.x.bx=FP_OFF(buffer);
     segregs.es=FP_SEG(buffer);
     int86x(DISKIO,&inregs,&outregs,&segregs);
     if (debug) {
       puts("\nint 13h function 2 returns:");
       printf("Register ah,al=%02x %02x\n",outregs.h.ah,outregs.h.al);
       printf("Register bh,bl=%02x %02x\n",outregs.h.bh,outregs.h.bl);
       printf("Register ch,cl=%02x %02x\n",outregs.h.ch,outregs.h.cl);
       printf("Register dh,dl=%02x %02x\n",outregs.h.dh,outregs.h.dl);
       printf("Register es:di=%04x:%04x\n",segregs.es,outregs.x.di);
     }
     if (fflag) {
       ok=0;
     }
     else {
       ok=outregs.h.ah;
       if (ok!=0) {
	 fprintf(stderr,"\nERROR track %d head %d, R)etry, A)bort or I)gnore ? ",cyl,head);
	 fflush(stderr);
	 ch=getch();
	 ch=toupper(ch);
	 fprintf(stderr,"%c\n",ch);
	 if (ch=='I') ok=0;
	 if (ch=='A')
	   exit(1); /* quit program immediately */
       }
     }
   }
   return(outregs.h.al); /* number of sectors */
}

int disktyp(drive,tmax,smax)
int drive;
int *tmax,*smax;
{  union REGS inregs, outregs;
   struct SREGS segregs;

   inregs.h.ah=8; /* get drive parameters */
   inregs.h.dl=drive; /* drive to inspect */
   inregs.x.di=0;
   segregs.es=0;
   int86x(DISKIO,&inregs,&outregs,&segregs);
   /* number of drives in dl */
   *tmax= outregs.h.ch +1; /* number of cylinders, only lower 8 bits */
   *smax= outregs.h.cl & 0x3f; /* number of sectors, only lower 6 bits */
   if (debug) {
    puts("int 13h function 8 returns:");
    printf("Register ah,al=%02x %02x\n",outregs.h.ah,outregs.h.al);
    printf("Register bh,bl=%02x %02x\n",outregs.h.bh,outregs.h.bl);
    printf("Register ch,cl=%02x %02x (decimal: %d %d)\n",outregs.h.ch,outregs.h.cl,
	   outregs.h.ch,outregs.h.cl);
    printf("Register dh,dl=%02x %02x\n",outregs.h.dh,outregs.h.dl);
    printf("Register es:di=%04x:%04x\n",segregs.es,outregs.x.di);
   }
   return(outregs.h.ah); /* status */
}
