use warnings;
use strict;
use Tk;
use File::Copy;
use Tk::Photo;
use Tk::JPEG;

# USAGE:
#  unchoke dir1 dir2 dir3 ...
#where: dir1, 2, 3 - directories to create
# Images are stored in current directory, in current directory subdirectories
# are created
#
# MW 2014

if ($#ARGV==-1)
{
	print "No parameters given!\n";
	exit;
}

#1. Parse parameters - labels
#2. Create directories
	foreach my $lab (@ARGV)
	{
		print "Checking ".$lab."...";
		if (!-d $lab)
		{
			mkdir ($lab);
			print "CREATING";
		}
		print "\n";
	}

#3. Create form
#4. Create frame for images
	my $file = <*.jpg>;
	
	my $mw = MainWindow->new;

	print "Processing file: ".$file." ";
	#label in col0;
    my $lHandle= $mw->Label(-text => $file)->grid(-column=>0, -row=>0, -columnspan=>6);
	
	#image frame in col1
	my $bHandle = $mw->Button()->grid(-column=>0, -row=>6, -columnspan=>6, -pady=>2,);
	my $temp = $bHandle->Photo(-file => $file);
	my ($height, $width) = ($temp->height, $temp->width);
	my $yfactor = $height/600;
    my $xfactor = $width/700;
    my $scalefactor = $xfactor > $yfactor ? int($xfactor) : int($yfactor);
    $scalefactor +=1;
    my $pHandle = $bHandle->Photo();
    $pHandle->copy($temp, -subsample => $scalefactor);
	$bHandle->configure( -image => $pHandle);
	$temp->delete;
	$temp->destroy;
	
	
	#create the "restore" button
	my $previousFile="";
	my $previousTarget="";
	my $retractorHandle = $mw->Button(
			-text    => "SystemRestore",
			-command => sub 
				{ 
					print "\nRetract\n";
					move($previousFile,$previousTarget);
					disableBtn();
				},
			-height => 1,
			-width => 60,
			-state=>"disabled",
		)->grid( -column=>0, -row=>5, -padx=>8, -columnspan=>6,);
		
	sub disableBtn
	{
		$retractorHandle->configure(-state=>"disabled");
	}
	
	
	#create buttons and append actions to them
	my $col=0;
	my $row=1;
	foreach my $lab (@ARGV)
	{
		$mw->Button(
			-text    => $lab,
			-command => sub 
				{ #connect REFERENCE TO FUNCTION to button's command. This will call from 
					&moveFile($lab, $file);   #nonexisting object without error. Terrible hack.
					$file = <*.jpg>;
					if ($file eq "")  #This will fail when undef, no files and may kill program
					{
						print "END OF PROCESSING";
						exit;
					}	
					print "Processing file: ".$file." ";
					$lHandle->destroy;  #File name display logic
					$lHandle = $mw->Label(-text => $file)->grid(-column=>0, -row=>0, -columnspan=>6);
					$pHandle->delete;
					$pHandle->destroy;	#GARBAGE CLEAN. IMPORTANT. MEMORY LEAK IF NOT CALLED TWICE.
					$bHandle->destroy;	
					$bHandle = $mw->Button()->grid(-column=>0, -row=>6, -columnspan=>6, -pady=>2);
					$temp = $bHandle->Photo(-file => $file); #CREATE PHOTO THUMBNAIL
					($height, $width) = ($temp->height, $temp->width);
					$yfactor = $height/600;
					$xfactor = $width/700;
					$scalefactor = $xfactor > $yfactor ? int($xfactor) : int($yfactor);
					$scalefactor +=1;
					$pHandle = $bHandle->Photo(); 
					$pHandle->copy($temp, -subsample => $scalefactor);
					$bHandle->configure( -image => $pHandle);
					$temp->delete;
					$temp->destroy;
					
					$retractorHandle->configure(-state=>"normal");
				},
			-height => 2,
			-width => 15,
		)->grid( -column=>$col, -row=>$row, -padx=>8, -pady=>4,);
		$col++;
		if ($col>5)
		{
			$col=0;
			$row++;
		}
		if ($row>5)
		{
			$row=0;
		}
	}		
		
	MainLoop; #Fire up the GUI

	
#Move image (directory, file)
sub moveFile
{
	print "Sent to ";
	#check if file exists
	my $from=$_[1];
	my $to="./".$_[0]."/".$_[1]; #ADAPT ME WHEN PORTING
	while (-e $to)
	{
		print "\n   WARNING: File ".$to." Exists. Renaming... ";
		$to=$to."0.jpg";
	}
	#move file
	move($from, $to);
	print $to."\n";
	$previousFile=$to;
	$previousTarget=$from;
}
