         TITLE 'EAG   3.0 * EAGSTEFP  Stub EFPL Type PLIST'
****Start of Specifications****************************************
*
* Module name:      EAGSTEFP
*
* Descriptive name: Stub EFPL Type PLIST
*
* Function:
*   This module serves as stub and is linked together with a
*   compiled REXX program of OBJ type.
*
*   The type of parameter list expected is supplied when from
*   within an EXEC the instruction CALL program_name is issued,
*   of if within an EXEC the program is invoked via function
*   invocation program_name().
*
*   The general processing sequence is as follows:
*
*   1. Save registers.
*   2. Obtain storage required for execution of the stub. Obtain
*      storage unconditionally.
*   3. Build a parameter list for the invocation of IRXEXEC. See
*      below for the mapping between input parameter list (upper
*      part of the picture) to the parameter list required for the
*      invocation of IRXEXEC (lower part of the figure).
*   4. Invoke IRXEXEC unconditionally (abend if IRXEXEC cannot be
*      LOADed).
*   5. Convert the result supplied by IRXEXEC to the form needed
*      for this type of invocation.
*   6. DELETE IRXEXEC, do not care about errors.
*   7. Free obtained storage, do not care about errors.
*   8. Restore registers and return to the caller.
*
*   Parameter list for the invocation of IRXEXEC:
*
*   Parameter 1  Address of exec block (not supplied - 0).
*   Parameter 2  Address of the argument list.
*   Parameter 3  Indicate type of invocation (Subroutine, extended
*                return codes).
*   Parameter 4  Address of in-storage block describing the
*                compiled program.
*   Parameter 5  Address of the CPPL (not supplied - 0).
*   Parameter 6  Address of an EVALBLOCK to contain the result.
*   Parameter 7  Address of a work area vector (not supplied - 0).
*   Parameter 8  Address of user field (not supplied - 0).
*   Parameter 9  Address of Environment block passed in register 0
*                on invocation.
*
*   Storage is obtained from the same subpool as REXX will do.
*
*   The necessary final EVALBLOCK handling (and the determination
*   of the return code to pass back) is as follows:
*
*     RC_to_pass_back = 0
*     If RC_from_IRXEXEC ^=0 Then
*       RC_to_pass_back=RC_from_IRXEXEC
*     Else
*       Do
*         If EVALBLOCK shows truncated result Then
*           Do
*             Invoke IRXRLT 'GETBLOCK'
*             If rc ^= 0 Then
*               RC_to_pass_back=rc
*             Else
*               Do
*                 Put new EVALBLOCK address into parameter list
*                 Invoke IRXRLT 'GETRLTE' with new EVALBLOCK
*                 If rc ^= 0 Then
*                   RC_to_pass_back=rc
*               End
*           End
*       End
*
*   If the return code passed back from IRXEXEC is 100 or 104
*   (which indicates an abend) then additionally register 0 will
*   contain the value as passed back by IRXEXEC (abend code and
*   reason code).
*
* ------- ----------------------------------
* |       | | Saved entry R0  -----------    |
* ------- | ------------->| ENVBLOCK  |    |
* |       | >--------   -----------    |
* -------                                    |
* |       |                                    |
* -------                 ---------------- |
* |       |                 | -----------  | |
* -------                 >| ArgList   |  | |
* |       ------------------>-----------  | |
* ----                   -----------  | |
* |       -->------------->| EVALBLOK  |  | |
* ---- >--------   -----------  | |
*           |                                | |
*           |                                | |
* ------- | -----------                  | |
* |       Ӳ->|00 00 00 00|                  | |
* -------| --------   ------------- |
* |       |----------------->--------    |
* -------|| -----------                    |
* |       |->|30 00 00 00|                    |
* -------|| --------   -----------    |
* |       |->------------->| INSTBLK   |    |
* -------|| --------   -----------    |
* |       |                                  |
* -------|                                  |
* |       |                                  |
* -------|                                   |
* |                                          |
* -------                                   |
* |       Ө                                   |
* -------                                    |
* |       ------------------------------------
* -------
*
* Status:           IBM Library for REXX/370 (5695-014),
*                   Release 3, Level 0
*
* Module type:      see below
*   Processor:      HASM V2
*   Attributes:     Reentrant
*   Code page:      00037
*   Character set:  00697
*   Module size:    000258
*
* Entry points:
*   EAGSTUB  - Stub EFPL Type PLIST
*
* Maclibs:
*   SYS1.MACLIB
*
* Macros and control blocks:
*   GETMAIN  - Allocate Virtual Storage
*   FREEMAIN - Free Virtual Storage
*   IRXENVB  - Environment Block
*   IRXEVALB - EVALBLOCK
*   IRXEXTE  - REXX Vector of External Entry Points
*   IRXINSTB - In-Storage Block
*   IRXPARMB - Parm Block
*
* Change activity:
*   94-10-27  Release 3.0
*   95-06-21  PK  0C7 ABEND WHEN CODING EXIT WITOUT EXPRESSION
*             EYE CATCHER CHANGED, MODULE NAME INSERTED
*
****End of Specifications******************************************
                                                            SPACE 1
EAGSTUB  RMODE ANY
EAGSTUB  AMODE 31
                                                            SPACE 1
EAGSTUB  CSECT
         ENTRY EAGSTUB              Make name known
         EXTRN EAGOBJ               Compiled program
         USING *,R15
         B     PROLOG               Branch around header
         DROP  R15
                                                            SPACE 1
STIDL    DC    AL2(L'STID+L'STIDX)  ID string
STID     DC    C' EAGSTEFP/REXX - EFPL TYPE PLIST'
STIDX    DC    C' Generated &SYSDATE &SYSTIME'
                                                            SPACE 1
* ****** ***** ****************************************************
*
*        DC    C' Any string you would like to show'
*        DC    C' up in your linked programs, like a'
*        DC    C' copyright notice, may be added here.'
*
* ****** ***** ****************************************************
                                                            SPACE 1
*******************************************************************
* Save registers, establish addressability.
*******************************************************************
                                                            SPACE 1
         DS   0D
         DC    A(EAGSTBL)           Length of stub
         DC    F'0'
PROLOG   DS   0D
         STM   R14,R12,12(R13)      Save registers
         BALR  R12,R0               Establish base register
         USING *,R12                Tell assembler
                                                            SPACE 1
*******************************************************************
* Get required storage unconditionally in the same subpool where
* REXX will require storage. The subpool number is contained in
* the parameter block, which is addressed via the environment
* block. The address of the environment block is passed in register
* 0 on invocation, and is still there. The subpool number will be
* kept in register 11 throughout this program.
*******************************************************************
                                                            SPACE 1
         LR    R2,R1                Addr input parm vector
         LR    R3,R0                Addr environment block
         L     R3,ENVBLOCK_PARMBLOCK-ENVBLOCK(,R3) Addr parm block
         L     R11,PARMBLOCK_SUBPOOL-PARMBLOCK(,R3) Subpool number
         LA    R0,STSTORAL          Storage required
         GETMAIN RU,LV=(0),SP=(11),LOC=(ANY,ANY)
         ST    R13,4(,R1)           Save caller's save area addr
         ST    R1,8(R13)            Save my save area addr
         LR    R13,R1               Address my storage
         USING STSTORAG,R13         Establish addressability
         ST    R0,STSTLEN           Keep size of gotten storage
                                                            SPACE 1
*******************************************************************
* Now fill required control blocks.
* R2 points to original parameter vector.
*******************************************************************
                                                            SPACE 1
* Initialize PLIST.
         LA    R3,NIL               No exec block
         LA    R4,STAARGV           Addr argument vector
         LA    R5,INVOTYPE          Invocation type
         LA    R6,STAINST           Addr in-storage block
         LR    R7,R3                No CPPL
         L     R8,20(,R2)           Addr of addr of EVALBLOCK
         LA    R8,0(,R8)            Clear HOB
         L     R9,0(,R8)            Addr of EVALBLOCK
         SR    R10,R10              Length zero
         ST    R10,EVALBLOCK_EVLEN-EVALBLOCK(,R9) Keep it
         LR    R9,R3                No work area
         LR    R10,R3               No user field
         L     R11,4(,R13)          Addr caller's save area
         LA    R11,20(,R11)         Addr of original R0
         O     R11,LASTARG          Last argument
         STM   R3,R11,STPLIST       Store in PLIST
* Initialize addresses of control blocks.
         L     R3,16(,R2)           Addr argument vector
         ST    R3,STAARGV           Keep it
         LA    R3,STINSTB           Addr in-storage block
         ST    R3,STAINST           Keep it
* Initialize in-storage control block.
         LA    R3,STINSTB           Address of in-storage block
         USING INSTBLK,R3           Make it addressable
         MVI   0(R3),X'00'          Init in-storage block to X'00'
         MVC   1(LINSTB-1,R3),0(R3)
         MVC   INSTBLK_ACRONYM,INSTBLK_ACRYN Identifier
         LA    R4,LINSTB            Length of in-storage block
         ST    R4,INSTBLK_HDRLEN    Keep in in-storage block
         LA    R4,STINSTE           Addr of first entry
         ST    R4,INSTBLK_ADDRESS   Keep in in-storage block
         LA    R4,LINSTE            Length of entries
         ST    R4,INSTBLK_USEDLEN   Keep in in-storage block
         MVI   INSTBLK_MEMBER,C'?'  Want default search order
         MVI   INSTBLK_MEMBER+1,C' ' But don't know member name
         MVC   INSTBLK_MEMBER+2(L'INSTBLK_MEMBER-2),INSTBLK_MEMBER+1
         MVI   INSTBLK_DDNAME,C' '  Don't know DD name
         MVC   INSTBLK_DDNAME+1(L'INSTBLK_DDNAME-1),INSTBLK_DDNAME
         MVI   INSTBLK_SUBCOM,C' '  Don't know initial SUBCOM
         MVC   INSTBLK_SUBCOM+1(L'INSTBLK_SUBCOM-1),INSTBLK_SUBCOM
*        SR    R4,R4                Length of DSN is zero
*        ST    R4,INSTBLK_DSNLEN    Keep in in-storage block
         DROP  R3
* Initialize in-storage control block entry.
         LA    R3,STINSTE           Address of in-storage block entry
         USING INSTBLK_ENTRY,R3     Make it addressable
         L     R4,AOBJECT           Address of compiled program
         ST    R4,INSTBLK_STMT@
         LA    R4,20                Say it's 20 bytes
         ST    R4,INSTBLK_STMTLEN
         DROP  R3
                                                            SPACE 1
*******************************************************************
* Invoke IRXEXEC, store return code (and abend code) in original
* save area, so that when registers are restored R15 (and R0) will
* be set correctly.
*******************************************************************
                                                            SPACE 1
         L     R10,4(,R13)          Addr caller's save area
         L     R7,20(,R10)          Original R0 = addr environment
         L     R8,ENVBLOCK_IRXEXTE-ENVBLOCK(,R7) Addr IRXEXTE
         L     R15,IRXEXEC-IRXEXTE(,R8) Addr of IRXEXEC
         LR    R0,R7                addr environment
         LA    R1,STPLIST           Addr PLIST for IRXEXEC
         BALR  R14,R15              Invoke IRXEXEC
         C     R15,SABEND           System Abend?
         BE    ABEND                ...Yes, keep register 0
         C     R15,UABEND           User Abend?
         BE    ABEND                ...Yes, keep register 0
         LTR   R15,R15              Got return code in register
         BNZ   NOABEND              ...Yes, need not convert
                                                            SPACE 1
*******************************************************************
* Return code from IRXEXEC is 0, we inspect whether the EVALBLOCK
* shows a truncated result. If it does we request a new EVALBLOCK
* (stop with return code if this is not possible), and then
* we request from IRXRLT that this EVALBLOCK be filled (stop with
* return code if this is not possible).
*******************************************************************
                                                            SPACE 1
         L     R3,20(,R2)           Addr of addr of EVALBLOCK
         L     R3,0(,R3)            Addr of EVALBLOCK
         L     R7,EVALBLOCK_EVLEN-EVALBLOCK(,R3) Data length
         LCR   R7,R7                Check on truncated result
         BNP   NOABEND              Ok result, R15 still 0
         ST    R7,STRLTEL           Store required length
         LA    R4,GETBLOCK          Was negative, not X'80000000'
         LA    R5,STRAEVB           Address of EVALBLOCK
         SR    R6,R6                Originally zero
         ST    R6,0(,R5)            Init EVALBLOCK address
         LA    R6,STRLTEL           Required length
         L     R10,4(,R13)          Addr caller's save area
         LA    R7,20(,R10)          Addr of original R0
         O     R7,LASTARG           Last argument
         STM   R4,R7,STRLTPL        Store in PLIST
         L     R7,20(,R10)          Original R0 = addr environment
         L     R8,ENVBLOCK_IRXEXTE-ENVBLOCK(,R7) Addr IRXEXTE
         L     R15,IRXRLT-IRXEXTE(,R8) Addr of IRXRLT
         LR    R0,R7                Addr environment
         LA    R1,STRLTPL           Addr PLIST
         LR    R7,R15               Keep address of IRXRLT
         BALR  R14,R15              IRXRLT 'GETBLOCK'
         LTR   R15,R15              Successful?
         BNZ   NOABEND              No, give up
         L     R3,20(,R2)           Addr of addr of EVALBLOCK
         MVC   0(4,R3),STRAEVB      Update invocation parm list
         LA    R4,GETRLTE           Get result function
         ST    R4,STRLTPL           Store in PLIST
         LR    R15,R7               Addr of IRXRLT
         LR    R8,R0                Addr environment
         BALR  R14,R15              IRXRLT 'GETRLTE'
*                                   Fall through, R15 set
* In case of no abend we must keep R15.
NOABEND  DS   0H
         L     R10,4(,R13)          Addr caller's save area
         ST    R15,16(,R10)         Keep return code
         B     DONE                 Common processing
* In case of an abend we must keep R15 and R0.
ABEND    DS   0F
         L     R10,4(,R13)          Addr caller's save area
         STM   R15,R0,16(R10)       Keep abend and return code
                                                            SPACE 1
*******************************************************************
* Give back storage gotten, reestablish caller's save area.
* Give back storage conditionally, do not care if not successful.
*******************************************************************
                                                            SPACE 1
DONE     DS   0H
         L     R0,STSTLEN           Size of storage gotten
         DROP  R13                  Storage no longer available
         LR    R1,R13               Copy my storage address
         L     R13,4(,R13)          Restore caller's save area
         L     R11,20(,R13)         Addr environment block
         L     R11,ENVBLOCK_PARMBLOCK-ENVBLOCK(,R11) Addr parm blk
         L     R11,PARMBLOCK_SUBPOOL-PARMBLOCK(,R11) Subpool number
         FREEMAIN RC,LV=(0),A=(1),SP=(11)
                                                            SPACE 1
*******************************************************************
* Restore register (R15 and R0 may be changed), return to caller
*******************************************************************
                                                            SPACE 1
ALLDONE  DS   0H
         DROP  R12                  No longer base
         LM    R14,R12,12(R13)      Restore registers
         BR    R14                  Return to caller
         EJECT
*******************************************************************
* Required constants and DSECTS
*******************************************************************
                                                            SPACE 1
*
AOBJECT  DC    V(EAGOBJ)            Address of compiled program
*
NIL      DC    XL4'00000000'        NIL
INVOTYPE DC    XL4'30000000'        Subrtn, extended return code
LASTARG  DC    XL4'80000000'        Last argument
SABEND   DC    F'100'               System Abend
UABEND   DC    F'104'               User Abend
FENCE    DC    XL8'FFFFFFFFFFFFFFFF' Fence
GETBLOCK DC    CL8'GETBLOCK'        Function for IRXRLT
GETRLTE  DC    CL8'GETRLTE'         Function for IRXRLT
*
STSTORAG DSECT
STSAVE   DS    18F                  Save area
STSTLEN  DS    F                    Length of storage in bytes
STPLIST  DS    9A                   PLIST for IRXEXEC invocation
STAARGV  DS    A                    Addr of argument vector
STAINST  DS    A                    Addr of in-storage block
         DS   0D
STINSTB  DS    CL(LINSTB)           In-storage block
STINSTE  DS    CL(LINSTE)           In-storage block entry
         DS   0D
         ORG   STPLIST              Use storage efficiently
STRLTPL  DS    4F                   PLIST for IRXRLT
STRLTEL  DS    F                    Required length of EVALBLOCK
STRAEVB  DS    F                    Address of Environment
         ORG   ,                    Set to maximum
STSTORAL EQU   *-STSTORAG           Length of DSECT
                                                            SPACE 1
EAGSTUB  CSECT
         IRXINSTB DECLARE=YES       In-Storage Block
EAGSTUB  CSECT
         IRXEVALB DECLARE=NO        EVALBLOK
EAGSTUB  CSECT
         IRXENVB                    Environment block
EAGSTUB  CSECT
         IRXPARMB                   Parm block
EAGSTUB  CSECT
         IRXEXTE                    REXX Vector of Ext.Ent.Pts
EAGSTUB  CSECT
         EJECT
*******************************************************************
* Find length of various DSECTs, register equates
*******************************************************************
                                                            SPACE 1
INSTBLK  DSECT ,
         ORG
LINSTB   EQU   *-INSTBLK            In-storage block length
                                                            SPACE 1
INSTBLK_ENTRY DSECT ,
         ORG
LINSTE   EQU   *-INSTBLK_ENTRY      In-storage block entry length
                                                            SPACE 1
EVALBLOCK DSECT ,
         ORG
LEVALB   EQU   *-EVALBLOCK+11       EVALBLOCK required length
                                                            SPACE 1
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
                                                            SPACE 1
EAGSTUB  CSECT
         DS   0D                    Compiled prog starts here
EAGSTBL  EQU   *-EAGSTUB            Length of stub
         END

