
#define IS_HOB_ON(ptr) ((long)ptr & 0x80000000 ? 1 : 0)

#define PRINT_RESULT(ptr)\
{\
  printf("the result is:\n    string pointer = '%#x'\n", ptr);\
  if (IS_HOB_ON(ptr))\
  {\
    long t = (long)ptr & 0x07000000;\
    printf(" -> the result is not valid because\n");\
    if (t == 0x01000000)\
      printf("    of memory shortage.\n");\
    if (t == 0x02000000)\
      printf("    IRXINIT ended with error.\n");\
    if (t == 0x03000000)\
    {\
      printf("    IRXEXEC ended with error.\n");\
      printf("    REXX error number : %d\n",\
             ((long)ptr & 0x00FFFFFF)-20000);\
    }\
    if (t == 0x04000000)\
      printf("    IRXRLT  ended with error.\n");\
  }\
  else\
  {\
    printf("    string length  = '%d'\n", strlen(ptr));\
    printf("    first 100 chars= '%.100s'\n", ptr);\
  }\
  printf("memory for EVALBLOCK has %sbeen freed.\n\n",\
         evalfree(ptr) ? "NOT " : "");\
}
