/********************************************************/
/*                                                      */
/* AIRCRFT2.CMD - IBM Object REXX Sample Program        */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1996 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/

/* create a new aircraft */
myPlane = .Aircraft~New("N7650T", "Cessna 172A", 35)
say myPlane

/*******************************************************/
/* Declare the aircraft class                          */
/*******************************************************/
::CLASS Aircraft

/*******************************************************/
/* Declare the INIT method for all new aircrafts. The  */
/* INIT method will be invoked for every new object of */
/* the aircraft class. It is invoked as a result of    */
/* the NEW message to the aircraft class.              */
/* Three arguments will be processed and stored in the */
/* object's instance variables:                        */
/*      1. Registration of aircraft                    */
/*      2. Type of aircraft                            */
/*      3. Size (wingspan)                             */
/*******************************************************/
::METHOD Init
  Expose Registration Type Size
  Use Arg Registration, Type, Size

/*******************************************************/
/* Declare the STRING method for the aircraft class.   */
/* Return a string using the object's instance         */
/* variables.                                          */
/*******************************************************/
::METHOD String
  /* get access to the following instance variables */
  Expose Registration Type Size

  Return "A" Type "(" || Registration,
         || ") with a wingspan of" Size || "ft"
