/*****************************************************************************/
/* (C) Copyright IBM Corporation 1997, 1998. All Rights reserved.            */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
::class HTML public subclass array

::method queue attribute

::method init                          /* initialize an html object         */
  expose array_index type              /* index into the array, docu type   */
  array_index = 1                      /* start at the first item           */
  self~queue = ""
  type = 'text/html'                   /* default document type             */
  forward class (super)                /* do superclass initialization      */
                                       /* Start the html array off          */

::method put                           /* over ride of the put method       */
  expose array_index                   /* get the current index             */
  parse arg text
  self~put:super(text, array_index)
  array_index = array_index + 1

::method type                          /* change the document type          */
  expose type
  parse arg type

::method title                         /* title tag                         */
  parse arg text, opts
  self~put('<html><head><title>'text'</title></head><body 'opts'>') 

::method scrollingtitle                         /* title tag                         */
  parse arg text, opts
  self~put('<html><head>')
  do i = 1 to text~length
      self~put('<title>'text~substr(1,i)'</title>')
  end
  do i = text~length-1 to 1 by -1
      self~put('<title>'text~right(i)'</title>')
  end
  self~put('<title>'text'</title></head><body 'opts'>') 

::method h1                            /* header 1 tag                      */
  parse arg text
  self~put('<H1>'text'</H1>')

::method h2                            /* header 2 tag                      */
  parse arg text
  self~put('<H2>'text'</H2>')

::method h3                            /* header 3 tag                      */
  parse arg text
  self~put('<H3>'text'</H3>')

::method h4                            /* header 4 tag                      */
  parse arg text
  self~put('<H4>'text'</H4>')

::method h5                            /* header 5 tag                      */
  parse arg text
  self~put('<H5>'text'</H5>')

::method h6                            /* header 6 tag                      */
  parse arg text
  self~put('<H6>'text'</H6>')

::method href                          /* href tag with text and picture    */
  parse arg ref, text, pic
  if arg()=2 then self~put('<a href="'ref'"> <b>'text '</b></a>')
  else do
     self~put('<a href="'ref'"> <img align=middle src="'pic'">')
     if text \= '' then self~put('                 <b>'text '</b></a>')
     else self~put('</a>')
  end

::method moref                          /* href tag with 2 pictures    */
  parse arg ref, nr, picn, picmouse, text, opts
  self~put('<a href="'ref'" onMouseOver="document.images['nr'].src=''',
  || picmouse''';return true;" onMouseOut="document.images['nr'].src=''',
  || picn''';return true;"> <img align=middle src="'picn'" 'opts' >')
  if Arg(5,'o') = 0 then self~put('                 <b>'text '</b></a>')
  else self~put('</a>')

::method tag                           /* generate any tag                  */
  parse arg name, text
  self~put('<'name'>'text) 

::method etag                          /* generate any "end" tag            */
  parse arg name, text
  self~put('</'name'>'text) 

::method tage                          /* generate any tag with matching end*/
  parse arg name, text
  self~put('<'name'>'text'</'name'>') 

::method text                          /* add raw text to the stream        */
  parse arg text
  self~put(text)

/* paragraph tags                     */
::method p_common                       
  parse arg align, text
  if Arg(1,'o') = 1 then 
      self~put('<p >'text)
  else     
      self~put('<p align='align'>'text)

::method p                             /* paragraph tag                     */
  parse arg text
  self~p_common(,text)  

::method pl                            /* left paragraph tag                */
  parse arg text
  self~p_common("left", text)  

::method pc                            /* centered paragraph tag            */
  parse arg text
  self~p_common("center", text)  
  
::method pr                            /* right paragraph tag               */
  parse arg text
  self~p_common("right", text)  

::method br                            /* break tag                         */
  parse arg text
  self~put('<br>'text)  

::method hr                            /* hr tag                            */
  self~put('<hr>')  

::method ul                            /* ul tag                            */
  self~put('<ul>')  

::method eul                           /* eul tag                           */
  self~put('</ul>')  

::method ol                            /* ol tag                            */
  self~put('<ol>')  

::method eol                           /* eol tag                           */
  self~put('</ol>')  

::method dir                           /* dir tag                           */
  self~put('<dir>')  

::method edir                          /* edir tag                          */
  self~put('</dir>')  

::method li                            /* li tag                            */
  parse arg text
  self~put('<li>'text)  

::method strong                        /* strong tag                        */
  parse arg text
  self~put('<strong>'text'</strong>')  

::method em                            /* em (emphasis) tag                 */
  parse arg text
  self~put('<em>'text'</em>')  

::method b                             /* b (bold) tag                      */
  parse arg text
  self~put('<b>'text'</b>')  

::method i                             /* i (italic) tag                    */
  parse arg text
  self~put('<i>'text'</i>')  

::method u                             /* u (underscore) tag                */
  parse arg text
  self~put('<u>'text'</u>')  

::method tt                            /* tt (teletype) tag                 */
  parse arg text
  self~put('<tt>'text'</tt>')  

::method table                         /* table tag                         */
  parse arg options
  self~put('<table' options'>')

::method etable                        /* table end tag                     */
  self~put('</table>')

::method td                            /* td tag                            */
  parse arg text, options
  if text = '' then self~put('<td' options'>')
  else              self~put('<td' options'>'text'</td>')

::method etd                           /* td end tag                        */
  self~put('</td>')

::method th                            /* th tag                            */
  parse arg text, options
  self~put('<th' options'>'text'</th>')

::method tr                            /* tr tag                            */
  self~put('<tr>')

::method array2table
  use arg ar_h, ar_d, ar_o, options 
  if Arg(4,'o') = 1 then options = ""
  self~table(options)
  if Arg(1,'o') = 0 then do i over ar_h
      self~th(i)
  end
  do i = 1 to ar_d~dimension(1)
      self~tr
      do j = 1 to ar_d~dimension(2)
          if Arg(3,'o') = 1 then  
              self~td(ar_d[i,j])
          else if ar_o = "CURRENCY" then
              self~td(ar_d[i,j], 'align=right')
          else self~td(ar_d[i,j], ar_o[j])
      end    
  end    
  self~etable

::method form                          /* form tag                          */
  parse arg action
  self~put('<form method="GET" action="'action'">')

::method eform                         /* eform tag                         */
  self~put('</form>')

::method img
  parse arg bmpfile, align
  if Arg(2,'o') = 1 then align = "bottom"
  if bmpfile~pos('.') = 0 then bmpfile = bmpfile || ".GIF"
  self~put('<img src='bmpfile' align='align'>')
  
::method play
  parse arg soundfile
  if soundfile~pos('.') = 0 then soundfile = soundfile || ".WAV"
  self~put('<bgsound src='soundfile'>')
  
::method input                         /* input tag                         */
  parse arg type, name, value, opts, text
  if type = 'submit' then self~put('<input type="submit">')
  else
    self~put('<input type="'type'" name="'name'" value="'value'"' opts'>' text)

::method inputline                     /* input line */
  parse arg textb, type, name, value, opts, texta
  if Arg(1,'o') = 0 then self~br(textb); else self~br 
  self~put('<input type="'type'" name="'name'" value="'value'"' opts'>' texta)

::method ilist                        /* input list */
  parse arg action
  self~put('<form method="GET" action="'action'">')
  self~put('<table border=0 cellpadding=1>')
  
::method ili                          /* input list item */          
  parse arg textb, type, name, value, opts, texta
  self~put('<tr>')
  self~td(textb,'align=left')
  self~td('<input type="'type'" name="'name'" value="'value'"' opts'>')
  self~td(texta,'align=left')

::method eilist                        /* end input list */
  self~put('</table>')
  self~put('</form>')
  
::method select
  use arg name, size, listarr, opts
  if Arg(3,'o') = 1 then return -1
  if Arg(2,'o') = 1 then size listarr~items
  if Arg(4,'o') = 1 then opts = ""
  self~put('<select name='name' size='size opts'>')
  do i over listarr
      self~put('<option>'i)
  end
  self~put('</select>')
      
::method multiselect
  parse arg name, size, listarr, selarr
  if Arg(3,'o') = 1 then return -1
  if Arg(2,'o') = 1 then size listarr~items
  self~put('<select name='name' size='size 'multiple>')
  if Arg(4,'o') = 1 then do
    do i = 1 to listarr~items
      do j = 1 to selarr~items
         if selarr[j] = i then leave
      end
      if selarr[j] = i then   
          self~put('<option selected>'listarr[i])
      else    
          self~put('<option>'listarr[i])
    end  
  end
  else do i over listarr
      self~put('<option>'i)
  end
  self~put('</select>')


::method address                       /* address tag                       */
  parse arg text
  self~put('<address>'text'</eaddress>')

::method sign                          /* signature/end                     */
  self~~hr~href('/orxwww/main.htm',"Ingo's Home Page",'/orxwww/orxok.gif')
  self~~br~b('Object REXX Web Tutorial')
  self~br('Ingo Holder - IBM SWSD Germany')
  self~address('holder1@de.ibm.com')
  self~~hr~~etag('body')~~etag('html')

::method ingohome                       /* ingo's home page                 */
  self~href('/orxwww/main.htm', "Ingo's Home Page", ,
            '/orxwww/orxok.gif')

::method errormsg                      /* generate an error message         */
  expose array_index
  parse arg text
  if array_index = 1 then self~title('Error Message')
  else self~h4('Error Message')
  self~~p~~b(text)
  self~~hr~ingohome
  self~~sign~send

::method write                         /* write html to file (NOT USED)     */
  parse arg output                     /* output file                       */
  stream = .stream~new(output)         /* get a stream object               */
  do line over self                    /* time to write out the data        */
    stream~lineout(line)               /* write out the next line           */
  end
  stream~close                         /* close the file                    */

::method send                          /* send the HTML from the array      */
  expose type 
  crlf = '0d0a'x
  if self~queue \= "" then do          /* client-server dispatcher is used */
      queue 'Content-Type:' type  
      queue ''
      queue '<!doctype html public "html2.0">'
      do line over self                    /* loop over the array               */
        queue line                         /* queue the next line               */
      end
      queue "###FINISHED###"
  end
  else do
      s = .local["STDOUT"]
      s~lineout('Content-Type:' type) 
      s~lineout('')
      s~lineout('<!doctype html public "html2.0">')
      do line over self                    /* loop over the array               */
        s~lineout(line)                           /* send out the next line            */
      end
  end    
