/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Servers.frm  -  Base Class for TCP/IP Socket Servers                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
                                       
::REQUIRES "sockets.frm"               /* Load the sockets framework        */   

/*--------------------------------------------------------------------------*/
/* tcpServer Class definition                                               */
/*--------------------------------------------------------------------------*/
::CLASS tcpServer PUBLIC

/*--------------------------------------------------------------------------*/
::METHOD init                          /* Get sockets and binds port        */ 
  expose sSocket port
  use arg port                         /* Server port is parameter          */                          

  say "*** Starting server"
  say ""

  sSocket = .tcpSocket~new             /* Get a stream socket               */
  
/*--------------------------------------------------------------------------*/
::METHOD StartAccepting                /* Accept and service clients        */ 
  expose sSocket port

  signal on syntax                     /* Intercept ctrl-c                  */

  rc = sSocket~Bind(port)              /* Bind server socket to known port  */
  if rc < 0 then do
    say "Bind of port" port "to" sSocket "failed!"
    say "Server could not be started!"
    return -999
  end

  say ""
  say "*** tcpServer at port" port "started on" sSocket
  say "*** Enter 'Ctrl-c' to shut down server"

  sSocket~listen(10)                   /* Listen to queue of max 10 entries */
                                       /* Start service until 'shutdown'    */   
  do forever                      
    say "*** Server is waiting to accept clients"
    say ""                             
 
                                       /* Accept client request, get socket */             
    clientSocket = sSocket~accept      /* this is blocking until a client   */
                                       /* connects / server socket goes down*/ 

                                       /* request queue still active?       */ 
    if clientSocket~HostName = -1 then leave 
                                       /* get client hostname and address   */
    say " ** Accepted host:" clientSocket~HostName 
    say "    IP address" clientSocket~dotAddress "on" clientSocket

    self~NewClient(clientSocket)       /* New client, must be non-blocking! */
  end

syntax:                                
  return

/*--------------------------------------------------------------------------*/
::METHOD Shutdown UNGUARDED            /* Shutdown the server               */ 
  expose sSocket port
          
  sSocket~Close                        /* Close the server socket           */
  say ""
  say "*** Server shutdown"

  return 

/*--------------------------------------------------------------------------*/
::METHOD ServerSocket UNGUARDED        /* get server socket                 */    
  expose sSocket port
  return sSocket                 

/*--------------------------------------------------------------------------*/
::METHOD NewClient UNGUARDED           /* Process client request on socket  */    
  use arg cSocket                      

  cSocket~SendData(cSocket~ReceiveData)/* Reflect packet back to client     */   
  cSocket~Close                        /* Close client's socket             */  
                                       /* NOTE: noting must be returned     */ 
  return                               /* otherwise accepting new clients   */
                                       /* would be blocked!                 */
