/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    IBM Corporation 1998                                                  */
/*                                                                          */
/*  Command_C.cmd  -  Session Client using TCP/IP Sockets                   */
/*                                                                          */
/*    Client program for the command server. Ask the user for a string,     */ 
/*    send the string to the server and display the result strings.         */
/*                                                                          */
/*    Parameters:                                                           */
/*      Server:   alias name of the server                                  */
/*      Alias:    alias name of the client (optional, but recommended)      */
/*      Port:     server port number (optional)                             */
/*                                                                          */
/*  Documentation: see cmmnd.doc in directory docs                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Server Alias Port
if Port = '' then Port = 1922          /* Default port of command server    */
                                       /* create client for server via port */
client = .Client~new(Server, Port, Alias)
if client~connected then do            /* Is client connected to server?    */
  client~listenToServer                /* Start listening to the server     */ 

  say "Please enter a command" 
  say                                  /* Run session until entering 'quit' */ 
  do until keyWord = 'QUIT' | keyWord = 'SHUTDOWN'
    rc = client~promptInput()          /* get input from user               */ 
    if rc < 0 then do                  /* if error quit client session      */
      client~stopListening             /* Stop listening of the client      */
      leave
    end
    keyWord = client~Input~word(1)~translate 
  end 
end

exit   

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

/*--------------------------------------------------------------------------*/
/* Client Class definition                                                  */
/*--------------------------------------------------------------------------*/
::CLASS Client SUBCLASS tcpClient

/*--------------------------------------------------------------------------*/
::METHOD init
  use arg server, port, client, option                 

  self~init:super(server, port, client, option)/* Let the superclass do the init    */
  self~Listening = .FALSE              /* Indicate not being listening yet  */ 

/*--------------------------------------------------------------------------*/
::METHOD listenToServer UNGUARDED      /* Watch for any return data         */
  self~Listening = .TRUE               /* Indicate being listening now      */
  reply                                /* Return control and  continue      */
  
  do until RetString~right(20) = "#>>End_of_session<<#" 
    rc = self~receive                  /* receive the returned string       */
    if rc <= 0 then leave              /* if error terminate listening      */

    RetString = self~Output            /* get the output received           */
                                       /* and process it accordingly        */
    select                                                                    
      when RetString~right(14) = "#>>Get_File<<#" then do
                                       /* remove the control from retstring */ 
        Retstring = Retstring~left(RetString~length-14)
                                       /* send content of file to server    */
        rc = self~sendFile(self~Input~word(2))   
      end
      otherwise
    end  
    rr = charout(, RetString)          /* show the result                   */
  end

  self~Listening = .FALSE              /* Indicate not listening any more   */ 
  self~shutdown                        /* The client can be shutdown now    */

/*--------------------------------------------------------------------------*/
::METHOD Listening ATTRIBUTE           /* Set/Get the listening status      */

/*--------------------------------------------------------------------------*/
::METHOD stopListening                 /* Stop listening the conversation   */
  if self~Listening then               /* if still listening, force a quit  */
    self~sendInput('QUIT')             /* by sending the server 'quit'      */
      
/*--------------------------------------------------------------------------*/
::METHOD shutdown UNGUARDED            /* shutdown the client               */

  self~shutdown:super                  /* shutdown the tcpClient            */
  rc = Beep(800, 500)                  /* with a long beep                  */

