/*--------------------------------------------------------------------------*/
/*                                                                          */
/* Router protocol services of communication infrastructure of the agency   */
/*                                                                          */
/*   contains service routines that are intercepting special output         */       
/*   services and translates them into a tranmission protocol understood by */ 
/*   the client.                                                            */
/*                                                                          */
/*   This command file has to be included in transient or resident agents   */
/*   using the directive:                                                   */
/*                                                                          */
/*   ::REQUIRES Router                                                      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* GET services for remote processing                                       */
/*--------------------------------------------------------------------------*/
::ROUTINE get PUBLIC
  Use arg fname, mode
 
  say '#>>Get file='fname mode'<<#'
  return 0

/*--------------------------------------------------------------------------*/
/* PUT services for remote processing                                       */
/*--------------------------------------------------------------------------*/
::ROUTINE put PUBLIC
  Use arg fname, mode
 
  say '#>>Put file='fname mode'<<#'
  return 0

/*--------------------------------------------------------------------------*/
/* BEEP services for remote processing                                      */
/*--------------------------------------------------------------------------*/
::ROUTINE beep PUBLIC
  Use arg tone, duration
 
  say '#>>Beep' tone duration'<<#'
  return 0

/*--------------------------------------------------------------------------*/
/* PLAY services for remote processing                                      */
/*--------------------------------------------------------------------------*/
::ROUTINE play PUBLIC
  parse arg fileName playMode

  say '#>>Play file='fileName playMode'<<#'
  return 0
