/* Testing the REXX-API *****************************************************************/
/*                                                                                      */
/* REXX calls the Function Aspi_Fill_REXX_Variable_Pool and hands over the name of      */
/* a buffer. The C-function allocates storage for that buffer and fills the buffer.     */
/* The buffer is copied into the REXX-Variable pool. REXX is able to access the values  */
/* using the buffer-name                                                                */
/*                                                                                      */
/****************************************************************************************/

Call RxFuncAdd "AspiLoadFuncs2", "rexxasp2", "AspiLoadFuncs2"
Call AspiLoadFuncs2

call Aspi_Fill_REXX_Variable_Pool "ReadBuf"
Say 'Length of Buffer allocated by the C-function: ' Length(ReadBuf)

Say 'The C-function Aspi_Fill_REXX_Variable_Pool has put the following data into the buffer: '

Do i = 1 To Length(ReadBuf)
  Say 'Position in buffer:' i 'Decimal Value:' C2D(SubStr(ReadBuf, i, 1)) 'Hex Value: ' C2X(SubStr(ReadBuf, i, 1))
End

call AspiDeregFunc2

exit
