/******************************************************************************/
/*  factor                   Object REXX Samples                              */
/*                                                                            */
/*  A factorial program.                                                      */
/*                                                                            */
/*                                                                            */
/*  Licensed Materials - Property of IBM                                      */
/*  IBM Object REXX for AIX                                                   */
/*  (C) Copyright IBM Corp. 1998,  2004                                       */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                        */
/* code is sample code created by IBM Corporation. This                       */
/* sample code is not part of any standard or IBM                             */
/* product and is provided to you solely for the                              */
/* purpose of assisting you in the development of your                        */
/* applications.  The code is provided "AS IS", without                       */
/* warranty of any kind.  IBM shall not be liable for                         */
/* any damages arising out of your use of the sample                          */
/* code,  even if they have been advised of the                               */
/* possibility of such damages.                                               */
/*                                                                            */
/*  Description:                                                              */
/*  This program demonstrates a way to define a factorial class using the     */
/*  subclass method and the .methods environment symbol.                      */
/******************************************************************************/
say "Enter a number"
pull number
If \datatype(number, '9') then do
  Say 'Invalid whole number' number
  Exit
end

factorial_class = .string~subclass("Sample")~~define('FACTORIAL', .methods['FACTORIAL'])
say number 'factorial is' factorial_class~new(number)~factorial

Exit

/* Define the factorial method.  Note that this method contains a recursive   */
/* call to itself.                                                            */
::method factorial
  If self <= 1 then return 1
  else do
    t = self~class~new(self - 1)
    Return self * (t~factorial)
  end
