/**********************************************************************/
/*                                                                    */
/* SAMP08.REX: OLE Automation with Object REXX - Sample 8             */
/*                                                                    */
/* Create a new document in WinWord 97. Enter some text into the      */
/* document using different text styles. Also include the current     */
/* time and date. After that the document is saved to the root of the */
/* C:\ drive as Samp08.Doc and printed to the default printer.        */
/*                                                                    */
/* If the default printer is writing to a file you will get a dialog  */
/* asking for the output filename.                                    */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1999 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/
/* Create a new Word document and insert some text */
WordApp = .OLEObject~New("Word.Application")
WordDocs = WordApp~Documents
NewDocument = WordDocs~Add

/* Enter some text into first paragraph */
myRange = NewDocument~Paragraphs(1)~Range
myRange~Font~Name = "Brush Script"
myRange~Font~Size = "24"
myRange~InsertAfter("Hello from REXX!")
myRange~Words(3)~Bold = .True /* set the last word to bold */

/* Add a second paragraph with different attributes */
NewDocument~Paragraphs~Add
myRange = NewDocument~Paragraphs(2)~Range
myRange~Font~Name = "Arial"
myRange~Font~Size = "12"
myRange~Bold = .False
myRange~Italic = .False
myRange~InsertAfter("Greetings from the SHARE Technical Conference in SFO. ")
myRange~InsertAfter("This document was created on: ")
myRange~Collapse(0) /* unselect range, go to end (wdCollapseEnd=0) */
myRange~InsertDateTime("MMMM dd, yyyy at HH:mm:ss")

/* Save and print document */
NewDocument~SaveAs("C:\Samp08.doc")
NewDocument~PrintOut
WordApp~Quit /* quit word */

::REQUIRES OREXXOLE.CLS
