/********************************************************/
/*                                                      */
/* AIRCRFT4.CMD - IBM Object REXX Sample Program        */
/*                                                      */
/* One of the step by step samples to demonstrate the   */
/* inheritance features of Object REXX.                 */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1997 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/
myPlane = .Plane~New("N7650T", "Cessna 172A", 35)
myCopter = .Helicopter~New("N1187W", "Bell JetRanger", 33)
myBalloon = .Balloon~New("N6148R", "Cameron", 120000, "yellow")
Say myPlane
Say myCopter
Say myBalloon

/* try to set and read aircraft headings */
myPlane~setHeading(235)
Say myPlane~getHeading
myBalloon~setHeading(235)

/*-------------------------------------------------------------*/

/* Declare the generic aircraft class */
::CLASS Aircraft

/* catch the arguments supplied when a new object is created */
::METHOD Init
  Expose Registration Type Size
  Use Arg Registration, Type, Size

/* return string representation of the aircraft object */
::METHOD String
  Expose Registration Type Size
  Return "A" Type "(" || Registration || ") with" Self~SizeString

/* provide access to the size stored in the aircraft class */
::METHOD getSize
  Expose Size
  Return Size

/* catch any unknown message being sent to the object */
::METHOD Unknown
  Use Arg Message
  FailingClass = Self~Class~String
  Say FailingClass "does not understand message:" Message
  Return .nil  /* in case someone expects a return value */

/*-------------------------------------------------------------*/

/* declare the Steerable mixin class */
::CLASS Steerable MIXINCLASS Object

::METHOD SetHeading
  Expose Heading
  Use Arg Heading

::METHOD GetHeading
  Expose Heading
  Return "The aircraft is heading towards" Heading || " magnetic."

/*-------------------------------------------------------------*/

/* subclass Plane from Aircraft and inherit from Steerable */
::CLASS Plane SUBCLASS Aircraft INHERIT Steerable

/* provide the necessary SizeString method */
::METHOD SizeString
  Return "a wingspan of" Self~getSize "ft."

/*-------------------------------------------------------------*/

/* subclass Helicopter from Aircraft, inherit from Steerable */
::CLASS Helicopter SUBCLASS Aircraft INHERIT Steerable

/* provide the necessary SizeString method */
::METHOD SizeString
  Return "a rotor diameter of" Self~getSize "ft."

/*-------------------------------------------------------------*/

/* subclass Balloon from Aircraft */
::CLASS Balloon SUBCLASS Aircraft

/* catch the color attribute of the new balloon object */
::METHOD Init
  Expose Color
  Use Arg Registration, Type, Volume, Color

  /* forward registration, type, volume to parent class */
  Forward Class(Super) Array(Registration, Type, Volume)

/* provide the necessary SizeString method */
::METHOD SizeString
  Return "a volume of" Self~getSize "cubic ft"

/* format string representation for a balloon object */
::METHOD String
  Expose Color

  /* get the string as it is formatted by the parent */
  /* class and append the color of the balloon       */
  Return Self~String:Super || ", color" Color
