/*****************************************************************************/
/* List Addresses from File                                         www3.cmd */ 
/*                                                                           */
/* (C) Copyright IBM Corporation 1999.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/

use arg type, list, who                /* get the arguments                  */

parm = .parmdir~new(list)              /* create parameter directory         */

address = parm['address']              /* get the address                    */

parse source env . pathname            /* retrieve the source directory      */     
sourcedir = pathname~left(changestr('\', pathname, '/')~lastpos('/'))

html = .myHtml~new                     /* create an html object to work with */               
html~title('The Object REXX Address Book on the Web')
                                       /* get the address book               */
addr = getAddressBook(sourcedir"address.dat") 
if .nil = addr then do                 /* if not available...                */
  html~errormsg('Unable to open file "address.dat"!')
  return html                          /* error an error document            */
end
      
if address~DataType("N") = 0 then 
  address = ""                         /* also true for "List all addresses" */

if address = "" then do                /* if we want to list all addresses   */
  html~h2('All addresses...   from file <i>address.dat</i>')
  html~p('Select an entry from the following table.')~p
  html~table('border=2 cellpadding=2') /* define a table format              */
                                       /* row of 3 table headers             */
  html~tr~th('Number')~th('Name')~th('City')~etr
  do ad over addr                      /* list all addresses in table rows   */
    html~tr                            /* number field refers to an entry    */
    html~td(, 'align=left')~aref('www3?address='ad['NR'], ad['NR'])~etd
    html~td(ad['NA'])
    html~td(ad['CI'])~etr
  end 
  html~caption('My favourite list of persons','align="left" valign="bottom"')
  html~etable                          /* end the table definition           */
  html~p
end    
else do                                /* display a particular address       */
  html~h2('Address of 'addr[address]['NA'])
  html~p                               
  html~table('border=3 cellpadding=2') /* List information selected          */ 
  html~tr                              /* table row                          */
  html~td("Number")~td(addr[address]['NR'])
  html~tr                              /* table row                          */ 
  html~td("Name")~td(addr[address]['NA'])
  html~tr                              /* table row                          */ 
  html~td("Street")~td(addr[address]['ST'])
  html~tr                              /* table row                          */ 
  html~td("City")~td(addr[address]['CI'])
  html~tr                              /* table row                          */ 
  html~td("Country")~td(addr[address]['CO'])
  html~tr                              /* table row                          */ 
  html~td("Phone")~td(addr[address]['PH'])
  html~etable                          /* end of table definition            */

  html~form("/cgi-bin/orxwww/www3")    /* add "List all addresses" form      */
  html~p~submit("address", "List all addresses")
  html~eform                           /* end the form                       */
end

html~footing("/orxwww/www3.cmd")       /* footing with code reference        */
return html~end                        /* end HTML document and return it    */
     
::requires "myhtml.cls"                /* load myHtml class                  */

/*---------------------------------------------------------------------------*/
::ROUTINE getAddressBook               /* get the address book               */
  use arg filename

  addr = .environment["My.Addressbook"]/* just get previously loaded array   */
  if .nil = addr then do               /* if not available...                */
    file = .stream~new(filename)       /* create stream object and open it   */
    if file~open("READ") \= "READY:" then 
      return .nil                      /* return error                       */

    /* create an array object and load all addresses of the file into it.    */
    addr = .array~new(20)              /* Every address entry is a directory */
    i = 1
    do line over file                  /* create directory from each line    */
      parse var line nr "," name "," street "," city "," country "," phone
      dir = .directory~new             /* create directory & define entries  */ 
      dir['NR'] = nr                     
      dir['NA'] = name
      dir['ST'] = street
      dir['CI'] = city
      dir['CO'] = country
      dir['PH'] = phone
  
      addr[i] = dir                    /* put directory into array           */
      i = i + 1
    end
    .environment["My.Addressbook"]=addr/* store array in local environment   */
    call beep 550, 500                 /* beep when address book is created  */  
  end
  return addr                          /* address book successfully received */
