/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class hlcjnote {
    private Vector notesTitles = new Vector();
    private Vector notesListVec = new Vector();
    private Vector notesBodies = new Vector();
    private String inputFileName;
    private boolean notesFileExists;
    private hlcconfig configurations;
    private Vector nDir;
    static final String fsep = new String(System.getProperty("file.separator"));
    final String runDir;

    public hlcjnote(String string, String string2) {
        this.runDir = new String(string2);
        this.configurations = new hlcconfig(this.runDir, "", null);
        this.nDir = new Vector(this.configurations.getNotesPath(true));
        this.parseNoteFile(this.nDir, string);
    }

    public String getNoteBody(int n) {
        return this.notesBodies.elementAt(n).toString();
    }

    public void setNoteBodyTitle(String string, int n) {
        this.notesBodies.setElementAt(string, n);
        int n2 = string.indexOf("\n");
        if (n2 >= 0) {
            this.notesListVec.setElementAt(this.notesTitles.elementAt(n) + "    " + string.substring(0, n2), n);
        } else {
            this.notesListVec.setElementAt(this.notesTitles.elementAt(n) + "    " + string, n);
        }
    }

    public String getNoteTitle(int n) {
        return this.notesTitles.elementAt(n).toString();
    }

    public String getNoteEntry(int n) {
        return this.notesListVec.elementAt(n).toString();
    }

    public int numNotes() {
        return this.notesListVec.size();
    }

    public Vector getNoteEntries() {
        return this.notesListVec;
    }

    private boolean searchFor(RandomAccessFile randomAccessFile, String string) {
        String string2 = new String(" ");
        boolean bl = false;
        String string3 = new String(" ");
        try {
            while (string3 != null && !bl) {
                string3 = randomAccessFile.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens() && !bl) {
                    bl = stringTokenizer.nextToken().toString().equals(string);
                }
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Could not read notes file.", "IBM Softcopy Reader", 1);
        }
        return bl;
    }

    private String readOneLine(RandomAccessFile randomAccessFile) {
        String string = new String();
        try {
            string = randomAccessFile.readLine();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Could not read notes file.", "IBM Softcopy Reader", 1);
        }
        return string;
    }

    public int[] hasNotes(String string) {
        int[] nArray = new int[]{};
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < this.notesTitles.size()) {
            if (this.notesTitles.elementAt(n).equals(string)) {
                vector.addElement(new Integer(n));
            }
            ++n;
        }
        if (vector.size() > 0) {
            nArray = new int[vector.size()];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = (Integer)vector.elementAt(n2);
                ++n2;
            }
        }
        return nArray;
    }

    public static String fixWidth2(int n) {
        if (n == 0) {
            return "00";
        }
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n, 10);
    }

    public static String fixWidth6(int n) {
        if (n == 0) {
            return "000000";
        }
        if (n < 10) {
            return "00000" + n;
        }
        if (n < 100) {
            return "0000" + n;
        }
        if (n < 1000) {
            return "000" + n;
        }
        if (n < 10000) {
            return "00" + n;
        }
        if (n < 100000) {
            return "0" + n;
        }
        return Integer.toString(n, 10);
    }

    public static String convertedDate() {
        Calendar calendar = Calendar.getInstance();
        String string = new String("Date: " + calendar.get(1) + "" + hlcjnote.fixWidth2(calendar.get(2) + 1) + "" + hlcjnote.fixWidth2(calendar.get(5))) + "; Time: " + hlcjnote.fixWidth2(calendar.get(11)) + ":" + hlcjnote.fixWidth2(calendar.get(12)) + ":" + hlcjnote.fixWidth2(calendar.get(13)) + ";";
        return string;
    }

    public boolean saveNoteFile(hlcjbook hlcjbook2) {
        if (this.inputFileName.equals("")) {
            return false;
        }
        String string = new String(this.inputFileName);
        String string2 = new String(this.inputFileName.substring(0, this.inputFileName.lastIndexOf(46)) + ".ntx");
        try {
            File file = new File(string);
            File file2 = new File(string2);
            if (file.exists()) {
                file.renameTo(file2);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("Internal Version 4.2;");
            printStream.println("NOTES: Document " + hlcjbook2.jbGetjStitle() + "; Docnum " + hlcjbook2.jbGetjDocnum());
            printStream.println("       User PCWUSER; " + hlcjnote.convertedDate() + " Node: READWIN");
            printStream.println("Security \u00b0 Copyright IBM Corp. 1994");
            int n = 0;
            while (n < this.notesTitles.size()) {
                this.writeNote(printStream, n, hlcjbook2);
                ++n;
            }
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Could not save notes file.", "IBM Softcopy Reader", 0);
            return false;
        }
    }

    public boolean deleteNote(hlcjbook hlcjbook2, int n) {
        if (this.notesTitles.size() > n) {
            this.notesTitles.removeElementAt(n);
            this.notesListVec.removeElementAt(n);
            this.notesBodies.removeElementAt(n);
            if (this.notesTitles.isEmpty()) {
                File file = new File(this.inputFileName);
                try {
                    return file.delete();
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
            return this.saveNoteFile(hlcjbook2);
        }
        return false;
    }

    public static int nLines(String string) {
        int n = string.indexOf("\n");
        int n2 = 1;
        int n3 = 0;
        while (n > -1) {
            n3 = n;
            ++n2;
            n = string.indexOf("\n", n3 + 1);
        }
        return n2;
    }

    private String CRtoCRLF(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.toString().indexOf("\n");
        while (n < stringBuffer.length() & n >= 0) {
            stringBuffer.insert(n, "\r");
            n = stringBuffer.toString().indexOf("\n", n + 2);
        }
        return stringBuffer.toString();
    }

    private void writeNote(PrintStream printStream, int n, hlcjbook hlcjbook2) {
        int n2 = hlcjnote.nLines(this.notesBodies.elementAt(n).toString());
        String string = this.notesTitles.elementAt(n).toString();
        int n3 = hlcjbook2.getTopicMatchID(string);
        printStream.println(string + " " + hlcjnote.fixWidth6(0) + "." + hlcjnote.fixWidth6(0) + "." + hlcjnote.fixWidth6(0) + "." + hlcjnote.fixWidth6(n3) + ". " + n2);
        printStream.println(this.CRtoCRLF(this.notesBodies.elementAt(n).toString()));
    }

    public boolean hasNotesFile() {
        return this.notesFileExists;
    }

    public boolean parseNoteFile(Vector vector, String string) {
        File file = new File(string);
        String string2 = new String(file.getName());
        String string3 = new String(file.getParent());
        vector.addElement(string3);
        String string4 = new String(string2.substring(0, string2.lastIndexOf(46)) + ".ntf");
        int n = 0;
        this.notesFileExists = false;
        while (n < vector.size() && !this.notesFileExists) {
            this.inputFileName = vector.elementAt(n).toString() + fsep + string4;
            file = new File(this.inputFileName);
            if (file.exists()) {
                this.notesFileExists = true;
                string4 = this.inputFileName;
            }
            ++n;
        }
        if (this.notesFileExists) {
            boolean bl = false;
            boolean bl2 = false;
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(string4, "r");
                if (this.searchFor(randomAccessFile, "Security")) {
                    while (!bl2) {
                        bl2 = this.getNote(randomAccessFile);
                    }
                }
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Could not read notes file.", "IBM Softcopy Reader", 1);
            }
        } else {
            this.inputFileName = vector.size() > 1 ? vector.elementAt(0).toString() + fsep + string4 : "";
        }
        return this.notesFileExists;
    }

    private boolean getNote(RandomAccessFile randomAccessFile) {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        boolean bl = false;
        string2 = this.readOneLine(randomAccessFile);
        if (string2 != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "&,");
                string3 = stringTokenizer2.nextToken();
                stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ".");
                int n = stringTokenizer2.countTokens();
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                try {
                    int n2 = new Integer(stringTokenizer2.nextToken());
                    if (stringTokenizer2.hasMoreTokens()) {
                        int n3 = new Integer(stringTokenizer2.nextToken());
                    }
                    int n4 = new Integer(stringTokenizer.nextToken());
                    StringBuffer stringBuffer = new StringBuffer(this.readOneLine(randomAccessFile));
                    string = string3 + "    " + stringBuffer;
                    int n5 = 2;
                    while (n5 <= n4) {
                        stringBuffer.append("\n" + this.readOneLine(randomAccessFile));
                        ++n5;
                    }
                    this.notesListVec.addElement(string);
                    this.notesTitles.addElement(string3);
                    this.notesBodies.addElement(stringBuffer);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = false;
                JOptionPane.showMessageDialog(null, "Error parsing notes file.", "IBM Softcopy Reader", 0);
            }
        } else {
            bl = false;
        }
        return !bl;
    }

    public void addNote(String string, String string2) {
        int n = string2.indexOf("\n");
        if (n >= 0) {
            this.notesListVec.addElement(string + "    " + string2.substring(0, n));
        } else {
            this.notesListVec.addElement(string + "    " + string2);
        }
        this.notesTitles.addElement(string);
        this.notesBodies.addElement(string2);
    }
}

