/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class hlcSaveDialog
extends JDialog
implements ActionListener,
FocusListener {
    public static final int SAVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JList fileList;
    private fileListModel listModel;
    private File startDirectory;
    private File saveFile;
    private File openDirectory;
    private JScrollPane scrollPane;
    private JButton saveButton;
    private JButton cancelButton;
    private JButton upOneButton;
    private JButton newFolderButton;
    private JTextField fileNameTextField;
    private JComboBox fileFilterComboBox;
    private driveSelectionComboBox directoryComboBox;
    private JLabel lookInLabel;
    private JLabel fileNameLabel;
    private JLabel filesOfTypeLabel;
    private String systemDirectory = "";
    private Vector prohibitExtensionList = new Vector();
    private GridBagConstraints gbc;
    private int returnValue;

    public hlcSaveDialog(JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        this.systemDirectory = string2;
        this.startDirectory = new File(System.getProperty("user.home"));
        this.createSaveDialog();
    }

    public hlcSaveDialog(JFrame jFrame, String string, File file, String string2) {
        super(jFrame, string, true);
        this.systemDirectory = string2;
        this.startDirectory = file;
        this.createSaveDialog();
    }

    public hlcSaveDialog(JFrame jFrame, String string) {
        super(jFrame, "Save", true);
        this.systemDirectory = string;
        this.startDirectory = new File(System.getProperty("user.home"));
        this.createSaveDialog();
    }

    public hlcSaveDialog(JFrame jFrame, File file, String string) {
        super(jFrame, "Save", true);
        this.systemDirectory = string;
        this.startDirectory = file;
        this.createSaveDialog();
    }

    public hlcSaveDialog(JDialog jDialog, String string, String string2) {
        super(jDialog, string, true);
        this.systemDirectory = string2;
        this.startDirectory = new File(System.getProperty("user.home"));
        this.createSaveDialog();
    }

    public hlcSaveDialog(JDialog jDialog, String string, File file, String string2) {
        super(jDialog, string, true);
        this.systemDirectory = string2;
        this.startDirectory = file;
        this.createSaveDialog();
    }

    public hlcSaveDialog(JDialog jDialog, String string) {
        super(jDialog, "Save", true);
        this.systemDirectory = string;
        this.startDirectory = new File(System.getProperty("user.home"));
        this.createSaveDialog();
    }

    public hlcSaveDialog(JDialog jDialog, File file, String string) {
        super(jDialog, "Save", true);
        this.systemDirectory = string;
        this.startDirectory = file;
        this.createSaveDialog();
    }

    private void createSaveDialog() {
        this.setDefaultCloseOperation(0);
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.getContentPane().add((Component)this.createTopPanel(), "North");
        this.getContentPane().add((Component)this.createBottomPanel(), "South");
        this.getContentPane().add((Component)this.createScrollPane(), "Center");
        this.setSize(400, 250);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - 200, dimension.height / 2 - 125);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                hlcSaveDialog.this.returnValue = 1;
                hlcSaveDialog.this.closeWindow();
            }
        });
    }

    private JPanel createTopPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        this.lookInLabel = new JLabel("Look In:");
        this.add(this.topPanel, this.lookInLabel, this.gbc, 0, 0, 1, 1, "NONE", "CENTER", 5, 5, 0, 0);
        File[] fileArray = File.listRoots();
        this.directoryComboBox = new driveSelectionComboBox(fileArray);
        this.directoryComboBox.setDirectoryPath(this.startDirectory);
        this.directoryComboBox.setEditable(false);
        this.directoryComboBox.setToolTipText("Select Directory");
        this.add(this.topPanel, this.directoryComboBox, this.gbc, 1, 0, 2, 1, "HORIZONTAL", "CENTER", 5, 5, 0, 0);
        this.directoryComboBox.addActionListener(this);
        this.directoryComboBox.addFocusListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.upOneButton = new JButton(new ImageIcon(this.systemDirectory + "images" + File.separator + "UpFolder.gif"));
        this.upOneButton.setToolTipText("Up One Level");
        this.upOneButton.setMargin(new Insets(0, 0, 0, 0));
        this.add(jPanel, this.upOneButton, this.gbc, 0, 0, 1, 1, "NONE", "EAST", 0, 0, 0, 5);
        this.upOneButton.addActionListener(this);
        this.upOneButton.addFocusListener(this);
        this.newFolderButton = new JButton(new ImageIcon(this.systemDirectory + "images" + File.separator + "NewFolder.gif"));
        this.newFolderButton.setToolTipText("Create New Folder");
        this.newFolderButton.setMargin(new Insets(0, 0, 0, 0));
        this.add(jPanel, this.newFolderButton, this.gbc, 1, 0, 1, 1, "NONE", "WEST", 0, 0, 5, 0);
        this.newFolderButton.addActionListener(this);
        this.newFolderButton.addFocusListener(this);
        this.add(this.topPanel, jPanel, this.gbc, 3, 0, 1, 1, "NONE", "CENTER", 5, 5, 0, 0);
        return this.topPanel;
    }

    private JScrollPane createScrollPane() {
        if (this.startDirectory.isDirectory()) {
            File[] fileArray = this.startDirectory.listFiles();
        } else {
            File[] fileArray = this.startDirectory.getParentFile().listFiles();
        }
        this.listModel = new fileListModel();
        this.fileList = new JList(this.listModel);
        this.fileList.setCellRenderer(new fileListRenderer());
        this.fileList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.fileList);
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                if (!jList.isSelectionEmpty() && !listSelectionEvent.getValueIsAdjusting()) {
                    File file = (File)jList.getSelectedValue();
                    if (!file.isDirectory()) {
                        hlcSaveDialog.this.saveButton.setText("Save");
                        String string = file.toString();
                        int n = string.lastIndexOf(File.separator);
                        int n2 = string.length();
                        hlcSaveDialog.this.fileNameTextField.setText(string.substring(n + 1, n2));
                    } else {
                        hlcSaveDialog.this.saveButton.setText("Open");
                        hlcSaveDialog.this.openDirectory = new File(file.toString());
                    }
                }
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                File file;
                if (mouseEvent.getClickCount() == 2 && (file = (File)hlcSaveDialog.this.fileList.getSelectedValue()).isDirectory()) {
                    hlcSaveDialog.this.listModel.setElements(file.listFiles());
                    hlcSaveDialog.this.deactivateDirectoryComboBox();
                    hlcSaveDialog.this.directoryComboBox.setDirectoryPath(file);
                    hlcSaveDialog.this.activateDirectoryComboBox();
                    hlcSaveDialog.this.saveButton.setText("Save");
                }
            }
        });
        return this.scrollPane;
    }

    private JPanel createBottomPanel() {
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.fileNameLabel = new JLabel("File Name:");
        this.add(this.bottomPanel, this.fileNameLabel, this.gbc, 0, 0, 1, 1, "NONE", "CENTER", 5, 5, 0, 0);
        this.fileNameTextField = new JTextField();
        this.add(this.bottomPanel, this.fileNameTextField, this.gbc, 1, 0, 2, 1, "HORIZONTAL", "CENTER", 5, 5, 0, 0);
        this.fileNameTextField.addFocusListener(this);
        this.saveButton = new JButton(" Save ");
        this.saveButton.setMnemonic('S');
        this.saveButton.setMargin(new Insets(1, 3, 1, 3));
        this.add(this.bottomPanel, this.saveButton, this.gbc, 3, 0, 1, 1, "NONE", "CENTER", 5, 5, 0, 0);
        this.saveButton.addActionListener(this);
        this.filesOfTypeLabel = new JLabel("Files of Type:");
        this.add(this.bottomPanel, this.filesOfTypeLabel, this.gbc, 0, 1, 1, 1, "NONE", "CENTER", 5, 5, 0, 0);
        this.fileFilterComboBox = new JComboBox();
        this.fileFilterComboBox.setEditable(false);
        Vector<String> vector = new Vector<String>();
        vector.addElement("All Files");
        vector.addElement("*");
        this.fileFilterComboBox.addItem(vector);
        this.fileFilterComboBox.setRenderer(new fileFilterRenderer());
        this.add(this.bottomPanel, this.fileFilterComboBox, this.gbc, 1, 1, 2, 1, "HORIZONTAL", "CENTER", 5, 5, 0, 0);
        this.fileFilterComboBox.addActionListener(this);
        this.fileFilterComboBox.addFocusListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setMargin(new Insets(1, 1, 1, 1));
        this.add(this.bottomPanel, this.cancelButton, this.gbc, 3, 1, 1, 1, "NONE", "CENTER", 5, 5, 0, 0);
        this.cancelButton.addActionListener(this);
        this.cancelButton.addFocusListener(this);
        return this.bottomPanel;
    }

    private void add(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, String string, String string2, int n5, int n6, int n7, int n8) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.insets.top = n5;
        gridBagConstraints.insets.bottom = n6;
        gridBagConstraints.insets.left = n7;
        gridBagConstraints.insets.right = n8;
        if (string.equals("NONE")) {
            gridBagConstraints.fill = 0;
        } else if (string.equals("HORIZONTAL")) {
            gridBagConstraints.fill = 2;
        } else if (string.equals("BOTH")) {
            gridBagConstraints.fill = 1;
        }
        if (string2.equals("EAST")) {
            gridBagConstraints.anchor = 13;
        } else if (string2.equals("WEST")) {
            gridBagConstraints.anchor = 17;
        } else if (string2.equals("CENTER")) {
            gridBagConstraints.anchor = 10;
        }
        jPanel.add(component, gridBagConstraints);
    }

    private void closeWindow() {
        this.setVisible(false);
    }

    public void prohibitFileOfType(String string) {
        this.prohibitExtensionList.add(string.toLowerCase());
    }

    public void addFileFilter(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            vector.addElement("");
        } else {
            vector.addElement(string);
        }
        if (string2 == null) {
            vector.addElement("");
        } else {
            vector.addElement(string2.toLowerCase());
        }
        this.fileFilterComboBox.removeActionListener(this);
        this.fileFilterComboBox.insertItemAt(vector, 0);
        this.fileFilterComboBox.addActionListener(this);
        this.fileFilterComboBox.setSelectedIndex(0);
    }

    public void setFileName(String string) {
        this.fileNameTextField.setText(string);
    }

    public void setFileName(File file) {
        this.fileNameTextField.setText(file.toString());
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    private void deactivateDirectoryComboBox() {
        this.directoryComboBox.removeActionListener(this);
    }

    private void activateDirectoryComboBox() {
        this.directoryComboBox.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.returnValue = 1;
            this.closeWindow();
        } else if (object == this.saveButton) {
            if (this.saveButton.getText().equals("Open")) {
                if (this.openDirectory != null && this.openDirectory.exists()) {
                    this.listModel.setElements(this.openDirectory.listFiles());
                    this.deactivateDirectoryComboBox();
                    this.directoryComboBox.setDirectoryPath(this.openDirectory);
                    this.activateDirectoryComboBox();
                }
                this.saveButton.setText("Save");
                this.fileList.clearSelection();
            } else {
                String string = this.fileNameTextField.getText();
                if (string != null && string.length() > 0) {
                    String string2 = "." + (String)((Vector)this.fileFilterComboBox.getSelectedItem()).elementAt(1);
                    if (!string2.equals(".*") && !string.toLowerCase().endsWith(string2)) {
                        string = string + string2;
                    }
                    String string3 = string.toLowerCase();
                    boolean bl = true;
                    int n = this.prohibitExtensionList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        if (string3.endsWith((String)this.prohibitExtensionList.elementAt(n2))) {
                            JOptionPane.showMessageDialog(this, "Cannot save files of this type!", "ERROR", 0);
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        String string4 = ((File)this.directoryComboBox.getSelectedItem()).toString() + File.separator + string;
                        this.saveFile = new File(string4);
                        if (this.saveFile.exists()) {
                            int n3 = JOptionPane.showConfirmDialog(this, "File Exists, Replace the existing one?", "File Exists", 0, 2);
                            if (n3 == 0) {
                                this.returnValue = 0;
                                this.closeWindow();
                            }
                        } else {
                            this.returnValue = 0;
                            this.closeWindow();
                        }
                    }
                }
            }
        } else if (object == this.directoryComboBox) {
            this.deactivateDirectoryComboBox();
            File file2 = (File)this.directoryComboBox.getSelectedItem();
            this.listModel.setElements(file2.listFiles());
            this.directoryComboBox.setDirectoryPath(file2);
            this.activateDirectoryComboBox();
        } else if (object == this.upOneButton) {
            this.deactivateDirectoryComboBox();
            File file3 = (File)this.directoryComboBox.getSelectedItem();
            boolean bl = true;
            if (hlcvImage.linux) {
                bl = !file3.toString().equals(File.separator);
            } else {
                boolean bl2 = bl = !file3.toString().endsWith(":" + File.separator);
            }
            if (bl) {
                int n = this.directoryComboBox.getSelectedIndex();
                file3 = (File)this.directoryComboBox.getItemAt(n - 1);
                this.listModel.setElements(file3.listFiles());
                this.directoryComboBox.setDirectoryPath(file3);
            }
            this.activateDirectoryComboBox();
        } else if (object == this.newFolderButton) {
            File file4;
            createFolderDialog createFolderDialog2 = new createFolderDialog(this);
            createFolderDialog2.show();
            if (createFolderDialog2.getReturnValue() && (file4 = createFolderDialog2.getNewFolder()).mkdirs()) {
                this.listModel.setElements(((File)this.directoryComboBox.getSelectedItem()).listFiles());
            }
        } else if (object == this.fileFilterComboBox && (file = (File)this.directoryComboBox.getSelectedItem()) != null) {
            this.listModel.setElements(file.listFiles());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.saveButton.setText("Save");
        this.fileList.clearSelection();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private class createFolderDialog
    extends JDialog
    implements ActionListener {
        private boolean returnValue = false;
        private File newFolder;
        private JLabel label;
        private JTextField folderName;
        private JButton okButton;
        private JButton cancelCreateButton;

        public createFolderDialog(JDialog jDialog) {
            super(jDialog, "Create Folder", true);
            this.setDefaultCloseOperation(0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.label = new JLabel("Folder Name:");
            this.add(jPanel, this.label, hlcSaveDialog.this.gbc, 0, 0, 2, 1, "NONE", "WEST", 0, 0, 10, 0);
            this.folderName = new JTextField("New Folder");
            this.add(jPanel, this.folderName, hlcSaveDialog.this.gbc, 0, 1, 2, 1, "HORIZONTAL", "CENTER", 0, 0, 10, 10);
            this.okButton = new JButton("OK");
            this.okButton.setMargin(new Insets(1, 8, 1, 8));
            this.add(jPanel, this.okButton, hlcSaveDialog.this.gbc, 0, 2, 1, 1, "NONE", "EAST", 0, 0, 0, 10);
            this.okButton.addActionListener(this);
            this.cancelCreateButton = new JButton("Cancel");
            this.cancelCreateButton.setMargin(new Insets(1, 1, 1, 1));
            this.add(jPanel, this.cancelCreateButton, hlcSaveDialog.this.gbc, 1, 2, 1, 1, "NONE", "WEST", 0, 0, 10, 0);
            this.cancelCreateButton.addActionListener(this);
            this.getContentPane().add(jPanel);
            this.setSize(250, 100);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(dimension.width / 2 - 125, dimension.height / 2 - 50);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ createFolderDialog this$1;
                {
                    this.this$1 = createFolderDialog2;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    createFolderDialog.access$1702(this.this$1, false);
                    createFolderDialog.access$1800(this.this$1);
                }
            });
        }

        private void closeDialog() {
            this.setVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.cancelCreateButton) {
                this.returnValue = false;
                this.closeDialog();
            } else if (object == this.okButton) {
                this.newFolder = new File(((File)hlcSaveDialog.this.directoryComboBox.getSelectedItem()).toString() + File.separator + this.folderName.getText());
                if (this.newFolder.exists()) {
                    JOptionPane.showMessageDialog(this, "Folder Already Exists", "ERROR", 0);
                } else {
                    this.returnValue = true;
                    this.closeDialog();
                }
            }
        }

        public boolean getReturnValue() {
            return this.returnValue;
        }

        public File getNewFolder() {
            return this.newFolder;
        }

        public void add(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, String string, String string2, int n5, int n6, int n7, int n8) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.insets.top = n5;
            gridBagConstraints.insets.bottom = n6;
            gridBagConstraints.insets.left = n7;
            gridBagConstraints.insets.right = n8;
            if (string.equals("NONE")) {
                gridBagConstraints.fill = 0;
            } else if (string.equals("HORIZONTAL")) {
                gridBagConstraints.fill = 2;
            } else if (string.equals("BOTH")) {
                gridBagConstraints.fill = 1;
            }
            if (string2.equals("EAST")) {
                gridBagConstraints.anchor = 13;
            } else if (string2.equals("WEST")) {
                gridBagConstraints.anchor = 17;
            } else if (string2.equals("CENTER")) {
                gridBagConstraints.anchor = 10;
            }
            jPanel.add(component, gridBagConstraints);
        }

        static /* synthetic */ boolean access$1702(createFolderDialog createFolderDialog2, boolean bl) {
            createFolderDialog2.returnValue = bl;
            return createFolderDialog2.returnValue;
        }

        static /* synthetic */ void access$1800(createFolderDialog createFolderDialog2) {
            createFolderDialog2.closeDialog();
        }
    }

    private class driveSelectionComboBox
    extends JComboBox {
        int selectedIndex;

        public driveSelectionComboBox(File[] fileArray) {
            super(fileArray);
            this.setRenderer(new driveListRenderer());
        }

        public void setDirectoryPath(File file) {
            String string = file.toString();
            int n = this.getItemCount();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (string.startsWith(((File)this.getItemAt(n3)).toString())) {
                    n2 = n3 + 1;
                    break;
                }
                ++n3;
            }
            this.selectedIndex = n2 - 1;
            this.clearDirectoryPathComponents();
            this.setDirectoryPathComponents(file, n2);
            this.setSelectedIndex(this.selectedIndex);
        }

        private void clearDirectoryPathComponents() {
            int n = this.getItemCount();
            boolean bl = true;
            int n2 = n - 1;
            while (n2 >= 0) {
                if (hlcvImage.linux) {
                    bl = !((File)this.getItemAt(n2)).toString().equals(File.separator);
                } else {
                    boolean bl2 = bl = !((File)this.getItemAt(n2)).toString().endsWith(":" + File.separator);
                }
                if (bl) {
                    this.removeItemAt(n2);
                }
                --n2;
            }
        }

        private void setDirectoryPathComponents(File file, int n) {
            File file2;
            boolean bl = true;
            if (file.isDirectory()) {
                if (hlcvImage.linux) {
                    bl = !file.toString().equals(File.separator);
                } else {
                    boolean bl2 = bl = !file.toString().endsWith(":" + File.separator);
                }
                if (bl) {
                    this.insertItemAt(file, n);
                    ++this.selectedIndex;
                }
            }
            if ((file2 = file.getParentFile()) != null) {
                this.setDirectoryPathComponents(file2, n);
            }
        }
    }

    private class fileFilterRenderer
    extends JLabel
    implements ListCellRenderer {
        private fileFilterRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Vector vector = (Vector)object;
            this.setOpaque(true);
            this.setText((String)vector.elementAt(0));
            if (bl) {
                this.setBackground(Color.blue);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    private class driveListRenderer
    extends JLabel
    implements ListCellRenderer {
        private driveListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            String string = file.toString();
            this.setOpaque(true);
            if (string.endsWith(":" + File.separator)) {
                this.setIcon(new ImageIcon(hlcSaveDialog.this.systemDirectory + "images" + File.separator + "HardDrive.gif"));
                this.setText(string);
            } else {
                this.setIcon(new ImageIcon(hlcSaveDialog.this.systemDirectory + "images" + File.separator + "Directory.gif"));
                int n2 = string.lastIndexOf(File.separator);
                int n3 = string.length();
                this.setText(string.substring(n2 + 1, n3));
            }
            if (bl) {
                this.setBackground(Color.blue);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    private class fileListModel
    extends DefaultListModel {
        private fileListModel() {
        }

        public void setElements(File[] fileArray) {
            Vector vector = (Vector)hlcSaveDialog.this.fileFilterComboBox.getSelectedItem();
            String string = (String)vector.elementAt(1);
            if (fileArray != null) {
                int n = fileArray.length;
                int n2 = 0;
                int n3 = 0;
                this.removeAllElements();
                int n4 = 0;
                while (n4 < n) {
                    if (fileArray[n4].isDirectory()) {
                        this.insertFileInOrder(fileArray[n4], 0, n2);
                        ++n2;
                        ++n3;
                    } else if (string.equals("") || string.equals("*")) {
                        this.insertFileInOrder(fileArray[n4], n2, n3);
                        ++n3;
                    } else if (fileArray[n4].toString().endsWith("." + string)) {
                        this.insertFileInOrder(fileArray[n4], n2, n3);
                        ++n3;
                    }
                    ++n4;
                }
            }
        }

        public void insertFileInOrder(File file, int n, int n2) {
            if (n == n2) {
                this.insertElementAt(file, n);
            } else if (n + 1 == n2) {
                int n3 = ((File)this.getElementAt(n)).toString().compareToIgnoreCase(file.toString());
                if (n3 < 0) {
                    this.insertElementAt(file, n2);
                } else {
                    this.insertElementAt(file, n);
                }
            } else {
                int n4 = (n + n2) / 2;
                int n5 = ((File)this.getElementAt(n4)).toString().compareToIgnoreCase(file.toString());
                if (n5 < 0) {
                    this.insertFileInOrder(file, n4, n2);
                } else if (n5 > 0) {
                    this.insertFileInOrder(file, n, n4);
                } else {
                    this.insertElementAt(file, n4);
                }
            }
        }
    }

    private class fileListRenderer
    extends JLabel
    implements ListCellRenderer {
        private fileListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            String string = file.toString();
            int n2 = string.lastIndexOf(File.separator);
            int n3 = string.length();
            this.setOpaque(true);
            if (file.isDirectory()) {
                this.setIcon(new ImageIcon(hlcSaveDialog.this.systemDirectory + "images" + File.separator + "Directory.gif"));
            } else {
                this.setIcon(new ImageIcon(hlcSaveDialog.this.systemDirectory + "images" + File.separator + "File.gif"));
            }
            this.setText(string.substring(n2 + 1, n3));
            if (bl) {
                this.setBackground(Color.blue);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

