/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class hlcjnote {
    private Vector notesTitles = new Vector();
    private Vector notesListVec = new Vector();
    private Vector notesBodies = new Vector();
    private String inputFileName;
    private boolean notesFileExists;
    private hlcconfig configurations;
    private Vector nDir;
    static final String fsep = new String(System.getProperty("file.separator"));
    private String userDataDirectory = "";

    public hlcjnote(String runDir, String fileName, String userDataDirectoryIn) {
        this.userDataDirectory = new String(userDataDirectoryIn);
        this.configurations = new hlcconfig(runDir, this.userDataDirectory, "", null);
        this.nDir = new Vector(this.configurations.getNotesPath(true));
        this.parseNoteFile(this.nDir, fileName);
    }

    public String getNoteBody(int index) {
        return this.notesBodies.elementAt(index).toString();
    }

    public void setNoteBodyTitle(String bText, int index) {
        this.notesBodies.setElementAt(bText, index);
        int lineBreak = bText.indexOf("\n");
        if (lineBreak >= 0) {
            this.notesListVec.setElementAt(this.notesTitles.elementAt(index) + "    " + bText.substring(0, lineBreak), index);
        } else {
            this.notesListVec.setElementAt(this.notesTitles.elementAt(index) + "    " + bText, index);
        }
    }

    public String getNoteTitle(int index) {
        return this.notesTitles.elementAt(index).toString();
    }

    public String getNoteEntry(int index) {
        return this.notesListVec.elementAt(index).toString();
    }

    public int numNotes() {
        return this.notesListVec.size();
    }

    public Vector getNoteEntries() {
        return this.notesListVec;
    }

    private boolean searchFor(RandomAccessFile nFile, String searchStr) {
        String tokVal = new String(" ");
        boolean end = false;
        String lineFromNotesFile = new String(" ");
        try {
            while (lineFromNotesFile != null && !end) {
                lineFromNotesFile = nFile.readLine();
                StringTokenizer stok = new StringTokenizer(lineFromNotesFile);
                while (stok.hasMoreTokens() && !end) {
                    end = stok.nextToken().toString().equals(searchStr);
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not read notes file.", "IBM Softcopy Reader", 1);
        }
        return end;
    }

    private String readOneLine(RandomAccessFile noteFile) {
        String oneLine = new String();
        try {
            oneLine = noteFile.readLine();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not read notes file.", "IBM Softcopy Reader", 1);
        }
        return oneLine;
    }

    public int[] hasNotes(String topicID) {
        int[] nNotes = new int[]{};
        Vector<Integer> notesForTopic = new Vector<Integer>();
        for (int i = 0; i < this.notesTitles.size(); ++i) {
            if (!this.notesTitles.elementAt(i).equals(topicID)) continue;
            notesForTopic.addElement(new Integer(i));
        }
        if (notesForTopic.size() > 0) {
            nNotes = new int[notesForTopic.size()];
            for (int jj = 0; jj < nNotes.length; ++jj) {
                nNotes[jj] = (Integer)notesForTopic.elementAt(jj);
            }
        }
        return nNotes;
    }

    public static String fixWidth2(int value) {
        if (value == 0) {
            return "00";
        }
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value, 10);
    }

    public static String fixWidth6(int value) {
        if (value == 0) {
            return "000000";
        }
        if (value < 10) {
            return "00000" + value;
        }
        if (value < 100) {
            return "0000" + value;
        }
        if (value < 1000) {
            return "000" + value;
        }
        if (value < 10000) {
            return "00" + value;
        }
        if (value < 100000) {
            return "0" + value;
        }
        return Integer.toString(value, 10);
    }

    public static String convertedDate() {
        Calendar today = Calendar.getInstance();
        String dateBuf = new String("Date: " + today.get(1) + "" + hlcjnote.fixWidth2(today.get(2) + 1) + "" + hlcjnote.fixWidth2(today.get(5))) + "; Time: " + hlcjnote.fixWidth2(today.get(11)) + ":" + hlcjnote.fixWidth2(today.get(12)) + ":" + hlcjnote.fixWidth2(today.get(13)) + ";";
        return dateBuf;
    }

    public boolean saveNoteFile(hlcjbook jb) {
        if (this.inputFileName.equals("")) {
            return false;
        }
        String noteFileName = new String(this.inputFileName);
        String oldFileName = new String(this.inputFileName.substring(0, this.inputFileName.lastIndexOf(46)) + ".ntx");
        try {
            File nFile = new File(noteFileName);
            File oFile = new File(oldFileName);
            if (nFile.exists()) {
                nFile.renameTo(oFile);
            }
            FileOutputStream ostream = new FileOutputStream(nFile);
            PrintStream out = new PrintStream(ostream);
            out.println("Internal Version 4.2;");
            out.println("NOTES: Document " + jb.jbGetjStitle() + "; Docnum " + jb.jbGetjDocnum());
            out.println("       User PCWUSER; " + hlcjnote.convertedDate() + " Node: READWIN");
            out.println("Security  Copyright IBM Corp. 1994");
            for (int i = 0; i < this.notesTitles.size(); ++i) {
                this.writeNote(out, i, jb);
            }
            ostream.close();
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not save notes file.", "IBM Softcopy Reader", 0);
            return false;
        }
    }

    public boolean deleteNote(hlcjbook jbk, int index) {
        if (this.notesTitles.size() > index) {
            this.notesTitles.removeElementAt(index);
            this.notesListVec.removeElementAt(index);
            this.notesBodies.removeElementAt(index);
            if (this.notesTitles.isEmpty()) {
                File nFile = new File(this.inputFileName);
                try {
                    return nFile.delete();
                }
                catch (SecurityException e) {
                    return false;
                }
            }
            return this.saveNoteFile(jbk);
        }
        return false;
    }

    public static int nLines(String sIn) {
        int i = sIn.indexOf("\n");
        int j = 1;
        int k = 0;
        while (i > -1) {
            k = i;
            ++j;
            i = sIn.indexOf("\n", k + 1);
        }
        return j;
    }

    private String CRtoCRLF(String SInput) {
        StringBuffer tempStr = new StringBuffer(SInput);
        int i = tempStr.toString().indexOf("\n");
        while (i < tempStr.length() & i >= 0) {
            tempStr.insert(i, "\r");
            i = tempStr.toString().indexOf("\n", i + 2);
        }
        return tempStr.toString();
    }

    private void writeNote(PrintStream outf, int i, hlcjbook jbk) {
        int numLines = hlcjnote.nLines(this.notesBodies.elementAt(i).toString());
        String thisTitle = this.notesTitles.elementAt(i).toString();
        int topicNum = jbk.getTopicMatchID(thisTitle);
        outf.println(thisTitle + " " + hlcjnote.fixWidth6(0) + "." + hlcjnote.fixWidth6(0) + "." + hlcjnote.fixWidth6(0) + "." + hlcjnote.fixWidth6(topicNum) + ". " + numLines);
        outf.println(this.CRtoCRLF(this.notesBodies.elementAt(i).toString()));
    }

    public boolean hasNotesFile() {
        return this.notesFileExists;
    }

    public boolean parseNoteFile(Vector sDir, String fileName) {
        File findFile = new File(fileName);
        String nFileName = findFile.getName();
        String nFilePath = findFile.getParent();
        if (nFilePath != null) {
            sDir.addElement(nFilePath);
        }
        String noteFileName = new String(nFileName.substring(0, nFileName.lastIndexOf(46)) + ".ntf");
        this.notesFileExists = false;
        for (int i = 0; i < sDir.size() && !this.notesFileExists; ++i) {
            this.inputFileName = sDir.elementAt(i).toString() + fsep + noteFileName;
            findFile = new File(this.inputFileName);
            if (!findFile.exists()) continue;
            this.notesFileExists = true;
            noteFileName = this.inputFileName;
        }
        if (this.notesFileExists) {
            boolean errFlag = false;
            boolean end = false;
            try {
                RandomAccessFile nFile = new RandomAccessFile(noteFileName, "r");
                if (this.searchFor(nFile, "Security")) {
                    while (!end) {
                        end = this.getNote(nFile);
                    }
                }
                nFile.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Could not read notes file.", "IBM Softcopy Reader", 1);
            }
        } else {
            this.inputFileName = sDir.size() > 1 ? sDir.elementAt(0).toString() + fsep + noteFileName : "";
        }
        return this.notesFileExists;
    }

    private boolean getNote(RandomAccessFile noteFile) {
        String topicEntry = new String();
        String lineBuffer = new String();
        String topicTitle = new String();
        boolean succ = false;
        lineBuffer = this.readOneLine(noteFile);
        if (lineBuffer != null) {
            try {
                StringTokenizer sl = new StringTokenizer(lineBuffer, " ");
                StringTokenizer st = new StringTokenizer(sl.nextToken(), "&,");
                topicTitle = st.nextToken();
                st = new StringTokenizer(sl.nextToken(), ".");
                int ntok = st.countTokens();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                try {
                    int topicNo = new Integer(st.nextToken());
                    if (st.hasMoreTokens()) {
                        int topicLine = new Integer(st.nextToken());
                    }
                    int nLines = new Integer(sl.nextToken());
                    StringBuffer topicText = new StringBuffer(this.readOneLine(noteFile));
                    topicEntry = topicTitle + "    " + topicText;
                    for (int j = 2; j <= nLines; ++j) {
                        topicText.append("\n" + this.readOneLine(noteFile));
                    }
                    this.notesListVec.addElement(topicEntry);
                    this.notesTitles.addElement(topicTitle);
                    this.notesBodies.addElement(topicText);
                    succ = true;
                }
                catch (NumberFormatException nfe) {
                    succ = false;
                }
            }
            catch (NoSuchElementException e) {
                succ = false;
                JOptionPane.showMessageDialog(null, "Error parsing notes file.", "IBM Softcopy Reader", 0);
            }
        } else {
            succ = false;
        }
        return !succ;
    }

    public void addNote(String noteTitle, String noteText) {
        int lineBreak = noteText.indexOf("\n");
        if (lineBreak >= 0) {
            this.notesListVec.addElement(noteTitle + "    " + noteText.substring(0, lineBreak));
        } else {
            this.notesListVec.addElement(noteTitle + "    " + noteText);
        }
        this.notesTitles.addElement(noteTitle);
        this.notesBodies.addElement(noteText);
    }
}

