/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.io.Serializable;
import symantec.itools.util.GeneralUtils;

public class FormattedTextField
extends TextField {
    public final char ESCAPE = (char)47;
    public final char DIGIT = (char)57;
    public final char SIGN = (char)43;
    public final char DIGIT_OR_SIGN = (char)45;
    public final char ALPHA_UPPER = (char)65;
    public final char ALPHA_LOWER = (char)97;
    public final char ALPHA_TO_UPPER = (char)85;
    public final char ALPHA_TO_LOWER = (char)76;
    public final char ALPHANUMERIC_UPPER = (char)88;
    public final char ALPHANUMERIC_LOWER = (char)120;
    public final char ALPHANUMERIC_TO_UPPER = (char)78;
    public final char ALPHANUMERIC_TO_LOWER = (char)110;
    public final char ANY = (char)42;
    protected String designTimeText = "";
    protected final int BACKSPACE = 8;
    protected final int ENTER = 10;
    protected final int DEL = 127;
    protected int caret = 0;
    protected String mask;
    protected String unformattedCurrent = "";
    protected String maskStripEscapes;
    protected int maskStripEscapesLen;
    private Key keyListener;

    public FormattedTextField() {
        this(256);
    }

    public FormattedTextField(int i) {
        this("", i);
    }

    public FormattedTextField(String s) {
        this(s, 256);
    }

    public FormattedTextField(String s, int i) {
        super(s, i);
    }

    public void setMask(String mask) {
        this.mask = mask != null && mask.length() < 1 ? null : mask;
        this.maskStripEscapes = this.stripMaskEscapes();
        this.maskStripEscapesLen = this.maskStripEscapes.length();
        this.setText(this.getText());
    }

    public String getMask() {
        return this.mask;
    }

    public void setEditFont(Font f) {
        this.setFont(f);
    }

    public Font getEditFont() {
        return this.getFont();
    }

    public void setText(String t) {
        String newString;
        if (Beans.isDesignTime()) {
            this.designTimeText = t;
        }
        if (this.mask == null) {
            this.unformattedCurrent = newString = t;
        } else {
            newString = this.applyMask(t);
        }
        super.setText(newString);
    }

    public String getText() {
        return Beans.isDesignTime() ? this.designTimeText : this.unformattedCurrent;
    }

    public String getFormattedText() {
        return super.getText();
    }

    public void setEditable(boolean f) {
        super.setEditable(f);
        this.setEnabled(f);
    }

    public String getMaskTemplateString() {
        String newString = "";
        if (this.mask != null) {
            int ml = this.mask.length();
            int maskIndex = 0;
            while (maskIndex < ml) {
                char maskChar = this.mask.charAt(maskIndex);
                newString = String.valueOf(newString) + (maskChar == '/' ? this.mask.charAt(++maskIndex) : (char)' ');
                ++maskIndex;
            }
        }
        return newString;
    }

    public void setFillMask() {
        String newString = this.getMaskTemplateString();
        this.unformattedCurrent = "";
        super.setText(newString);
    }

    public synchronized void addNotify() {
        if (this.keyListener == null) {
            this.keyListener = new Key();
            this.addKeyListener(this.keyListener);
        }
        super.addNotify();
    }

    public synchronized void removeNotify() {
        if (this.keyListener != null) {
            this.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        super.removeNotify();
    }

    public Dimension preferredSize() {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fm = this.getFontMetrics(f);
            if (this.mask != null) {
                int w = fm.stringWidth("W") * this.maskStripEscapesLen + 4;
                int h = fm.getHeight() + 4;
                return new Dimension(w, h);
            }
            return new Dimension(fm.stringWidth("ABCDE") + 4, fm.getHeight() + 4);
        }
        return new Dimension(30, 15);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    protected int validChar(String s, int start, char maskChar) {
        int len = s.length();
        int i = start;
        while (i < len) {
            boolean isReturn = false;
            char c = s.charAt(i);
            switch (maskChar) {
                case '9': {
                    if (!Character.isDigit(c)) break;
                    isReturn = true;
                    break;
                }
                case '+': {
                    if (c != '+' && c != '-') break;
                    isReturn = true;
                    break;
                }
                case '-': {
                    if (!Character.isDigit(c) && c != '+' && c != '-') break;
                    isReturn = true;
                    break;
                }
                case 'A': {
                    if (!Character.isUpperCase(c)) break;
                    isReturn = true;
                    break;
                }
                case 'a': {
                    if (!Character.isLowerCase(c)) break;
                    isReturn = true;
                    break;
                }
                case 'X': {
                    if (!Character.isUpperCase(c) && !Character.isDigit(c)) break;
                    isReturn = true;
                    break;
                }
                case 'x': {
                    if (!Character.isLowerCase(c) && !Character.isDigit(c)) break;
                    isReturn = true;
                    break;
                }
                case 'U': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) break;
                    isReturn = true;
                    break;
                }
                case 'L': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) break;
                    isReturn = true;
                    break;
                }
                case 'N': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c) && !Character.isDigit(c)) break;
                    isReturn = true;
                    break;
                }
                case 'n': {
                    if (!Character.isUpperCase(c) && !Character.isLowerCase(c) && !Character.isDigit(c)) break;
                    isReturn = true;
                    break;
                }
                case '*': {
                    isReturn = true;
                    break;
                }
            }
            if (isReturn) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String applyMask(String s) {
        if (this.mask == null) {
            this.unformattedCurrent = s;
            return s;
        }
        this.unformattedCurrent = "";
        int maskLength = this.mask.length();
        int stringLength = s == null ? 0 : s.length();
        String newString = "";
        int maskIndex = 0;
        int stringIndex = 0;
        while (stringIndex < stringLength && maskIndex < maskLength) {
            boolean isValidChar;
            char maskChar = this.mask.charAt(maskIndex);
            if (maskChar == '/') {
                if (++maskIndex < maskLength) {
                    newString = String.valueOf(newString) + this.mask.charAt(maskIndex);
                }
                ++maskIndex;
                continue;
            }
            char stringChar = s.charAt(stringIndex);
            boolean bl = isValidChar = this.validChar(String.valueOf(stringChar), 0, maskChar) != -1;
            if (isValidChar) {
                stringChar = this.filterChar(stringChar, maskChar);
                newString = String.valueOf(newString) + stringChar;
                this.unformattedCurrent = String.valueOf(this.unformattedCurrent) + stringChar;
                ++maskIndex;
            }
            ++stringIndex;
        }
        int newLength = newString.length();
        if (newLength < this.maskStripEscapesLen) {
            String maskTemplate = this.getMaskTemplateString();
            newString = String.valueOf(newString) + maskTemplate.substring(newLength > 0 ? newLength - 1 : 0);
        }
        return newString;
    }

    protected String applyMaskToChar(char targetChar, int index) {
        boolean isValidChar;
        if (this.mask == null) {
            return String.valueOf(targetChar);
        }
        if (this.isEscape(index)) {
            return "";
        }
        int numEscapes = 0;
        int i = 0;
        while (i < index) {
            if (this.isEscape(i)) {
                ++numEscapes;
            }
            ++i;
        }
        char maskChar = this.mask.charAt(index + numEscapes);
        boolean bl = isValidChar = this.validChar(String.valueOf(targetChar), 0, maskChar) != -1;
        if (isValidChar) {
            targetChar = this.filterChar(targetChar, maskChar);
            return String.valueOf(targetChar);
        }
        return "";
    }

    protected char filterChar(char targetChar, char maskChar) {
        char returnChar = targetChar;
        switch (maskChar) {
            case 'U': {
                if (!Character.isLowerCase(targetChar)) break;
                returnChar = Character.toUpperCase(targetChar);
                break;
            }
            case 'L': {
                if (!Character.isUpperCase(targetChar)) break;
                returnChar = Character.toLowerCase(targetChar);
                break;
            }
            case 'N': {
                if (!Character.isLowerCase(targetChar)) break;
                returnChar = Character.toUpperCase(targetChar);
                break;
            }
            case 'n': {
                if (!Character.isUpperCase(targetChar)) break;
                returnChar = Character.toLowerCase(targetChar);
                break;
            }
        }
        return returnChar;
    }

    protected String stripMask(String s) {
        int sl = s.length();
        int i = 0;
        String newString = "";
        while (i < this.maskStripEscapesLen && i < sl) {
            if (this.isEscape(i)) {
                ++i;
                continue;
            }
            newString = String.valueOf(newString) + s.charAt(i++);
        }
        return newString;
    }

    protected void processChar(int key) {
        int selEnd;
        int selStart = this.getSelectionStart();
        boolean isSelection = selStart != (selEnd = this.getSelectionEnd());
        boolean isBackspace = key == 8;
        boolean isDelete = key == 127;
        String keyString = isBackspace || isDelete ? "" : String.valueOf((char)key);
        String currentString = this.getFormattedText();
        int currentLength = currentString.length();
        String leftOfSelection = selStart > 0 ? currentString.substring(0, selStart) : "";
        String rightOfSelection = selEnd < currentLength ? currentString.substring(selEnd) : "";
        String finalString = "";
        this.caret = selStart;
        if (this.mask == null) {
            if (isBackspace || isDelete) {
                if (isSelection) {
                    finalString = String.valueOf(leftOfSelection) + rightOfSelection;
                } else if (isBackspace) {
                    String tempLeft = "";
                    int leftLength = leftOfSelection.length();
                    if (leftLength > 0) {
                        tempLeft = leftOfSelection.substring(0, leftLength - 1);
                        --this.caret;
                    }
                    finalString = String.valueOf(tempLeft) + rightOfSelection;
                } else {
                    String tempRight = "";
                    int rightLength = rightOfSelection.length();
                    if (rightLength > 0) {
                        tempRight = rightOfSelection.substring(1, rightLength);
                    }
                    finalString = String.valueOf(leftOfSelection) + tempRight;
                }
            } else if (keyString.equals(String.valueOf('\u0000'))) {
                finalString = currentString;
            } else {
                this.caret = leftOfSelection.length() + 1;
                finalString = String.valueOf(leftOfSelection) + keyString + rightOfSelection;
            }
            this.unformattedCurrent = finalString;
        } else {
            String tempUnformatted;
            String newLeft;
            int i;
            int maskIndex;
            boolean isBeep = false;
            int unformattedLength = this.unformattedCurrent.length();
            String newRight = "";
            String tempString = "";
            String newPartialUnformatted = "";
            String maskTemplate = this.getMaskTemplateString();
            int numCharsBeforeSelStart = this.countNonEscapeChars(0, selStart);
            if (isSelection) {
                if (!isBackspace && !isDelete) {
                    maskIndex = selStart;
                    while (maskIndex < this.maskStripEscapesLen) {
                        if (!this.isEscape(maskIndex)) break;
                        ++maskIndex;
                    }
                    if (this.applyMaskToChar(keyString.charAt(0), maskIndex) == "") {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                int numCharsInSelection = 0;
                i = 0;
                maskIndex = 0;
                while (i < unformattedLength && maskIndex < this.maskStripEscapesLen) {
                    if (!this.isEscape(maskIndex)) {
                        ++i;
                        if (maskIndex >= selStart && maskIndex < selEnd) {
                            ++numCharsInSelection;
                        }
                    }
                    ++maskIndex;
                }
                if (numCharsInSelection > 0) {
                    String tempL = numCharsBeforeSelStart > 0 ? this.unformattedCurrent.substring(0, numCharsBeforeSelStart) : "";
                    int tempIndex = numCharsBeforeSelStart + numCharsInSelection;
                    String tempR = tempIndex < unformattedLength ? this.unformattedCurrent.substring(tempIndex) : "";
                    this.unformattedCurrent = String.valueOf(tempL) + tempR;
                    unformattedLength = this.unformattedCurrent.length();
                } else {
                    int numNonEscapeChars = this.countNonEscapeChars(selStart, selEnd);
                    if (numNonEscapeChars == 0) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
            } else if (isBackspace) {
                int numCharsBeforeSelection = 0;
                i = 0;
                maskIndex = 0;
                while (i < unformattedLength && maskIndex < this.maskStripEscapesLen) {
                    if (!this.isEscape(maskIndex)) {
                        ++i;
                        if (maskIndex >= selStart) break;
                        ++numCharsBeforeSelection;
                    }
                    ++maskIndex;
                }
                while (this.caret >= 0) {
                    if (!this.isEscape(this.caret - 1)) break;
                    --this.caret;
                }
                --this.caret;
                if (numCharsBeforeSelection < numCharsBeforeSelStart) {
                    this.select(this.caret, this.caret);
                    return;
                }
                this.unformattedCurrent = GeneralUtils.removeCharAtIndex(this.unformattedCurrent, numCharsBeforeSelection - 1);
                unformattedLength = this.unformattedCurrent.length();
            } else if (isDelete) {
                int numCharsAfterSelection = 0;
                i = 0;
                maskIndex = 0;
                while (i < unformattedLength && maskIndex < this.maskStripEscapesLen) {
                    if (!this.isEscape(maskIndex)) {
                        ++i;
                        if (maskIndex >= selEnd) {
                            ++numCharsAfterSelection;
                        }
                    }
                    ++maskIndex;
                }
                if (numCharsAfterSelection > 0) {
                    int tempStart = numCharsBeforeSelStart < unformattedLength ? numCharsBeforeSelStart : unformattedLength - 1;
                    this.unformattedCurrent = GeneralUtils.removeCharAtIndex(this.unformattedCurrent, tempStart);
                    unformattedLength = this.unformattedCurrent.length();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            numCharsBeforeSelStart = this.countNonEscapeChars(0, this.caret);
            if (unformattedLength < numCharsBeforeSelStart) {
                i = 0;
                maskIndex = 0;
                while (i < unformattedLength && maskIndex < this.maskStripEscapesLen) {
                    if (!this.isEscape(maskIndex)) {
                        ++i;
                    }
                    ++maskIndex;
                }
                if (!isBackspace) {
                    this.caret = maskIndex;
                }
            } else {
                maskIndex = this.caret;
            }
            String string = newLeft = maskIndex > 0 ? currentString.substring(0, maskIndex) : "";
            if (keyString.equals(String.valueOf('\u0000'))) {
                tempUnformatted = this.unformattedCurrent.substring(numCharsBeforeSelStart <= unformattedLength ? numCharsBeforeSelStart : unformattedLength);
                --this.caret;
            } else {
                tempUnformatted = String.valueOf(keyString) + this.unformattedCurrent.substring(numCharsBeforeSelStart <= unformattedLength ? numCharsBeforeSelStart : unformattedLength);
            }
            i = 0;
            while (i < tempUnformatted.length() && maskIndex < this.maskStripEscapesLen) {
                if (this.isEscape(maskIndex)) {
                    newRight = String.valueOf(newRight) + maskTemplate.charAt(maskIndex);
                } else {
                    tempString = this.applyMaskToChar(tempUnformatted.charAt(i), maskIndex);
                    if (tempString == "") {
                        isBeep = true;
                    } else if (i == 0 && keyString != "") {
                        while (this.caret < this.maskStripEscapesLen) {
                            if (!this.isEscape(this.caret)) break;
                            ++this.caret;
                        }
                        ++this.caret;
                        while (this.caret < this.maskStripEscapesLen) {
                            if (!this.isEscape(this.caret)) break;
                            ++this.caret;
                        }
                    }
                    newPartialUnformatted = String.valueOf(newPartialUnformatted) + tempString;
                    newRight = String.valueOf(newRight) + tempString;
                    ++i;
                }
                ++maskIndex;
            }
            finalString = String.valueOf(newLeft) + newRight + maskTemplate.substring(newLeft.length() + newRight.length());
            this.unformattedCurrent = String.valueOf(this.unformattedCurrent.substring(0, numCharsBeforeSelStart <= unformattedLength ? numCharsBeforeSelStart : unformattedLength)) + newPartialUnformatted;
            if (isBeep) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        super.setText(finalString);
        this.select(this.caret, this.caret);
    }

    protected int countNonEscapeChars(int start, int beforeIndex) {
        int numChars = 0;
        int i = start;
        while (i < beforeIndex) {
            if (!this.isEscape(i)) {
                ++numChars;
            }
            ++i;
        }
        return numChars;
    }

    private boolean isEscape(int index) {
        return index < 0 || index >= this.maskStripEscapesLen ? false : this.maskStripEscapes.charAt(index) == '/';
    }

    private String stripMaskEscapes() {
        if (this.mask == null) {
            return "";
        }
        int ml = this.mask.length();
        int maskIndex = 0;
        String nm = "";
        while (maskIndex < ml) {
            char maskChar;
            if ((maskChar = this.mask.charAt(maskIndex++)) == '/') {
                ++maskIndex;
            }
            nm = String.valueOf(nm) + maskChar;
        }
        return nm;
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 37: {
                    if (--FormattedTextField.this.caret >= 0) break;
                    FormattedTextField.this.caret = 0;
                    break;
                }
                case 39: {
                    if (++FormattedTextField.this.caret < FormattedTextField.this.maskStripEscapesLen) break;
                    FormattedTextField.this.caret = FormattedTextField.this.maskStripEscapesLen;
                    break;
                }
                case 36: {
                    FormattedTextField.this.caret = 0;
                    break;
                }
                case 35: {
                    FormattedTextField.this.caret = FormattedTextField.this.maskStripEscapesLen;
                    break;
                }
                default: {
                    FormattedTextField.this.processChar(e.getKeyChar());
                    e.consume();
                }
                case 9: 
                case 10: 
            }
        }

        Key() {
            FormattedTextField.this = FormattedTextField.this;
        }
    }
}

