/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class StateCheckBox
extends Canvas {
    private static final int WIDTH = 14;
    private static final int HEIGHT = 14;
    public static final int TWO_STATE = 0;
    public static final int THREE_STATE = 1;
    public static final int STATE_UNCHECKED = 0;
    public static final int STATE_CHECKED = 1;
    public static final int STATE_DEFAULT = 2;
    protected VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected Mouse mouse;
    protected ActionListener actionListener;
    transient boolean pressed = false;
    transient boolean released = true;
    private int width = 14;
    private int height = 14;
    int state = 0;
    int type = 0;

    public void setStyle(int newStyle) throws PropertyVetoException {
        if (this.type != newStyle) {
            Integer oldStyleInt = new Integer(this.type);
            Integer newStyleInt = new Integer(newStyle);
            this.vetos.fireVetoableChange("Style", oldStyleInt, newStyleInt);
            this.type = newStyle;
            this.changes.firePropertyChange("Style", oldStyleInt, newStyleInt);
            this.repaint();
        }
    }

    public int getStyle() {
        return this.type;
    }

    public void setState(int newState) throws PropertyVetoException {
        if (this.state != newState) {
            Integer oldStateInt = new Integer(this.state);
            Integer newStateInt = new Integer(newState);
            this.vetos.fireVetoableChange("State", oldStateInt, newStateInt);
            this.state = newState;
            this.changes.firePropertyChange("State", oldStateInt, newStateInt);
            this.repaint();
        }
    }

    public int getState() {
        return this.state;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void reshape(int x, int y, int width, int height) {
        this.width = 14;
        this.height = 14;
        super.reshape(x, y, width, height);
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void paint(Graphics g) {
        g.clipRect(0, 0, this.width, this.height);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        int w = this.width - 1;
        int h = this.height - 1;
        if (this.pressed) {
            g.setColor(Color.lightGray);
            g.fillRect(2, 2, w - 4, h - 4);
        }
        g.setColor(Color.gray);
        g.drawLine(0, h - 1, 0, 0);
        g.drawLine(0, 0, w - 1, 0);
        g.setColor(Color.lightGray);
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, h - 2, w - 2, 1);
        g.setColor(Color.black);
        g.drawLine(1, h - 2, 1, 1);
        g.drawLine(1, 1, w - 2, 1);
        switch (this.state) {
            case 2: {
                g.setColor(Color.lightGray);
                g.fillRect(2, 2, w - 4, h - 4);
                g.setColor(Color.black);
            }
            case 1: {
                int i = 0;
                while (i < 3) {
                    g.drawLine(3, 5 + i, 5, 7 + i);
                    g.drawLine(5, 7 + i, 9, 3 + i);
                    ++i;
                }
                break;
            }
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        super.removeNotify();
    }

    protected void sendActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            StateCheckBox.this.pressed = true;
            StateCheckBox.this.released = false;
            StateCheckBox.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (StateCheckBox.this.pressed) {
                StateCheckBox.this.pressed = false;
                StateCheckBox.this.state = (StateCheckBox.this.state + 1) % (StateCheckBox.this.type == 0 ? 2 : 3);
                StateCheckBox.this.repaint();
                StateCheckBox.this.sendActionEvent();
            }
            StateCheckBox.this.released = true;
        }

        public void mouseEntered(MouseEvent e) {
            if (!StateCheckBox.this.released) {
                this.mousePressed(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (StateCheckBox.this.pressed) {
                StateCheckBox.this.pressed = false;
                StateCheckBox.this.repaint();
            }
        }

        Mouse() {
            StateCheckBox.this = StateCheckBox.this;
        }
    }
}

