/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Date;
import symantec.itools.awt.ComboBox;
import symantec.itools.awt.util.spinner.NumericSpinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.util.GeneralUtils;

public class Calendar
extends Panel {
    String actionCommand;
    ActionListener actionListener;
    protected ComboBox combo;
    protected boolean bNeedsPlatformHelp;
    protected NumericSpinner sc;
    protected Date dCurrent;
    protected Date dLast;
    protected Color selectedColor;
    protected String[][] cal;
    protected int edgePad = 2;
    protected int dateSelectedx = -1;
    protected int dateSelectedy = -1;
    protected int lastSelectedDate = -1;
    protected int maxMonthx = -1;
    protected int maxMonthy = -1;
    protected int firstDay = -1;
    protected int topRow = -1;
    protected int selectHeight = -1;
    protected int centerNumber = -1;
    protected int heightAdjust = -1;
    protected int numberAdjust = -1;
    private Action action;
    private Mouse mouse;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public Calendar() {
        this(new Date());
    }

    public Calendar(Date defaultdate) {
        super.setLayout(null);
        this.bNeedsPlatformHelp = ComboBox.needsPlatformHelp();
        this.dLast = this.dCurrent = defaultdate;
        this.combo = new ComboBox();
        try {
            DateFormatSymbols dfs = new DateFormatSymbols();
            String[] months = dfs.getMonths();
            int length = months.length > 12 ? 12 : months.length;
            int i = 0;
            while (i < length) {
                this.combo.addItem(months[i]);
                ++i;
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.add(this.combo);
        this.sc = new NumericSpinner();
        this.add(this.sc);
        try {
            this.sc.setMin(1900);
            this.sc.setMax(9999);
            this.sc.setCurrent(1900 + this.dCurrent.getYear());
            this.sc.setEditable(false);
            this.combo.select(this.dCurrent.getMonth());
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.selectedColor = OS.isMacintosh() ? Color.black : Color.blue;
        if (!OS.isMacintosh()) {
            if (this.bNeedsPlatformHelp) {
                ((Component)this).setFont(new Font("Dialog", 0, 9));
            } else {
                ((Component)this).setFont(new Font("Dialog", 1, 10));
            }
        }
    }

    public void setDate(String date) throws PropertyVetoException {
        String oldValue = this.getDate();
        if (!GeneralUtils.objectsEqual(oldValue, date)) {
            Date newDate;
            this.vetos.fireVetoableChange("Date", oldValue, date);
            try {
                newDate = new Date(date);
            }
            catch (Exception exception) {
                newDate = new Date();
            }
            if (!this.dCurrent.equals(newDate)) {
                this.dCurrent = newDate;
                this.combo.select(this.dCurrent.getMonth());
                this.sc.setCurrent(1900 + this.dCurrent.getYear());
                this.firstDay = -1;
                this.lastSelectedDate = -1;
                this.repaint();
            }
            this.changes.firePropertyChange("Date", oldValue, date);
        }
    }

    public String getDate() {
        DateFormat df = DateFormat.getDateInstance(1);
        String str = df.format(this.dCurrent);
        return str;
    }

    public void setSelectedColor(Color c) throws PropertyVetoException {
        Color oldValue = this.selectedColor;
        if (!GeneralUtils.objectsEqual(oldValue, c)) {
            this.vetos.fireVetoableChange("SelectedColor", oldValue, c);
            this.selectedColor = c;
            this.repaint();
            this.changes.firePropertyChange("SelectedColor", oldValue, c);
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.sc.addActionListener(this.action);
            this.combo.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.sc.removeActionListener(this.action);
            this.combo.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (!this.sc.getBackground().equals(this.getBackground())) {
            this.sc.setBackground(this.getBackground());
        }
        Dimension spinnerSize = this.sc.getPreferredSize();
        this.sc.setBounds(this.getSize().width - spinnerSize.width - this.edgePad, this.edgePad, spinnerSize.width, spinnerSize.height);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle r = this.bounds();
        if (this.bNeedsPlatformHelp) {
            this.combo.reshape(12, 20, 100, 34);
            this.topRow = 70;
            this.selectHeight = fm.getHeight() + 2;
            this.centerNumber = 14;
            this.heightAdjust = 6;
            this.numberAdjust = 6;
        } else {
            Dimension comboSize = this.combo.getPreferredSize();
            this.combo.setBounds(this.edgePad, this.edgePad, comboSize.width, comboSize.height);
            this.topRow = spinnerSize.height + this.edgePad + 2;
            this.selectHeight = fm.getHeight();
            this.centerNumber = 14;
            this.heightAdjust = 2;
            this.numberAdjust = 0;
        }
        int widthWith2EdgeAdj = r.width - 2 * this.edgePad;
        int blockwidth = widthWith2EdgeAdj / 7;
        int blockheight = (r.height - this.topRow - this.edgePad) / 7;
        int halfBlockwidth = blockwidth / 2;
        int xloc = halfBlockwidth - fm.stringWidth("S") / 2;
        int yloc = this.topRow + this.centerNumber;
        if (this.dateSelectedx < 0) {
            int widthWithEdgeAdj = r.width - this.edgePad;
            int topRowBlockHeight = this.topRow + 7 * blockheight;
            g.setColor(Color.black);
            g.drawLine(this.edgePad, this.topRow, r.width - this.edgePad - 2, this.topRow);
            g.setColor(Color.lightGray);
            g.drawLine(this.edgePad, topRowBlockHeight, widthWithEdgeAdj - 3, topRowBlockHeight);
            g.setColor(Color.white);
            g.drawLine(this.edgePad + 1, topRowBlockHeight + 1, widthWithEdgeAdj - 2, topRowBlockHeight + 1);
            g.setColor(Color.black);
            g.drawLine(this.edgePad, this.topRow, this.edgePad, topRowBlockHeight);
            g.setColor(Color.lightGray);
            g.drawLine(widthWithEdgeAdj - 2, this.topRow, widthWithEdgeAdj - 2, topRowBlockHeight);
            g.setColor(Color.white);
            g.drawLine(widthWithEdgeAdj - 1, this.topRow, widthWithEdgeAdj - 1, topRowBlockHeight);
            g.fillRect(this.edgePad + 1, this.topRow + blockheight, widthWith2EdgeAdj - 3, 6 * blockheight);
            g.setColor(Color.gray);
            g.fillRect(this.edgePad + 1, this.topRow + 1, widthWith2EdgeAdj - 3, blockheight + 1);
            g.setColor(Color.white);
            if (OS.isMacintosh()) {
                yloc += (blockheight + 1) / 2 - fm.getHeight() / 2;
            }
            g.drawString("S", xloc, yloc - 1);
            xloc = blockwidth + (halfBlockwidth - fm.stringWidth("M") / 2);
            g.drawString("M", xloc, yloc - 1);
            xloc = blockwidth * 2 + (halfBlockwidth - fm.stringWidth("T") / 2);
            g.drawString("T", xloc, yloc - 1);
            xloc = blockwidth * 3 + (halfBlockwidth - fm.stringWidth("W") / 2);
            g.drawString("W", xloc, yloc - 1);
            xloc = blockwidth * 4 + (halfBlockwidth - fm.stringWidth("T") / 2);
            g.drawString("T", xloc, yloc - 1);
            xloc = blockwidth * 5 + (halfBlockwidth - fm.stringWidth("FM") / 2);
            g.drawString("F", xloc, yloc - 1);
            xloc = blockwidth * 6 + (halfBlockwidth - fm.stringWidth("S") / 2);
            g.drawString("S", xloc, yloc - 1);
        }
        Date dMonthStart = new Date(this.dCurrent.getYear(), this.dCurrent.getMonth(), 1);
        dMonthStart = new Date(this.dCurrent.getYear(), this.dCurrent.getMonth(), 1);
        if (this.firstDay < 0) {
            this.firstDay = dMonthStart.getDay();
        }
        int initdate = -1;
        int caldate = 1;
        int templastdate = -1;
        int month = this.dCurrent.getMonth() + 1;
        if (this.lastSelectedDate < 1) {
            initdate = this.dCurrent.getDate();
        } else if (this.dateSelectedx < 0) {
            initdate = this.lastSelectedDate;
        }
        g.setColor(Color.black);
        int j = 0;
        block0: while (j < 6) {
            int i = 0;
            while (i < 7) {
                if (this.maxMonthy < this.dateSelectedy || this.maxMonthy == this.dateSelectedy && this.maxMonthx < this.dateSelectedx) {
                    this.dateSelectedx = -1;
                    this.dateSelectedy = -1;
                    break block0;
                }
                if (j == 0 && i < this.firstDay) {
                    if (this.dateSelectedx == i && this.dateSelectedy == j) {
                        this.dateSelectedx = -1;
                        this.dateSelectedy = -1;
                        break block0;
                    }
                } else {
                    xloc = i * blockwidth + (halfBlockwidth - fm.stringWidth(Integer.toString(caldate)) / 2);
                    yloc = this.topRow + this.heightAdjust + 4 + this.numberAdjust + ((j + 2) * blockheight - fm.getHeight());
                    if (this.dateSelectedx < 0 && initdate != caldate) {
                        if (caldate < 10) {
                            g.drawString(Integer.toString(caldate), xloc, yloc);
                        } else {
                            g.drawString(Integer.toString(caldate), xloc, yloc);
                        }
                    } else if (this.dateSelectedx == i && this.dateSelectedy == j || initdate == caldate) {
                        if (this.dateSelectedx == i && this.dateSelectedy == j) {
                            int tempYear = this.dCurrent.getYear();
                            int tempMonth = this.dCurrent.getMonth();
                            this.dCurrent = new Date();
                            this.dCurrent = new Date();
                            this.dCurrent.setDate(caldate);
                            this.dCurrent.setYear(tempYear);
                            this.dCurrent.setMonth(tempMonth);
                        }
                        g.setColor(this.selectedColor);
                        if (caldate < 10) {
                            g.fillRect(xloc, yloc - this.selectHeight + this.heightAdjust, fm.stringWidth(Integer.toString(caldate)) + 2, this.selectHeight);
                        } else {
                            g.fillRect(xloc, yloc - this.selectHeight + this.heightAdjust, fm.stringWidth(Integer.toString(caldate)), this.selectHeight);
                        }
                        g.setColor(Color.white);
                        if (caldate < 10) {
                            g.drawString(Integer.toString(caldate), xloc, yloc);
                        } else {
                            g.drawString(Integer.toString(caldate), xloc, yloc);
                        }
                        templastdate = caldate;
                        g.setColor(Color.black);
                    } else if (caldate == this.lastSelectedDate) {
                        g.setColor(Color.white);
                        if (caldate < 10) {
                            g.fillRect(xloc, yloc - this.selectHeight + this.heightAdjust, fm.stringWidth(Integer.toString(caldate)) + 2, this.selectHeight);
                        } else {
                            g.fillRect(xloc, yloc - this.selectHeight + this.heightAdjust, fm.stringWidth(Integer.toString(caldate)), this.selectHeight);
                        }
                        g.setColor(Color.black);
                        if (caldate < 10) {
                            g.drawString(Integer.toString(caldate), xloc, yloc);
                        } else {
                            g.drawString(Integer.toString(this.lastSelectedDate), xloc, yloc);
                        }
                        this.lastSelectedDate = -1;
                    }
                    if (caldate >= 31) {
                        this.maxMonthx = i;
                        this.maxMonthy = j;
                        break block0;
                    }
                    if (caldate >= 30 && (month == 4 || month == 6 || month == 9 || month == 11)) {
                        this.maxMonthx = i;
                        this.maxMonthy = j;
                        break block0;
                    }
                    if (caldate >= 29 && month == 2) {
                        this.maxMonthx = i;
                        this.maxMonthy = j;
                        break block0;
                    }
                    if (caldate >= 28 && month == 2 && !this.isLeapYear(this.dCurrent.getYear())) {
                        this.maxMonthx = i;
                        this.maxMonthy = j;
                        break block0;
                    }
                    ++caldate;
                }
                ++i;
            }
            ++j;
        }
        if (this.lastSelectedDate < 0) {
            this.lastSelectedDate = templastdate;
        }
        this.dateSelectedx = -1;
        this.dateSelectedy = -1;
        if (!this.dLast.equals(this.dCurrent)) {
            this.dLast = this.dCurrent;
            this.sourceActionEvent();
        }
    }

    public Dimension preferredSize() {
        return new Dimension(250, 200);
    }

    public Dimension minimumSize() {
        return new Dimension(250, 200);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void setActionCommand(String command) throws PropertyVetoException {
        String oldValue = this.actionCommand;
        this.vetos.fireVetoableChange("ActionCommand", oldValue, command);
        this.actionCommand = command;
        this.changes.firePropertyChange("ActionCommand", oldValue, command);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void setLayout(LayoutManager lm) {
    }

    boolean isLeapYear(int year) {
        return year % 4 == 0 && year != 2100;
    }

    class Mouse
    extends MouseAdapter {
        public synchronized void mousePressed(MouseEvent e) {
            int topRow = -1;
            int x = e.getX();
            int y = e.getY();
            if (Calendar.this.bNeedsPlatformHelp) {
                topRow = 70;
                Calendar.this.centerNumber = 14;
                Calendar.this.heightAdjust = 6;
                Calendar.this.numberAdjust = 6;
            } else {
                topRow = 40;
                Calendar.this.numberAdjust = 0;
            }
            Rectangle r = Calendar.this.bounds();
            int blockheight = (r.height - topRow - 14) / 7;
            int blockwidth = (r.width - 32) / 7;
            if (x >= 15 && x < r.width - 15 && y >= topRow + blockheight && y < r.height - 14) {
                Calendar.this.dateSelectedx = (x - 16) / blockwidth;
                Calendar.this.dateSelectedy = (y - topRow - blockheight) / blockheight;
                Calendar.this.repaint();
                Calendar.this.firstDay = -1;
            }
        }

        Mouse() {
            Calendar.this = Calendar.this;
        }
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int yr;
            int mo;
            int dy;
            Object target = e.getSource();
            if (target instanceof ComboBox) {
                dy = Calendar.this.dCurrent.getDate();
                mo = Calendar.this.combo.getSelectedIndex();
                yr = Calendar.this.dCurrent.getYear();
                Calendar.this.dCurrent = new Date(yr, mo, dy);
                while (Calendar.this.dCurrent.getMonth() != mo) {
                    Calendar.this.dCurrent = new Date(yr, mo, --dy);
                    Calendar.this.lastSelectedDate = -1;
                }
                Calendar.this.firstDay = -1;
                Calendar.this.repaint();
            }
            if (target == Calendar.this.sc) {
                dy = Calendar.this.dCurrent.getDate();
                mo = Calendar.this.dCurrent.getMonth();
                yr = Calendar.this.sc.getCurrent() - 1900;
                Calendar.this.dCurrent = new Date(yr, mo, dy);
                while (Calendar.this.dCurrent.getMonth() != mo) {
                    Calendar.this.dCurrent = new Date(yr, mo, --dy);
                    Calendar.this.lastSelectedDate = -1;
                }
                Calendar.this.firstDay = -1;
                Calendar.this.repaint();
            }
        }

        Action() {
            Calendar.this = Calendar.this;
        }
    }
}

