/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.Context;
import symantec.itools.util.GeneralUtils;

public class StatusScroller
implements Runnable {
    protected boolean isRightToLeft = true;
    protected boolean isRepeat = true;
    protected boolean isScrollClean = true;
    protected AppletContext context;
    protected Thread thread;
    protected int delay = 100;
    protected int wblength;
    protected int sslength;
    protected int index;
    protected String statusString = null;
    protected StringBuffer workingBuffer;
    private boolean execute = true;
    private boolean loopFlag = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public StatusScroller() {
        this.thread = new Thread(this);
        try {
            this.setAppletContext(Context.getApplet());
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.thread.start();
    }

    public void setString(String s) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.statusString, s)) {
            String oldValue = this.statusString;
            this.vetos.fireVetoableChange("String", oldValue, s);
            this.statusString = s;
            this.index = 0;
            if (this.statusString == null || this.statusString.equals("")) {
                this.statusString = null;
                this.workingBuffer = null;
                this.wblength = 0;
                this.sslength = 0;
                if (this.execute) {
                    this.clear();
                }
            } else {
                this.sslength = this.statusString.length();
                this.updateWorkingBuffer();
            }
            this.changes.firePropertyChange("String", oldValue, this.statusString);
        }
    }

    public String getString() {
        return this.statusString;
    }

    public void setRightToLeft(boolean b) throws PropertyVetoException {
        Boolean oldValue = new Boolean(this.isRightToLeft);
        Boolean newValue = new Boolean(b);
        this.vetos.fireVetoableChange("RightToLeft", oldValue, newValue);
        this.isRightToLeft = b;
        this.changes.firePropertyChange("RightToLeft", oldValue, newValue);
    }

    public boolean isRightToLeft() {
        return this.isRightToLeft;
    }

    public boolean getRightToLeft() {
        return this.isRightToLeft();
    }

    public void setScrollClean(boolean b) throws PropertyVetoException {
        if (this.isScrollClean != b) {
            Boolean oldValue = new Boolean(this.isScrollClean);
            Boolean newValue = new Boolean(b);
            this.vetos.fireVetoableChange("ScrollClean", oldValue, newValue);
            this.isScrollClean = b;
            this.updateWorkingBuffer();
            this.changes.firePropertyChange("ScrollClean", oldValue, newValue);
        }
    }

    public boolean isScrollClean() {
        return this.isScrollClean;
    }

    public boolean getScrollClean() {
        return this.isScrollClean();
    }

    public void setAutoStart(boolean f) throws PropertyVetoException {
        Boolean oldValue = new Boolean(this.isAutoStart());
        Boolean newValue = new Boolean(f);
        this.vetos.fireVetoableChange("AutoStart", oldValue, newValue);
        if (f) {
            this.start();
        } else {
            this.stop();
        }
        this.changes.firePropertyChange("AutoStart", oldValue, newValue);
    }

    public boolean isAutoStart() {
        return this.execute;
    }

    public boolean getAutoStart() {
        return this.isAutoStart();
    }

    public void setRepeat(boolean f) throws PropertyVetoException {
        Boolean oldValue = new Boolean(this.isRepeat);
        Boolean newValue = new Boolean(f);
        this.vetos.fireVetoableChange("Repeat", oldValue, newValue);
        this.isRepeat = f;
        this.changes.firePropertyChange("Repeat", oldValue, newValue);
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public boolean getRepeat() {
        return this.isRepeat();
    }

    public void setDelay(int d) throws PropertyVetoException {
        int temp = 0;
        temp = d < 30 ? 30 : d;
        Integer oldValue = new Integer(this.delay);
        Integer newValue = new Integer(temp);
        this.vetos.fireVetoableChange("Delay", oldValue, newValue);
        this.delay = temp;
        this.changes.firePropertyChange("Delay", oldValue, newValue);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setAppletContext(AppletContext c) throws PropertyVetoException {
        AppletContext oldValue = this.context;
        this.vetos.fireVetoableChange("AppletContext", oldValue, c);
        this.context = c;
        this.changes.firePropertyChange("AppletContext", oldValue, c);
    }

    public void setAppletContext(Applet a) throws PropertyVetoException {
        if (a == null) {
            this.setAppletContext((AppletContext)null);
        } else {
            this.setAppletContext(a.getAppletContext());
        }
    }

    public void start() {
        this.execute = true;
        this.thread.resume();
    }

    public void stop() {
        this.execute = false;
    }

    public void clear() {
        if (this.context != null) {
            this.context.showStatus("");
        }
    }

    public void run() {
        String workingString = null;
        if (!this.execute) {
            this.thread.suspend();
        }
        try {
            while (true) {
                Thread.sleep(this.delay);
                if (this.execute) {
                    workingString = this.scrollString();
                    if (this.context != null && workingString != null) {
                        this.context.showStatus(workingString);
                    }
                }
                if (this.index != 0 || this.isRepeat) continue;
                this.thread.suspend();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected String scrollString() {
        if (this.workingBuffer == null) {
            return null;
        }
        if (this.wblength < 2) {
            return this.workingBuffer.toString();
        }
        char[] temp = new char[this.wblength - 1];
        if (this.isRightToLeft) {
            char ch = this.workingBuffer.charAt(0);
            this.workingBuffer.getChars(1, this.wblength, temp, 0);
            this.workingBuffer = new StringBuffer(new String(temp));
            this.workingBuffer = this.workingBuffer.append(ch);
            ++this.index;
            if (this.index > this.wblength - 1) {
                this.index = 0;
            }
        } else {
            char ch = this.workingBuffer.charAt(this.wblength - 1);
            this.workingBuffer.getChars(0, this.wblength - 1, temp, 0);
            this.workingBuffer = new StringBuffer(String.valueOf(ch));
            this.workingBuffer = this.workingBuffer.append(temp);
            --this.index;
            if (this.index < 0) {
                this.index = this.wblength - 1;
            }
        }
        return this.workingBuffer.toString().substring(0, this.sslength);
    }

    protected String makePadding(int howBig) {
        StringBuffer str = new StringBuffer(0);
        int i = 0;
        while (i < howBig) {
            str.append(" ");
            ++i;
        }
        return str.toString();
    }

    protected void updateWorkingBuffer() {
        if (this.isScrollClean) {
            String temp = this.makePadding(this.sslength);
            this.workingBuffer = new StringBuffer(String.valueOf(this.statusString) + temp);
        } else {
            this.workingBuffer = new StringBuffer(this.statusString);
        }
        this.wblength = this.workingBuffer.length();
    }
}

