/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import sun.audio.AudioStream;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.multimedia.SoundViewerItem;
import symantec.itools.multimedia.SoundViewerThread;

public class SoundPlayer
implements Serializable {
    public static final int INFINITE = -1;
    private transient Vector clips;
    private transient SoundViewerThread spt;
    private Vector URLlist;
    private boolean sync = true;
    private int repeatCt = 1;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SoundPlayer() {
        this.clips = new Vector();
        this.URLlist = new Vector();
    }

    public void setSyncMode(boolean newSyncMode) throws PropertyVetoException {
        if (this.sync != newSyncMode) {
            Boolean oldSyncModeBoolean = new Boolean(this.sync);
            Boolean newSyncModeBoolean = new Boolean(newSyncMode);
            this.vetos.fireVetoableChange("SyncMode", oldSyncModeBoolean, newSyncModeBoolean);
            this.sync = newSyncMode;
            if (this.spt != null) {
                this.spt.doSync(newSyncMode);
            }
            this.changes.firePropertyChange("SyncMode", oldSyncModeBoolean, newSyncModeBoolean);
        }
    }

    public boolean isSyncMode() {
        return this.sync;
    }

    public boolean getSyncMode() {
        return this.isSyncMode();
    }

    public void setRepeat(int c) throws PropertyVetoException {
        if (this.repeatCt != c) {
            Integer newValue = new Integer(c);
            Integer oldValue = new Integer(this.repeatCt);
            this.vetos.fireVetoableChange("Repeat", oldValue, newValue);
            this.repeatCt = c;
            this.changes.firePropertyChange("Repeat", oldValue, newValue);
        }
    }

    public int getRepeat() {
        return this.repeatCt;
    }

    public void setURLList(URL[] list) throws PropertyVetoException {
        this.clips.removeAllElements();
        this.URLlist.removeAllElements();
        URL[] oldValue = this.getURLList();
        this.vetos.fireVetoableChange("URLList", oldValue, list);
        int i = 0;
        while (i < list.length) {
            this.addURL(list[i]);
            ++i;
        }
        this.changes.firePropertyChange("URLList", oldValue, list);
    }

    public URL[] getURLList() {
        Object[] ret = new URL[this.URLlist.size()];
        this.URLlist.copyInto(ret);
        return ret;
    }

    public void addURL(URL u) {
        InputStream in = null;
        try {
            try {
                URLConnection uc = u.openConnection();
                uc.setAllowUserInteraction(true);
                in = uc.getInputStream();
                AudioStream as = new AudioStream(in);
                this.clips.addElement(new SoundViewerItem(as.getData(), (int)((double)as.getLength() / 7168.0 * 1000.0)));
                this.URLlist.addElement(u);
            }
            finally {
                Object var5_5 = null;
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    public void addStringURL(String url) {
        try {
            this.addURL(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void play() {
        this.spt = new SoundViewerThread(this.clips, this.sync, this.repeatCt);
        this.spt.start();
    }

    public void stop() {
        if (this.spt != null) {
            this.spt.doStop();
        }
    }

    public void stop(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {}
        this.stop();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.clips = new Vector();
        int i = 0;
        while (i < this.URLlist.size()) {
            InputStream in = null;
            try {
                try {
                    URLConnection uc = ((URL)this.URLlist.elementAt(i)).openConnection();
                    uc.setAllowUserInteraction(true);
                    in = uc.getInputStream();
                    AudioStream as = new AudioStream(in);
                    this.clips.addElement(new SoundViewerItem(as.getData(), (int)((double)as.getLength() / 7168.0 * 1000.0)));
                }
                finally {
                    Object var6_4 = null;
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
    }
}

