/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSDLIST_HPP
#define HWSDLIST_HPP

#include "hws.h"

class HWSLNode;
class HWSError;

//  The DList class is a container for LLData objects.
//  DList contains the Message Descriptor Name.
//  DList will maintain and provide access to a set of LLData objects.
class DllExport HWSDList {

  // Public access
  public:

     // Member functions
     HWSDList(char * mdName);
     ~HWSDList();

	  HWSDList  * getNextList();
	  HWSDList  * getPrevList();
	  int      insertList(HWSDList * aDList);
	  int      addList(HWSDList * aDList);

     HWSLNode * findNamed( char * );
     HWSLNode * getFirst( );
     HWSLNode * getNext( HWSLNode * );
     HWSLNode * getLast( );
     HWSLNode * getPrev( HWSLNode * );
     int      addNode( HWSLNode * aNode );

     HWSLNode * removeFirst( );
     HWSLNode * removeLast( );
     HWSLNode * remove( HWSLNode * );
     void     deleteAll();

     int	  isMember( HWSLNode * );

     // Data members
     char   * MDName;
     HWSDList  * next;
     HWSDList  * prev;

  private:
     HWSLNode * firstNode;         // Pointer to first HWSLNode object.
     HWSLNode * lastNode;          // Pointer to last HWSLNode object.
	  HWSLNode * currentNode;
};

#endif
