/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
/*--------------------------------------------------------------------*/
/* This file contains definitions for the Net.Data IMS Web Language   */
/* environment.                                                       */
/*                                                                    */
/* History:                                                           */
/*                                                                    */
/* 05/01/97   JEH  Created.                                           */
/*                                                                    */
/* 05/15/98   JEH  PTM2398  Change wording of 8013.                   */
/*                                                                    */
/*--------------------------------------------------------------------*/

#ifndef HWSDTW_INCLUDE
#define HWSDTW_INCLUDE

#ifdef HWSNT4
#include <windows.h>
#endif

#ifdef HWSOS2
#define INCL_BASE
#define INCL_NOPMAPI
#include <os2.h>
#endif

#include "hwsdlist.hpp"
#include "hwslnode.hpp"


/*--------------------------------------------------------------------*/
/* IMS Web specific data pointed to by le_opaque_data.                */
/*--------------------------------------------------------------------*/
typedef struct
{
   HWSDList    *listOfDLLs;              /* List of transaction DLLs. */
}  HWSLEData;

/*--------------------------------------------------------------------*/
/* Values for $(RETURN_CODE) and default_error_message.               */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* The following values for $(RETURN_CODE) are not referred to        */
/* specifically in the Net.Data macro.  They all map to the message   */
/* associated with +default in the %MESSAGE block of the macro.       */
/*--------------------------------------------------------------------*/
#define HWS_TABLE_NOT_EMPTY             8000
#define HWS_TABLE_NOT_EMPTY_S           "Input table not empty."
#define HWS_BAD_OUTFUNC_PARMS           8001
#define HWS_BAD_OUTFUNC_PARMS_S         "Invalid input to function processOutputParms."
#define HWS_DTW_STRDUP_FAILURE          8002
#define HWS_DTW_STRDUP_FAILURE_S        "dtw_strdup failed."
#define HWS_DTW_TABLE_SETN_FAILURE      8003
#define HWS_DTW_TABLE_SETN_FAILURE_S    "dtw_table_setN failed."
#define HWS_DTW_UNKNOWN_ERR             8004
#define HWS_DTW_UNKNOWN_ERR_S           "Error unknown."
#define HWS_DTW_TABLE_SETV_FAILURE      8005
#define HWS_DTW_TABLE_SETV_FAILURE_S    "dtw_table_setV failed."
#define HWS_LPAGE_NO_FIELDS             8006
#define HWS_LPAGE_NO_FIELDS_S           "Lpage has no fields."
#define HWS_INVALID_MAXCOLS             8008
#define HWS_INVALID_MAXCOLS_S           "Generated maximum columns is invalied."
#define HWS_TABLE_NOT_FOUND             8009
#define HWS_TABLE_NOT_FOUND_S           "Pointer to input table is null."
#define HWS_UNKNOWN_PARMTYPE            8010
#define HWS_UNKNOWN_PARMTYPE_S          "Unknown parameter type."
#define HWS_UNKNOWN_PARMUSE             8011
#define HWS_UNKNOWN_PARMUSE_S           "Unknown parameter usage."
#define HWS_BAD_INFUNC_PARMS            8012
#define HWS_BAD_INFUNC_PARMS_S          "Invalid input to function processInputParms."
#define HWS_LEDATA_NOTFOUND             8013
#define HWS_LEDATA_NOTFOUND_S           "IMS Web language environment data not available."
#define HWS_INVALID_ERRNODE             8014
#define HWS_INVALID_ERRNODE_S           "Invalid HWSLNode error object returned by transaction DLL."

/*--------------------------------------------------------------------*/
/* The following two values for $(RETURN_CODE) are referred to        */
/* specifically in the Net.Data macro.  They are presented here for   */
/* informational purposes only.                                       */
/*--------------------------------------------------------------------*/
#define HWS_CANT_FIND_DLL               9000
#define HWS_CANT_FIND_DLL_S             "Unable to load transaction program DTWxxxxx."
#define HWS_CANT_FIND_ENTRY             9001
#define HWS_CANT_FIND_ENTRY_S           "Unable to locate execute entry point in transaction program DTWxxxxx."

/*--------------------------------------------------------------------*/
/* The following two values for $(RETURN_CODE) are due to errors in   */
/* the generated transaction DLL.                                     */
/*--------------------------------------------------------------------*/
#define HWS_NULL_TRANOUT_OBJ             9500
#define HWS_NULL_TRANOUT_OBJ_S           "Error in IMS Web transaction DLL - null transaction output object.  Contact your Web master."
#define HWS_NULL_TRANOUT_LIST            9501
#define HWS_NULL_TRANOUT_LIST_S          "Error in IMS Web transaction DLL - failed to create output list.  Contact your Web master."

#endif
// HWSDTW_INCLUDE
