/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
#ifndef HWSECVTE_H
#define HWSECVTE_H

/*--------------------------------------------------------------------*/
/* HWSConverter class external error messages.                        */
/* 2100 - 2199                                                       */
/*--------------------------------------------------------------------*/
#define  IC_PRIOR_OPEN                         2100
#define  IC_PRIOR_OPEN_S                       "Prior open; this open is invalid."
// Explanation:  The open method may only be invoked once per HWSConverter instance.
// User Action:  If you wish to change the language or Endian information for the
//               HWSConverter instance you must invoke the close method before
//               re-invoking the open method.
#define  IC_INVALID_LANG                       2101
#define  IC_INVALID_LANG_S                     "Invalid language."
// Explanation:  The value you specified for the language parameter of the open method
//               is not supported.
// User Action:  Refer to the docmentation of the HWSConverter class for the supported
//               values for the language parameter.
#define  IC_UNKNOWN_ENDIAN                     2102
#define  IC_UNKNOWN_ENDIAN_S                   "Unknown endian."
// Explanation:  The value you specified for the clientEndian parameter of the open method
//               is not supported.
// User Action:  Refer to the docmentation of the HWSConverter class for the supported
//               values for the clientEndian parameter.
#define  IC_NO_CONVID_TBL                      2103
#define  IC_NO_CONVID_TBL_S                    "Conversion table missing or invalid."
// Explanation:  A file containing one of the tables used to convert IMS message data
//               was missing or invalid.    .
// User Action:  !!!!!!!!!!!!! Fix this !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the path where the
//               IMS Web Server conversion tables are are installed.  For Windows NT,
//               use REGEDIT to verify that value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the path where the IMS Web Server conversion tables are installed.
//               For AIX, verify the path /usr/lpp/imsweb/.
//               This directory should contain conversion table files of the form
//               CTBLxxxx.TBL for all the languages supported by IMS Web.
#define  IC_NO_PRIOR_OPEN                      2104
#define  IC_NO_PRIOR_OPEN_S                    "Open not performed prior to close."
// Explanation:  The HWSConverter instance must be open in order to invoke the close method.
// User Action:  Inovke the open method prior to invoking the close method.
#define  IC_XLATE_TARGET_LENGTH_EXCEEDED       2105
#define  IC_XLATE_TARGET_LENGTH_EXCEEDED_S     "Target length exceeded during conversion."
// Explanation:  The number of bytes provided for the coverted data (tarLength) is not
//               sufficient for the conversion.
// User Action:  Check the length of the source data and adjust the target length accordingly.
#define  IC_NO_OPEN                            2106
#define  IC_NO_OPEN_S                          "Open must be invoked prior to convert."
// Explanation:  The HWSConverter instance must be open in order to invoke the conversion methods.
// User Action:  Inovke the open method, prior to invoking the conversion methods, to establish
//               the language and endian for conversion,
#define  IC_XLATE_SOURCE_LENGTH_EXCEEDED       2107
#define  IC_XLATE_SOURCE_LENGTH_EXCEEDED_S     "Source string length exceeded during conversion."
// Explanation:  The data provided for conversion was invalid.
// User Action:  Verify that the length provided for the data to be converted includes all the bytes to be
//               converted, including both bytes of any double byte data and any shiftout/shiftin characters, if applicable.
#define  IC_SHORT_TARGET_LENGTH_FOR_SI         2108
#define  IC_SHORT_TARGET_LENGTH_FOR_SI_S       "Could not add ShiftIn - target length too small."
// Explanation:  The number of bytes provided for the converted data (tarLength) is not
//               sufficient for conversion.
// User Action:  Keep in mind that, for double byte data, the target length must allow for additional
//               (shiftout/shiftin) characters when converting to IMS format.  Adjust the target length
//               accordingly.
#define  IC_NO_TRAIL                           2109
#define  IC_NO_TRAIL_S                         "No trailing (second) byte found for a DBCS character."
// Explanation:  The data provided for conversion is incomplete.
// User Action:  Ensure that, in the case of double byte data, the length of the source includes
//               both bytes of trailing double byte data.  Adjust the target length accordingly.
#define  IC_OUT_OF_STORAGE                     2110
#define  IC_OUT_OF_STORAGE_S                   "Unable to obtain sufficient virtual storage."
// Explanation:  The HWSConverter class was unable to obtain sufficient virtural storage for use by the
//               conversion methods.
// User Action:  Reduce your system's demands for virtal storage.
#define  IC_NO_HWSPATH                         2111
#define  IC_NO_HWSPATH_S                       "Path to conversion tables missing."
// Explanation:  You failed to provide a path to the conversion tables when the HWSConverter instance was
//               created.
// User Action:  Refer to the documentation of the HWSConverter class for a description of the path
//               parameter.
#endif
