#ifndef HWSETRCE_H
#define HWSETRCE_H

/*--------------------------------------------------------------------*/
/* Error message defines for HWSCMD TRACE                             */
/*--------------------------------------------------------------------*/

#define  BAD_TRACE_CREATE                   10000
#define  BAD_TRACE_CREATE_S                 "HWSTRACE>Failure to open new trace file for write."
// Explanation:  An attempt to open a new program_name.TMP file during processing of
//               command "HWSCMD TRACE ON program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.
#define  BAD_TRACE_OPEN                     10001
#define  BAD_TRACE_OPEN_S                   "HWSTRACE>Failure to open existing trace file."
// Explanation:  An attempt to open an existing program_name.TMP file during processing of
//               command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.
#define  BAD_TRACE_WRITE                    10002
#define  BAD_TRACE_WRITE_S                 "HWSTRACE>Failure to write 1st record to new trace file."
// Explanation:  An attempt to write the first or last record of a program_name.TMP file during
//               processing of command "HWSCMD TRACE ON|OFF program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.
#define  TRACE_NOT_ON                       10003
#define  TRACE_NOT_ON_S                     "HWSTRACE>The IMS Web Server DLL trace is not ON."
// Explanation:  An attempt to turn off the IMS Web Server DLL trace failed for the specified CGI-BIN
//               program when IMS Web was unable to find the temporary trace file, program_name.TMP.
// User Action:  Turn the IMS Web Server DLL trace on, specifying the name of the CGI-BIN program.
#define  RENAME_FAILURE                     10004
#define  RENAME_FAILURE_S                   "HWSTRACE>Unable to rename .TMP file to .LOG file."
// Explanation:  An attempt to rename a program_name.TMP file to program_name.LOG during processing
//               of command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.
#define  BAD_LOG_OPEN                       10005
#define  BAD_LOG_OPEN_S                     "HWSTRACE>Failure to open existing trace log for write."
// Explanation:  An attempt to open an existing program_name.LOG file during processing of
//               command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.
#define  LOG_WRITE_FAILURE                  10006
#define  LOG_WRITE_FAILURE_S                "HWSTRACE>Failure to append to trace log."
// Explanation:  An attempt to append to an existing program_name.LOG file during processing of
//               command "HWSCMD TRACE OFF program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.

#define  BAD_TRACEDIR_CREATE                10007
#define  BAD_TRACEDIR_CREATE_S              "HWSTRACE>Failure to create new trace directory."
// Explanation:  An attempt to create a trace directory during processing of
//               command "HWSCMD TRACE ON program_name" failed.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the IMS Web Server
//               installation path.  For Windows NT, use REGEDIT to verify that the
//               value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the IMS Web Server installation path.  For AIX and OS/390, verify that the 
//               path /usr/lpp/imsweb/ exists.  Verify the existence of the
//               directories and any temporary trace files and trace log files.

#define  NO_HWSPATH                         10008
#define  NO_HWSPATH_S                       "HWSTRACE>Failure to find the system variable HWSPATH. It might be missing or invalid."   
// Explanation:  IMS Web was unable to find a system variable HWSPATH which is used
//               to determine the location of the server files.
// User Action:  This is most likely an installation error.  For OS/2, verify that
//               the HWSPATH environment variable is set to the path where the
//               IMS Web Server files are installed.  For Windows NT, use REGEDIT
//               to verify that value HWSPATH for the key
//               \HKEY_LOCAL_MACHINE\SOFTWARE\IBM\IMS Web  NT4 Server\1.0 is set to
//               the path where the IMS Web Server files are installed.
//               For AIX, verify the path /usr/lpp/imsweb/.
//               This directory should contain server files.


#endif
