/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
#ifndef HWSFLD_HPP
#define HWSFLD_HPP

#include "hws.h"

//  HWSFldDesc is a class which represents the MFLD specification
//  in the MFS source.
class DllExport HWSFldDesc {

  // Public access
  public:

     // Member functions
     HWSFldDesc(char *fName,MFLDType fType,int fLength);
	 ~HWSFldDesc();                 // Destructor.

     // Data members
     HWSFldDesc    *next;           // Pointer to next of possible multiple
                                    // MFLDs in message.
     char          *name;           // Name of attribute (input/output message field).
                                    // This name could be an MFLD name (specified or
                                    // DO-generated), a DFLD name (specified or DO-generated),
                                    // or a name generated by IMS.web.
     MFLDType      fldType;         // Type of MFLD
     int           literalLen;      // Literal length.
     char          *literalVal;     // Literal value (other than system literals).
                                    // This attribute contains the constant literals;
                                    // for system literals and non-literal fields this
                                    // attribute is NULL.
     int           length;          // Field length.
     int           pp;              // ppnn.
     JUSTType      justify;         // Message field justification.
     FILLType      fillType;        // Fill character type (HWSCHAR, HWSHEX, HWSNULL).
     char          fill;            // Fill character.
     A3270Type     A3270Attr;	      // 3270=yes/no
     short         eAttr;           // number of the eAttr, the length is 2*eAttr
	 /* following fields will be initialized when this Fld is added to Seg */
     MSGOption     option;          // Formatting option (OPT1, OPT2, OPT3).
     MSGType       type;            // Message type (HWSIN, HWSOUT).
//     char *        attr;          // Pointer to buffer of form LLLLDDDDD.
//     above attr for eAttr need to moved to the generated class some how.
   };

#endif
