/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSFLDF_HPP
#define HWSFLDF_HPP

#include "hwsfld.hpp"

class HWSLNode;
class HWSDList;
class HWSConverter;
class HWSError;

//  The HWSFldFormat class inherits from HWSFldDesc class to inherit
//  all the information about the field.
//  HWSFldFormat enhances the parent class by providing methods
//  to format the field.
class DllExport HWSFldFormat : public HWSFldDesc {

  // Public access
  public:

     // Member functions

     // Constructor...
     HWSFldFormat(char *fName, MFLDType fType, int fLength);
     // Destructor...
     ~HWSFldFormat();

     HWSLNode *formatIn( HWSError    *errStruc,
                       HWSLNode      *fld,
                       HWSConverter  *convObj,
                       HWSBool       *haveCGIData );
     HWSLNode *formatOut( HWSError   *errStruc,
                        char         **buf,
                        HWSBool      *processingAttrs,
                        HWSConverter *convObj );

   // Private access
   private:

     // Member functions

     // Get input data in preparation for alignment and fill/truncation.
     char *getInData( HWSError *errStruc,
                      HWSLNode   *fld,
                      HWSBool  *haveCGIData );

     // Get output data in preparation for alignment and fill/truncation.
     char *getOutData( HWSError *errStruc,
                       char     **ptr,
                       HWSBool  *processingAttrs );
};

#endif
